import sys
from Ft.Lib import pDomlette
from Ft.Rdf.Serializers.Dom import Serializer
from Ft.Rdf.Drivers import Memory
from xml.dom.ext import PrettyPrint
from Ft.Rdf import Model
from RdfHelper import *

SOURCE_URI = 'http://foo/'

# REC RDF Syntax 7.4.1
source = """<rdf:RDF
    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
    xmlns:dc='http://purl.org/metadata/dublin_core#'>
    <rdf:Description about='http://www.dlib.org'>
      <dc:Title>D-Lib Program - Research in Digital Libraries</dc:Title>
      <dc:Description>The D-Lib program supports the community of people
       with research interests in digital libraries and electronic
       publishing.</dc:Description>
      <dc:Publisher>Corporation For National Research Initiatives</dc:Publisher>
      <dc:Date>1995-01-07</dc:Date>
      <dc:Subject>
        <rdf:Bag>
          <rdf:li>Research; statistical methods</rdf:li>
          <rdf:li>Education, research, related topics</rdf:li>
          <rdf:li>Library use Studies</rdf:li>
        </rdf:Bag>
      </dc:Subject>
      <dc:Type>World Wide Web Home Page</dc:Type>
      <dc:Format>text/html</dc:Format>
      <dc:Language>en</dc:Language>
    </rdf:Description>
    <rdf:Description about='http://fourthought.com'>
      <dc:Title>an XML consulting company</dc:Title>
      <dc:Description>A software engineering company with focus on XML and Knoledge based technologies
        </dc:Description>
      <dc:Publisher resource='http://fourthought.com'/>
      <dc:Date>1998-06-01</dc:Date>
      <dc:Subject>
        <rdf:Bag>
          <rdf:li>XML</rdf:li>
          <rdf:li>AI</rdf:li>
          <rdf:li>python</rdf:li>
        </rdf:Bag>
      </dc:Subject>
      <dc:Type>World Wide Web Home Page</dc:Type>
      <dc:Format>text/html</dc:Format>
      <dc:Language>en</dc:Language>
    </rdf:Description>
  </rdf:RDF>
"""

import sys
if sys.hexversion < 0x2000000:
    addSlash = lambda x:x+'/'
else:
    addSlash = lambda x:x

deserialized = [(addSlash('http://www.dlib.org'),
  'http://purl.org/metadata/dublin_core#Title',
  'D-Lib Program - Research in Digital Libraries',
  '',
  'http://foo/'),
 (addSlash('http://www.dlib.org'),
  'http://purl.org/metadata/dublin_core#Description',
  'The D-Lib program supports the community of people\012       with research interests in digital libraries and electronic\012       publishing.',
  '',
  'http://foo/'),
 (addSlash('http://www.dlib.org'),
  'http://purl.org/metadata/dublin_core#Publisher',
  'Corporation For National Research Initiatives',
  '',
  'http://foo/'),
 (addSlash('http://www.dlib.org'),
  'http://purl.org/metadata/dublin_core#Date',
  '1995-01-07',
  '',
  'http://foo/'),
 ('ANONYMOUS0', #'urn:uuid:2060800-90c-e01-d03-d0c0803d09',
  'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
  'http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag',
  '',
  'http://foo/'),
 ('ANONYMOUS0', #'urn:uuid:2060800-90c-e01-d03-d0c0803d09',
  'http://www.w3.org/1999/02/22-rdf-syntax-ns#_1',
  'Research; statistical methods',
  '',
  'http://foo/'),
 ('ANONYMOUS0', #'urn:uuid:2060800-90c-e01-d03-d0c0803d09',
  'http://www.w3.org/1999/02/22-rdf-syntax-ns#_2',
  'Education, research, related topics',
  '',
  'http://foo/'),
 ('ANONYMOUS0', #'urn:uuid:2060800-90c-e01-d03-d0c0803d09',
  'http://www.w3.org/1999/02/22-rdf-syntax-ns#_3',
  'Library use Studies',
  '',
  'http://foo/'),
 (addSlash('http://www.dlib.org'),
  'http://purl.org/metadata/dublin_core#Subject',
  'ANONYMOUS0', #'urn:uuid:2060800-90c-e01-d03-d0c0803d09',
  '',
  'http://foo/'),
 (addSlash('http://www.dlib.org'),
  'http://purl.org/metadata/dublin_core#Type',
  'World Wide Web Home Page',
  '',
  'http://foo/'),
 (addSlash('http://www.dlib.org'),
  'http://purl.org/metadata/dublin_core#Format',
  'text/html',
  '',
  'http://foo/'),
 (addSlash('http://www.dlib.org'),
  'http://purl.org/metadata/dublin_core#Language',
  'en',
  '',
  'http://foo/'),
 (addSlash('http://fourthought.com'),
  'http://purl.org/metadata/dublin_core#Title',
  'an XML consulting company',
  '',
  'http://foo/'),
 (addSlash('http://fourthought.com'),
  'http://purl.org/metadata/dublin_core#Description',
  'A software engineering company with focus on XML and Knoledge based technologies\012        ',
  '',
  'http://foo/'),
 (addSlash('http://fourthought.com'),
  'http://purl.org/metadata/dublin_core#Publisher',
  addSlash('http://fourthought.com'),
  '',
  'http://foo/'),
 (addSlash('http://fourthought.com'),
  'http://purl.org/metadata/dublin_core#Date',
  '1998-06-01',
  '',
  'http://foo/'),
 ('ANONYMOUS1', #'urn:uuid:e010706-b08-10c-708-a09010ad0a',
  'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
  'http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag',
  '',
  'http://foo/'),
 ('ANONYMOUS1', #'urn:uuid:e010706-b08-10c-708-a09010ad0a',
  'http://www.w3.org/1999/02/22-rdf-syntax-ns#_1',
  'XML',
  '',
  'http://foo/'),
 ('ANONYMOUS1', #'urn:uuid:e010706-b08-10c-708-a09010ad0a',
  'http://www.w3.org/1999/02/22-rdf-syntax-ns#_2',
  'AI',
  '',
  'http://foo/'),
 ('ANONYMOUS1', #'urn:uuid:e010706-b08-10c-708-a09010ad0a',
  'http://www.w3.org/1999/02/22-rdf-syntax-ns#_3',
  'python',
  '',
  'http://foo/'),
 (addSlash('http://fourthought.com'),
  'http://purl.org/metadata/dublin_core#Subject',
  'ANONYMOUS1', #'urn:uuid:e010706-b08-10c-708-a09010ad0a',
  '',
  'http://foo/'),
 (addSlash('http://fourthought.com'),
  'http://purl.org/metadata/dublin_core#Type',
  'World Wide Web Home Page',
  '',
  'http://foo/'),
 (addSlash('http://fourthought.com'),
  'http://purl.org/metadata/dublin_core#Format',
  'text/html',
  '',
  'http://foo/'),
 (addSlash('http://fourthought.com'),
  'http://purl.org/metadata/dublin_core#Language',
  'en',
  '',
  'http://foo/')]

def Test(tester):

    tester.startGroup('DOM Serializer')
    driver = tester.test_data['driver']
    if driver.ExistsDb('test'):
        driver.DestroyDb('test')
    driver.CreateDb('test')

    reader = pDomlette.PyExpatReader()
    szr = Serializer()
    dom = reader.fromString(source)
    
    tester.startTest('deserialize')
    db = driver.GetDb('test')
    db.begin()
    model = Model.Model(db)
    szr.deserialize(model, dom, SOURCE_URI)
    reader.releaseNode(dom)
    nss = {}
    nss["http://purl.org/metadata/dublin_core#"] = 'dc'
    # Save it for later
    dom = szr.serialize(model, nss)
    actual = make_tuple(model.statements(), SOURCE_URI)
    tester.compare(deserialized, actual, func=compare_tuple)
    db.rollback()
    tester.testDone()

    tester.startTest('serialize')
    db = driver.GetDb('test')
    db.begin()
    model = Model.Model(db)
    szr.deserialize(model, dom, SOURCE_URI)
    reader.releaseNode(dom)
    actual = make_tuple(model.statements(), SOURCE_URI)
    tester.compare(deserialized, actual, func=compare_tuple)
    db.rollback()
    tester.testDone()
    tester.groupDone()
