"""
A writer for building Dom DocumentFragments from an XSLT processor output
Much inspired by RtfWriter.

Copyright (c) 2000-2001 Alexandre Fayolle, France

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.

THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
"""

from xml.dom.ext import SplitQName
from xml.dom import XMLNS_NAMESPACE
from xml.xslt import NullWriter

class DomWriter(NullWriter.NullWriter):
    def __init__(self, ownerDoc=None):
        NullWriter.NullWriter.__init__(self)
        if not ownerDoc:
            from xml.dom import implementation
            ownerDoc = implementation.createDocument('',None,
                                                     implementation.createDocumentType('','',''))
        self._ownerDoc = ownerDoc
        self._root = ownerDoc.createDocumentFragment()
        self._nodeStack = [self._root]
        self._currElement = None

    def getResult(self):
        return self._root

    def startElement(self, name, namespace='', extraNss=None):
        new_element = self._ownerDoc.createElementNS(namespace,
                                                      name)
        self._nodeStack.append(new_element)
        extraNss = extraNss or {}
        prefix, localName = SplitQName(name)
        for prefix in extraNss.keys():
            if prefix:
                new_element.setAttributeNS(XMLNS_NAMESPACE,
                                           'xmlns:'+prefix,
                                           extraNss[prefix])
            else:
                new_element.setAttributeNS(XMLNS_NAMESPACE,
                                           'xmlns',
                                           extraNss[''])
        return

    def endElement(self, name):
        new_element = self._nodeStack[-1]
        del self._nodeStack[-1]
        self._nodeStack[-1].appendChild(new_element)
        return

    def text(self, text, escapeOutput=1, asis=0):
        new_text = self._ownerDoc.createTextNode(text)
        self._nodeStack[-1].appendChild(new_text)
        return

    def attribute(self, name, value, namespace=''):
        attr = self._ownerDoc.createAttributeNS(namespace, name)
        attr.value = value
        if self._nodeStack[-1].nodeType == self._nodeStack[-1].ELEMENT_NODE:
            self._nodeStack[-1].setAttributeNodeNS(attr)
        else:
            #Document-fragment parent
            self._nodeStack[-1].appendChild(attr)
        return

    def processingInstruction(self, target, data):
        pi = self._ownerDoc.createProcessingInstruction(target,data)
        self._nodeStack[-1].appendChild(pi)
        return

    def comment(self, text):
        comment = self._ownerDoc.createComment(text)
        self._nodeStack[-1].appendChild(comment)
        return
      
