#!/usr/bin/env python
############################################################################
#  
#  Copyright (c)2000 Fourthought, Inc.
#  http://ftsuite.com/4ODS
#
############################################################################
#
# File Name: 		register.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Tools/4odb_create.py.html
#


#Create a new database ready to accept ODL

import sys, os

__doc__  = """The register command is used to reset registered modules in the system.  Registered modules are used to define implementations for operations."""


def Run(options,args):
    from Ft.Ods.StorageManager import Adapters
    dbName = args['dbName']
    
    mang = Adapters.GetManager(options.get('adapter')) 
    adapter = Adapters.GetAdapter(options.get('adapter')) 

    _Run(dbName,args['module'])


def _Run(dbName,modList):
    from Ft.Ods import Database
    from Ft.Ods.Parsers.Odl import Register
    mods = []
    for m in modList:

        m = os.path.splitext(m)[0]

        mod = __import__(m,{},{},'*')

        mods.append(mod)

    db = Database.Database()
    db.open(dbName)

    tx = db.new()
    tx.begin()

    res = Register.RegisterExtensionModules(db,mods)

    tx.commit()
    db.close()

    print "Registration Results:\n"
    for name,repoId,funcName,fileName in res:
        print "Registered Operation %s (%d) to function %s in file %s" % (name,repoId,funcName,fileName)
    


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('register',
                          'Register a set of extension modules.',
                          ' test',                          
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('dbName',
                                                                  'The name of the database.',
                                                                  str),
                                       Arguments.OneOrMoreArgument('module',
                                                                   'Python path of module to use',
                                                                   str),
                                       ],
                                                               
                          )
    return cmd


