from Ft.Ods import Enumeration

TYPEID=-100

class MetaKindElement(Enumeration.EnumElement):
    nameMapping={0:'mk_attribute',
                 1:'mk_class',
                 2:'mk_collection',
                 3:'mk_constant',
                 4:'mk_const_operand',
                 5:'mk_enumeration',
                 6:'mk_exception',
                 7:'mk_expression',
                 8:'mk_interface',
                 9:'mk_literal',
                 10:'mk_member',
                 11:'mk_module',
                 12:'mk_operation',
                 13:'mk_parameter',
                 14:'mk_primitive_type',
                 15:'mk_relationship',
                 16:'mk_repository',
                 17:'mk_structure',
                 18:'mk_type_definition',
                 19:'mk_union',
                 20:'mk_union_case',
                 }
    def __init__(self,db,value):
        if value == None: value = 0
        if type(value) == type(()):
            value = value[0]
        Enumeration.EnumElement.__init__(self,db,self.nameMapping[value],value,'MetaKind',TYPEID)




mk_attribute = MetaKindElement(None,0)
mk_class = MetaKindElement(None,1)
mk_collection = MetaKindElement(None,2)
mk_constant = MetaKindElement(None,3)
mk_const_operand = MetaKindElement(None,4)
mk_enumeration = MetaKindElement(None,5)
mk_exception = MetaKindElement(None,6)
mk_expression = MetaKindElement(None,7)
mk_interface = MetaKindElement(None,8)
mk_literal = MetaKindElement(None,9)
mk_member = MetaKindElement(None,10)
mk_module = MetaKindElement(None,11)
mk_operation = MetaKindElement(None,12)
mk_parameter = MetaKindElement(None,13)
mk_primitive_type = MetaKindElement(None,14)
mk_relationship = MetaKindElement(None,15)
mk_repository = MetaKindElement(None,16)
mk_structure = MetaKindElement(None,17)
mk_type_definition = MetaKindElement(None,18)
mk_union = MetaKindElement(None,19)
mk_union_case = MetaKindElement(None,20)


class MetaKindEnum(Enumeration.Enumeration):
    def __init__(self):
        Enumeration.Enumeration.__init__(self,
                                         "MetaKind",
                                         TYPEID,
                                         [mk_attribute,
                                          mk_class,
                                          mk_collection,
                                          mk_constant,
                                          mk_const_operand,
                                          mk_enumeration,
                                          mk_exception,
                                          mk_expression,
                                          mk_interface,
                                          mk_literal,
                                          mk_member,
                                          mk_module,
                                          mk_operation,
                                          mk_parameter,
                                          mk_primitive_type,
                                          mk_relationship,
                                          mk_repository,
                                          mk_structure,
                                          mk_type_definition,
                                          mk_union,
                                          mk_union_case,
                                          ])


MetaKind = MetaKindEnum()
