#!/usr/bin/env python
############################################################################
#
# File Name: 		Enumeration.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Object.py.html
#






class Enumeration:
    
    def __init__(self,name,typeId,elements):
        self.elements = []
        ctr = 0
        for e in elements:
            if not isinstance(e,EnumElement):
                raise TypeError("Enumeration element %s must be derived from Ft.Ods.Enumeration.EnumElement" % str(e))
            self.elements.append(e)
        self.name = name
        self._typeId = typeId

    def lookup(self, name):
        names = filter(lambda enum, name=name: enum._n == name,self.elements)
        if names:
            return names[0]
        return ''

    def isMember(self,member):
        return member in self.elements


class EnumElement:
    def __init__(self,db,name,value,enumName,typeId):
        self.name = name
        self._n = name
        self.value = value
        self._v = value
        self._typeId = typeId
        self._typeIds = (typeId,)
        self._enumName = enumName

    def _4ods_getData(self):
        return (self._v,)

    def copy(self):
        return self.__class__(None,self._v)

    def __str__(self):
        return "<%s Enumeration Element %s (%d) at %x>" % (self._enumName,
                                                           self.name,
                                                           self.value,
                                                           id(self))

    def __cmp__(self,other):
        if isinstance(other,EnumElement):
            return not (self._typeId == other._typeId and self._v == other._v)
        return 1

    def __hash__(self):
        return (self._typeId << 16) | self._v


    def _4ods_isModified(self):
        return 1
