#include "Python.h"
#include "domlette.h"

/*Internal Methods*/

void Comment_ReleaseNode(PyCommentObject *comment)
{
  Py_XDECREF(comment->commentData.nodeValue);
  comment->commentData.nodeValue = NULL;
}


/*External Methods*/


static struct PyMethodDef Comment_methods[] = { NODE_METHODS,CHARACTERDATA_METHODS,
  {NULL,     NULL}      /* sentinel */
};



/*Type Methods*/

static PyObject *comment_getattr(PyCommentObject *self, char *name)
{
  PyObject *rt = NULL;

  if (!strcmp(name,"data")) {
    rt = self->commentData.nodeValue;
  }
  else if (!strcmp(name,"nodeValue")) {
    rt = self->commentData.nodeValue;
  }
  else if (!strcmp(name,"nodeType")) {
    rt = g_commentNodeType;
  }
  else if (!strcmp(name,"nodeName")) {
    rt = g_commentNodeName;
  }
  if (rt) {
    Py_INCREF(rt);
    return rt;
  }

  return node_getattr((PyNodeObject*)self,name,Comment_methods);
}


static void comment_dealloc(PyCommentObject *node)
{
  node_dealloc((PyNodeObject*)node);
}


static void comment_build_display_string(char *buf, PyCommentObject *v)
{
  sprintf(buf, "<cDomlette Comment Node at %x>", (long)v);
}

static int comment_print(PyCommentObject *v, FILE *fp, int flags)
/* flags not used but required by interface */
{
  char buf[256];
  comment_build_display_string(buf,v);
  fputs(buf, fp);
  return 0;
}


PyTypeObject PyDomletteComment_Type = {
    PyObject_HEAD_INIT(0)
    0,
    "cDomlette.Comment",
    sizeof(PyCommentObject),
    0,
    (destructor)comment_dealloc,    /*tp_dealloc*/
    (printfunc)comment_print,   /*tp_print*/
    (getattrfunc)comment_getattr,   /*tp_getattr*/
    0,              /*tp_setattr*/
    0,                          /*tp_compare*/
    0,          /*tp_repr*/
    0,                          /*tp_as_number*/
    0,              /*tp_as_sequence*/
    0,              /*tp_as_mapping*/
    0,                             /*tp_hash*/
    0,          /*tp_call*/
    0,          /*tp_str*/
    0,                      /*tp_getattro*/
    0,          /*tp_setattro*/
};

