#include "Python.h"
#include "domlette.h"

void Attr_ReleaseNode(PyAttrObject *attr)
{
  Py_XDECREF(attr->attrData.nodeValue);
  Py_XDECREF(attr->nodeData.namespaceURI);
  Py_XDECREF(attr->nodeData.prefix);
  Py_XDECREF(attr->nodeData.localName);
  Py_XDECREF(attr->nodeData.nodeName);
  attr->attrData.nodeValue = NULL;
}


/*
   External Methods
*/


static struct PyMethodDef Attr_methods[] = { NODE_METHODS,
  {NULL,     NULL}      /* sentinel */
};

/*
  Methods for our type
*/

static PyObject *attr_getattr(PyAttrObject *self, char *name)
{
  PyObject *rt = NULL;
  PyObject * temp;
  if (!strcmp(name,"name")) {
    rt = self->nodeData.nodeName;
  }
  else if (!strcmp(name,"childNodes")) {
    /*Create a child list of length one*/
    rt = PyList_New(0);
    temp = (PyObject *)Document_CreateTextNode((PyDocumentObject *)self->nodeData.ownerDocument,
					       PyString_AsString(self->attrData.nodeValue),
					       &self->nodeData.docIndex);
    self->nodeData.docIndex--;
    PyList_Append(rt,temp);
    Py_DECREF(temp);
    return rt;
  }
  else if (!strcmp(name,"firstChild")) {
    rt = (PyObject *)Document_CreateTextNode((PyDocumentObject *)self->nodeData.ownerDocument,
					     PyString_AsString(self->attrData.nodeValue),
					     &self->nodeData.docIndex);
    return rt;
  }
  else if (!strcmp(name,"lastChild")) {
    rt = (PyObject *)Document_CreateTextNode((PyDocumentObject *)self->nodeData.ownerDocument,
					     PyString_AsString(self->attrData.nodeValue),
					     &self->nodeData.docIndex);
    return rt;
  }
  else if (!strcmp(name,"nodeName")) {
    rt = self->nodeData.nodeName;
  }
  else if (!strcmp(name,"namespaceURI")) {
    rt = self->nodeData.namespaceURI;
  }
  else if (!strcmp(name,"prefix")) {
    rt = self->nodeData.prefix;
  }
  else if (!strcmp(name,"localName")) {
    rt = self->nodeData.localName;
  }
  else if (!strcmp(name,"value")) {
    rt = self->attrData.nodeValue;
  }
  else if (!strcmp(name,"nodeValue")) {
    rt = self->attrData.nodeValue;
  }
  else if (!strcmp(name,"ownerElement")) {
    rt = self->nodeData.parentNode;
  }
  else if (!strcmp(name,"parentNode")) {
    rt = Py_None;
  }
  else if (!strcmp(name,"nodeType")) {
    rt = g_attrNodeType;
  }
  else if (!strcmp(name,"specified")) {
    /*Just return because we inc ref it ourselve*/
    return PyInt_FromLong(0);
  }

  if (rt) {
    Py_INCREF(rt);
    return rt;
  }
  return node_getattr((PyNodeObject*)self,name, Attr_methods);
}

static void attr_dealloc(PyAttrObject *node)
{
  node_dealloc((PyNodeObject*)node);
}

void attr_build_display_string(buf,v)
     char *buf;
     PyAttrObject *v;
{
  sprintf(buf, "<cDomlette Attribute Node at %x: name='%s', value='%s'>",
      (long)v,
      PyString_AS_STRING(v->nodeData.nodeName),
      PyString_AS_STRING(v->attrData.nodeValue)
      );
}

static int
attr_print(v, fp, flags)
     PyAttrObject *v;
     FILE *fp;
     int flags; /* Not used but required by interface */
{
  char buf[256];
  attr_build_display_string(buf,v);
  fputs(buf, fp);
  return 0;
}

/*
  Our type
 */

PyTypeObject PyDomletteAttr_Type = {
    PyObject_HEAD_INIT(0)
    0,
    "cDomlette.Attr",
    sizeof(PyAttrObject),
    0,
    (destructor)attr_dealloc,   /*tp_dealloc*/
    (printfunc)attr_print,          /*tp_print*/
    (getattrfunc)attr_getattr,  /*tp_getattr*/
    0,              /*tp_setattr*/
    0,                          /*tp_compare*/
    0,          /*tp_repr*/
    0,                          /*tp_as_number*/
    0,              /*tp_as_sequence*/
    0,              /*tp_as_mapping*/
    0,                             /*tp_hash*/
    0,          /*tp_call*/
    0,          /*tp_str*/
    0,                      /*tp_getattro*/
    0,          /*tp_setattro*/
};

