"This creates an HDF5 file with a potentially large number of objects"

import sys
import numarray
import tables

# Open a new empty HDF5 file
fileh = tables.openFile("data.nobackup/large-number-objects.h5", mode = "w")

# nlevels -- Number of levels in hierarchy
# ngroups -- Number of groups on each level
# ndatasets -- Number of arrays on each group
# LR: Low ratio groups/datasets
#nlevels, ngroups, ndatasets = (3, 1, 1000)
# MR: Medium ratio groups/datasets
#nlevels, ngroups, ndatasets = (3, 10, 100)
# HR: High ratio groups/datasets
nlevels, ngroups, ndatasets = (30, 10, 10)

# Create an Array to save on disk
a = numarray.array([-1, 2, 4], numarray.Int16)

group = fileh.root
for j in range(ngroups):
    for i in range(ndatasets):
        # Save the array on the HDF5 file
        fileh.createArray(group, 'array'+str(i), a, "Signed short array")
    # Create a new group
    group2 = fileh.createGroup(group, 'group'+str(j))
    # Iterate over this new group (group2)
    group = group2

fileh.close()

