%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

Name:           python-pyspf
Version:        2.0.10
Release:        1%{?dist}
Summary:        Python module and programs for SPF (Sender Policy Framework).

Group:          Development/Languages
License:        Python Software Foundation License
URL:            http://sourceforge.net/forum/forum.php?forum_id=596908
Source0:        pyspf-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  python-setuptools python-devel
Requires:       python-pydns python >= 2.6 python-authres python-ipaddr >= 2.1.10
# Provide pyspf *only* if not using pyspf package for non-default python
Provides:	pyspf

%description
SPF does email sender validation.  For more information about SPF,
please see http://openspf.net

This SPF client is intended to be installed on the border MTA, checking
if incoming SMTP clients are permitted to send mail.  The SPF check
should be done during the MAIL FROM:<...> command.

%define namewithoutpythonprefix %(echo %{name} | sed 's/^python-//')
%prep
%setup -q -n %{namewithoutpythonprefix}-%{version}


%build
%{__python} setup.py build


%install
rm -rf $RPM_BUILD_ROOT
%{__python} setup.py install -O1 --skip-build --root $RPM_BUILD_ROOT
mv $RPM_BUILD_ROOT/usr/bin/type99.py $RPM_BUILD_ROOT/usr/bin/type99
mv $RPM_BUILD_ROOT/usr/bin/spfquery.py $RPM_BUILD_ROOT/usr/bin/spfquery
rm -f $RPM_BUILD_ROOT/usr/bin/*.py{o,c}


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc CHANGELOG PKG-INFO README test
%{python_sitelib}/spf.py*
/usr/bin/type99
/usr/bin/spfquery
/usr/lib/python2.6/site-packages/pyspf-%{version}-py2.6.egg-info

%changelog
* Tue Sep  2 2014 Stuart Gathman <stuart@gathman.org> 2.0.10-1
- Fix AAAA not flagged as bytes when strict=2 
- Split mechanisms by space only, not by whitespace
- include '~' as safe char in url quoted macro expansion
- treat AttributeError from pydns as TempError

* Tue Apr 29 2014 Stuart Gathman <stuart@gathman.org> 2.0.9-1
- RFC7208 support
- void lookup limit and test cases
- Convert YAML tests to TestCases, and have testspf.py return success/fail.

* Tue Jul 23 2013 Stuart Gathman <stuart@gathman.org> 2.0.8-2
- Test case and fix for PermError on non-ascii chars in non-SPF TXT records
- Use ipaddr/ipaddress module in place of custom IP processing code
- Numerous python3 compatibility fixes
- Improved unicode error detection in SPF records
- Fixed a bug caused by a null CNAME in cache

* Fri Feb 03 2012 Stuart Gathman <stuart@bmsi.com> 2.0.7-1
- fix CNAME chain duplicating TXT records
- local test cases for CNAME chains
- python3 compatibility changes e.g. print a -> print(a)
- check for 7-bit ascii on TXT and SPF records
- Use openspf.net for SPF web site instead of openspf.org
- Support Authentication-Results header field
- Support overall DNS timeout

* Thu Oct 27 2011 Stuart Gathman <stuart@bmsi.com> 2.0.6-1
- Python3 port (still requires 2to3 on spf.py)
- Ensure Temperror for all DNS rcodes other than 0 and 3 per RFC 4408
- Parse Received-SPF header
- Report CIDR error only for valid mechanism
- Handle invalid SPF record on command line
- Add timeout to check2
- Check for non-ascii policy
- parse_header method
- python2.6

* Wed Apr 02 2008 Stuart Gathman <stuart@bmsi.com> 2.0.5-1
- Add timeout parameter to query ctor and DNSLookup
- Patch from Scott Kitterman to retry truncated results with TCP unless harsh
- Validate DNS labels
- Reflect decision on empty-exp errata

* Wed Jul 25 2007 Stuart Gathman <stuart@bmsi.com> 2.0.4-1
- Correct unofficial 'best guess' processing.
- PTR validation processing cleanup
- Improved detection of exp= errors
- Keyword args for get_header, minor fixes

* Mon Jan 15 2007 Stuart Gathman <stuart@bmsi.com> 2.0.3-1
- pyspf requires pydns, python-pyspf requires python-pydns
- Record matching mechanism and add to Received-SPF header.
- Test for RFC4408 6.2/4, and fix spf.py to comply.
- Test for type SPF (type 99) by default in harsh mode only.
- Permerror for more than one exp or redirect modifier.
- Parse op= modifier

* Sat Dec 30 2006 Stuart Gathman <stuart@bmsi.com> 2.0.2-1
- Update openspf URLs
- Update Readme to better describe available pyspf interfaces
- Add basic description of type99.py and spfquery.py scripts
- Add usage instructions for type99.py DNS RR type conversion script
- Add spfquery.py usage instructions
- Incorporate downstream feedback from Debian packager
- Fix key-value quoting in get_header

* Fri Dec 08 2006 Stuart Gathman <stuart@bmsi.com> 2.0.1-1
- Prevent cache poisoning attack
- Prevent malformed RR attack
- Update license on a few files we missed last time

* Mon Nov 20 2006 Stuart Gathman <stuart@bmsi.com> 2.0-1
- Completed RFC 4408 compliance
- Added spf.check2 for RFC 4408 compatible result codes
- Full IP6 support
- Fedora Core compatible RPM spec file
- Update README, licenses

* Tue Sep 26 2006 Stuart Gathman <stuart@bmsi.com> 1.8-1
- YAML test suite syntax
- trailing dot support (RFC4408 8.1)

* Tue Aug 29 2006 Sean Reifschneider <jafo@tummy.com> 1.7-1
- Initial RPM spec file.
