/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Pointer {
    public static final int SIZE = Native.POINTER_SIZE;
    public static final Pointer NULL;
    long peer;

    public static final Pointer createConstant(long peer) {
        return new Opaque(peer);
    }

    Pointer() {
    }

    Pointer(long peer) {
        this.peer = peer;
    }

    public Pointer share(long offset, long sz) {
        return new Pointer(this.peer + offset);
    }

    void clear(long size) {
        this.setMemory(0L, size, (byte)0);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return this.peer == 0L;
        }
        return o instanceof Pointer && ((Pointer)o).peer == this.peer;
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFFFFFFFFFL));
    }

    public native long indexOf(long var1, byte var3);

    public native void read(long var1, byte[] var3, int var4, int var5);

    public native void read(long var1, short[] var3, int var4, int var5);

    public native void read(long var1, char[] var3, int var4, int var5);

    public native void read(long var1, int[] var3, int var4, int var5);

    public native void read(long var1, long[] var3, int var4, int var5);

    public native void read(long var1, float[] var3, int var4, int var5);

    public native void read(long var1, double[] var3, int var4, int var5);

    public void read(long bOff, Pointer[] buf, int index, int length) {
        for (int i = 0; i < length; ++i) {
            buf[i + index] = this.getPointer(bOff + (long)(i * SIZE));
        }
    }

    public native void write(long var1, byte[] var3, int var4, int var5);

    public native void write(long var1, short[] var3, int var4, int var5);

    public native void write(long var1, char[] var3, int var4, int var5);

    public native void write(long var1, int[] var3, int var4, int var5);

    public native void write(long var1, long[] var3, int var4, int var5);

    public native void write(long var1, float[] var3, int var4, int var5);

    public native void write(long var1, double[] var3, int var4, int var5);

    public void write(long bOff, Pointer[] buf, int index, int length) {
        for (int i = 0; i < length; ++i) {
            this.setPointer(bOff + (long)(i * SIZE), buf[index + i]);
        }
    }

    public native byte getByte(long var1);

    public native char getChar(long var1);

    public native short getShort(long var1);

    public native int getInt(long var1);

    public native long getLong(long var1);

    public NativeLong getNativeLong(long offset) {
        return new NativeLong(NativeLong.SIZE == 8 ? this.getLong(offset) : (long)this.getInt(offset));
    }

    public native float getFloat(long var1);

    public native double getDouble(long var1);

    public native Pointer getPointer(long var1);

    public ByteBuffer getByteBuffer(long offset, long length) {
        return this.getDirectByteBuffer(offset, length).order(ByteOrder.nativeOrder());
    }

    private native ByteBuffer getDirectByteBuffer(long var1, long var3);

    public native String getString(long var1, boolean var3);

    public String getString(long offset) {
        long len;
        String encoding = System.getProperty("jna.encoding");
        if (encoding != null && (len = this.indexOf(offset, (byte)0)) != -1L) {
            if (len > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("String exceeds maximum length: " + len);
            }
            byte[] data = this.getByteArray(offset, (int)len);
            try {
                return new String(data, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return this.getString(offset, false);
    }

    public byte[] getByteArray(long offset, int arraySize) {
        byte[] buf = new byte[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public char[] getCharArray(long offset, int arraySize) {
        char[] buf = new char[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public short[] getShortArray(long offset, int arraySize) {
        short[] buf = new short[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public int[] getIntArray(long offset, int arraySize) {
        int[] buf = new int[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public long[] getLongArray(long offset, int arraySize) {
        long[] buf = new long[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public float[] getFloatArray(long offset, int arraySize) {
        float[] buf = new float[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public double[] getDoubleArray(long offset, int arraySize) {
        double[] buf = new double[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public Pointer[] getPointerArray(long offset, int arraySize) {
        Pointer[] buf = new Pointer[arraySize];
        this.read(offset, buf, 0, arraySize);
        return buf;
    }

    public native void setMemory(long var1, long var3, byte var5);

    public native void setByte(long var1, byte var3);

    public native void setShort(long var1, short var3);

    public native void setChar(long var1, char var3);

    public native void setInt(long var1, int var3);

    public native void setLong(long var1, long var3);

    public void setNativeLong(long offset, NativeLong value) {
        if (NativeLong.SIZE == 8) {
            this.setLong(offset, value.longValue());
        } else {
            this.setInt(offset, value.intValue());
        }
    }

    public native void setFloat(long var1, float var3);

    public native void setDouble(long var1, double var3);

    public native void setPointer(long var1, Pointer var3);

    public native void setString(long var1, String var3, boolean var4);

    public void setString(long offset, String value) {
        byte[] data = Native.getBytes(value);
        this.write(offset, data, 0, data.length);
        this.setByte(offset + (long)data.length, (byte)0);
    }

    public String toString() {
        return "native@0x" + Long.toHexString(this.peer);
    }

    static {
        if (SIZE == 0) {
            throw new Error("Native library not initialized");
        }
        NULL = null;
    }

    private static class Opaque
    extends Pointer {
        private String MSG = "This pointer is opaque: " + this;

        private Opaque(long peer) {
            super(peer);
        }

        public long indexOf(long offset, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, byte[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, char[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, short[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, int[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, long[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, float[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, double[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, byte[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, char[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, short[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, int[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, long[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, float[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, double[] buf, int index, int length) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public byte getByte(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public char getChar(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public short getShort(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public int getInt(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public long getLong(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public float getFloat(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public double getDouble(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public Pointer getPointer(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public String getString(long bOff, boolean wide) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setByte(long bOff, byte value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setChar(long bOff, char value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setShort(long bOff, short value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setInt(long bOff, int value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setLong(long bOff, long value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setFloat(long bOff, float value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setDouble(long bOff, double value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setPointer(long offset, Pointer value) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setString(long offset, String value, boolean wide) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public String toString() {
            return "opaque@0x" + Long.toHexString(this.peer);
        }
    }
}

