# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import os.path

# Application
appVersion   = '1.1'
appNameShort = 'pypar2'
appName      = 'PyPar2'
appURL       = 'http://pypar2.silent-blade.org'
prefsVersion = 1

# Directories
dirUsr = os.path.expanduser('~')
dirCfg = os.path.join(dirUsr, '.' + appNameShort)
dirSrc = os.path.join(os.path.dirname(__file__))
dirRes = os.path.join(dirSrc, '..', 'res')
dirPix = os.path.join(dirSrc, '..', 'pix')

dirLocale = os.path.join(dirSrc, '..', 'locale')
if not os.path.isdir(dirLocale) :
    dirLocale = os.path.join(dirSrc, '..', '..', 'locale')

# Files
fileImgAbout = os.path.join(dirPix, 'about.png')
fileImgIcon  = os.path.join(dirPix, 'icon.png')
filePrefs    = os.path.join(dirCfg, 'prefs.xml')
fileLicense  = '/usr/share/common-licenses/GPL-2'

# Create the configuration directory if needed
if not os.path.isdir(dirCfg) :
    os.mkdir(dirCfg)
