'''OpenGL extension NV.vertex_array_range2

Overview (from the spec)
	
	Enabling and disabling the vertex array range is specified by the
	original NV_vertex_array_range extension specification to flush the
	vertex array range implicitly.  In retrospect, this semantic is
	extremely misconceived and creates terrible performance problems
	for any application that wishes to mix conventional vertex arrays
	with vertex arrange range-enabled vertex arrays.
	
	This extension provides a new token for enabling/disabling the
	vertex array range that does NOT perform an implicit vertex array
	range flush when the enable/disable is performed.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/NV/vertex_array_range2.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = constant.Constant( 'GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV', 0x8533 )


def glInitVertexArrayRange2NV():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_NV_vertex_array_range2' )
