'''OpenGL extension EXT.color_subtable

Overview (from the spec)
	
	This extension allows a portion of a color table to be redefined.
	If EXT_copy_texture is implemented, this extension also defines a
	method to load a portion of a color lookup table from the 
	framebuffer.
	

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/color_subtable.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes

glColorSubTableEXT = platform.createExtensionFunction( 
	'glColorSubTableEXT', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLsizei, constants.GLsizei, constants.GLenum, constants.GLenum, ctypes.c_void_p,),
	doc = 'glColorSubTableEXT( GLenum(target), GLsizei(start), GLsizei(count), GLenum(format), GLenum(type), c_void_p(data) ) -> None',
	argNames = ('target', 'start', 'count', 'format', 'type', 'data',),
)

glCopyColorSubTableEXT = platform.createExtensionFunction( 
	'glCopyColorSubTableEXT', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLsizei, constants.GLint, constants.GLint, constants.GLsizei,),
	doc = 'glCopyColorSubTableEXT( GLenum(target), GLsizei(start), GLint(x), GLint(y), GLsizei(width) ) -> None',
	argNames = ('target', 'start', 'x', 'y', 'width',),
)


def glInitColorSubtableEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_EXT_color_subtable' )
