from distutils.core import setup, Extension

setup(
  name         = "PyOpenAL",
  version      = "0.1.3",
  license      = "LGPL",
  description  = "OpenAL port to Python.",
  long_description  = """OpenAL port to Python.
Does not include OpenAL extension.
There's also a module for integrating OpenAL with the Soya3d engine.""",
  author       = "Blam (LAMY Bertrand), Jiba (LAMY Jean-Baptiste)",
  author_email = "jiba@tuxfamily.org",
  url          = "http://oomadness.tuxfamily.org/en/pyopenal",
  home_page    = "http://oomadness.tuxfamily.org/en/pyopenal",
  classifiers  = [
  "Topic :: Multimedia :: Sound/Audio :: Players",
  "Topic :: Software Development :: Libraries :: Python Modules",
  "Programming Language :: Python",
  "Intended Audience :: Developers",
  "Development Status :: 5 - Production/Stable",
  "License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)",
  ],
  
  package_dir  = {"pyopenal" : ""},
  packages     = ["pyopenal"],
  
  ext_modules  = [Extension("_openal",
                            ["py_openal.c"],
                            ["/usr/include", "/usr/local/include"],
                            [("HAVE_CONFIG_H", None)],
                            None,
                            ["/usr/lib", "/usr/local/lib"],
                            ["openal"],
                            )
                  ]
  )

