#!/usr/bin/env python
## pyNeighborhood.py
## 
## Copyright (C) 2005-2007 Mykola Lynnyk <pydefiner@gmail.com>
## Copyright (C) 2008 Stefan J. Betz <stefan_betz@gmx.net>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 3 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

from sys import argv, _getframe
from inspect import getframeinfo
from os import getenv
from os.path import exists, dirname, abspath, join, split, basename
from optparse import OptionParser

# Global Variable Definitions
options = None

# Function Definitions
def unpad(mystr):
    """
    Removes more than one Space in the String 'str'
    """
    unpaded = []
    for item in mystr.split(" "):
        temp = item.strip()
        if temp != "":
            unpaded.append(temp)
    result = " ".join(unpaded)
    return result

def localenv():
    """
    This function is used to determine whether we work global or local
    """
    if exists(join(dirname(abspath(argv[0])),"pyneighborhood")):
        return True
        autoprefix = dirname(abspath(argv[0]))
    else:
        return False
        autoprefix = dirname(dirname(abspath(argv[0]))[:-3])

def prefix():
    """
    "Calculate" prefix using superior folder structure
    """
    if localenv():
        return dirname(abspath(argv[0]))
    else:
        return split(dirname(argv[0]))[0]

def iconpath():
    """
    This Function returns the Icon Path
    """
    if localenv():
        return prefix() + "/icons"
    else:
        return prefix() + "/share/pyneighborhood/icons"

def sharepath():
    """
    This Function returns the Shared Path (Glade Files an so on)
    """
    if localenv():
        return prefix()
    else:
        return prefix() + "/share/pyneighborhood"

def homeconfdir():
    """
    This Function returns the User Configuration Path (~/.pyNeighborhood)
    """
    return getenv("HOME") + "/.pyNeighborhood"

def parse_args():
    """
    Parse Command Line Arguments
    """
    parser = OptionParser()
    parser.add_option("-d", "--debug", action="store_true", dest="debug",
                        help="Enable Debug Output")
    parser.add_option("-t", "--trace", action="store_true", dest="trace",
                        help="Enable Tracing Output")
    global options# Don't remove this, because "options" is then every Time "None"!
    options, args = parser.parse_args()

def print_debug(text, output = None):
    """
    Generic Debug & Trace Handler
    """
    frame = _getframe(1)
    frameinfo = getframeinfo(frame)
    if options.trace:
        if not output:
            print "In %(file)s at Line %(line)i:\n%(text)s" % { "file":basename(frameinfo[0]),
                                                               "line":frameinfo[1],
                                                               "text":text }
        else:
            print "In %(file)s at Line %(line)i, the command '%(text)s' returns:\n%(output)s" % { "file":basename(frameinfo[0]),
                                                               "line":frameinfo[1],
                                                               "text":text,
                                                               "output":output }
    elif options.debug:
        if not output:
            print "Debug: %s" % ( text )
        else:
            print "Debug: Running Command '%s'" % ( text )
