## __init__.py
## 
## Copyright (C) 2005-2007 Mykola Lynnyk <pydefiner@gmail.com>
## Copyright (C) 2008 Stefan J. Betz <stefan_betz@gmx.net>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 3 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

import ConfigParser
from ConfigParser import SafeConfigParser
from os import environ, F_OK, R_OK, X_OK, access, mkdir, chmod
from os.path import isdir
from stat import S_IRUSR, S_IWUSR
from pyneighborhood.misc import homeconfdir, print_debug, parse_args

# DO NOT move this !!!
# Parsing arguments
parse_args()

if not isdir(homeconfdir()):
    print_debug("Creating Config Directory...")
    mkdir(homeconfdir())

config = SafeConfigParser()

if not access(homeconfdir() + "/config", F_OK):
    print_debug("Creating Default Config...")
    config.add_section("Main")
    config.set("Main", "mount_directory", environ["HOME"] + "/pyNeighborhood")
    if not isdir(environ["HOME"] + "/pyNeighborhood"):
        mkdir(environ["HOME"] + "/pyNeighborhood")
    config.set("Main", "cleanup_dirs", "True")
    config.set("Main", "enable_file_manager", "True")
    config.set("Main", "smbclient", "/usr/bin/smbclient")
    config.set("Main", "nmblookup", "/usr/bin/nmblookup")
    config.set("Main", "smbtree", "/usr/bin/smbtree")
    config.set("Main", "username", "")
    config.set("Main", "password", "")
    config.set("Main", "legacy_browsing", "False")
    config.set("Main", "workgroup", "")
    config.set("Main", "filemanager", "/usr/bin/nautilus")
    config.set("Main", "enable_sudo", "True")
    config.set("Main", "sudo", "/usr/bin/gksu")
    config.add_section("SMB")
    config.set("SMB", "enable", "False")
    config.set("SMB", "mount", "/usr/bin/smbmount")
    config.set("SMB", "unmount", "/usr/bin/smbumount")
    config.set("SMB", "options", "")
    config.add_section("CIFS")
    config.set("CIFS", "enable", "True")
    config.set("CIFS", "mount", "/sbin/mount.cifs")
    config.set("CIFS", "unmount", "/sbin/umount.cifs")
    config.set("CIFS", "options", "")
    f = file(homeconfdir() + "/config", "w")
    config.write(f)
    f.flush()
    f.close()
    del f
    chmod(homeconfdir() + "/config", S_IRUSR + S_IWUSR)
else:
    f = file(homeconfdir() + "/config", "r")
    config.readfp(f)
    f.close()
    del f

# Ensure that executables like smbclient, nmblookup, ... really exist
# The conditions are valid defaults defined below...
defaults =  {"nmblookup":   "/usr/bin/nmblookup",
             "smbclient":   "/usr/bin/smbclient",
             "smbtree":     "/usr/bin/smbtree",
             "filemanager": "/usr/bin/nautilus",
             "sudo":        "/usr/bin/gksu"}

for file in defaults.keys():
    if not access( config.get("Main", file), R_OK + X_OK ):
        print_debug( "%s isn't accessable, falling back to default: %s"
                    % ( config.get("Main", file), defaults[file] ) )
        config.set("Main", file, defaults[file])

for file in ["mount", "unmount"]:
    if config.get("SMB", "enable") == "True":
        if not access( config.get("SMB", file), R_OK + X_OK ):
            fallback = "/usr/bin/smb%s" % (file == "mount") and "mount" or "umount"
            print_debug( "%s isn't accessable, falling back to default: %s"
                         % ( config.get("SMB", file), fallback ) )
    else:
        if not access( config.get("CIFS", file), R_OK + X_OK ):
            fallback = "/sbin/%s.cifs" % (file == "mount") and "mount" or "umount"
            print_debug( "%s isn't accessable, falling back to default: %s"
                         % ( config.get("CIFS", file), fallback ) )
        