## threads.py
## 
## Copyright (C) 2005-2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import threading
import gobject 
import string
import time
import thread
from os import system, getenv

import getsmbshare
import checkmount
import sharmount
import pyNeighborhood
import dialog

progressbar_lock = False
pulse = None

class Monitor_Thread(threading.Thread):
    def __init__(self, treestore):
        self.treestore = treestore
        super(Monitor_Thread, self).__init__()
        self.quit = False
        return 

    def monitor_handler(self):
        i=0
        resource = []
        (hosts, shares, mount_points, type) = checkmount.checkmount()
        if self.hosts_old != hosts and self.shares_old != shares:
            self.treestore.clear()
            for host in hosts:
                resource.append(string.join(["/", host, shares[i]], '/'))
                iter = self.treestore.append(None, None)
                self.treestore.set(iter, 0, type[i])
                self.treestore.set(iter, 1, resource[i])
                self.treestore.set(iter, 2, mount_points[i])
                i = i+1
            self.hosts_old = hosts
            self.shares_old = shares
        return

    def run(self):
        self.hosts_old = []
        self.shares_old= []
        while not self.quit:
            gobject.idle_add(self.monitor_handler)
            time.sleep(2)
        return
 
class Mount_Thread(threading.Thread):
    def __init__(self, treeview,  path, column, treestore, notebook, mount_type):
        self.treestore = treestore
        self.treeview = treeview
        self.path = path
        self.column = column
        self.notebook = notebook
        self.mount_type = mount_type

        super(Mount_Thread, self).__init__()
        self.quit = False
        self.flag_exit = 1

    def mountshar(self, treestore):
        f_thread = Fmanager_Thread(self.notebook, self.treeview, pyNeighborhood.parser.file_managers[0])
        f_thread.start()
        treestore.set(self.iter, 3, self.mount_point)
        return

    def mount_by_type(self, type):
        self.show_popup = True
        if type == "ip":
            self.h_name = self.dic["ip"]
            print "IP: ", self.h_name
        if type == "netbios":
            self.h_name = self.dic["netbios"]
        
        if self.h_name == "":
            return
        (hosts, shares, mount_points, type) = checkmount.checkmount()
        flag = 0
        
        count1 = 0
        count2 = 0
        print self.h_name
        for num in hosts:
            if num == string.upper(self.h_name):
                print num
                for num1 in shares:
                    if num1 == self.current_host: 
                        if count1 == count2: 
                            print "Already mounted!!!"
                            gobject.idle_add(dialog.dialog,"According to mtab already mounted.", None)
                            self.result = False
                            self.show_popup = False
                            return
                    count2 = count2 + 1
                count2 = 0
            count1 = count1 + 1

        for num in mount_points:
            if num == self.mount_point: 
                print "Mount point already in use!!!"
                gobject.idle_add(dialog.dialog,"Mount point already in use.", None)
                self.result = False
                self.show_popup = False
                return

        self.result = sharmount.sharmount(self.h_name, self.current_host, self.mount_point, self.mount_type)
        if self.result:
            print "Mounted succesfully"
        else:
            print "Failed to mount"
            
    def run(self):
        #get a share properties		
        model = self.treeview.get_model()
        self.iter = model.get_iter(self.path)
        self.current_host = model.get_value(self.iter, 0)
        par_iter = model.iter_parent(self.iter)

        self.dic = pyNeighborhood.hosts.find(model.get_value(par_iter, 0))
        self.display_name = model.get_value(par_iter, 0)

        #resolve mountpoint
        self.mount_dir = pyNeighborhood.parser.get_value("mount_directory")

        self.mount_point = string.join([self.mount_dir, "/" ,self.display_name , "/" , self.current_host], '')
	    
        if self.notebook.get_current_page() == 0:
            self.mount_by_type("ip")

            host_ch, share_ch, mount_points_ch, type_ch = checkmount.checkmount()
            try:
                host_ch.index(self.h_name)
            except:
                print "Failed, mounting by netbios"
                self.mount_by_type("netbios")
                host_ch, share_ch, mount_points_ch, type_ch = checkmount.checkmount()
                try:
                    host_ch.index(string.upper(self.h_name))
                except:
                    gobject.idle_add(dialog.dialog, "Failed to mount.", None)
                    return
        if self.result:
            gobject.idle_add(self.mountshar, self.treestore)
        else:
            if self.show_popup:
                gobject.idle_add(dialog.dialog, "Failed to mount.", None)
				

class Umount_Thread(threading.Thread):
    def __init__(self, notebook, treeview, treestore, treeview_mon, treestore_mon, treeview_groups ,treestore_groups):
        self.notebook = notebook
        self.treestore = treestore
        self.treestore_mon = treestore_mon
        self.treestore_groups = treestore_groups
        self.treeview = treeview
        self.treeview_mon = treeview_mon
        self.treeview_groups = treeview_groups

        super(Umount_Thread, self).__init__()
        return 

    def run(self):
        notebook = self.notebook
        treestore = self.treestore
        treestore_mon = self.treestore_mon
        treestore_groups = self.treestore_groups
        treeview =self.treeview
        treeview_mon = self.treeview_mon
        treeview_groups = self.treeview_groups

        page = notebook.get_current_page()
        if page == 0:
            treeselection = treeview.get_selection()
            (model, iter) = treeselection.get_selected()
            par_iter = model.iter_parent(iter)
            if not par_iter == None:
                h_name = model.get_value(iter, 3)
                flag = sharmount.sharumount(h_name)
                if flag == True: gobject.idle_add(treestore.set, iter, 3, '')
                else: 
                    print "Could not unmount current share"
                    gobject.idle_add(dialog.dialog,"Could not unmount current share.", None)

            else: print "Probably not smb-filesystem "
            return

        if page == 1:
            treeselection = treeview_mon.get_selection()
            (model, iter) = treeselection.get_selected()
            try:
                host_share = model.get_value(iter, 1)
                print host_share
            except:
                return
            mountpoint = model.get_value(iter, 2)
            line = host_share.split('/')
            line[3] = line[3].replace("_", " ")

            temp_dic = pyNeighborhood.hosts.find_by_name(line[2])
            if temp_dic == None:
                temp_dic = pyNeighborhood.hosts.find_by_ip(line[2])
            flag = sharmount.sharumount(mountpoint)
            if flag == True: 
                gobject.idle_add(treestore_mon.remove, iter)
                try:
                    hostlist = pyNeighborhood.hosts.hostslist
                    n = 0
                    k = 0
                    for host in hostlist:
                        iter = treestore.get_iter((n, ))
                        value = treestore.get_value(iter, 0)
                        n = n + 1
                        if value == temp_dic["display"]:
                            break
                        value_sh = ''
                    while True:
                        iter_sh = treestore.get_iter((n-1, k))
                        value_sh = treestore.get_value(iter_sh, 0)
                        k = k + 1
                        if value_sh == line[3]:
                            break
                    gobject.idle_add(treestore.set,iter_sh, 3, '')
                except:
                    return
            else:
                print "Could not unmount current share"
                gobject.idle_add(dialog.dialog,"Could not unmount current share.", None)
            return
        return

class Fmanager_Thread(threading.Thread):
    def __init__(self, notebook, treeview, label):
        self.notebook = notebook
        self.treeview = treeview
        self.label = label

        super(Fmanager_Thread, self).__init__()
        return 

    def filemanager(self, notebook, treeview):
        page = notebook.get_current_page()
        treeselection = treeview.get_selection()
        (model, iter) = treeselection.get_selected()
        if page == 0:
            par_iter = model.iter_parent(iter)
            if not par_iter == None:
                h_name = model.get_value(iter, 3)
                sharmount.file_mng(h_name, self.label)
            return
        if page == 1:
            try:
                mountpoint = model.get_value(iter, 2)
                print mountpoint
            except:
                return
            sharmount.file_mng(mountpoint, self.label)
        return
		
    def run(self):
        self.filemanager(self.notebook, self.treeview)
        return

class RetrieveData_Thread(threading.Thread):
    def __init__(self, button, entry_name, entry_ip, entry_display):
        self.button = button
        self.entry_name = entry_name
        self.entry_ip = entry_ip
        self.entry_display = entry_display
        super(RetrieveData_Thread, self).__init__()
        return 
    
    def update_gui(self, set_query):
        self.button.set_sensitive(True)
        self.entry_name.set_sensitive(True)
        self.entry_ip.set_sensitive(True)
        self.entry_display.set_sensitive(True)
        
        if set_query == True:
            self.entry_name.set_text(self.host)
            self.entry_ip.set_text(self.ip)

    def run(self):
        self.host, self.ip = '', ''
        try:
            self.host, self.ip = getsmbshare.retrieve_share_data(pyNeighborhood.unpad(self.entry_name.get_text()), 
                                                       pyNeighborhood.unpad(self.entry_ip.get_text()))
            if not pyNeighborhood.ip_validator(self.ip):
                self.ip = ""
        except:
            gobject.idle_add(self.update_gui, False)
        print self.host, self.ip
        if self.ip != "failed":
            gobject.idle_add(self.update_gui, True)
            return

        gobject.idle_add(self.update_gui, False)
        return

class Append_Groups_Thread(threading.Thread):
    def __init__(self, treeview, path, treestore, type):
        self.treeview = treeview
        self.treestore = treestore
        self.type = type
        self.treeselection = self.treeview.get_selection()

        self.id = threading._get_ident()
        self.model = treeview.get_model()
        self.iter = self.model.get_iter(path)

        super(Append_Groups_Thread, self).__init__()

    def clearlist(self, treeview, treestore):
        treestore.remove(self.iter)
        self.iter = self.treestore.append(None, ["Groups", "groups", ""])
        self.treeselection.select_iter(self.iter)

    def appendshar(self, treeview, treestore):
        treestore.remove(self.iter)
        self.iter = self.treestore.append(None, ["Groups", "groups", ""])
        self.treeselection.select_iter(self.iter)
        c = 0
        for parent in self.workgroups:
            iter = self.treestore.append(self.iter, [ self.workgroups[c], 'workgroup', ""])
            self.treestore.set(iter, 2, '')
            c = c + 1

        path = self.model.get_path(self.iter)
        treeview.expand_row(path, True)
        return

    def run(self):
        if pyNeighborhood.groups_scan_lock:
            print "Groups scan already running"
            return
        pyNeighborhood.groups_scan_lock = True
        if not progressbar_lock:
            print "Trying to start the pulse thread"
            pulse = ProgressBar_Thread()
            pulse.start()
        
        gobject.idle_add(pyNeighborhood.update_statusbar, 
                         pyNeighborhood.statusbar, "Scanning groups...")
        gobject.idle_add(self.clearlist, self.treeview, self.treestore)
        self.workgroups = []
        self.masters = []
        self.ipaddrs = []
        print self.type
        
        try:
            if self.type == "common":
                (self.workgroups, self.masters) = getsmbshare.getgroups()
            if self.type == "msbrowse":
                (self.workgroups, self.masters, self.ipaddrs) = getsmbshare.getgroups_msbrowse()

            pyNeighborhood.workgroups = self.workgroups
            pyNeighborhood.masters = self.masters
            pyNeighborhood.master_ips = self.ipaddrs
            gobject.idle_add(self.appendshar, self.treeview, self.treestore)
            gobject.idle_add(pyNeighborhood.update_statusbar, 
                             pyNeighborhood.statusbar, "Finished scanning groups")
        except:
            gobject.idle_add(pyNeighborhood.update_statusbar,
                             pyNeighborhood.statusbar, "Failed to scan groups")
            print "Failed to scan groups"

        if not progressbar_lock:
            try:
                pulse.stop()
                pulse = None
                print "Stopped the pulse thread succesfully"
            except:
                print "Pulse thread exception"
        pyNeighborhood.groups_scan_lock = False
        return

class Append_Workgroup_Thread(threading.Thread):
    def __init__(self, treeview,  path, treestore):
        self.treeview = treeview
        self.path = path
        self.treestore = treestore
        self.treeselection = treeview.get_selection()

        self.id = threading._get_ident()
        self.model = treeview.get_model()
        self.iter = self.model.get_iter(path)
        self.current_name = self.model.get_value(self.iter, 0)
        self.m_browser = ""
        self.m_browser_ip = ""
        try:
            self.m_browser_ip = pyNeighborhood.master_ips[pyNeighborhood.workgroups.index(self.current_name)]
            self.m_browser = pyNeighborhood.masters[pyNeighborhood.workgroups.index(self.current_name)]
        except:
            try:
                self.m_browser_ip = pyNeighborhood.master_ips[pyNeighborhood.workgroups.index(self.current_name)]
            except:
                self.m_browser = pyNeighborhood.masters[pyNeighborhood.workgroups.index(self.current_name)]

        super(Append_Workgroup_Thread, self).__init__()

    def appendshar(self, treeview,  path, treestore):
        #get some necessary info 
        model = self.model
        iter = self.iter
        current_name = self.current_name
        (servers, commentlist) = (self.servers, self.commentlist)

        i = 0
        is_last_iter = False
        #check whether we are trying to scan a last share
        if model.iter_next(iter) == None:
            is_last_iter = True
            useiter = model.iter_parent(iter)
        else:
            useiter = iter
        
        treestore.remove(iter)
        if not is_last_iter:
            newiter = treestore.insert_before(None, useiter, [current_name, "workgroup", ""])
        else:
            newiter = treestore.append(useiter,[current_name, "host", ""])
        self.treeselection.select_iter(newiter)

        for child in servers:
            temiter = treestore.append(newiter, [servers[i], "host", commentlist[i]])
            i = i+1
        
        if self.path == (0, 0) and is_last_iter:
            path = self.model.get_path(useiter)
            treeview.expand_row(path, True)
        else:
            treeview.expand_row(self.path, True)
        self.treeselection.select_iter(newiter)
        return False

    def run(self):
        try: 
            pyNeighborhood.workgroups_scan_locks.index(self.current_name)
            print "This workgroup is alredy being scanned"
            return
        except:
            print "Scanning workgroup at first"
        pyNeighborhood.workgroups_scan_locks.append(self.current_name)
        
        if not progressbar_lock:
            print "Trying to start the pulse thread"
            pulse = ProgressBar_Thread()
            pulse.start()
        
        result = True
        message_workgroupscan = "Scanning workgroup %s"

        gobject.idle_add(pyNeighborhood.update_statusbar, 
                         pyNeighborhood.statusbar, 
                         message_workgroupscan % self.current_name + "...")

        (self.servers, self.commentlist) = getsmbshare.gethosts(self.m_browser)
        if self.servers == []:
            if self.m_browser_ip != '':
                print "Using workgroup scan by ip"
                (self.servers, self.commentlist) = getsmbshare.gethosts(self.m_browser_ip)
            else:
                result = False

        if self.servers == []:
            result = False

        if result != False:
            gobject.idle_add(self.appendshar, self.treeview,  self.path, self.treestore)
            gobject.idle_add(pyNeighborhood.update_statusbar, 
                             pyNeighborhood.statusbar, 
                             message_workgroupscan % self.current_name + "... " + pyNeighborhood.message_success)

        else: 
            gobject.idle_add(pyNeighborhood.update_statusbar, 
                             pyNeighborhood.statusbar, 
                             "Failed to scan workgroup %s" % self.current_name)

        if not progressbar_lock:
            try:
                pulse.stop()
                pulse = None
                print "Stopped the pulse thread succesfully"
            except:
                print "Pulse thread exception"
        pyNeighborhood.workgroups_scan_locks.remove(self.current_name)
        return
 
class Append_Share_Thread(threading.Thread):
    def __init__(self, treeview,  path, column, treestore, newiter):
        self.treeview = treeview
        self.path = path
        self.column = column
        self.treestore = treestore
        self.newiter = newiter
        
        self.id = threading._get_ident()
        self.model = treeview.get_model()
        self.iter = self.model.get_iter(path)
        self.current_name = self.model.get_value(self.iter, 0)
        dic = pyNeighborhood.hosts.find(self.current_name)
        print "Current name:", self.current_name
        print "Dictionary:", dic
        if dic != None:
            self.current_ip = dic["ip"]
            self.current_host = dic["netbios"]
            if self.current_host == '':
                self.current_host = dic["ip"]
        else:
            self.current_host = self.current_name

        super(Append_Share_Thread, self).__init__()

    def appendshar(self, treeview,  path, column, treestore):
        #get some necessary info 
        model = self.model
        iter = self.iter
        current_host = self.current_host
        current_name = self.current_name
        cur_host_prev = current_host
        newiter = self.newiter
        #get a list of shares with comments
        (hosts, shares, mount_points, type) = checkmount.checkmount()
        #print hosts, shares, mount_points
        (hostsharlist, commentlist) = (self.hostsharlist, self.commentlist)
        if hostsharlist == 0:
            return False

        #
        # Create a dictionary of mounted shares for current host
        #
        cur_mount_dic = {}
        n = 0
        for host in hosts:
            if host == string.upper(current_host):
                cur_mount_dic[shares[n]] = mount_points[n]
            else:
                if pyNeighborhood.hosts.find_by_ip(host) != None:
                    if string.upper(pyNeighborhood.hosts.find_by_ip(host)["netbios"]) == string.upper(current_host):
                        cur_mount_dic[shares[n]] = mount_points[n]
            n = n + 1

        i = 0

        for child in hostsharlist:
            temiter = treestore.append(newiter, [hostsharlist[i], "share", commentlist[i], ""])
            try:
                cur_mount_dic[hostsharlist[i]]
                treestore.set_value(temiter, 3, cur_mount_dic[hostsharlist[i]])
            except:
                pass
                #print hostsharlist[i], "not in dictinary"
            i = i+1

        treeview.expand_row(path, True)
        return False

    def run(self):
        try: 
            pyNeighborhood.shares_scan_locks.index(self.current_name)
            print "This host is alredy being scanned"
            return
        except:
            print "Scanning host at first"
        pyNeighborhood.shares_scan_locks.append(self.current_name)
        
        if not progressbar_lock:
            print "Trying to start the pulse thread"
            pulse = ProgressBar_Thread()
            pulse.start()
        
        message_hostscan = "Scanning host %s"

        gobject.idle_add(pyNeighborhood.update_statusbar, 
                         pyNeighborhood.statusbar, 
                         message_hostscan % self.current_host + "...")
        
        if self.current_ip != "":
            (self.hostsharlist, self.commentlist) = getsmbshare.getsmbshare(self.current_ip, self.id)
            if self.hostsharlist == []:
                print "Failed to scan by IP, trying by name..."
                (self.hostsharlist, self.commentlist) = getsmbshare.getsmbshare(self.current_host, self.id)
        else:
            (self.hostsharlist, self.commentlist) = getsmbshare.getsmbshare(self.current_host, self.id)
            
        gobject.idle_add(self.appendshar, self.treeview,  self.path, self.column, self.treestore)
        
        if self.hostsharlist != []:
            gobject.idle_add(pyNeighborhood.update_statusbar, 
                             pyNeighborhood.statusbar, 
                             message_hostscan % self.current_host + "... " + pyNeighborhood.message_success)
            print "success"
        else:
            gobject.idle_add(pyNeighborhood.update_statusbar, 
                             pyNeighborhood.statusbar, 
                             message_hostscan % self.current_host + "... " + pyNeighborhood.message_failed)
            print "failed"

        if not progressbar_lock:
            try:
                pulse.stop()
                pulse = None
                print "Stopped the pulse thread succesfully"
            except:
                print "Pulse thread exception"
        pyNeighborhood.shares_scan_locks.remove(self.current_name)
        return

class ProgressBar_Thread(threading.Thread):
    def __init__(self):
        progressbar_lock = True
        super(ProgressBar_Thread, self).__init__()
        self.quit = False
        return 

    def stop(self):
        print "Quitting the pulse thread"
        self.quit = True
        gobject.source_remove(self.timer)
        gobject.idle_add(pyNeighborhood.progressbar.set_fraction, 0.0)
        progressbar_lock = False

    def run(self):
        print "Starting the pulse thread"
        self.timer = gobject.timeout_add(180, gobject.idle_add, pyNeighborhood.progressbar.pulse)

