## getsmbshare.py
## 
## Copyright (C) 2005-2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import os
import string
from os import system, environ, path, getenv, mkdir, getcwd
import gobject

import pyNeighborhood

def verify_msbrowse_line(line):
     lst = list(line)
     if len(lst) == 4:
        if lst[0] == "<" and lst[3] == ">":
            return True
     return False

def retrieve_share_data(host, ip):
    ip_old, host_old = ip, host
    if ip == "" and host == "":
        return "", ""
    if host != "":
        command = pyNeighborhood.parser.get_value("lookup") + " -T " + '"' + host + '"'
        print command
        lines = os.popen(command).readlines()
        ip_new = lines[1].split(" ")[1]
        if pyNeighborhood.ip_validator(ip_new):
     	      return host, ip_new
        else:
     	      ip_new = lines[1].split(" ")[0]
     	      if pyNeighborhood.ip_validator(ip_new):
                return host, ip_new
        print "Invalid IP", ip_new
        return host, ip_new
        
    if ip != "":
        command = pyNeighborhood.parser.get_value("lookup") + " -A " + '"' + ip + '"'
        print command
        lines = os.popen(command).readlines()
        try:
            host = pyNeighborhood.unpad(lines[1].split(" ")[0].split("\t")[1])
        except:
            return host_old, ip_old
        
        if string.swapcase(os.popen("hostname").readlines()[0].split("\n")[0]) == host:
            return host_old, ip_old
        print "Host: ", host, "     IP: ", ip
        return host, ip

def getsmbshare(host, id):
    print host
    # check if ~/.pyNeighborhood exists. If not, create it
    if not path.exists(getenv("HOME")+"/.pyNeighborhood"): 
        mkdir(getenv("HOME")+"/.pyNeighborhood")

    if path.exists(getenv("HOME")+"/.pyNeighborhood"): 
        home = getenv("HOME")
        conflocation = string.join([home, "/.pyNeighborhood"], '')
        os.chdir(conflocation)

    #specify a command to get a list of smb-shares of a current  host
    if pyNeighborhood.parser.get_value("anonymous") == "True":
        get_client_command = pyNeighborhood.parser.get_value("client") + " -N -L"
        command = string.join([get_client_command, host])
        print "Scanning share", host, "anonymously"
        print command
    else:
        password = "-U" + '"' + pyNeighborhood.user + '"' + "%" + '"' + pyNeighborhood.password + '"'
        command = string.join([pyNeighborhood.parser.get_value("client"), "-L", host, password])
        print "Scanning share", host, "using login"
        print command

    lines = os.popen(command).readlines()
    share_lines = []
	
    sharelist = []
    commentlist = []

    i = 0
    try:
        for line in lines:
            splitted = line.split()
            try:
                splitted.index("Disk")
                share_lines.append(splitted)
            except:
                pass

        for sh_line in share_lines:
            flag = True
            share = ""
            comment = ""
            num = sh_line.index("Disk")
            for entry in sh_line:
                if entry == "Disk":
                    flag = False
                    continue
                if flag == True:
                    share = share + " " + entry
                else:
                    comment = comment + " " + entry

            if share.strip() != "ADMIN$":
                sharelist.append(share.strip())
                commentlist.append(comment.strip())

        return sharelist, commentlist
    except:
        return sharelist, commentlist

def getgroups():
    init_lookup_command =  string.join([pyNeighborhood.parser.get_value("lookup"),"-M",
                           pyNeighborhood.parser.get_value("workgroup"),"-S -d1"])
    m_browser = os.popen(init_lookup_command).readlines()[3].split()[0]

    if pyNeighborhood.parser.get_value("anonymous") == "True":
        password = "-U%"
    else:
        password = string.join(["-U",'"', pyNeighborhood.parser.get_value("user"),'"','%',
                                     '"', pyNeighborhood.parser.get_value("password"),'"'], "")
 
    client_initial_command = string.join([pyNeighborhood.parser.get_value("client"), "-L", m_browser,
                                  "-W", pyNeighborhood.parser.get_value("workgroup"), password, "-d1"])

    print client_initial_command
    lines = os.popen(client_initial_command).readlines()
    sw = False
    workgroups = []
    masters = []
    for line in lines:
        line_sp = line.split()
        if sw == True:
            workgroups.append(line_sp[0])
            masters.append(line_sp[1])
        if len(line_sp) == 2:
            if line_sp[0] == "Workgroup" and line_sp[1] == "Master":
                print "Setting to true"
                sw = True
    
    workgroups.remove(workgroups[0])
    masters.remove(masters[0])
    print workgroups
    print masters
    return workgroups, masters

def getgroups_msbrowse():
    init_lookup_command =  string.join([pyNeighborhood.parser.get_value("lookup"),"-M -- -"])
    print init_lookup_command
    ip_list = os.popen(init_lookup_command).readlines()
    ip_list.remove(ip_list[0])

    masters_ip = []
    workgroups = []
    masters = []
    final_ip_list = []
    for line in ip_list:
        masters_ip.append(line.split()[0])
    
    for ip_address in masters_ip:
        a_command = string.join([pyNeighborhood.parser.get_value("lookup"), "-A", ip_address])
        print a_command
        gobject.idle_add(pyNeighborhood.update_statusbar, pyNeighborhood.statusbar, "Processing %s..."%ip_address)
        master_lines = os.popen(a_command).readlines()
        master_lines.remove(master_lines[0])
        master_is_set = False
        workgroup_is_set = False
        for m_line in master_lines:
            splitted_temp = m_line.split()
            splitted = []
            repl_line = ""
            flag0 = True

            if splitted_temp[0] == "No" and splitted_temp[1] == "reply":
                break
            
            for temp_line in splitted_temp:
                if not verify_msbrowse_line(temp_line) and flag0:
                    repl_line = repl_line + " " + temp_line
                else:
                    flag0 = False
                    splitted.append(temp_line)
            
            splitted.insert(0, repl_line.strip())

            if len(splitted) == 5 and not master_is_set:
                if splitted[0] != "..__MSBROWSE__.":
                    masters.append(splitted[0])
                    master_is_set = True
            if splitted[3] == '<GROUP>' and not workgroup_is_set:
                if splitted[0] != "..__MSBROWSE__.":
                    workgroups.append(splitted[0])
                    workgroup_is_set = True
            if master_is_set and workgroup_is_set:
                final_ip_list.append(ip_address)
                break
    
    return workgroups, masters, final_ip_list

def gethosts(m_browser):
    if pyNeighborhood.parser.get_value("anonymous") == "True":
        password = "-U%"
    else:
        password = string.join(["-U",'"', pyNeighborhood.parser.get_value("user"),'"','%',
                                     '"', pyNeighborhood.parser.get_value("password"),'"'], "")

    init_workgroup_command = string.join([pyNeighborhood.parser.get_value("client"), "-L", m_browser,
                                          password, "-d1"])

    lines = os.popen(init_workgroup_command).readlines()
    sw = False
    servers = []
    comments = []
    for line in lines:
        line_sp = line.split()
        if sw == True:
            if line_sp == []:
                break
            servers.append(line_sp[0])
            try:
                comments.append(line_sp[1])
            except:
                comments.append("")
        if len(line_sp) == 2:
            if line_sp[0] == "Server" and line_sp[1] == "Comment":
                print "Setting to true"
                sw = True
    if servers == []:
        return [], []

    servers.remove(servers[0])
    comments.remove(comments[0])
    return servers, comments

