/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.WriteCoilResponse;
import net.wimpi.modbus.procimg.DigitalOut;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;

public final class WriteCoilRequest
extends ModbusRequest {
    private int m_Reference;
    private boolean m_Coil;

    public WriteCoilRequest() {
        this.setFunctionCode(5);
        this.setDataLength(4);
    }

    public WriteCoilRequest(int ref, boolean b) {
        this.setFunctionCode(5);
        this.setDataLength(4);
        this.setReference(ref);
        this.setCoil(b);
    }

    public ModbusResponse createResponse() {
        WriteCoilResponse response = null;
        DigitalOut dout = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            dout = procimg.getDigitalOut(this.getReference());
            dout.set(this.getCoil());
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        response = new WriteCoilResponse(this.getReference(), dout.isSet());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setCoil(boolean b) {
        this.m_Coil = b;
    }

    public boolean getCoil() {
        return this.m_Coil;
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        if (this.m_Coil) {
            dout.write(Modbus.COIL_ON_BYTES, 0, 2);
        } else {
            dout.write(Modbus.COIL_OFF_BYTES, 0, 2);
        }
    }

    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        this.m_Coil = din.readByte() == -1;
        din.readByte();
    }
}

