/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.BitVector;

public final class ReadInputDiscretesResponse
extends ModbusResponse {
    private int m_BitCount;
    private BitVector m_Discretes;

    public ReadInputDiscretesResponse() {
        this.setFunctionCode(2);
    }

    public ReadInputDiscretesResponse(int count) {
        this.setBitCount(count);
    }

    public int getBitCount() {
        return this.m_BitCount;
    }

    public void setBitCount(int count) {
        this.m_BitCount = count;
        this.m_Discretes = new BitVector(count);
        this.setDataLength(this.m_Discretes.byteSize() + 1);
    }

    public BitVector getDiscretes() {
        return this.m_Discretes;
    }

    public boolean getDiscreteStatus(int index) throws IndexOutOfBoundsException {
        return this.m_Discretes.getBit(index);
    }

    public void setDiscreteStatus(int index, boolean b) throws IndexOutOfBoundsException {
        this.m_Discretes.setBit(index, b);
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.writeByte(this.m_Discretes.byteSize());
        dout.write(this.m_Discretes.getBytes(), 0, this.m_Discretes.byteSize());
    }

    public void readData(DataInput din) throws IOException {
        int count = din.readUnsignedByte();
        byte[] data = new byte[count];
        for (int k = 0; k < count; ++k) {
            data[k] = din.readByte();
        }
        this.m_Discretes = BitVector.createBitVector(data);
        this.setDataLength(count + 1);
    }
}

