/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.BytesInputStream;
import net.wimpi.modbus.io.BytesOutputStream;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.UDPTerminal;

public class ModbusUDPTransport
implements ModbusTransport {
    private UDPTerminal m_Terminal;
    private BytesOutputStream m_ByteOut;
    private BytesInputStream m_ByteIn;

    public ModbusUDPTransport(UDPTerminal terminal) {
        this.m_Terminal = terminal;
        this.m_ByteOut = new BytesOutputStream(256);
        this.m_ByteIn = new BytesInputStream(256);
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            BytesOutputStream bytesOutputStream = this.m_ByteOut;
            synchronized (bytesOutputStream) {
                this.m_ByteOut.reset();
                msg.writeTo(this.m_ByteOut);
                this.m_Terminal.sendMessage(this.m_ByteOut.toByteArray());
            }
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O exception - failed to write.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModbusRequest readRequest() throws ModbusIOException {
        try {
            ModbusRequest req = null;
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                this.m_ByteIn.reset(this.m_Terminal.receiveMessage());
                this.m_ByteIn.skip(7);
                int functionCode = this.m_ByteIn.readUnsignedByte();
                this.m_ByteIn.reset();
                req = ModbusRequest.createModbusRequest(functionCode);
                req.readFrom(this.m_ByteIn);
            }
            return req;
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModbusResponse readResponse() throws ModbusIOException {
        try {
            ModbusResponse res = null;
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                this.m_ByteIn.reset(this.m_Terminal.receiveMessage());
                this.m_ByteIn.skip(7);
                int functionCode = this.m_ByteIn.readUnsignedByte();
                this.m_ByteIn.reset();
                res = ModbusResponse.createModbusResponse(functionCode);
                res.readFrom(this.m_ByteIn);
            }
            return res;
        }
        catch (InterruptedIOException ioex) {
            throw new ModbusIOException("Socket timed out.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }
}

