#/*##########################################################################
# Copyright (C) 2004-2018 V.A. Sole, European Synchrotron Radiation Facility
#
# This file is part of the PyMca X-ray Fluorescence Toolkit developed at
# the ESRF by the Software group.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
#############################################################################*/
__author__ = "V.A. Sole - ESRF Data Analysis"
__contact__ = "sole@esrf.fr"
__license__ = "MIT"
__copyright__ = "European Synchrotron Radiation Facility, Grenoble, France"

import logging
import sys

if sys.version_info < (3, ):
    from collections import MutableMapping
else:
    from collections.abc import MutableMapping

_logger = logging.getLogger(__name__)


aspect_ratio = [
#/* columns rows colors chars-per-pixel */
"32 32 5 1",
"  c #47463F",
". c #BA165D",
"X c #2F3AB5",
"o c #FFFFE8",
"O c None",
#/* pixels */
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOXXXXXXXXXXXXXXXXXXXXXXXXXXXXOO",
"OOXooooooooooooooooooooooooooXOO",
"OOXo ......  ooooooooooooooooXOO",
"OOXo. XXXXX.    oooooooooooooXOO",
"OOXo.XXXXXX.ooo   oooooooooooXOO",
"OOXo .. ....oooooo   ooooooooXOO",
"OOXo ooo ooo ooooooo    oooooXOO",
"OOXo  ooo ooo ooooooooo    ooXOO",
"OOXoo oooo                  oXOO",
"OOXoo oooo ................ oXOO",
"OOXoo  ooo ................ oXOO",
"OOXooo ooo ..XXXXXXXXXXXX.. oXOO",
"OOXooo ooo ..XXXXXXXXXXXX.. oXOO",
"OOXooo ooo ..XXXXXXXXXXXX.. oXOO",
"OOXoooo oo ..XXXXXXXXXXXX.. oXOO",
"OOXoooo oo ..XXXXXXXXXXXX.. oXOO",
"OOXoooo oo ..XXXXXXXXXXXX.. oXOO",
"OOXooooo o ..XXXXXXXXXXXX.. oXOO",
"OOXooooo o ..XXXXXXXXXXXX.. oXOO",
"OOXooooo o ..XXXXXXXXXXXX.. oXOO",
"OOXooooo   ..XXXXXXXXXXXX.. oXOO",
"OOXoooooo  ..XXXXXXXXXXXX.. oXOO",
"OOXoooooo  ..XXXXXXXXXXXX.. oXOO",
"OOXoooooo  ................ oXOO",
"OOXooooooo ................ oXOO",
"OOXooooooo                  oXOO",
"OOXooooooooooooooooooooooooooXOO",
"OOXXXXXXXXXXXXXXXXXXXXXXXXXXXXOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
]


# --- scan window icons ---
plugin = [
#columns rows colors chars-per-pixel
"32 32 16 1",
"  c #000000",
". c #303030",
"X c #585858",
"o c #c05800",
"O c #ff8000",
"+ c #ffa858",
"@ c #c0c000",
"# c #ffff00",
"$ c #808080",
"% c #a0a0a0",
"& c #ffdca8",
"* c #c3c3c3",
"= c #dcdcdc",
"- c #ffffc0",
"; c #ffffff",
": c None",
# pixels
":::::::::::::::::::::::  :::::::",
":::::::::::::::::::::: -& :  :::",
":::::::::::::::::::    &## &+ ::",
":::::::::::::::::: -&-&&#+&#o ::",
":::::::::::::::::: ###+#@#@+o ::",
"::::::::::::::::::: &&#@ @O@O  :",
":::::::::::::::::: -&#@ : o@+#+ ",
":::::::::::   ::: &&## ::: #+@@ ",
":::::::::: ;;; :: ##@+# : &#@@ :",
"::::: :::: ;;= :::  #@+@ #&+# ::",
":::: ;    ;;;;=     @+@+#&##+# :",
"::: ;;;;;;;====;;;; #oO@+@@@## :",
":: ;;;;;;;===***%%% oo @@@    ::",
"::: ;;;;;;===**%%%%$  : @@ :::::",
"::: ;;;;====**%%%$%$  ::  ::::::",
"::: ;;;;==%XXX%%%%$$  ::::::::::",
"::: ;;===%X   X$$$$$$ ::::::::::",
":  ;;;==%X ::: X$$%$%%  ::::::::",
" ;;;====X ::::: $$$%%%=* :::::::",
" ;;;==**$ ::::: %$%%%%*$ :::::::",
" ;===***% ::::: =%%%%$X$ :::::::",
":  ****%%% ::: ;=%%%$X  ::::::::",
"::: **%%%%%   ;;%%%*$ ::::::::::",
"::: =%%%%$$%;;=%%%*=$ ::::::::::",
"::: =%%%$$%$$%%%%***% ::::::::::",
"::: =%%$$$$%%%%***=== ::::::::::",
":: **%$%$$%$%%%***==== :::::::::",
"::: X    .$%%%$X$%**= ::::::::::",
"::::      X%%$X    = :::::::::::",
"::::: :::: %*$ :::: ::::::::::::",
":::::::::: %X$ :::::::::::::::::",
":::::::::::   ::::::::::::::::::"
]

crop =[
"16 16 2 1",
"   c none",
".  c black",
"                ",
"   ..           ",
"   ..           ",
"   ..           ",
"   ..........   ",
"   ..........   ",
"   ..      ..   ",
"   ..      ..   ",
"   ..      ..   ",
"   ..      ..   ",
"   ..........   ",
"   ..........   ",
"           ..   ",
"           ..   ",
"           ..   ",
"                ",
]

togglepoints =[
"16 16 2 1",
"   c none",
".  c blue",
"                ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .   ...   ... ",
"  .   . .   ... ",
"  .   ...   ... ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"  .    .        ",
"                "
]

square16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
" XXXXXXXXXXXXXX ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" XXXXXXXXXXXXXX ",
"                "
]


rectangle16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"                ",
"                ",
" XXXXXXXXXXXXXX ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" XXXXXXXXXXXXXX ",
"                ",
"                ",
"                "
]


polygon16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"       XX       ",
"      X  X      ",
"     X    X     ",
"    X      X    ",
"   X        X   ",
"  X         X   ",
" X         X    ",
"  X       X     ",
"   X      X     ",
"    X     X     ",
"     X     X    ",
"    X       X   ",
"   X         X  ",
"   XXXXXXXXXXX  ",
"                "
]


circle16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"     XXXXXX     ",
"    X      X    ",
"   X        X   ",
"  X          X  ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
" X            X ",
"  X          X  ",
"   X        X   ",
"    X      X    ",
"     XXXXXX     ",
"                "
]

ellipse16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"                ",
"                ",
"                ",
"     XXXXXX     ",
"   X        X   ",
"  X          X  ",
" X            X ",
" X            X ",
" X            X ",
"  X          X  ",
"   X        X   ",
"     XXXXXX     ",
"                ",
"                ",
"                ",
]

solid_circle16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"     XXXXXX     ",
"    XXXXXXXX    ",
"   XXXXXXXXXX   ",
"  XXXXXXXXXXXX  ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
"  XXXXXXXXXXXX  ",
"   XXXXXXXXXX   ",
"    XXXXXXXX    ",
"     XXXXXX     ",
"                "
]

solid_ellipse16 =[
"16 16 2 1",
"  c none",
"X c blue",
"                ",
"                ",
"                ",
"                ",
"     XXXXXX     ",
"   XXXXXXXXXX   ",
"  XXXXXXXXXXXX  ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
" XXXXXXXXXXXXXX ",
"  XXXXXXXXXXXX  ",
"   XXXXXXXXXX   ",
"     XXXXXX     ",
"                ",
"                ",
"                ",
]


subtract =[
"16 16 2 1",
"  c none",
". c blue",
"                ",
"  ..........    ",
"  .         .   ",
"  .          .  ",
"  .          .  ",
"  .          .  ",
"  .         .   ",
"  ..........    ",
"  .         .   ",
"  .          .  ",
"  .          .  ",
"  .          .  ",
"  .          .  ",
"  .         .   ",
"  ..........    ",
"                "
]

substract = subtract

smooth = [
"16 16 3 1",
"O c none",
"* c yellow",
": c blue",
"OOOOOOOOOOOOOOOO",
"OOOO**OOO*:OOOOO",
"OOOOO**O*::OOOOO",
"OOOO::***:O:OOOO",
"OOOO::O**OO:OOOO",
"OOO:O:****OO:OOO",
"OOO:OO*:O**O:OOO",
"OO:OO**OOOOO:OOO",
"OO:OO*OOOOOO:OOO",
"O:OOOOOOOOOO::OO",
"O:OOOOOOOOOOO:OO",
"O:OOOOOOOOOOO::O",
"OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO"
]



derive = [
"16 16 2 1",
"   c None",
".  c blue",
"                ",
"  ..   .        ",
" .  .  .        ",
" .              ",
" .              ",
" .              ",
" .   .       .  ",
" .. .  .   .  . ",
" .  .   . .   . ",
" .  .    .    . ",
" .  .   . .   . ",
" .  .  .   .  . ",
" .   .       .  ",
"                ",
"                ",
"                "
]

swapsign = [
"16 16 3 1",
"   c None",
".  c blue",
"X  c red",
"                ",
"                ",
"             XX ",
"      XXX   XX  ",
"    XXX XX XX   ",
"   XX    XXX    ",
" XXX            ",
"                ",
" .............. ",
"                ",
" ...            ",
"   ..    ...    ",
"    ... .. ..   ",
"      ...   ..  ",
"             .. ",
"                "
]

ymintozero = [
"16 16 3 1",
"   c None",
"X  c blue",
".  c red",
"                ",
"                ",
"                ",
"                ",
"             XX ",
"      XXX   XX  ",
"    XXX XX XX   ",
"   XX    XXX    ",
"  XX            ",
" XX             ",
" X............. ",
"                ",
"                ",
"                ",
"                ",
"                ",
]

"""
average16=[
"16 16 2 1",
". c blue",
"  c None",
"                ",
" .............. ",
"                ",
" ..         ..  ",
"  ..       ..   ",
"   ..     ..    ",
"    ..   ..     ",
"     .. ..      ",
"      ...       ",
"      ..        ",
"     ..         ",
"    ..          ",
"   ..           ",
"  ..            ",
" ..             ",
"                "
]
"""
average16=[
"16 16 2 1",
". c blue",
"  c None",
"                ",
" .............. ",
"                ",
"  .          .  ",
"   .        .   ",
"    .      .    ",
"     .    .     ",
"      .  .      ",
"       ..       ",
"       .        ",
"      .         ",
"     .          ",
"    .           ",
"   .            ",
"  .             ",
"                "
]

horizontal=[
"16 16 2 1",
". c blue",
"  c None",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
" .............. ",
" .............. ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                "
]

vertical=[
"16 16 2 1",
". c blue",
"  c None",
"                ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"       ..       ",
"                "
]

diagonal =[
"16 16 2 1",
". c blue",
"  c None",
"                ",
" ..             ",
"  ..            ",
"   ..           ",
"    ..          ",
"     ..         ",
"      ..        ",
"       ..       ",
"        ..      ",
"         ..     ",
"          ..    ",
"           ..   ",
"            ..  ",
"             .. ",
"              . ",
"                "
]

# -------------------------
sliderson=[
"16 16 2 1",
"  c blue",
". c None",
"................",
"...  .....  ....",
".  ..     ..  ..",
"...  .....  ....",
"................",
"................",
"...  .....  ....",
".  ..     ..  ..",
"...  .....  ....",
"................",
"................",
"...  .....  ....",
".  ..     ..  ..",
"...  .....  ....",
"................",
"................"
]

slidersoff = [
"16 16 3 1",
"  c blue",
". c red",
"X c None",
"XXXXXXXXXXXXXXXX",
"X..  XXXXX  XX.X",
"X ..X     XX ..X",
"XXX..XXXXX  ..XX",
"XXXX..XXXXX..XXX",
"XXXXX..XXX..XXXX",
"XXX  X..X.. XXXX",
"X  XX  ...XX  XX",
"XXX  XX...  XXXX",
"XXXXXX..X..XXXXX",
"XXXXX..XXX..XXXX",
"XXX ..XXXX ..XXX",
"X  ..     XX..XX",
"XX.. XXXXX  X..X",
"X..XXXXXXXXXXX.X",
"XXXXXXXXXXXXXXXX"
]

remove = [
"16 16 3 1",
"O c #ffc0c0",
"+ c None",
"X c red",
"++++++++++++++++",
"+XX++++++++++XX+",
"++XX+++++++OXX++",
"+++XX+++++OXX+++",
"++++XXO++OXX++++",
"+++++XX.OXX+++++",
"++++++XXXX++++++",
"++++++OXX+++++++",
"+++++OXXXX++++++",
"++++OXX+OXX+++++",
"+++OXX+++OXX++++",
"+++XX+++++OXX+++",
"++XX+++++++OXX++",
"+XX++++++++++XX+",
"++++++++++++++++",
"++++++++++++++++"
]

sigma=[
"16 16 2 1",
"  c blue",
". c None",
"................",
"....          ..",
"....  ..........",
".....  .........",
"......  ........",
".......  .......",
"........  ......",
".......  .......",
"......  ........",
".....  .........",
"....  ..........",
"...  ...........",
"..  ............",
".  .............",
".             ..",
"................"
]


normalize16=[
"16 16 2 1",
"  c none",
". c blue",
"                ",
" ...            ",
"  .    .     .  ",
"  .   .  . .  . ",
"  .   .   .   . ",
"  .   .  . .  . ",
" ...   .     .  ",
"                ",
" .............. ",
"                ",
"     .   .      ",
"     ..  .      ",
"     . . .      ",
"     .  ..      ",
"     .   .      ",
"                "
]

#grid
grid16 = [
"16 16 2 1",
"   c none",
".  c blue",
"                ",
"  .    .    .   ",
" .............  ",
"  .    .    .   ",
"  .    .    .   ",
"  .    .    .   ",
"  .    .    .   ",
" .............  ",
"  .    .    .   ",
"  .    .    .   ",
"  .    .    .   ",
"  .    .    .   ",
" .............  ",
"  .    .    .   ",
"                ",
"                "
]
rgb=[
"23 23 107 2",
"   c #0134013ffeec4048",
".  c #0ec30ec3fefe0000",
"X  c #02621250fd510000",
"o  c #13090006fee00000",
"O  c #1c771c77fefe0000",
"+  c #292e0006fefe0000",
"@  c #32a90183ff020000",
"#  c #23bf23bffefe0000",
"$  c #364736aafe4c0000",
"%  c #004a54cafeffffff",
"&  c #00cb6d74fefeffff",
"*  c #0cec671affff0000",
"=  c #6bbb0000fafe0000",
"-  c #462e462efefe0000",
";  c #736a736afefe0000",
":  c #7e467e46fefe0000",
">  c #0110feec01070000",
",  c #0c20fed101f80000",
"<  c #0913fefe09130000",
"1  c #0119fd5310f7dfdf",
"2  c #0f53fd4310270000",
"3  c #16d2fefe16d20000",
"4  c #25c4fefe25c40000",
"5  c #2f78fefe2f780000",
"6  c #004ffefe553c4048",
"7  c #00b1fef56c170000",
"8  c #0da7ffff67aa0000",
"9  c #4b75ffd836f6abac",
"0  c #6fb8fefb000a2e42",
"q  c #7f30fbdb00880000",
"w  c #5445fefe54450000",
"e  c #687dff00687f0000",
"r  c #717bfefe717b0000",
"t  c #0000e8e5ffda0000",
"y  c #0000ffd4e8c20000",
"u  c #0174fda4fda30000",
"i  c #22d9fd32fd650000",
"p  c #fef8015201430000",
"a  c #fefd0abc00290000",
"s  c #fefe0c980c980000",
"d  c #fefd00001b060000",
"f  c #fefe18eb18f30000",
"g  c #ff16402000160000",
"h  c #fefe236023600000",
"j  c #ff06001067c90000",
"k  c #fefe000071700000",
"l  c #fdf751ea00000000",
"z  c #fefd5d1101ba0000",
"x  c #ff1963f703480000",
"c  c #fefe59c659c60000",
"v  c #fefe665f665f0000",
"b  c #fefe701170110000",
"n  c #fefe758475840000",
"m  c #fefe796679660000",
"M  c #9889470dd6870000",
"N  c #b56c65cbff050000",
"B  c #ffff00dd97480000",
"V  c #fe7902189c2d0000",
"C  c #e5b6005dff6f0000",
"Z  c #eac60000fef80000",
"A  c #fef9008cec820000",
"S  c #fd9f00e7fdbf0000",
"D  c #ff7a1a99ff580000",
"F  c #b704fe0300080000",
"G  c #bb63fecf73900000",
"H  c #fefda38b483d0000",
"J  c #c2aefe9c02890000",
"K  c #fefddce5000c0000",
"L  c #eea6ffff010a0000",
"P  c #fdb8fe2b00e60000",
"I  c #fffffda636150000",
"U  c #86218564ff420000",
"Y  c #8e6c8e6cfefe0000",
"T  c #92659265fefe0000",
"R  c #bb17bb18feff0000",
"E  c #8c53fefb8c5c0000",
"W  c #af8efefeaf8e0000",
"Q  c #af56ff1bb22a0000",
"!  c #b98dfefeb98d0000",
"~  c #fefe874887480000",
"^  c #ffff9f5c8e1e0000",
"/  c #fefe964d964d0000",
"(  c #fefe9a9c9a9c0000",
")  c #fde1a109a2670000",
"_  c #fbc9b826bc010000",
"`  c #ffffbab2b3910000",
"'  c #cc2eba08ff700000",
"]  c #fe66a5bafeeb0000",
"[  c #c366fef1b3140000",
"{  c #c695c695fefe0000",
"}  c #c8fec8fefefe0000",
"|  c #c850d110ff780000",
" . c #dacfdacffefe0000",
".. c #cb83fefecb830000",
"X. c #d81efefed81e0000",
"o. c #da8aff17da8e0000",
"O. c #fea2c96fc8a10000",
"+. c #fefedbd6dbd60000",
"@. c #fe48ffffd7080000",
"#. c #e654fefee6540000",
"$. c #fefaf06cf0700000",
"%. c #ffcbf0d9fdde0000",
"&. c #f5c9f5c9fefe0000",
"*. c #f73afdb4fd7b0000",
"=. c #fefef75cf75c0000",
"-. c #fcccf898fac50000",
";. c #fed6feb9feb70000",
";.;.;.;.;.;.;.;.;.;.-.=.=.=.-.;.;.;.;.;.;.;.;.",
";.;.;.;.;.;.;.;.;.;.;.;.;.;.;.;.;.;.;.;.;.;.;.",
";.;.;.;.;.;.;.;.;.;.+.( n ( +.;.;.;.;.;.;.;.;.",
";.;.;.;.;.;.;.;.;.b s p p p s m ;.;.;.;.;.;.;.",
";.;.;.;.;.;.;.-.c p p p p p p p v ;.;.;.;.;.;.",
";.;.;.;.;.-.;.~ p p p p p p p p p / ;.-.;.;.;.",
";.;.;.;.;.;.$.f p p p p p p p p p h =.;.;.;.;.",
";.;.;.;.;.;._ p p p p p p p p p p p O.;.;.;.;.",
";.;.;.;.-.;.^ p p p p p p p p p p p ) ;.-.;.;.",
";.;.;.;.;.| M B V j d p p p a g x l ` ;.-.;.;.",
";.;.;.;.U     Z S S A k p z K P P L 9 Q ;.;.;.",
";.;.;.Y       = S S S D H P P P P q > > E ;.;.",
"*.;. .        o C S S ] @.P P P F , , > > W ;.",
"&.;.;           @ Z D %.;.I P J , > > > > 5 ;.",
";.;.$             + N *.*.G 0 , > > > > > > o.",
";.;.#               & i i 7 > > > > > > > > W ",
"*.;.-               & u u 7 > > > > > > > > ! ",
"&.;.T               % u u 6 > > > > > > > < #.",
";.;.&.O             X t y 1 > > > > > < > w ;.",
";.;.;.} .             * 8 > < > > > < > 3 o.;.",
";.;.;.;.{ $         $ ' [ 2 > > > > > 3 ..;.;.",
";.;.;.;.;.;.R : : R ;.;.;.o.e 4 < 4 r #.;.;.;.",
";.;.;.;.;.;.;.;.;.;.;.;.;.;.;.*.#.;.;.;.;.;.;."
]
rgb16 = [
"16 16 76 1",
"  c #01560165fef64048",
". c #0ed70f25fe590000",
"X c #28e128e1fefe0000",
"o c #06ae619cfbe30000",
"O c #00007fc6fab60000",
"+ c #69dc005cfbfa0000",
"@ c #5346569ffef20000",
"# c #62275eccfe640000",
"$ c #6087607ffef40000",
"% c #69667d4dfabbffff",
"& c #0192fee801e7ffff",
"* c #1c5cfefe1c5c0000",
"= c #236cff72002b0000",
"- c #2655fefe26550000",
"; c #0614fbe761450000",
": c #0000fab67e310000",
"> c #4236fe2703600000",
", c #4277fe3f3f5c0000",
"< c #552dfef152f20000",
"1 c #5fd6fefe5fd6dfdf",
"2 c #6b9afefe6b9a0000",
"3 c #744ffd547d650000",
"4 c #06b6d838d82a0000",
"5 c #00b9ff72ff860000",
"6 c #717afa5a81ae4048",
"7 c #fef6014101a80000",
"8 c #ff2b09e5018f0000",
"9 c #fefe0af30af3abac",
"0 c #fefc0000378d2e42",
"q c #fdfa2a4300000000",
"w c #fe5826312b410000",
"e c #fefe2c822c820000",
"r c #ffff401b22c70000",
"t c #fefe309830980000",
"y c #ff43027d42080000",
"u c #ffff00b851150000",
"i c #ff36693400000000",
"p c #fefe540254020000",
"a c #fee37bc87a200000",
"s c #a94f0000fed80000",
"d c #fceb016cd5070000",
"f c #e15301d2ffff0000",
"g c #f8ac00c3ffff0000",
"h c #fef20103fd940000",
"j c #ffff3b7bfa680000",
"k c #afdefbc60bd90000",
"l c #faf1de1b03030000",
"z c #f11cfda800870000",
"x c #fffffecc012a0000",
"c c #f9e5ffff0c990000",
"v c #fffffbb553fc0000",
"b c #a092a092fefe0000",
"n c #a438a438fefe0000",
"m c #aa46aa46fefe0000",
"M c #b746b746fefe0000",
"N c #9065fefe906c0000",
"B c #9893fefe98930000",
"V c #b42bfefeb42a0000",
"C c #c08aff34c0690000",
"Z c #a7befe60fea20000",
"A c #fefeb5e0b5e00000",
"S c #d377918acd300000",
"D c #fb72a8f9de230000",
"F c #dc66dc69fefe0000",
"G c #d2fbfefed2fb0000",
"H c #d30ce56ee5220000",
"J c #ffffd295c67e0000",
"K c #fefedd48dd480000",
"L c #edd2edc2ff190000",
"P c #ee6ffefeee6f0000",
"I c #fefee6bee6be0000",
"U c #fefeec81ec810000",
"Y c #f88bf876ff300000",
"T c #f793fefef7930000",
"R c #fe6bf783fcf70000",
#"E c #fed4fe9efea70000",
"E c none",
"EEEEEEREEEREEEEE",
"EEEEEEEEKIEEEEEE",
"EEEEEEAt79pIEEEE",
"EEEEEA77777eUEEE",
"EEEERw777777aERE",
"EEEEJ7777777wTEE",
"EEEESuy7778qrREE",
"EEY@ fhd0ilxk3EE",
"YE$  +hgDcxz=&<E",
"EF    sjEvz>&&&V",
"Em     %Z6=&&&&2",
"EM     O5:&&&&&1",
"EL.    o5;&&&&&B",
"YEb     4&&&&&*P",
"EEEnX .#H,&&&-GE",
"EEEEEFLEEECNVTEE"
]
eraseselect=[
"16 16 201 2",
"   c #03082B",
".  c #153F20",
"X  c #3B3001",
"o  c #202424",
"O  c #003E50",
"+  c #015605",
"@  c #005D1E",
"#  c #144200",
"$  c #184109",
"%  c #1F4800",
"&  c #00452C",
"*  c #016308",
"=  c #007928",
"-  c #2F4500",
";  c #3D4600",
":  c #00514E",
">  c #006856",
",  c #2B5C41",
"<  c #4E5F00",
"1  c #426100",
"2  c #627300",
"3  c #2E16DC",
"4  c #2D14FF",
"5  c #2F19F3",
"6  c #3D03FF",
"7  c #3D05FF",
"8  c #3E04FF",
"9  c #3E06FF",
"0  c #3A0AFF",
"q  c #3A0EFF",
"w  c #3D09FF",
"e  c #3E08FF",
"r  c #3E09FF",
"t  c #311EFF",
"y  c #2720FF",
"u  c #2C25F7",
"i  c #2923FF",
"p  c #2A23FF",
"a  c #2929FF",
"s  c #2338FB",
"d  c #2E36FB",
"f  c #3221FF",
"g  c #2F6682",
"h  c #1F5BEB",
"j  c #1857F2",
"k  c #167DDA",
"l  c #097AFF",
"z  c #0F7EFF",
"x  c #1569F6",
"c  c #1D60FF",
"v  c #2044FD",
"b  c #2547FF",
"n  c #204EFF",
"m  c #2B43F1",
"M  c #3A45E2",
"N  c #4000FF",
"B  c #4100FE",
"V  c #4100FF",
"C  c #4101FF",
"Z  c #4003FF",
"A  c #4300FC",
"S  c #4200FF",
"D  c #4300FF",
"F  c #470BF4",
"G  c #501CE0",
"H  c #5324DC",
"J  c #592ED3",
"K  c #5220E0",
"L  c #6036CA",
"P  c #437BC8",
"I  c #09BC0D",
"U  c #1BBD03",
"Y  c #19BD06",
"T  c #38A400",
"R  c #09947F",
"E  c #00BF51",
"W  c #20924F",
"Q  c #30916B",
"!  c #27B567",
"~  c #04CB14",
"^  c #11C712",
"/  c #03CC22",
"(  c #01D030",
")  c #05FF0D",
"_  c #04F714",
"`  c #0EFF18",
"'  c #02FF27",
"]  c #06FF21",
"[  c #0FFE35",
"{  c #37CA00",
"}  c #23FF0C",
"|  c #2DFF00",
" . c #32FF00",
".. c #3DFF09",
"X. c #27FF21",
"o. c #00C749",
"O. c #00C95C",
"+. c #00C268",
"@. c #00FF4D",
"#. c #00FF4F",
"$. c #00F757",
"%. c #00FF67",
"&. c #00FF77",
"*. c #2CDB60",
"=. c #24DD7D",
"-. c #2DD47C",
";. c #22FE5C",
":. c #4AAD00",
">. c #5ABE00",
",. c #5EBE00",
"<. c #77A700",
"1. c #7CB500",
"2. c #5BA766",
"3. c #69B166",
"4. c #4DCD02",
"5. c #45F800",
"6. c #46FE1F",
"7. c #51FF00",
"8. c #72FF00",
"9. c #5AE147",
"0. c #4FE866",
"q. c #0091A4",
"w. c #0099B9",
"e. c #1180A9",
"r. c #00A192",
"t. c #00B59A",
"y. c #09BD98",
"u. c #00B1A1",
"i. c #00BAAF",
"p. c #379490",
"a. c #2EBA86",
"s. c #2FBFB6",
"d. c #0099C0",
"f. c #1192CC",
"g. c #0F97E3",
"h. c #0097FF",
"j. c #0995FF",
"k. c #0997FF",
"l. c #1B8AE6",
"z. c #0BBADD",
"x. c #14A0D6",
"c. c #00ABE4",
"v. c #00AEFF",
"b. c #00B7FF",
"n. c #00B9FE",
"m. c #00B9FF",
"M. c #34ABCC",
"N. c #02CA87",
"B. c #17C1B3",
"V. c #00FF96",
"C. c #00F89B",
"Z. c #00FFA8",
"A. c #00FFBD",
"S. c #2ED7B6",
"D. c #00C0FD",
"F. c #00C5FF",
"G. c #00CEFF",
"H. c #00DFEF",
"J. c #00D0F8",
"K. c #00F7C4",
"L. c #00FFCB",
"P. c #00EEE6",
"I. c #00E9FF",
"U. c #00EDFF",
"Y. c #00F2E8",
"T. c #00FCE9",
"R. c #25CADC",
"E. c #2FD0C7",
"W. c #85BE07",
"Q. c #92B400",
"!. c #A9AE00",
"~. c #A3B900",
"^. c #ABA75C",
"/. c #B6B24E",
"(. c #B3BB4F",
"). c #B2B073",
"_. c #BCBE7C",
"`. c #82FE14",
"'. c #85FF10",
"]. c #AACD00",
"[. c #ACF500",
"{. c #B1FA00",
"}. c #AEC37E",
"|. c #C68600",
" X c #CADC06",
".X c #C6C665",
"XX c #CACA65",
"oX c #888882",
"OX c #84928E",
"+X c #819C8D",
"@X c #A09B9C",
"#X c #AEAD8D",
"$X c #AFAF8E",
"%X c #B8B885",
"&X c #A8A3A6",
"*X c #A9A7A9",
"=X c #BACE84",
"-X c #C5C585",
";X c #F4F485",
":X c #FEFB84",
">X c #FFFD84",
"B B B B B B B 0 a t B D B B B B ",
"B B B B B 8 s x.N.y.l.v 6 B B B ",
"B B B B u f.=.6.} ` [ B.M G K F ",
"B B D d a.`.8. .] @.*.}.-X%XoXJ ",
"B D 3 R W.].4.~ ( -.=X>X;XXX^.H ",
"B 5   X 2 - + = , _.>X;X.X/.L B ",
"D j o |.<.{ / W +X#X$X).(.P 8 B ",
"0 g.. !.>.Y o.Q @X*X&XOXM.l 8 B ",
"i t.$ Q.,.^ +.e.g S.E.R.m.j.r B ",
"i ! - ~.:.^ +.q.d.P.I.F.b.j.r B ",
"t 3.; 1.T I E r.u.i.w.m.v.n B B ",
"4 2.< < # * @ & > : O c.h.f B B ",
"6 p. X[.5._ $.C.K.Y.J.m.z q B B ",
"6 h 9.[.7.) #.V.A.T.U.m.b D B B ",
"B 8 k 0.`.| ' &.Z.L.P.j B B B B ",
"B B r x S.;.5.X.%.z.m r B B B B "
]

additionalselect = [
"16 16 16 1",
"  c #2F16FE",
". c #4200FE",
"X c #4900FD",
"o c #1A55FE",
"O c #14FE10",
"+ c #0FF765",
"@ c #55FB11",
"# c #66DC5A",
"$ c #0FA1F4",
"% c #0AE7A0",
"& c #0BE6EF",
"* c #25988D",
"= c #ABF908",
"- c #E9E402",
"; c #EDAC2C",
": c #FCFEFD",
".......   ......",
"...... $++$ ....",
".... $+#@OO%o...",
"..X %==::+++& ..",
".. %=-@::%%%& ..",
". *=-@O::%&&&o..",
"Xo@;=@O::%&&&$..",
".$;::::::::::$..",
" *;::::::::::$.X",
" +--@O+::&&&$$..",
" #--@O+::&&&&o..",
".*-=@O+::&&$$ ..",
"X*-=@O+::&$&$...",
"Xo@=@O+%&&&& ...",
"..$#=OO+%%&o....",
"...o&+@O+&  ...."
]

brushselect =[
"16 16 193 2",
"   c #000507",
".  c #051B00",
"X  c #001B1E",
"o  c #001C1D",
"O  c #002704",
"+  c #012B08",
"@  c #00370F",
"#  c #002129",
"$  c #002F33",
"%  c #343700",
"&  c #003747",
"*  c #084000",
"=  c #154C00",
"-  c #125401",
";  c #00463B",
":  c #00443F",
">  c #004D34",
",  c #066203",
"<  c #027B0B",
"1  c #05780A",
"2  c #196E00",
"3  c #17691F",
"4  c #00602F",
"5  c #007F20",
"6  c #007D31",
"7  c #204E00",
"8  c #004543",
"9  c #00415E",
"0  c #005844",
"q  c #005056",
"w  c #005650",
"e  c #005A56",
"r  c #004B7A",
"t  c #005367",
"y  c #007E4A",
"u  c #006A7D",
"i  c #007961",
"p  c #007C71",
"a  c #007E73",
"s  c #424900",
"d  c #424D00",
"f  c #2D14FF",
"g  c #3E02FF",
"h  c #3E05FF",
"j  c #3E06FF",
"k  c #3F06FF",
"l  c #3A0AFF",
"z  c #3A0EFF",
"x  c #3D09FF",
"c  c #3E08FF",
"v  c #3E09FF",
"b  c #311DFF",
"n  c #311EFF",
"m  c #2025C2",
"M  c #2720FF",
"N  c #2C27F7",
"B  c #2923FF",
"V  c #2A23FF",
"C  c #2D20FF",
"Z  c #2929FF",
"A  c #2B2CFA",
"S  c #253AFB",
"D  c #2D33FB",
"F  c #3222FF",
"G  c #322AF7",
"H  c #005A89",
"J  c #007BB3",
"K  c #1F5BEB",
"L  c #1C52FF",
"P  c #0878CC",
"I  c #167DDA",
"U  c #097AF0",
"Y  c #097DFF",
"T  c #0F7FFE",
"R  c #1569F5",
"E  c #1C65F5",
"W  c #1D60FF",
"Q  c #2243FD",
"!  c #2547FF",
"~  c #2B43F2",
"^  c #2052FF",
"/  c #4100FF",
"(  c #4101FF",
")  c #4002FF",
"_  c #4003FF",
"`  c #4103FF",
"'  c #4200FF",
"]  c #4300FF",
"[  c #009E3D",
"{  c #01AB2C",
"}  c #249902",
"|  c #2A9700",
" . c #338900",
".. c #3A8E14",
"X. c #3E9800",
"o. c #23BE04",
"O. c #009648",
"+. c #009E52",
"@. c #01857D",
"#. c #00B542",
"$. c #00AD6F",
"%. c #00BD61",
"&. c #0BC40D",
"*. c #06C51C",
"=. c #0ED30E",
"-. c #1EC106",
";. c #12C912",
":. c #08FF0D",
">. c #02FF27",
",. c #10FF36",
"<. c #2EFF00",
"1. c #3DFF09",
"2. c #2CFF21",
"3. c #00C95D",
"4. c #00CC5A",
"5. c #00C267",
"6. c #00FF50",
"7. c #00E476",
"8. c #02FF66",
"9. c #00FF75",
"0. c #38C267",
"q. c #22FE5F",
"w. c #65AD66",
"e. c #79BA66",
"r. c #43E400",
"t. c #53FF00",
"y. c #70D13E",
"u. c #6DFA00",
"i. c #5AE147",
"p. c #4FE865",
"a. c #0082B9",
"s. c #0094A5",
"d. c #0092AF",
"f. c #0098AB",
"g. c #00B292",
"h. c #00BB9A",
"j. c #10BF9A",
"k. c #00BCBD",
"l. c #1CB1B0",
"z. c #379490",
"x. c #22BF85",
"c. c #2FBE86",
"v. c #129BD6",
"b. c #0081E4",
"n. c #0995FF",
"m. c #099BFF",
"M. c #1B8DE4",
"N. c #1C9BE3",
"B. c #00A3C4",
"V. c #00B4C1",
"C. c #0BBADC",
"Z. c #00B5F9",
"A. c #00B9FF",
"S. c #00BEFA",
"D. c #00C482",
"F. c #02CF88",
"G. c #00C690",
"H. c #00C89F",
"J. c #09C097",
"K. c #00CFA2",
"L. c #00C6BD",
"P. c #00CCBE",
"I. c #00DDB7",
"U. c #00FF96",
"Y. c #00FFA8",
"T. c #00FFBD",
"R. c #2ED7B6",
"E. c #00CAC3",
"W. c #00C1EE",
"Q. c #00C8F9",
"!. c #00DFEE",
"~. c #00D1F6",
"^. c #00FFCA",
"/. c #00EDFE",
"(. c #00F9EE",
"). c #00FCE9",
"_. c #807500",
"`. c #83A200",
"'. c #A48700",
"]. c #B19809",
"[. c #9BDE00",
"{. c #85FF0F",
"}. c #B2E300",
"|. c #B5E013",
" X c #B1FA00",
".X c #B3FF00",
"XX c #BBF207",
"oX c #DEB700",
"OX c #D6A720",
"+X c #EEB200",
"@X c #CFE006",
"#X c #F0D800",
"$X c #E3EC00",
"/ / / / / / ] l Z F / / / / / / ",
"/ / / / / ` S v.F.J.M.Q / / / / ",
"/ / / / N P @.3 o.=.,.I.L g / / ",
"/ / / D c...= * 1 @ 5 7.W.n ] / ",
"/ ] A x.XX`.} *.{ $.0 > u G ] / ",
"/ C l.|.$Xu.- [ %.G.h.p   m ` / ",
"] E y.+X[.| + +.D.H.w o t U k / ",
"l N.OX_.. , #.g.f.E.8 k.Q.Y k / ",
"V j.].%  .-.5.a.J P.; V.Z.n.v / ",
"V 0.'.d X.;.3.s.B.L.q o H m.v / ",
"M e.oXs 2 &.4.a $ e d.# r ^ / / ",
"f w.#X}.7 O O.4 i : & 9 b.F ] / ",
"/ z.@X.Xr.< 6 y K.(.~.S.T z / / ",
"/ K i. Xt.:.6.U.T.)./.A.! ] / / ",
"/ k I p.{.<.>.9.Y.^.!.W ` / / / ",
"/ / v R R.q.1.2.8.C.~ v / / / / "
]

image=[
"16 16 186 2",
"   c #271EFF",
".  c #2D14FF",
"X  c #3E02FF",
"o  c #3E04FF",
"O  c #3E05FF",
"+  c #3E06FF",
"@  c #3A0AFF",
"#  c #3A0EFF",
"$  c #3D09FF",
"%  c #3E08FF",
"&  c #3E09FF",
"*  c #311CFF",
"=  c #311EFF",
"-  c #2C25F7",
";  c #2922FF",
":  c #2A23FF",
">  c #2D20FF",
",  c #2929FF",
"<  c #2B2CFA",
"1  c #2338FB",
"2  c #2D33FB",
"3  c #3221FF",
"4  c #3230FF",
"5  c #1F5CEB",
"6  c #1C52FF",
"7  c #1D5FFF",
"8  c #167DDA",
"9  c #097BFF",
"0  c #0F7EFF",
"q  c #1567F5",
"w  c #1C65F5",
"e  c #2242FD",
"r  c #2547FF",
"t  c #204EFF",
"y  c #2B43F2",
"u  c #2058FF",
"i  c #4100FF",
"p  c #4101FF",
"a  c #4002FF",
"s  c #4003FF",
"d  c #4200FF",
"f  c #4300FF",
"g  c #36BC67",
"h  c #05FF0D",
"j  c #0AFF07",
"k  c #04FF14",
"l  c #04FF1F",
"z  c #0CFF17",
"x  c #0EFF17",
"c  c #14FF08",
"v  c #1CFF0B",
"b  c #1EFF0D",
"n  c #13FF1B",
"m  c #02FF27",
"M  c #06FF20",
"N  c #08FF2A",
"B  c #10FF34",
"V  c #23FF0C",
"C  c #2DFF00",
"Z  c #32FF00",
"A  c #3DFF01",
"S  c #3EFF09",
"D  c #2AFF21",
"F  c #00FF44",
"G  c #01FF47",
"H  c #00FF4D",
"J  c #00FF4F",
"K  c #00FE5B",
"L  c #00FF5A",
"P  c #01FF5C",
"I  c #00FF66",
"U  c #00FF69",
"Y  c #00FA77",
"T  c #00FF73",
"R  c #00FF75",
"E  c #00F97B",
"W  c #24DD7D",
"Q  c #22FE5F",
"!  c #65AE66",
"~  c #77B966",
"^  c #47FF00",
"/  c #46FE1F",
"(  c #51FF00",
")  c #53FF03",
"_  c #57FF00",
"`  c #5AFF00",
"'  c #6FD03E",
"]  c #60FF00",
"[  c #6FFF00",
"{  c #72FF00",
"}  c #77FF00",
"|  c #5ADF47",
" . c #4FE865",
".. c #09BD96",
"X. c #0EBC98",
"o. c #1CB1B0",
"O. c #379490",
"+. c #20BF85",
"@. c #2BB786",
"#. c #1192CC",
"$. c #0988FF",
"%. c #0095FF",
"&. c #0997FF",
"*. c #0998FF",
"=. c #1B8AE4",
"-. c #1C9BE1",
";. c #0BBADC",
":. c #14A0D6",
">. c #00AEFF",
",. c #00B7F9",
"<. c #00B7FE",
"1. c #00B9FF",
"2. c #00BFFF",
"3. c #02CA87",
"4. c #00DDB6",
"5. c #00FF83",
"6. c #00FF85",
"7. c #00FF93",
"8. c #00FF95",
"9. c #00FF99",
"0. c #00FF9B",
"q. c #00FF9F",
"w. c #00FFA7",
"e. c #00FEAB",
"r. c #00FEAC",
"t. c #00FFB6",
"y. c #00FFB8",
"u. c #2ED5B6",
"i. c #00C1F0",
"p. c #00C1FF",
"a. c #00C6FF",
"s. c #00CCF6",
"d. c #00C8FE",
"f. c #00DCEE",
"g. c #00D1FD",
"h. c #00D0FF",
"j. c #00D3FF",
"k. c #00D5FD",
"l. c #00DEF7",
"z. c #00D8FF",
"x. c #00DEF8",
"c. c #00DEFD",
"v. c #00EBCB",
"b. c #00F8C3",
"n. c #00FFC3",
"m. c #00FFC6",
"M. c #00FFC7",
"N. c #00FAC9",
"B. c #00F8DE",
"V. c #00EFEF",
"C. c #00E7FD",
"Z. c #00E9F9",
"A. c #00E9FE",
"S. c #00EFF8",
"D. c #00ECFE",
"F. c #00EFFC",
"G. c #00F4E5",
"H. c #00FCE7",
"J. c #00F9EF",
"K. c #00FBEF",
"L. c #00F7F5",
"P. c #00FAF0",
"I. c #00FBF2",
"U. c #00F8F5",
"Y. c #80FF00",
"T. c #85FF0F",
"R. c #81FE14",
"E. c #ABF900",
"W. c #B6ED07",
"Q. c #B4E013",
"!. c #B1F700",
"~. c #B2FD00",
"^. c #BFF600",
"/. c #BCFD00",
"(. c #D0A11F",
"). c #D6BE09",
"_. c #CFE006",
"`. c #C6FE00",
"'. c #D5FC00",
"]. c #DDF400",
"[. c #E8C400",
"{. c #EDD700",
"}. c #FDC100",
"|. c #F9CC00",
" X c #E2EA00",
".X c #F0F100",
"i i i i i i f @ , = f i i i i i ",
"i i i i i o 1 :.3...=.e i i i i ",
"i i i i - #.W / V x B 4.6 i i i ",
"i i f 2 @.R.{ Z M H K 6.i.= f i ",
"i f < +.W.`.) l F 7.q.e.l.4 i i ",
"f > o.Q. X{ c F 6.t.N.V.A.u i i ",
"f w ' }.E.A N T e.n.B.z.z.$.o i ",
"@ -.(..XY.b K v.x.I.L.F.d.9 + i ",
": X.).'.} v E ,.<.J.J.A.<.*.s s ",
": g [.].] n Y s.g.I.Z.g.<.*.s f ",
"  ~ |.^.` x U b.G.U.z.d.<.t + f ",
". ! {./._ j K 0.n.U.g.2.%.3 f f ",
"i O._.~.^ k K 0.n.J.k.2.0 # f i ",
"i 5 | !.) h H 8.y.H.D.<.r f i i ",
"i o 8  .T.C N T e.M.f.w i i f i ",
"i i & q u.Q S D I ;.y & i i i i "
]

boxselect = [
"16 16 191 2",
"   c #073A04",
".  c #093600",
"X  c #1E3800",
"o  c #002338",
"O  c #003627",
"+  c #003A28",
"@  c #003736",
"#  c #3E2900",
"$  c #003A45",
"%  c #004514",
"&  c #004524",
"*  c #006803",
"=  c #016E1C",
"-  c #00780B",
";  c #007A2F",
":  c #284400",
">  c #2B5D00",
",  c #3F4D00",
"<  c #206400",
"1  c #3C6600",
"2  c #004C53",
"3  c #004B5D",
"4  c #004D63",
"5  c #005C66",
"6  c #005D68",
"7  c #007B4A",
"8  c #007F49",
"9  c #007B59",
"0  c #006A68",
"q  c #006C77",
"w  c #007F64",
"e  c #007B70",
"r  c #2D13FF",
"t  c #3E02FF",
"y  c #3E04FF",
"u  c #3E05FF",
"i  c #3E06FF",
"p  c #3A0AFF",
"a  c #3A0EFF",
"s  c #3D09FF",
"d  c #3E08FF",
"f  c #3E09FF",
"g  c #311CFF",
"h  c #311EFF",
"j  c #2720FF",
"k  c #2C25F7",
"l  c #2923FF",
"z  c #2A23FF",
"x  c #2D20FF",
"c  c #2929FF",
"v  c #2B2CFA",
"b  c #2338FB",
"n  c #2D33FB",
"m  c #3221FF",
"M  c #3230FF",
"N  c #007095",
"B  c #1F5CEB",
"V  c #1C52FF",
"C  c #1D5FFF",
"Z  c #167DDA",
"A  c #097CFF",
"S  c #0F7CFC",
"D  c #1569F5",
"F  c #1C65F5",
"G  c #2242FD",
"H  c #2547FF",
"J  c #204EFF",
"K  c #2B43F1",
"L  c #2058FF",
"P  c #4100FF",
"I  c #4101FF",
"U  c #4002FF",
"Y  c #4003FF",
"T  c #4200FF",
"R  c #4300FF",
"E  c #00A50B",
"W  c #09BE13",
"Q  c #1AB303",
"!  c #2E9500",
"~  c #28BF00",
"^  c #00A849",
"/  c #00BD48",
"(  c #36BD67",
")  c #07C00D",
"_  c #04CE15",
"`  c #01CE2F",
"'  c #09C925",
"]  c #05FF0D",
"[  c #0EFF17",
"{  c #02FF27",
"}  c #06FF21",
"|  c #10FF34",
" . c #23FF0C",
".. c #2DFF00",
"X. c #32FF00",
"o. c #3EFF09",
"O. c #2AFF21",
"+. c #00C45B",
"@. c #00CC50",
"#. c #00CE59",
"$. c #00CF72",
"%. c #00CE7D",
"&. c #00FF50",
"*. c #00FF51",
"=. c #00FF5C",
"-. c #00FF66",
";. c #00FF75",
":. c #24DD7D",
">. c #22FE5F",
",. c #65AE66",
"<. c #77BA66",
"1. c #4DCF02",
"2. c #46FE1F",
"3. c #53FF00",
"4. c #6FD03E",
"5. c #72FF00",
"6. c #5ADF47",
"7. c #4FE865",
"8. c #009E9C",
"9. c #0097AB",
"0. c #0091BC",
"q. c #0098BE",
"w. c #00A19C",
"e. c #00BA86",
"r. c #09BD96",
"t. c #0EBC9A",
"y. c #1FBE85",
"u. c #00A8A3",
"i. c #00A9B1",
"p. c #00ADB9",
"a. c #00BCA0",
"s. c #00BAA8",
"d. c #00BCB7",
"f. c #1CB1B0",
"g. c #379490",
"h. c #2DB986",
"j. c #009FC4",
"k. c #1192CC",
"l. c #0988FF",
"z. c #0091F9",
"x. c #0997FF",
"c. c #0998FF",
"v. c #1B8AE4",
"b. c #1C9BE3",
"n. c #00A0C0",
"m. c #0BBADB",
"M. c #14A0D6",
"N. c #00A8F7",
"B. c #00B3F7",
"V. c #00B2F8",
"C. c #00BFF6",
"Z. c #00BCFF",
"A. c #02CA87",
"S. c #00CF87",
"D. c #00C99A",
"F. c #00DA8D",
"G. c #00C7BA",
"H. c #00DDB6",
"J. c #00FF88",
"K. c #00FF99",
"L. c #00FFA6",
"P. c #2ED7B6",
"I. c #00C7C2",
"U. c #00C1F0",
"Y. c #00DCED",
"T. c #00D1F8",
"R. c #00DDF6",
"E. c #00FFC0",
"W. c #00FFC8",
"Q. c #00E2F8",
"!. c #00ECFF",
"~. c #00FCED",
"^. c #94CC07",
"/. c #85FF0F",
"(. c #82FE14",
"). c #ABCD00",
"_. c #AEDB13",
"`. c #BCEE00",
"'. c #B1F700",
"]. c #B1FB00",
"[. c #BAF800",
"{. c #D6BE09",
"}. c #D0A120",
"|. c #F8B700",
" X c #CFE006",
".X c #DBEA00",
"XX c #D2F600",
"oX c #E8C300",
"OX c #EDD700",
"+X c #F9CC00",
"@X c #EDE900",
"P P P P P P P p c h R R P P P P ",
"P P P P P y b M.A.r.v.G P P P P ",
"P P P P k k.:.2. .[ | H.V P P P ",
"P P R n h.(.5.X.} &.=.J.U.h R P ",
"P R v h.^.).1._ ` $.S.F.R.M R P ",
"R x f._.#     % & + O @ Q.C P P ",
"R F 4.|., ~ ' #.S.D.r.2 T.l.u P ",
"p b.}.@X1 Q / 8.9.d.i.5 C.A u P ",
"z t.{.XX: E ^ 0.0.u.w.$ V.x.f P ",
"z ( oX.X> W +.j.j.G.p.3 B.x.f P ",
"h <.+X`.< W @.e.s.I.j.4 N.J P P ",
"r ,.OX[.X * = 7 w 0 5 o z.m P P ",
"t g. X'.! - ; 7 9 e q N S a P P ",
"t B 6.'.3.] *.K.L.~.!.Z.H R P P ",
"P y Z 7.(.X.{ ;.L.W.Y.C u P P P ",
"P P p D P.>.o.O.;.m.K d R R P P "]

brush=[
"16 16 73 1",
"  c #0B0B00",
". c #0F0F06",
"X c #101000",
"o c #111100",
"O c #121200",
"+ c #373737",
"@ c #51510D",
"# c #52520D",
"$ c #53530D",
"% c #4D4D37",
"& c #4E4E37",
"* c #4F4F39",
"= c #5A5A2B",
"- c #616104",
"; c #666611",
": c #727207",
"> c #616122",
", c #444445",
"< c #464646",
"1 c #4A4A4A",
"2 c #4D4D4D",
"3 c #515151",
"4 c #5C5C5C",
"5 c #676744",
"6 c #616162",
"7 c #6E6E6E",
"8 c #737373",
"9 c #757575",
"0 c #7C7C71",
"q c #7B7B7B",
"w c #9E9E00",
"e c #ADAD00",
"r c #B2B200",
"t c #B5B500",
"y c #888884",
"u c #8B8B8C",
"i c #8D8D8E",
"p c #8D8D8F",
"a c #8E8E90",
"s c #949498",
"d c #9A9A9A",
"f c #9C9C9C",
"g c #9F9F9F",
"h c #A2A2A3",
"j c #A6A6A7",
"k c #AAAAAF",
"l c #ADADB1",
"z c #AEAEB1",
"x c #B3B3B3",
"c c #B5B5B5",
"v c #B5B5B6",
"b c #B8B8B8",
"n c #B9B9B9",
"m c #BABABA",
"M c #B9B9BC",
"N c #BCBCBC",
"B c #C1C1C1",
"V c #C2C2C2",
"C c #C2C2C3",
"Z c #C4C4C4",
"A c #C4C4C5",
"S c #C5C5C5",
"D c #C5C5C6",
#"F c #C6C6C6",
"F c none",
"G c #C7C7C7",
"H c #C6C6C8",
"J c #C8C8C8",
"K c #C9C9C9",
"L c #CACACA",
"P c #CDCDCD",
"I c #D2D2D2",
"U c #D3D3D3",
"Y c #E1E1E1",
"FFFFFFFFFFFFFFFF",
"FFFFFFFKDFFFFFFF",
"FFFFFFBsvKFFFFFF",
"FFFFFF0-5MDFFFFF",
"FFFFFF*r$kFFFFFF",
"FFFFFF*e#kDFFFFF",
"FFFFFD*e#lKFFFFF",
"FFFFDj>t:yDFFFFF",
"FFFFl=wre;pKFFFF",
"FFFKh.ooo 7LFFFF",
"FFFGh,apa67LFFFF",
"FFFKd9LIYc7LFFFF",
"FFFKf9bBIc7LFFFF",
"FFFC4+123<qKFFFF",
"FFFFNbbbbbBFFFFF",
"FFFFFFFFFFFFFFFF"
]

gioconda16=[
"16 16 118 2",
"   c #000000",
".  c #330b0e",
"X  c #390d0e",
"o  c #330b11",
"O  c #3e0d12",
"+  c #3d120c",
"@  c #3a1211",
"#  c #005072",
"$  c #005a7f",
"%  c #450f0e",
"&  c #43150d",
"*  c #461d0d",
"=  c #49180d",
"-  c #421510",
";  c #461c12",
":  c #57190b",
">  c #521d10",
",  c #4c2413",
"<  c #532412",
"1  c #592215",
"2  c #5b311c",
"3  c #5d3b1b",
"4  c #622a13",
"5  c #662f19",
"6  c #693114",
"7  c #6b3118",
"8  c #6d3e18",
"9  c #7f3c14",
"0  c #624423",
"q  c #6a4423",
"w  c #694822",
"e  c #734b28",
"r  c #7b4730",
"t  c #7c512b",
"y  c #7c5f2d",
"u  c #555555",
"i  c #006286",
"p  c #00709f",
"a  c #0097c3",
"s  c #05aada",
"d  c #60b2d0",
"f  c #803f1f",
"g  c #8b461c",
"h  c #815134",
"j  c #9a4c29",
"k  c #975326",
"l  c #97532a",
"z  c #925531",
"x  c #8c7233",
"c  c #916c36",
"v  c #90762f",
"b  c #957530",
"n  c #967933",
"m  c #9a7a35",
"M  c #a05117",
"N  c #b7621e",
"B  c #ab6532",
"V  c #a86f31",
"C  c #b86325",
"Z  c #bf7c2c",
"A  c #a9704a",
"S  c #b6784b",
"D  c #bb774a",
"F  c #cf7616",
"G  c #d47315",
"H  c #c47222",
"J  c #ce7c25",
"K  c #a28a3e",
"L  c #a88d3b",
"P  c #b09039",
"I  c #bd9b3e",
"U  c #9e8641",
"Y  c #9e8c45",
"T  c #a58740",
"R  c #a78f46",
"E  c #a59444",
"W  c #a3944c",
"Q  c #a5994c",
"!  c #af9b4b",
"~  c #ab9a51",
"^  c #b29441",
"/  c #b3964a",
"(  c #b09f4f",
")  c #bf9b44",
"_  c #bb984c",
"`  c #b1a155",
"'  c #b8a453",
"]  c #bfab5a",
"[  c #c68239",
"{  c #ce8733",
"}  c #d49139",
"|  c #e38c38",
" . c #e39734",
".. c #e39c36",
"X. c #c59c4e",
"o. c #d78d44",
"O. c #d4894d",
"+. c #d48e5b",
"@. c #d5944e",
"#. c #c5a14a",
"$. c #c0ab59",
"%. c #cca552",
"&. c #e6a251",
"*. c #eca45d",
"=. c #e1b452",
"-. c #e9b252",
";. c #eaa663",
":. c #e9b461",
">. c #edb963",
",. c #808080",
"<. c #96d7e9",
"1. c #a2e0f1",
"2. c #c3c3c3",
"3. c #fffedd",
"4. c #fffee3",
"5. c #fffeeb",
"6. c #fefef3",
"7. c #fefefd",
"                                ",
"  m v n x n R ~ K T E Q Y Y W   ",
"  P P L T e , @ ; 0 K ~ E E ~   ",
"  I X._ 2 6 7 - o o , / ` ! `   ",
"  #.%.c Z :.>.O.> . . 0 $.$.$.  ",
"  %.%.5 &.:.>.;.A & o o U ' '   ",
"  =.V 4 H ..F C N > O X 0 ` `   ",
"  X.t 1 9 B j z g : + X , E E   ",
"  8 2 7 }  .G -.| i i i i i i   ",
"  < = 1 *.} M *.S i 7.<.1.<.d   ",
"  < = = D H f +.z i 2.A s a p   ",
"  3 , = 1 J H k > i u u i i #   ",
"  y 3 * + = 1 & & i 7.7.7.5.5.  ",
"  x w * & X h h r i 7.6.5.5.3.  ",
"  3 , * ; 4 [ @.{   7.6.5.4.3.  ",
"                                "
]

gioconda16mirror=[
"16 16 118 2",
"   c #000000",
".  c #330b0e",
"X  c #390d0e",
"o  c #330b11",
"O  c #3e0d12",
"+  c #3d120c",
"@  c #3a1211",
"#  c #005072",
"$  c #005a7f",
"%  c #450f0e",
"&  c #43150d",
"*  c #461d0d",
"=  c #49180d",
"-  c #421510",
";  c #461c12",
":  c #57190b",
">  c #521d10",
",  c #4c2413",
"<  c #532412",
"1  c #592215",
"2  c #5b311c",
"3  c #5d3b1b",
"4  c #622a13",
"5  c #662f19",
"6  c #693114",
"7  c #6b3118",
"8  c #6d3e18",
"9  c #7f3c14",
"0  c #624423",
"q  c #6a4423",
"w  c #694822",
"e  c #734b28",
"r  c #7b4730",
"t  c #7c512b",
"y  c #7c5f2d",
"u  c #555555",
"i  c #006286",
"p  c #00709f",
"a  c #0097c3",
"s  c #05aada",
"d  c #60b2d0",
"f  c #803f1f",
"g  c #8b461c",
"h  c #815134",
"j  c #9a4c29",
"k  c #975326",
"l  c #97532a",
"z  c #925531",
"x  c #8c7233",
"c  c #916c36",
"v  c #90762f",
"b  c #957530",
"n  c #967933",
"m  c #9a7a35",
"M  c #a05117",
"N  c #b7621e",
"B  c #ab6532",
"V  c #a86f31",
"C  c #b86325",
"Z  c #bf7c2c",
"A  c #a9704a",
"S  c #b6784b",
"D  c #bb774a",
"F  c #cf7616",
"G  c #d47315",
"H  c #c47222",
"J  c #ce7c25",
"K  c #a28a3e",
"L  c #a88d3b",
"P  c #b09039",
"I  c #bd9b3e",
"U  c #9e8641",
"Y  c #9e8c45",
"T  c #a58740",
"R  c #a78f46",
"E  c #a59444",
"W  c #a3944c",
"Q  c #a5994c",
"!  c #af9b4b",
"~  c #ab9a51",
"^  c #b29441",
"/  c #b3964a",
"(  c #b09f4f",
")  c #bf9b44",
"_  c #bb984c",
"`  c #b1a155",
"'  c #b8a453",
"]  c #bfab5a",
"[  c #c68239",
"{  c #ce8733",
"}  c #d49139",
"|  c #e38c38",
" . c #e39734",
".. c #e39c36",
"X. c #c59c4e",
"o. c #d78d44",
"O. c #d4894d",
"+. c #d48e5b",
"@. c #d5944e",
"#. c #c5a14a",
"$. c #c0ab59",
"%. c #cca552",
"&. c #e6a251",
"*. c #eca45d",
"=. c #e1b452",
"-. c #e9b252",
";. c #eaa663",
":. c #e9b461",
">. c #edb963",
",. c #808080",
"<. c #96d7e9",
"1. c #a2e0f1",
"2. c #c3c3c3",
"3. c #fffedd",
"4. c #fffee3",
"5. c #fffeeb",
"6. c #fefef3",
"7. c #fefefd",
"                                ",
"  3 , * ; 4 [ @.{   7.6.5.4.3.  ",
"  x w * & X h h r i 7.6.5.5.3.  ",
"  y 3 * + = 1 & & i 7.7.7.5.5.  ",
"  3 , = 1 J H k > i u u i i #   ",
"  < = = D H f +.z i 2.A s a p   ",
"  < = 1 *.} M *.S i 7.<.1.<.d   ",
"  8 2 7 }  .G -.| i i i i i i   ",
"  X.t 1 9 B j z g : + X , E E   ",
"  =.V 4 H ..F C N > O X 0 ` `   ",
"  %.%.5 &.:.>.;.A & o o U ' '   ",
"  #.%.c Z :.>.O.> . . 0 $.$.$.  ",
"  I X._ 2 6 7 - o o , / ` ! `   ",
"  P P L T e , @ ; 0 K ~ E E ~   ",
"  m v n x n R ~ K T E Q Y Y W   ",
"                                "
]


energy = [
"16 16 3 1",
"  c blue",
". c white",
"X c None",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX",
"XXXXX      XXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX     XXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX XXXXXXXXXX",
"XXXXX      XXXXX",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX"
]

colormap16=[
"16 16 22 1",
"  c #000000",
". c #303030",
"X c #004040",
"o c #404000",
"O c #000080",
"+ c #008000",
"@ c #00c000",
"# c #008080",
"$ c #00c0c0",
"% c #c00000",
"& c #c05800",
"* c #ffa858",
"= c #808080",
"- c #a0a0a0",
"; c #8080ff",
": c #ffdca8",
"> c #c3c3c3",
", c #dcdcdc",
"< c #c0c0ff",
"1 c #c0ffc0",
"2 c #c0ffff",
"3 c None",
#"3 c #ffffff",
#/* pixels */
"333  33333333333",
"33 3, 33333  333",
"3 3,, 3333 ,> 33",
" 3,3,3 33 ,,>> 3",
" ,,  > 33 ,>>, 3",
" , 33 , 3 >;;O> ",
" , 33 ,, ,>;<O> ",
" ,, o,,,,,>OOO> ",
" ,,,,,,,,,,>>>> ",
" ,,**&,,,,$$#> 3",
" ,,*:&>-->$2#> 3",
" >,&&%@@+-##X= 3",
"3  ,,>@1+=>-- 33",
"33 ,>>+++=,> 333",
"333. ,,>->   333",
"33333     333333"
]

MINEcolormap16 = [
"22 16 12 1",
"  c black",
". c navy",
"X c blue",
"o c #000080800000",
"O c green",
"+ c #000080808080",
"@ c #808000000000",
"# c red",
"$ c yellow",
"% c #808080808080",
"& c #C0C0C0C0C0C0",
#"* c gray100",
"* c None",
"**********************",
"***&&&*********&&&&***",
"**&*&&&********&&&&&**",
"*&& ***&&****&&&&&O&&*",
"*&* *** &&**&&&+OOO+&*",
"*&&& ** &&&&&&&oOOO+&*",
"*&&&& %&&&&&&&&&o++&&*",
"**&&&&&&&&&&&&&&&&&&&*",
"**&&&&%&&&&&&&&&XXX&&*",
"**&&&#@#&&&&&&&.XXX.&*",
"**&&@###&&%%%&&.XX.&**",
"***&@##@&%$$$%&.X..&**",
"***&%@@@&+$$$%&...&***",
"****&&@&&+$$+%&&&&&***",
"*****&&&&&ooo%&&&&****",
"******&&&&&&&&&&******"
]

colormap = colormap16

MINEcolormap = [
"16 16 157 2",
"   c black",
".  c #32a230b6261c0000",
"X  c #2dd072373a280000",
"o  c #1b7a5e8a7e3e0000",
"O  c #0869714c720a0000",
"+  c #44b0439e3f120000",
"@  c #4d9943ac32ec0000",
"#  c #43d6445646fe0000",
"$  c #4cd049da43d20000",
"%  c #4d8d4dca4d740000",
"&  c #50b84dd34c760000",
"*  c #5730550c4ba70000",
"=  c #572159e84b700000",
"-  c #5f1f5a5f46520000",
";  c #562e53ea50ee0000",
":  c #590f5766534b0000",
">  c #5e475c7b59330000",
",  c #5f745f9161d00000",
"<  c #62755e9d57b00000",
"1  c #67086468556f0000",
"2  c #643c636a5ce40000",
"3  c #6bed68bf5bd60000",
"4  c #728d6e1157d60000",
"5  c #7028705770b60000",
"6  c #737173a661300000",
"7  c #737276576d9e0000",
"8  c #7f857d106e1f0000",
"9  c #77c4780f79440000",
"0  c #7ce87cbd7b8f0000",
"q  c #05d573daadaa0000",
"w  c #54497b7b87e30000",
"e  c #39498f5045650000",
"r  c #500a9b725bac0000",
"t  c #5de187637ab20000",
"y  c #5cc2ac8864db0000",
"u  c #6e0f80fe6cd70000",
"i  c #6aa598bc62350000",
"p  c #6c7fb13f6fbb0000",
"a  c #1b70843fb5fd0000",
"s  c #33d39b4c9bdd0000",
"d  c #5990b350ac230000",
"f  c #61c7a2559a560000",
"g  c #74fea34891de0000",
"h  c #712bacd8bdfa0000",
"j  c #4c169fe6c1910000",
"k  c #7ffbb5dcc8ba0000",
"l  c #7631ce79cde30000",
"z  c #70c3cf69d1f90000",
"x  c #64cec217e82c0000",
"c  c #99d4133821f90000",
"v  c #87097e866f430000",
"b  c #a7b15b945a4e0000",
"n  c #c11e31ff3ea00000",
"m  c #cb363b2547800000",
"M  c #c2185dd763f70000",
"N  c #d89a60e866aa0000",
"B  c #e8ee5d0166230000",
"V  c #ed436e8875310000",
"C  c #86e381036d780000",
"Z  c #8a91814f70620000",
"A  c #887d859c73a20000",
"S  c #8e88843072ea0000",
"D  c #8d9b896e71b70000",
"F  c #8d1d959373fe0000",
"G  c #8ad89a61750c0000",
"H  c #940b83c06c6f0000",
"J  c #95478e1973fa0000",
"K  c #9fff80ad71230000",
"L  c #9551926a7af20000",
"P  c #9ce295857b390000",
"I  c #96fea16f78380000",
"U  c #b53d91177e3a0000",
"Y  c #8346833084190000",
"T  c #8ba28be48caf0000",
"R  c #9769946b8ba00000",
"E  c #9e9f9ae68c7e0000",
"W  c #94249411937e0000",
"Q  c #943ca01196c10000",
"!  c #9b7a9a0a96e00000",
"~  c #9e1d9cd99c310000",
"^  c #90c5acc6ab4e0000",
"/  c #a0f29e208ed20000",
"(  c #a809a5398b520000",
")  c #a632a2ab96640000",
"_  c #a990a4c393650000",
"`  c #ae38b78093ba0000",
"'  c #b8ebad728ccf0000",
"]  c #b8edc05f9e730000",
"[  c #ae65adfda2820000",
"{  c #ab45ab14af050000",
"}  c #b439b6e5aa700000",
"|  c #bbb7b6d2aac20000",
" . c #bd52bba3a6820000",
".. c #8ecec76694970000",
"X. c #96aac4b6971a0000",
"o. c #8b55c1c7ad490000",
"O. c #892ec4ccb7af0000",
"+. c #ac2cc2449bcc0000",
"@. c #bc27c4caa3c10000",
"#. c #b116c0e6b4190000",
"$. c #bac9ef72b5220000",
"%. c #83abd0e3f1770000",
"&. c #c634984784310000",
"*. c #db719fcb954a0000",
"=. c #c159a96a8e280000",
"-. c #c496b7829dac0000",
";. c #c5c4bbb7995f0000",
":. c #d8a5aa7e9c680000",
">. c #e4ffa5249a800000",
",. c #f6fdbc65b0b70000",
"<. c #ca38c6a49d940000",
"1. c #ce6bc815a7e80000",
"2. c #cf0dc834ae850000",
"3. c #c890c58ebf790000",
"4. c #c564cc1cb2730000",
"5. c #cfcfd972baff0000",
"6. c #d66eca1da5130000",
"7. c #da30cf78a97b0000",
"8. c #d19ece63b8ac0000",
"9. c #df6bd3e3af430000",
"0. c #d754d705c0800000",
"q. c #dabbd7b6c0540000",
"w. c #e354cdd1a97f0000",
"e. c #eaadd985afbb0000",
"r. c #e517d6feba720000",
"t. c #e3ecd8febb540000",
"y. c #ed62d85ac08f0000",
"u. c #c498c4c4c7500000",
"i. c #cd3acdc3cf4a0000",
"p. c #d7e8d692cc140000",
"a. c #d511de75c37b0000",
"s. c #df34d9e6c5190000",
"d. c #e0aae0d5ca4a0000",
"f. c #d629d578d6c00000",
"g. c #dd7adce6dd6b0000",
"h. c #e069e0e3e30e0000",
"j. c #e3a6dc2dc7160000",
"k. c #e7b1dd12cada0000",
"l. c #eed2e041cf3f0000",
"z. c #e3e1e2dbcc030000",
"x. c #e743e4a7d8b20000",
"c. c #eaa4e350d3e60000",
"v. c #eb49e9a4d33b0000",
"b. c #f968eb0cc8730000",
"n. c #f622ecbbd45e0000",
"m. c #f6edf0d3dd2c0000",
"M. c #f7b2f2bddce30000",
"N. c #fbf0f55cdb450000",
"B. c #e7ace818e9910000",
"V. c #e83fe902ea1a0000",
"C. c #efffeba9e2bc0000",
"Z. c #ec97ed28ed8b0000",
"A. c #fa34f631eddf0000",
"S. c #f6d9f74df80b0000",
"D. c #f8e3f98ffa600000",
"F. c #fefafef9fef30000",
"G. c None",
"G.F.D.G.F.G.D.F.G.F.G.D.F.G.D.F.",
"G.F.G.T % W G.F.F.G.F.F.B.h.S.F.",
"F.G.5 ! A.[ ! G.F.F.G.u.+ . 0 G.",
"G.W ~ F.C.F.% g.F.G.i.: t.b.4 Y ",
"Z., x.3 + 2.p.% G.G.T S d. .w.% ",
"  3.R T G.* 8.2 i.V.$ v.k j #.C ",
"  | E 9 G.Y A N.< % -.h %.x a L ",
"  ) N.1 { Y E M.q. .n.^ a q o D ",
"  / M.c.7 } M.s.d.z.q.r.Q w ( J ",
"  _ n.z.,.>.d.k.l.k.j.0.o.@.e.J ",
"# 8 v.:.N m *.a.+.4.y.O.z d ] S ",
"G.& 5.M V B b X...p ` f l s u < ",
"G.g.6 &.n c K r $.y I g O t @ i.",
"D.G.i.= =.U 1.i e X F 6.;.H ; D.",
"G.F.G.u.6 <.7.9.G G ;.' - ; Z.G.",
"F.G.F.G.f.> v J P J Z > i.S.F.F."]

yauto  =[
"16 16 3 1",
"  c black",
". c #0000ff",
"X c none",
"XXXXXXXXXXXXXXXX",
"XX.XXXXXXXXXXXXX",
"X...XXXXXXXXXXXX",
".....XXXXXXXXXXX",
"XX.XXXXXXXXXXXXX",
"XX.XXX XXXXX XXX",
"XX.XXXX XXX XXXX",
"XX.XXXXX X XXXXX",
"XX.XXXXXX XXXXXX",
"XX.XXXXX XXXXXXX",
"XX.XXXX XXXXXXXX",
"XX.XXX XXXXXXXXX",
".....XXXXXXXXXXX",
"X...XXXXXXXXXXXX",
"XX.XXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX"
]

xauto  =[
"16 16 3 1",
"  c black",
". c #0000ff",
"X c none",

"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX",
"XXXXX XXXXX XXXX",
"XXXXXX XXX XXXXX",
"XXXXXXX X XXXXXX",
"XXXXXXXX XXXXXXX",
"XXXXXXX X XXXXXX",
"XXXXXX XXX XXXXX",
"XXXXX XXXXX XXXX",
"XXXXXXXXXXXXXXXX",
"XXX.XXXXXXXX.XXX",
"XX..XXXXXXXX..XX",
"X..............X",
"XX..XXXXXXXX..XX",
"XXX.XXXXXXXX.XXX"
]

close = [
"16 16 18 1",
". c None",
"d c #000000",
"c c #080808",
"k c #080c08",
"b c #181818",
"a c #212021",
"# c #212421",
"j c #292829",
"e c #313031",
"f c #393839",
"i c #424542",
"m c #525152",
"h c #525552",
"g c #5a595a",
"l c #636163",
"p c #6b696b",
"n c #7b797b",
"o c #ffffff",
"................",
"................",
"......#abcd.....",
"....efghijkdd...",
"...elmgnliaddd..",
"...fmoopnhoodd..",
"..#ggooogoooddd.",
"..ahnpooooocddd.",
"..bilngoooadddd.",
"..cjihooooodddd.",
"..dkaoooaoooddd.",
"...ddoocddoodd..",
"...ddddddddddd..",
"....ddddddddd...",
"......ddddd.....",
"................"
]


fileclose = [
"16 16 14 1",
"  c black",
". c #0b0b0b",
"X c #181818",
"o c #222222",
"O c gray17",
"+ c gray19",
"@ c gray23",
"# c #444444",
"$ c #535353",
"% c None",
"& c gray38",
"* c #686868",
"= c gray47",
"- c white",
"%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%",
"%%%%%%ooX. %%%%%",
"%%%%+@%$#O.  %%%",
"%%%+&$%=&#o   %%",
"%%%@$--*=$--  %%",
"%%o%%---%---   %",
"%%o$=*-----.   %",
"%%X#&=%---o    %",
#"%%.O#$---  %",
"%%.O#$---      %",
"%% .o---o---   %",
"%%%  --.  --  %%",
"%%%           %%",
"%%%%         %%%",
"%%%%%%     %%%%%",
"%%%%%%%%%%%%%%%%"
]

fileopen = [
"16 16 39 1",
"  c black",
". c gray4",
"X c gray7",
"o c #1f1f1e",
"O c #222222",
"+ c #323231",
"@ c #4b3119",
"# c #434343",
"$ c #4a4a49",
"% c #524f4c",
"& c #54514e",
"* c #565350",
"= c #5c5a57",
"- c #686867",
"; c #6f6f6e",
": c #b77d44",
"> c #c4864e",
", c #e5a566",
"< c #f8ac62",
"1 c #8d8d8b",
"2 c #949493",
"3 c #9c9c9b",
"4 c #a0a09f",
"5 c #a4a4a3",
"6 c #adadab",
"7 c #b5b5b5",
"8 c #bcbcbc",
"9 c #fec383",
"0 c #fec88a",
"q c #fed39a",
"w c #c4c4c3",
"e c #cccccc",
"r c #d4d4d3",
"t c #dddddc",
"y c #e4e4e3",
"u c #e8e8e7",
"i c #ececec",
"p c gray96",
"a c None",
"aaaaaa    aaaaaa",
"aaaaa  a    a aa",
"aaaa aaaaa    aa",
"aaaaaaaaaaa   aa",
"aaaaaaaaaa    aa",
"a    aaaaaaaaaaa",
" ,q9,       aaaa",
" q99<<<<<<<< aaa",
" 09@&&&=&&**&   ",
" 9>%ppiytrew877+",
" 9@ttuytrw8642$a",
" :&ttytrew764-Oa",
" @eerrrew8652$aa",
" *e8www87653;Xaa",
".85666655321$aaa",
"O$$$$$$$###+oaaa"
]

fileprint = [
"16 16 37 1",
"  c black",
". c gray19",
"X c gray22",
"o c #4f4928",
"O c #574934",
"+ c #444444",
"@ c #585858",
"# c #646464",
"$ c gray",
"% c lime",
"& c #b7996e",
"* c #b9b24a",
"= c #838383",
"- c #8c8c8c",
"; c #939393",
": c #9d9d9d",
"> c #a1a1a1",
", c #b7b7b7",
"< c #dfc097",
"1 c #e8c08d",
"2 c #e4cba9",
"3 c #e7d3b9",
"4 c #c3c3c3",
"5 c #cacaca",
"6 c gainsboro",
"7 c #e9d9c5",
"8 c #ecdfcc",
"9 c #eee4d5",
"0 c #f0e6d8",
"q c gray89",
"w c #f3ede4",
"e c #f4eee8",
"r c #f5f1eb",
"t c #f7f6f4",
"y c #f8f7f6",
"u c #fdfdfd",
"i c None",
"iiiiiiiiO  iiiii",
"iiiiiiiOuu4O iii",
"iiiiii wtytu8O i",
"iiiiiiOtyytrw8< ",
"iiii  wtytrw98& ",
"iii :O9weew08< i",
"ii :@&1299873@oi",
"i :>># &123<< *o",
" :::::># #&&.*oi",
"+6uq:::::># #o$ ",
"+55q6uq;--==$$@ ",
" >,455q6uq$$$@+ ",
"i  @>,455q6u@+X ",
"iiii  @>,4%4+X i",
"iiiiiii  @>,X ii",
"iiiiiiiiii   iii"
]

filesave = [
"16 16 26 1",
"  c #000000",
". c #0c0c0c",
"X c gray21",
"o c #3e3e3e",
"O c #444444",
"+ c #4c4c4c",
"@ c #535353",
"# c #5d5d5d",
"$ c #636363",
"% c #6a6a6a",
"& c #747474",
"* c #7c7c7c",
"= c #838383",
"- c #8c8c8c",
"; c #939393",
": c #9a9a9a",
"> c #a4a4a4",
", c gray68",
"< c gray71",
"1 c #c1c1c1",
"2 c gray81",
"3 c gray85",
"4 c #e6e6e6",
"5 c #efefef",
"6 c #ffffff",
"7 c None",
"7777   777777777",
"777@1,6   777777",
"777@1:6666   777",
"777@166666666   ",
"77@1>66666666>> ",
"77@1-66666666;> ",
"77@<56666666== 7",
"7@,>;-666666&- 7",
"7@:---==*662$; 7",
"7@:--=$#$&*2$; 7",
#"7@ =$#$&$#.7",
"@=$444+O+@@@* 77",
"@%+444443O@@- 77",
"   44444o+@$ 777",
"777   44X@@& 777",
"777777   @@; 777",
"777777777  .7777"
]

fit = [
"16 16 7 1",
"  c #303030",
". c #585858",
"X c #c00000",
"o c #808080",
"O c #dcdcdc",
"+ c #ffffff",
"@ c None",
"@@@@@oo@@@@@@@@@",
"@@@@@oo@@@@@@@@@",
"@@@@oXXo@@@@@@@@",
"@@@@o++X@@@@@@@@",
"@@@Xo++oX@oX@@@@",
"@@@o+++oX@XoX@@@",
"@@Xo++++.X++o@@@",
"@Xo+++++oo++oX@@",
"@     +  +    @@",
"@     +  +    X@",
"o  ++++  ++  oX@",
"X    ++  ++  oX@",
"+    ++  ++  oo@",
"+  ++++  ++  +oX",
"+  ++++  ++  ++o",
"@@@@@@@@@@@@@@@@"
]

logx = [
"16 16 4 1",
"  c #000040",
". c #0000ff",
"X c #dcdcdc",
"o c None",
"oooooooooooooooo",
"ooo oooooooooooo",
"ooo oooooooooooo",
"ooo oooooooooooo",
"ooo ooo ooo oooo",
"ooo oo o o o ooo",
"ooo oo o o o ooo",
"ooo   o ooo  ooo",
"oooooooooooo ooo",
"oooooooooo  oooo",
"oo.oooooooooo.oo",
"o..oooooooooo..o",
"................",
"o..oooooooooo..o",
"oo.oooooooooo.oo",
"oooooooooooooooo"
]

logy = [
"16 16 4 1",
"  c #000040",
". c #0000ff",
"X c #dcdcdc",
"o c None",
"oooooooooooooooo",
"oo.ooooooooooooo",
"o...oooooooooooo",
".....ooooooooooo",
"oo.ooooooooooooo",
"oo.ooo ooooooooo",
"oo.ooo ooooooooo",
"oo.ooo ooooooooo",
"oo.ooo ooo ooo o",
"oo.ooo oo o o o ",
"oo.ooo oo o o o ",
"oo.ooo   o ooo  ",
".....oooooooooo ",
"o...ooooooooo  o",
"oo.ooooooooooooo",
"oooooooooooooooo"
]

normal = [
"16 16 4 1",
"  c #303030",
". c #dcdcdc",
"X c #ffffff",
"o c None",
"oooooooooooooooo",
"o   oooooooooooo",
"o      ooooooooo",
"o         oooooo",
"oX       ooooooo",
"oX      oooooooo",
"oX      oooooooo",
"oXX      ooooooo",
"ooX  XX   oooooo",
"ooX XooX   ooooo",
"ooXXooooX   oooo",
"oooooooooX   ooo",
"ooooooooooX  ooo",
"oooooooooooooooo",
"oooooooooooooooo",
"oooooooooooooooo"
]

peak = [
"16 16 4 1",
"  c #303030",
". c #0080ff",
"X c #dcdcdc",
"o c None",
"oooooo   ooooooo",
"ooooo  . ooooooo",
"ooooo ...ooooooo",
"ooooo.....oooooo",
"ooooo o.o oooooo",
"ooooo o.o oooooo",
"oooo oo.o oooooo",
"oooo oo.o oooooo",
"oo o oo.o oooooo",
"oo o oo.o  ooo o",
"o    oo.oo oo   ",
"o o  oo.oo oo oo",
"o ooooo.oo    oo",
"  ooo.....oo ooo",
"oooooo...ooooooo",
"ooooooo.oooooooo"
]

peakreset = [
"16 16 6 1",
"  c #303030",
". c #0080ff",
"X c #ff0000",
"o c #dcdcdc",
"O c #ffc0c0",
"+ c None",
"XX++++   +++++XX",
"+XXO+  . ++++XX+",
"++XXO ...++OXX++",
"+++XX.....OXX+++",
"++++XXO.+OXX++++",
"+++++XX.OXX+++++",
"++++ +XXXX++++++",
"++++ +OXX ++++++",
"++ + OXXXX++++++",
"++ +OXX.OXX+++ +",
"+  OXX+.+OXX+   ",
"+ +XX++.++OXX ++",
"+ XX+++.++ OXX++",
" XX++.....++ XX+",
"+X++++...+++++X+",
"X++++++.+++++++X"
]

peaksearch = [
"16 16 6 1",
"  c #303030",
". c #585858",
"X c #0000c0",
"o c #dcdcdc",
"O c #ffffff",
"+ c None",
"++..++++++++++++",
"++.X.+++++++++++",
"++XXX+++++++++++",
"++.X.++++..+++++",
"+..X.+++.X..++++",
"+.OX..++XXX.++++",
"+.OXO..+.XO..+++",
"..OXOO..OXOO.+++",
"OOOXOOOOOXOO..OO",
"   ++++++++++...",
" ++ ++++++++++++",
" ++ +  ++  + + +",
"   + + + + + + +",
" +++  ++ + +  ++",
" +++ +++ + + + +",
" ++++  ++  + + +"
]

reload_ = [
"16 16 51 1",
"  c #000000",
". c #040d00",
"X c gray5",
"o c #111111",
"O c #1b1b1b",
"+ c #0c2600",
"@ c #113800",
"# c #153c17",
"$ c #242424",
"% c #2d2d2d",
"& c #343434",
"* c gray24",
"= c #154400",
"- c #124515",
"; c #1c4e1f",
": c #1b531c",
"> c #1e5421",
", c #244926",
"< c #235326",
"1 c #215824",
"2 c #265c28",
"3 c #295f2c",
"4 c #2f783f",
"5 c #2f7a41",
"6 c gray27",
"7 c #4c4c4c",
"8 c #525252",
"9 c #5a5a5a",
"0 c #7b7b7b",
"q c #208a17",
"w c #249215",
"e c #289b19",
"r c #2fa522",
"t c #3fbe31",
"y c #56a64f",
"u c #6ebc66",
"i c #44cd35",
"p c #818181",
"a c #929292",
"s c #9f9f9f",
"d c darkgray",
"f c #b2b2b2",
"g c #b9b9b9",
"h c #a9d7ad",
"j c #b5d7b3",
"k c #b3d8b2",
"l c #c6e0c4",
"z c #dbecda",
"x c #e4e4e4",
"c c white",
"v c None",
"vvvvc2>>>>=vvvvv",
"vvvc3kqr=@+==vvv",
"vvv1zqr=vvv .=vv",
"vvv<hr=vvvvvv =v",
"vvv;ut=vvvvvvvvv",
":::;yt====vvxvvv",
"v:juew4i#vcovcvv",
"vv,lw5i#vv$g vvv",
"v v-ji#vv g88 vv",
#"vvvv##vd98 ",
"vvvv##vd98888 vv",
"vvvvvvvoo 0&0ooo",
"vvvvvvvvv&s& vvv",
"v  vvvvvv p7Ovvv",
"vv   vvc f96 vvv",
"vvvoO  8a9*Xvvvv",
"vvvvvo$  O vvvvv"
]

roi = [
"16 16 6 1",
"  c #000000",
". c #0080ff",
"X c #c3c3c3",
"o c #dcdcdc",
"O c #ffffff",
"+ c None",
"++.XXX XX.++++++",
"++.XX   X.++++++",
"++.XX O X.++++++",
"++.X  O X.++++++",
"++.X OO X.++++++",
"++.X OO X.++++++",
"++.X OO X.++++++",
"++.  OO X.+  +++",
"++. OOO X.+  +++",
"++. OOO X.+  +++",
"++. OOO  .+ + ++",
"++. OOOO .+ + ++",
"  .OOOOOO. ++   ",
"++.OOOOOO.+++++ ",
"++.OOOOOO.++++++",
"++.OOOOOO.++++++"
]

roireset = [
"16 16 8 1",
"  c #000000",
". c #0080ff",
"X c #ff0000",
"o c #c3c3c3",
"O c #dcdcdc",
"+ c #ffc0c0",
"@ c #ffffff",
"# c None",
"XX.ooo oo.####XX",
"#XXoo   o.###XX#",
"##XXo @ o.#+XX##",
"##.XX @ o.+XX###",
"##.+XX@ o+XX####",
"##.o+XX +XX#####",
"##.o +XXXX######",
"##.  @+XX.#  ###",
"##. @+XXXX#  ###",
"##. +XX +XX  ###",
"##.+XX@  +XX# ##",
"##+XX@@@ .+XX ##",
"  XX@@@@@. +XX  ",
"#XX@@@@@@.###XX ",
"#X.@@@@@@.####X#",
"X#.@@@@@@.#####X"
]

rotate_left = [
"24 24 2 1",
"  c None",
". c #000000",
"            .           ",
"           ..           ",
"          ...           ",
"         ......         ",
"        ..........      ",
"        ...........     ",
"         ...........    ",
"          ...  .....    ",
"           ..   .....   ",
"            .    ....   ",
"                 ....   ",
"                  ....  ",
"                  ....  ",
"                  ....  ",
"  ....           ....   ",
"  ....           ....   ",
"  .....         .....   ",
"   .....       .....    ",
"   .......   .......    ",
"    ...............     ",
"     .............      ",
"       .........        ",
"          ...           ",
"                        "]


rotate_right = [
"24 24 2 1",
"  c None",
". c #000000",
"           .            ",
"           ..           ",
"           ...          ",
"         ......         ",
"      ..........        ",
"     ...........        ",
"    ...........         ",
"    .....  ...          ",
"   .....   ..           ",
"   ....    .            ",
"   ....                 ",
"  ....                  ",
"  ....                  ",
"  ....                  ",
"   ....           ....  ",
"   ....           ....  ",
"   .....         .....  ",
"    .....       .....   ",
"    .......   .......   ",
"     ...............    ",
"      .............     ",
"        .........       ",
"           ...          ",
"                        "]

selected = [
"16 16 10 1",
"  c black",
". c #000040",
"X c #004000",
"o c #400000",
"O c green",
"+ c #00c000",
"@ c fractal",
"# c gainsboro",
"$ c #c0ffc0",
"% c None",
"%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%$",
"%%@@@@@@@@@@@@$+",
"%%@%%%%%%%%%%$+O",
"%%@%%%%%%%%%$+OX",
"%%@%%%%%%%%$+OX ",
"%%@O%%%%%%$+OX %",
"%$++O%%%%$+OX.%%",
" XO++O%%$+OX @%%",
"% XO++O$+OXo%@%%",
"%%.XO+++OXo%%@%%",
"%%@ XO+OX %%%@%%",
"%%@% XOX %%%%@%%",
"%%@@@@@@@@@@@@%%",
"%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%"
]

unselected = [
"16 16 3 1",
"  c #808080",
". c #dcdcdc",
"X c None",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX",
"XX            XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX XXXXXXXXXX XX",
"XX            XX",
"XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX"
]





spec = [
"16 16 24 1",
"  c black",
". c #585858",
"X c #777777",
"o c #9f9f9f",
"O c #a5a5a5",
"+ c #acacac",
"@ c gray70",
"# c gray73",
"$ c #e6e6bc",
"% c #c3c3c3",
"& c #cecece",
"* c #d5d5d5",
"= c gainsboro",
"- c #e6e6c3",
"; c #e6e6cc",
": c #e6e6d5",
"> c #e6e6da",
", c #ffffdd",
"< c #e6e6e5",
"1 c #ffffe4",
"2 c #ffffeb",
"3 c #fffff4",
"4 c #fffffe",
"5 c None",
"5555555555555555",
"                ",
" 555*&%%#@+Oooo ",
" XXXXXXXXXXXXXX ",
" <444444444444> ",
" <44444444444,: ",
" %..4..%4%..%.. ",
" .444.4.3.3,.,; ",
" %.%4.3.3..2.1; ",
" <4.3..%2.,1.1; ",
" <4.4.222.1,.,: ",
" ..%2.211%..%.. ",
" >,,,,111,,,,,$ ",
" :::;;;;----$$$ ",
"                ",
"5555555555555555"
]

window_fullscreen = [
"16 16 23 1",
"  c black",
". c #777777",
"X c maroon",
"o c #9f9f9f",
"O c #a5a5a5",
"+ c #acacac",
"@ c gray70",
"# c gray73",
"$ c #e6e6bc",
"% c #c4c4c4",
"& c #cecece",
"* c #d5d5d5",
"= c gainsboro",
"- c #e6e6c3",
"; c #e6e6cc",
": c #e6e6d5",
"> c #e6e6db",
", c #ffffde",
"< c #e6e6e6",
"1 c #ffffe4",
"2 c #ffffec",
"3 c #fffff4",
"4 c #ffffff",
"4444444444444444",
"                ",
" ===*&%%#@+Oooo ",
" .............. ",
" <444444444444> ",
" <XXX444444XXX: ",
" <XX44444333XX: ",
" <X4X443333X2X; ",
" <444X33322211; ",
" <44333222X111; ",
" <X3X322211X,X- ",
" >XX222111,,XX- ",
" >XXX1111,,XXX$ ",
" :::;;;;----$$$ ",
"                ",
"4444444444444444"
]

window_new = [
"16 16 53 1",
"  c #000000",
". c #0f0000",
"X c #330100",
"o c #333940",
"O c #5e2479",
"+ c #555555",
"@ c #585858",
"# c gray40",
"$ c #0000d0",
"% c #0000d8",
"& c #3940e6",
"* c #642780",
"= c #6f2f90",
"- c #6e308b",
"; c #763796",
": c #793b9c",
"> c #7e3ea3",
", c #903339",
"< c #e60000",
"1 c #8242a7",
"2 c #894caf",
"3 c #8957a0",
"4 c #9056b5",
"5 c #925ab3",
"6 c #8d61a4",
"7 c #9065a8",
"8 c #9570ab",
"9 c #9873ae",
"0 c #c0c000",
"q c #c1c10a",
"w c yellow",
"e c #a480b9",
"r c #a881be",
"t c #ae86c5",
"y c #b894ce",
"u c #dedeb6",
"i c #dedebf",
"p c #ffff85",
"a c #c6c6c6",
"s c #dedec4",
"d c #dedecb",
"f c #deded2",
"g c #dededd",
"h c #ffffc0",
"j c #ffffdf",
"k c #e4e4e4",
"l c #eeeee6",
"z c #eeeeee",
"x c #ffffe4",
"c c #ffffec",
"v c #fffff4",
"b c #fffffe",
"n c None",
"@#+**********+++",
"@kayytre98763ga ",
"+aa45521>:;=-aa ",
"+@@OOOOOOOOOO@@ ",
"+zbbbbbbbbbbbvl ",
"+gbbbbbbbbvcccd ",
"+gbbbbbbbvcccxs ",
"+gbbbbbvcc@pxji ",
"+gbbbbv@pc@wj@p ",
"+gbbvccc@w0w0wu ",
"+gbvcccxxqhph0@ ",
"+gffdd@pwwpbpwwp",
"+        0hph0  ",
"nnnnnnnn w0w0wnn",
"nnnnnnn pn wn pn",
"nnnnnnnnnn pnnnn"
]

window_nofullscreen = [
"16 16 23 1",
"  c black",
". c #777777",
"X c maroon",
"o c #9f9f9f",
"O c #a5a5a5",
"+ c #acacac",
"@ c gray70",
"# c gray73",
"$ c #e6e6be",
"% c #c4c4c4",
"& c #cecece",
"* c #d5d5d5",
"= c gainsboro",
"- c #e6e6c4",
"; c #e6e6cc",
": c #e6e6d4",
"> c #e6e6db",
", c #ffffda",
"< c #e6e6e6",
"1 c #ffffe4",
"2 c #ffffec",
"3 c #fffff4",
"4 c #ffffff",
"4444444444444444",
"                ",
" ===*&%%#@+Oooo ",
" .............. ",
" X444444444444X ",
" <X4X444444X3X> ",
" <4XX444443XX2: ",
" <XXX444433XXX: ",
" <444443332221; ",
" <444433322211; ",
" <XXX332221XXX- ",
" <4XX322211XX,- ",
" >X3X22111,X,X$ ",
" X>:::;;;---$$X ",
"                ",
"4444444444444444"
]

zoom = [
"16 16 56 1",
"  c #000000",
". c #0b0b0b",
"X c #101010",
"o c #272727",
"O c #3f3f3f",
"+ c #3f3f40",
"@ c #404041",
"# c #707071",
"$ c #3eaab3",
"% c #00c0c0",
"& c aqua",
"* c #43b2bc",
"= c #7f8281",
"- c #53c9d4",
"; c #60c1cd",
": c #6ec4cd",
"> c #68c6d1",
", c #71c6ce",
"< c #7ac4cb",
"1 c #7cc9cd",
"2 c #76cbd5",
"3 c #79cad4",
"4 c #76d7e3",
"5 c #78d8e3",
"6 c #85ccd2",
"7 c #89c8d0",
"8 c #90d5db",
"9 c #90d9df",
"0 c #8bd7e0",
"q c #8adbe5",
"w c #8fdfe8",
"e c #95e1ea",
"r c #a8d1d5",
"t c #aed6db",
"y c #b6d9dd",
"u c #b9dade",
"i c #abdee4",
"p c #b9dbe0",
"a c #ade4e8",
"s c #afe9f0",
"d c #b0eaef",
"f c #baecef",
"g c #beedf1",
"h c #c3c3c3",
"j c #c1d4d6",
"k c #ced8d9",
"l c #c4eaed",
"z c #caeaed",
"x c #cdecf0",
"c c #d7e5e6",
"v c #d7e5e8",
"b c #d3f2f5",
"n c #def4f6",
"m c #e3f4f4",
"M c #eafbfa",
"N c None",
"NNNNoO.NNNNNNNNN",
"NN+ kvj +NNNNNNN",
"N+=mnlia=+NNNNNN",
"N mMng9:f NNNNNN",
"Xybnbsw,3p.NNNNN",
"oclgde4;6z.NNNNN",
".ri0q5-*1t NNNNN",
"N g2:>*$g NNNNNN",
"N+=g8<7g= &NNNNN",
"NN+ uzt @&  NNNN",
"NNNN . N% #h NNN",
"NNNNNNNNN @#h NN",
"NNNNNNNNNN @#h N",
"NNNNNNNNNNN @#h ",
"NNNNNNNNNNNN @# ",
"NNNNNNNNNNNNN  N"
]

zoomminus = [
"16 16 56 1",
"  c #000000",
". c #0b0b0b",
"X c #101010",
"o c #272727",
"O c #3f3f3f",
"+ c #3f3f40",
"@ c #404041",
"# c #707071",
"$ c #3eaab3",
"% c #00c0c0",
"& c aqua",
"* c #43b2bc",
"= c #7f8281",
"- c #53c9d4",
"; c #60c1cd",
": c #6ec4cd",
"> c #68c6d1",
", c #71c6ce",
"< c #7ac4cb",
"1 c #7cc9cd",
"2 c #76cbd5",
"3 c #79cad4",
"4 c #76d7e3",
"5 c #78d8e3",
"6 c #85ccd2",
"7 c #89c8d0",
"8 c #90d5db",
"9 c #90d9df",
"0 c #8bd7e0",
"q c #8adbe5",
"w c #8fdfe8",
"e c #95e1ea",
"r c #a8d1d5",
"t c #aed6db",
"y c #b6d9dd",
"u c #b9dade",
"i c #abdee4",
"p c #b9dbe0",
"a c #ade4e8",
"s c #afe9f0",
"d c #b0eaef",
"f c #baecef",
"g c #beedf1",
"h c #c3c3c3",
"j c #c1d4d6",
"k c #ced8d9",
"l c #c4eaed",
"z c #caeaed",
"x c #cdecf0",
"c c #d7e5e6",
"v c #d7e5e8",
"b c #d3f2f5",
"n c #def4f6",
"m c #e3f4f4",
"M c #eafbfa",
"N c None",
"NNNNoO.NNNNNNNNN",
"NN+ kvj +NNNNNNN",
"N+=mnlia=+NNNNNN",
"N mMng9:f NNNNNN",
"Xybnbsw,3p.NNNNN",
"oclgde4;6z.NNNNN",
".ri0q5-*1t NNNNN",
"N g2:>*$g NNNNNN",
"N+=g8<7g= &NNNNN",
"NN+ uzt +&  NNNN",
"NNNN . N% #h NNN",
"NNNNNNNNN @#h NN",
"NNNNNNNNNN @#h N",
"     NNNNNN @#h ",
"NNNNNNNNNNNN @# ",
"NNNNNNNNNNNNN  N"
]

zoomplus = [
"16 16 56 1",
"  c #000000",
". c #0b0b0b",
"X c #101010",
"o c #272727",
"O c #3f3f3f",
"+ c #3f3f40",
"@ c #404041",
"# c #707071",
"$ c #3eaab3",
"% c #00c0c0",
"& c aqua",
"* c #43b2bc",
"= c #7f8281",
"- c #53c9d4",
"; c #60c1cd",
": c #6ec4cd",
"> c #68c6d1",
", c #71c6ce",
"< c #7ac4cb",
"1 c #7cc9cd",
"2 c #76cbd5",
"3 c #79cad4",
"4 c #76d7e3",
"5 c #78d8e3",
"6 c #85ccd2",
"7 c #89c8d0",
"8 c #90d5db",
"9 c #90d9df",
"0 c #8bd7e0",
"q c #8adbe5",
"w c #8fdfe8",
"e c #95e1ea",
"r c #a8d1d5",
"t c #aed6db",
"y c #b6d9dd",
"u c #b9dade",
"i c #abdee4",
"p c #b9dbe0",
"a c #ade4e8",
"s c #afe9f0",
"d c #b0eaef",
"f c #baecef",
"g c #beedf1",
"h c #c3c3c3",
"j c #c1d4d6",
"k c #ced8d9",
"l c #c4eaed",
"z c #caeaed",
"x c #cdecf0",
"c c #d7e5e6",
"v c #d7e5e8",
"b c #d3f2f5",
"n c #def4f6",
"m c #e3f4f4",
"M c #eafbfa",
"N c None",
"NNNNoO.NNNNNNNNN",
"NN+ kvj +NNNNNNN",
"N+=mnlia=+NNNNNN",
"N mMng9:f NNNNNN",
"Xybnbsw,3p.NNNNN",
"oclgde4;6z.NNNNN",
".ri0q5-*1t NNNNN",
"N g2:>*$g NNNNNN",
"N+=g8<7g= &NNNNN",
"NN+ uzt +&  NNNN",
"NNNN . N% #h NNN",
"NN NNNNNN @#h NN",
"NN NNNNNNN @#h N",
"     NNNNNN @#h ",
"NN NNNNNNNNN @# ",
"NN NNNNNNNNNN  N"
]

zoomreset = [
"16 16 38 1",
"  c #000000",
". c #0c0c0c",
"X c #101010",
"o c #272727",
"O c #3f3f3f",
"+ c #3f3f40",
"@ c #404041",
"# c #00c0c0",
"$ c aqua",
"% c #7f8281",
"& c #60c1cd",
"* c #6ec4cd",
"= c #68c6d1",
"- c #71c6ce",
"; c #76cbd5",
": c #79cad4",
"> c red",
", c #90d5db",
"< c #90d9df",
"1 c #8bd7e0",
"2 c #8adbe5",
"3 c #8fdfe8",
"4 c #a8d1d5",
"5 c #b6d9dd",
"6 c #abdee4",
"7 c #ade4e8",
"8 c #baecef",
"9 c #beedf1",
"0 c #c1d4d6",
"q c #ced8d9",
"w c gainsboro",
"e c #c4eaed",
"r c #d7e5e6",
"t c #d7e5e8",
"y c #d5f2f4",
"u c #dcf2f3",
"i c #ffc0c0",
"p c None",
">>ppoO.ppppppp>>",
"p>> qt0 +pppp>>p",
"p+>>ue67%+pi>>pp",
"p i>>9<*8 i>>ppp",
"X5yi>>3-:i>>pppp",
"ore9i>>&i>>ppppp",
".4612i>>>> ppppp",
"p 9;*=i>> pppppp",
"p+%9,i>>>>$ppppp",
"pp+ i>> i>> pppp",
"pppi>> p#i>> ppp",
"ppi>>pppp i>> pp",
"pp>>pppppp i>> p",
"p>>pppppppp i>> ",
"p>pppppppppp @> ",
">pppppppppppp  >"
]

# Object3DIcons

image_print_data = [
"22 22 88 2",
"Qt c None",
".2 c #000000",
".S c #08ff08",
"#v c #100810",
".U c #101010",
"#c c #101018",
".M c #181018",
"#e c #181818",
".A c #181821",
".L c #211821",
"#l c #212121",
".z c #212129",
"#m c #292129",
"#u c #292929",
"#n c #292931",
".R c #29ff29",
"#o c #312931",
".T c #313131",
"#p c #313139",
".Z c #31ff31",
"#q c #393139",
"#t c #393939",
".y c #393942",
"#s c #423942",
".o c #424242",
"#h c #4a4a52",
".n c #5a525a",
"#r c #5a5a63",
".I c #5ace5a",
"#b c #6b636b",
".p c #6b6b6b",
".x c #6b6b73",
".Y c #6bff63",
".l c #736b73",
".t c #7b737b",
".s c #7b7384",
".0 c #7bff7b",
".r c #847b84",
".u c #847b8c",
"#g c #84848c",
".v c #8c7b94",
"#i c #8c848c",
".w c #8c8494",
"#j c #8c8c8c",
".8 c #8c8c94",
".m c #948c94",
"#k c #948c9c",
"#f c #949494",
".q c #94949c",
".J c #94c694",
"#d c #9c949c",
"#a c #9c94a5",
".k c #9c9c9c",
".N c #9c9ca5",
".H c #9ccea5",
".K c #a59ca5",
"#. c #a59cad",
".i c #a5a5a5",
".3 c #a5a5ad",
"## c #ad9cad",
".V c #ada5ad",
".d c #adadad",
".j c #adadb5",
".9 c #b5adb5",
".# c #b5b5b5",
".a c #bdbdbd",
".7 c #bdd6bd",
".c c #c6c6c6",
".5 c #cec6ce",
".b c #cecece",
".4 c #ceced6",
".F c #d6ced6",
".G c #d6cede",
".h c #d6d6d6",
".E c #d6d6de",
".Q c #d6ffd6",
".B c #ded6de",
".1 c #ded6e7",
".g c #dedede",
".D c #dedee7",
".6 c #e7dee7",
".f c #e7e7e7",
".C c #e7e7ef",
".X c #e7ffe7",
".O c #efe7ef",
".e c #efefef",
".W c #f7f7f7",
".P c #ffffff",
"QtQtQtQtQtQt.#.a.b.b.b.b.c.c.a.a.d.aQtQtQtQt",
"QtQtQtQtQtQt.a.e.f.f.f.f.f.e.e.e.g.aQtQtQtQt",
"QtQtQtQtQtQt.a.c.c.c.b.b.c.c.c.c.a.cQtQtQtQt",
"QtQtQtQtQtQt.#.a.a.a.a.#.a.a.#.#.d.aQtQtQtQt",
"QtQtQtQtQt.c.d.c.a.c.c.c.a.a.a.c.#QtQtQtQtQt",
"QtQtQtQtQt.a.a.#.a.a.a.a.a.a.c.c.#QtQtQtQtQt",
"QtQtQtQtQt.a.#.c.a.a.a.a.a.c.a.c.dQtQtQtQtQt",
"QtQtQtQtQt.c.a.a.a.a.a.a.a.a.a.a.#QtQtQtQtQt",
"QtQtQtQtQt.d.b.f.g.g.g.g.g.g.h.g.i.i.jQtQtQt",
"QtQtQt.a.k.l.#.h.b.h.b.h.b.h.g.g.m.n.o.p.#Qt",
"QtQt.a.q.r.s.t.t.t.t.t.t.t.u.v.w.x.y.z.A.o.i",
"Qt.a.k.B.C.D.B.E.E.E.E.F.G.H.I.J.K.o.L.L.M.y",
".a.N.O.P.P.P.P.P.P.P.P.P.Q.R.S.R.b.v.T.A.U.L",
".V.W.P.P.P.P.P.P.P.P.P.P.X.Y.Z.0.P.1.t.A.2.L",
".3.E.4.5.4.h.E.E.g.6.D.B.D.E.7.F.4.5.8.M.2.A",
".m.9.j.V.3#..3.K#.#..i#..K#.###a.q.8#b#c.2.L",
".m.j.j#..3.K.K.K.N.K.N.N.N.N#a#d#d.w#b#c.2#e",
"#f#.#..K.N.K.N.N.N#a.k#a#d#d#d#a.m#g#b.M.2#h",
".m.3.K.K#a.k#a#d#a.k#a#d#a#d.q.m.8#i.x#c#e.d",
"#f#g#i.w#j.w#i.8.w#i.8.8.m.8.m#k.8.w#b#e#fQt",
".#.l.z.A#l.z#m#m#m#n#o#o#p#p#q#q#p#o#p#fQtQt",
"QtQt.d#r#s#s#t#p.T.T.T#u#u.z#e#e#v.o.kQtQtQt"
]

image_cut_data = [
"22 22 3 1",
". c None",
"# c #000000",
"a c #000082",
"......................",
".......#.....#........",
".......#.....#........",
".......#.....#........",
".......#....##........",
".......##...#.........",
"........#...#.........",
"........##.##.........",
".........###..........",
".........###..........",
"..........#...........",
".........a#a..........",
"........aa.aaa........",
".......a.a.a..a.......",
"......a..a.a...a......",
".....a...a.a....a.....",
"....a....a.a....a.....",
"....a....a..a...a.....",
"....a....a..a..a......",
"....a...a....aa.......",
".....aaa..............",
"......................"
]

image_copy_data = [
"22 22 6 1",
". c None",
"# c #000000",
"b c #000082",
"c c #3c3cfd",
"d c #8b8bfd",
"a c #ffffff",
"......................",
"......................",
"########..............",
"#aaaaaa##.............",
"#a####a#a#............",
"#aaaaaa#aa#...........",
"#a####a#bbbbbbbb......",
"#aaaaaa#baaaaaabb.....",
"#a#####aba####abcb....",
"#aaaaaaabaaaaaabdcb...",
"#a#####aba####abadcb..",
"#aaaaaaabaaaaaabbbbbb.",
"#a#####aba####aaaaaab.",
"#aaaaaaabaaaaaaaaaaab.",
"#a#####aba#########ab.",
"#aaaaaaabaaaaaaaaaaab.",
"########ba#########ab.",
"........baaaaaaaaaaab.",
"........ba#########ab.",
"........baaaaaaaaaaab.",
"........bbbbbbbbbbbbb.",
"......................"
]

image_delete_data = [
"22 22 2 1",
". c None",
"# c #ff0000",
"......................",
"......................",
".................###..",
"...............####...",
".###..........###.....",
"..####.......###......",
"....####....###.......",
"......####.###........",
".......######.........",
"........######........",
"........#######.......",
".......#########......",
".......###..#####.....",
"......####...#####....",
".....####.....#####...",
"....#####.....#####...",
"...#####.......###....",
"...#####.......##.....",
"...####...............",
"....##................",
"......................",
"......................"
]


image_paste_data = [
"22 22 8 1",
". c None",
"# c #000000",
"e c #000084",
"c c #848200",
"b c #848284",
"d c #c6c3c6",
"a c #ffff00",
"f c #ffffff",
"......................",
".......#####..........",
"..######aaa######.....",
".######aaaaa######....",
"##bcb##a###a##bcb##...",
"#bcb#ddddddddd#bcb#...",
"#cbc#ddddddddd#cbc#...",
"#bcb###########bcb#...",
"#cbcbcbcbcbcbcbcbc#...",
"#bcbcbcbcbcbcbcbcb#...",
"#cbcbcbceeeeeeeeee#...",
"#bcbcbcbefffffffefe...",
"#cbcbcbcefeeeeefeffe..",
"#bcbcbcbefffffffefffe.",
"#cbcbcbcefeeeeefeffffe",
"#bcbcbcbefffffffeeeeee",
"#cbcbcbcefeeeeeffffffe",
"#bcbcbcbeffffffffffffe",
"#cbcbcbcefeeeeeeeeeefe",
".#######effffffffffffe",
"........eeeeeeeeeeeeee",
"......................"
]

file_open = ["22 22 5 1",
". c None",
"# c #000000",
"c c #848200",
"a c #ffff00",
"b c #ffffff",
"......................",
"......................",
"......................",
"............####....#.",
"...........#....##.##.",
"..................###.",
".................####.",
".####...........#####.",
"#abab##########.......",
"#babababababab#.......",
"#ababababababa#.......",
"#babababababab#.......",
"#ababab###############",
"#babab##cccccccccccc##",
"#abab##cccccccccccc##.",
"#bab##cccccccccccc##..",
"#ab##cccccccccccc##...",
"#b##cccccccccccc##....",
"###cccccccccccc##.....",
"##cccccccccccc##......",
"###############.......",
"......................"]

file_save = ["22 22 5 1",
". c None",
"# c #000000",
"a c #848200",
"b c #c1c1c1",
"c c #cab5d1",
"......................",
".####################.",
".#aa#bbbbbbbbbbbb#bb#.",
".#aa#bbbbbbbbbbbb#bb#.",
".#aa#bbbbbbbbbcbb####.",
".#aa#bbbccbbbbbbb#aa#.",
".#aa#bbbccbbbbbbb#aa#.",
".#aa#bbbbbbbbbbbb#aa#.",
".#aa#bbbbbbbbbbbb#aa#.",
".#aa#bbbbbbbbbbbb#aa#.",
".#aa#bbbbbbbbbbbb#aa#.",
".#aaa############aaa#.",
".#aaaaaaaaaaaaaaaaaa#.",
".#aaaaaaaaaaaaaaaaaa#.",
".#aaa#############aa#.",
".#aaa#########bbb#aa#.",
".#aaa#########bbb#aa#.",
".#aaa#########bbb#aa#.",
".#aaa#########bbb#aa#.",
".#aaa#########bbb#aa#.",
"..##################..",
"......................"]



IconDict0 = {
    "derive": derive,
    "close": close,
    "fileclose": fileclose,
    "fileopen": file_open,
    "filesave": file_save,
    "fileprint": image_print_data,
    "spec": spec,
    "normal": normal,
    "normalize16": normalize16,
    "reload": reload_,
    "window_fullscreen": window_fullscreen,
    "window_new": window_new,
    "window_nofullscreen": window_nofullscreen,
    "zoomplus": zoomplus,
    "zoomminus": zoomminus,
    "zoomreset": zoomreset,
    "zoom": zoom,
    "logx": logx,
    "logy": logy,
    "peak": peak,
    "peakreset": peakreset,
    "peaksearch": peaksearch,
    "roi": roi,
    "roireset": roireset,
    "selected": selected,
    "unselected": unselected,
    "fit": fit,
    "energy": energy,
    "xauto": xauto,
    "yauto": yauto,
    "colormap": colormap,
    "colormap16": colormap16,
    "gioconda16": gioconda16,
    "gioconda16mirror": gioconda16mirror,
    "grid16": grid16,
    "image": image,
    "eraseselect": eraseselect,
    "boxselect": boxselect,
    "brush": brush,
    "brushselect": brushselect,
    "rgb16": rgb16,
    "rgb": rgb,
    "sliderson": sliderson,
    "slidersoff": slidersoff,
    "sigma": sigma,
    "swapsign": swapsign,
    "ymintozero": ymintozero,
    "average16": average16,
    "square": square16,
    "polygon": polygon16,
    "rectangle": rectangle16,
    "circle": circle16,
    "ellipse": ellipse16,
    "solidcircle": solid_circle16,
    "solidellipse": solid_ellipse16,
    "smooth": smooth,
    "subtract": subtract,
    "substract": substract,
    "togglepoints": togglepoints,
    "remove": remove,
    "additionalselect": additionalselect,
    "crop": crop,
    "plugin": plugin,
    "horizontal": horizontal,
    "vertical": vertical,
    "diagonal": diagonal,
    "rotate_left": rotate_left,
    "rotate_right": rotate_right
}

# corresponding silx icons
TRANSLATION_TABLE = {
    "average16": "math-average",
    "derive": "math-derive",
    "close": "close",
    "crop": "crop",
    #"fileclose": fileclose,
    "fileopen": "document-open",
    "filesave": "document-save",
    #"fileprint": "document-print", PyMca icon is nicer
    "spec": "spec",
    "normal": "normal",
    "normalize16": "math-normalize",
    "reload": "view-refresh",
    "window_fullscreen": "view-fullscreen",
    #"window_new": window_new,
    "window_nofullscreen": "view-nofullscreen",
    "zoomplus": "zoom-in",
    "zoomminus": "zoom-out",
    "zoomreset": "zoom-original",
    "zoom": "zoom",
    "logx": "plot-xlog",
    "logy": "plot-ylog",
    "peak": "math-peak",
    "peakreset": "math-peak-reset",
    "peaksearch": "math-peak-search",
    #"roi": "plot-roi",
    "roireset": "plot-roi-reset",
    "selected": "selected",
    #"unselected": unselected,
    "fit": "math-fit",
    "energy": "math-energy",
    "xauto": "plot-xauto",
    "yauto": "plot-yauto",
    "colormap": "colormap",
    "colormap16": "colormap",
    #"gioconda16": gioconda16,
    #"gioconda16mirror": gioconda16mirror,
    "grid16": "plot-grid",
    #"image": image,
    #"eraseselect": eraseselect,
    #"boxselect": boxselect,
    "brush": "draw-brush",
    #"brushselect": brushselect,
    #"rgb16": rgb16,
    #"rgb": rgb,
    "sliderson": "sliders-on",
    "slidersoff": "sliders-off",
    "sigma": "math-sigma",
    "swapsign": "math-swap-sign",
    "ymintozero": "math-ymin-to-zero",
    "square": "shape-square",
    "polygon": "shape-polygon",
    "rectangle": "shape-rectangle",
    "circle": "shape-circle",
    "ellipse": "shape-ellipse",
    "solidcircle": "shape-circle-solid",
    "solidellipse": "shape-ellipse-solid",
    "smooth": "math-smooth",
    "subtract": "math-substract",
    "substract": "math-substract",
    "togglepoints": "plot-toggle-points",
    "remove": "remove",
    #"additionalselect": additionalselect,
    #"plugin": plugin,
    "horizontal": "shape-horizontal",
    "vertical": "shape-vertical",
    "diagonal": "shape-diagonal",
    #"rotate_left": rotate_left,
    #"rotate_right": rotate_right
    }


class _PatchedIconDict(MutableMapping):
    """IconDict that patches some legacy icons with new
    silx icons, when available.

    This object must be initialized with a legacy dictionary of icons.
    If silx is installed and a corresponding silx icon name is specified in
    TRANSLATION_TABLE, the silx icon is returned by __getitem__ rather
    than the legacy icon.

    This object allows modifying the icon dict via __setitem__ and
    deleting icons, like a real dict.
    """
    def __init__(self, *args, **kw):
        self._unpatched_icons = dict(*args, **kw)
        self.__initialized = False

    def __iter__(self):
        for key in self._unpatched_icons:
            yield key

    def __len__(self):
        # same length
        return len(self._unpatched_icons)

    def __getitem__(self, key):
        if not self.__initialized:
            from PyMca5.PyMcaGui import PyMcaQt as qt
            self._qt = qt
            try:
                from silx.gui import icons as silx_icons
            except ImportError:
                _logger.debug("Could not import silx. Legacy icons will be used.")
                silx_icons = None

            self._silx_icons = silx_icons
            # keep an internal copy:
            self._translation_table = TRANSLATION_TABLE.copy()
            self.__initialized = True
        if key not in self._unpatched_icons:
            raise KeyError("Unknown icon '%s'" % key)

        if self._silx_icons is None or key not in TRANSLATION_TABLE:
            _logger.debug("Using legacy icon '%s' because silx is not "
                          "available or because it has no corresponding icon.",
                          key)
            return self._unpatched_icons[key]

        if self._qt.QApplication.instance() is None:
            _logger.warning("Cannot fetch QPixmap without a QApplication."
                            " Using legacy PyMca icon as fallback.")
            return self._unpatched_icons[key]

        try:
            icon = self._silx_icons.getQPixmap(TRANSLATION_TABLE[key])
        except ValueError:
            _logger.warning("Icon '%s' not found in silx. "
                            "Using legacy PyMca icon '%s'.",
                            TRANSLATION_TABLE[key], key)
            icon = self._unpatched_icons[key]
        else:
            _logger.debug("Using silx icon '%s' instead of legacy icon '%s'.",
                          TRANSLATION_TABLE[key], key)
        finally:
            return icon

    def __delitem__(self, key):
        # deleting from legacy dict is enough
        del self._unpatched_icons[key]

    def __setitem__(self, key, item):
        self._unpatched_icons[key] = item
        if self._silx_icons is not None and key in self._translation_table:
            # we also need to remove the key from internal translation table
            del self._translation_table[key]

IconDict = _PatchedIconDict(IconDict0)


def showIcons():
    w = qt.QWidget()
    g = qt.QGridLayout(w)

    idx = 0
    for name, icon in IconDict.items():
        print(name, type(icon))
        column = int(idx / 10)
        row = idx % 10
        #print "name",name
        lab = qt.QLabel(w)
        lab.setText(str(name))
        g.addWidget(lab, row, 2 * column + 1)
        lab = qt.QLabel(w)
        lab.setPixmap(qt.QPixmap(icon))
        g.addWidget(lab, row, 2 * column)
        idx += 1

    w.show()
    return w

if __name__ == '__main__':
    from PyMca5.PyMcaGui import PyMcaQt as qt
    app = qt.QApplication(sys.argv)
    app.lastWindowClosed.connect(app.quit)
    logging.basicConfig()
    _logger.setLevel(logging.DEBUG)
    w = showIcons()
    app.exec_()
