# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
""" Copyright (c) 2000-2003 LOGILAB S.A. (Paris, FRANCE).
 http://www.logilab.fr/ -- mailto:contact@logilab.fr
"""

__revision__ = '$Id: unittest_lint.py,v 1.2 2004/10/19 15:07:16 syt Exp $'

import unittest
import sys

from logilab.pylint.config import get_note_message
from logilab.pylint.lint import PyLinter, sort_checkers, UnknownMessage
from logilab.pylint import checkers

class GetNoteMessageTC(unittest.TestCase):
    def test(self):
        msg = None
        for note in range(-1, 11):
            note_msg = get_note_message(note)
            self.assertNotEquals(msg, note_msg)
            msg = note_msg
        self.assertRaises(AssertionError, get_note_message, 11)
        
class PyLinterTC(unittest.TestCase):
    def setUp(self):
        self.linter = PyLinter()
        self.linter.disable_message_category('I')
        # register checkers
        checkers.initialize(self.linter)
        
    def test_disable_all(self):
        self.linter.disable_all_checkers()
        checkers = sort_checkers(self.linter._checkers, enabled_only=0)
        self.assert_(len(checkers) > 1)
        checkers = sort_checkers(self.linter._checkers, enabled_only=1)
        self.assertEquals(checkers, [self.linter])
        
    def test_message_help(self):
        msg = self.linter.get_message_help('F0001')
        expected = 'F0001:\n  Used when an error occured while building the ASTNG representation. This\n  message belongs to the master checker.'
        self.assertEquals(msg, expected)
        self.assertRaises(UnknownMessage, self.linter.get_message_help, 'YB12')
        
    def test_enable_message(self):
        linter = self.linter
        linter.open()
        linter.set_current_module('toto')
        self.assert_(linter.is_message_enabled('W0101'))
        self.assert_(linter.is_message_enabled('W0102'))
        linter.disable_message('W0101', scope='package')
        linter.disable_message('W0102', scope='module')
        self.assert_(not linter.is_message_enabled('W0101'))
        self.assert_(not linter.is_message_enabled('W0102'))
        linter.set_current_module('tutu')
        self.assert_(not linter.is_message_enabled('W0101'))
        self.assert_(linter.is_message_enabled('W0102'))        
        linter.enable_message('W0101', scope='package')
        linter.enable_message('W0102', scope='module')
        self.assert_(linter.is_message_enabled('W0101'))
        self.assert_(linter.is_message_enabled('W0102'))

    def test_enable_message_category(self):
        linter = self.linter
        linter.open()
        linter.set_current_module('toto')
        self.assert_(linter.is_message_enabled('W0101'))
        self.assert_(linter.is_message_enabled('R0102'))
        linter.disable_message_category('W', scope='package')
        linter.disable_message_category('REFACTOR', scope='module')
        self.assert_(not linter.is_message_enabled('W0101'))
        self.assert_(not linter.is_message_enabled('R0102'))
        linter.set_current_module('tutu')
        self.assert_(not linter.is_message_enabled('W0101'))
        self.assert_(linter.is_message_enabled('R0102'))        
        linter.enable_message_category('WARNING', scope='package')
        linter.enable_message_category('R', scope='module')
        self.assert_(linter.is_message_enabled('W0101'))
        self.assert_(linter.is_message_enabled('R0102'))

                     
if __name__ == '__main__':
    unittest.main()
