from __future__ import generators 
import py 

class TracebackEntry(object):
    exprinfo = None 

    def __init__(self, rawentry):
        self._rawentry = rawentry
        self.frame = py.code.Frame(rawentry.tb_frame)
        self.lineno = rawentry.tb_lineno - 1

    def __repr__(self):
        return "<TracebackEntry %s:%d>" %(self.frame.code.path, self.lineno+1)

    def statement(self):
        source = self.frame.code.fullsource
        return source.getstatement(self.lineno)
    statement = property(statement, None, None,
                         "statement of this traceback entry.")

    def path(self):
        return self.frame.code.path
    path = property(path, None, None, "path to the full source code")

    def reinterpret(self):
        """Reinterpret the failing statement and returns a detailed information
           about what operations are performed."""
        if self.exprinfo is None:
            from py.__.magic import exprinfo
            source = str(self.statement).strip()
            x = exprinfo.interpret(source, self.frame, should_fail=True)
            if not isinstance(x, str):
                raise TypeError, "interpret returned non-string %r" % (x,)
            self.exprinfo = x 
        return self.exprinfo

    def getsource(self): 
        """ return failing source code. """ 
        source = self.frame.code.fullsource
        start, end = self.frame.code.firstlineno, self.lineno 
        try:
            _, end = source.getstatementrange(end) 
        except IndexError: 
            end = self.lineno + 1 
        # heuristic to stop displaying source on e.g. 
        #   if something:  # assume this causes a NameError
        #      # _this_ lines and the one 
               #        below we don't want from entry.getsource() 
        for i in range(self.lineno, end): 
            if source[i].rstrip().endswith(':'): 
                end = i + 1
                break 
        return source[start:end]

    def __str__(self): 
        try: 
            fn = str(self.path) 
        except py.error.Error: 
            fn = '???'
        name = self.frame.code.name 
        line = str(self.statement).lstrip()
        return "  File %r:%d in %s\n  %s\n" %(fn, self.lineno+1, name, line) 

class Traceback(list):
    Entry = TracebackEntry 

    def __init__(self, tb):
        def f(cur): 
            while cur is not None: 
                yield self.Entry(cur)
                cur = cur.tb_next 
        list.__init__(self, f(tb)) 

#    def __str__(self): 
#        for x in self
#        l = []
##        for func, entry in self._tblist: 
#            l.append(entry.display()) 
#        return "".join(l) 

