import py
mypath = py.magic.autopath()

def test_excinfo_simple():
    try:
        raise ValueError
    except ValueError:
        info = py.code.ExceptionInfo()
    assert info.type == ValueError

def test_excinfo_getstatement():
    def g():
        raise ValueError
    def f():
        g()
    try:
        f()
    except ValueError:
        excinfo = py.code.ExceptionInfo()
    linenumbers = [f.func_code.co_firstlineno-1+3,
                   f.func_code.co_firstlineno-1+1,
                   g.func_code.co_firstlineno-1+1,]
    l = list(excinfo.traceback)
    foundlinenumbers = [x.lineno for x in l]
    print l[0].frame.statement
    assert foundlinenumbers == linenumbers
    #for x in info:
    #    print "%s:%d  %s" %(x.path.relto(root), x.lineno, x.statement)
    #xxx

# testchain for getentries test below
def f():
    raise ValueError
def g():
    f()
def h():
    g()

class TestTraceback_f_g_h: 
    def setup_method(self, method): 
        try:
            h()
        except ValueError:
            self.excinfo = py.code.ExceptionInfo()

    def test_traceback_entries(self):
        tb = self.excinfo.traceback 
        entries = list(tb) 
        assert len(tb) == 4 # maybe fragile test 
        assert len(entries) == 4 # maybe fragile test 
        names = ['f', 'g', 'h']
        for entry in entries:
            try:
                names.remove(entry.frame.code.name)
            except ValueError:
                pass
        assert not names

    def test_traceback_entry_getsource(self):
        tb = self.excinfo.traceback 
        s = str(tb[-1].getsource() )
        assert s.startswith("def f():")
        assert s.endswith("raise ValueError") 

    def test_traceback_entry_getsource_in_construct(self):
        source = py.code.Source("""\
            def xyz():
                try:
                    raise ValueError
                except somenoname:
                    pass
            xyz()
        """) 
        try: 
            exec source.compile()
        except NameError: 
            tb = py.code.ExceptionInfo().traceback 
            print tb[-1].getsource()
            s = str(tb[-1].getsource())
            assert s.startswith("def xyz():\n    try:")
            assert s.endswith("except somenoname:") 

    #def test_traceback_display_func(self):
    #    tb = self.excinfo.traceback 
    #    for x in tb: 
    #        x.setdisplay(lambda entry: entry.frame.code.name + '\n')
    ##    l = tb.display().rstrip().split('\n')
    #    assert l == ['setup_method', 'h', 'g', 'f']


def hello(x): 
    x + 5 

def test_tbentry_reinterpret(): 
    try: 
        hello("hello") 
    except TypeError: 
        excinfo = py.code.ExceptionInfo() 
    tbentry = excinfo.traceback[-1]
    msg = tbentry.reinterpret() 
    assert msg.startswith("TypeError: ('hello' + 5)") 

#def test_excinfo_getentries_type_error():
#    excinfo = py.test.raises(ValueError, h)
#    entries = excinfo.getentries(
#            lambda x: x.frame.code.name != 'raises',
#            lambda x: x.frame.code.name != 'f')
#    names = [x.frame.code.name for x in entries]
#    assert names == ['h','g']

def test_excinfo_exconly():
    excinfo = py.test.raises(ValueError, h)
    assert excinfo.exconly().startswith('ValueError')

def test_excinfo_errisinstance():
    excinfo = py.test.raises(ValueError, h)
    assert excinfo.errisinstance(ValueError) 
