#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#
# close.py - process several events with the same method
# Copyright (C) 2006  Sbastien Martini <sebastien.martini@gmail.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# usage: ./close.py [path-to-watch]

import os
# please read src/examples/README
try:
    # import local build
    import autopath
    from src.pyinotify.pyinotify import WatchManager, Notifier, \
         ProcessEvent, EventsCodes
except ImportError:
    # import global (installed) pyinotify
    from pyinotify import WatchManager, Notifier, ProcessEvent, \
         EventsCodes


class PClose(ProcessEvent):
    def process_IN_CLOSE(self, event):
        """
        process 'IN_CLOSE_*' events
        """
        if event.name:
            f = "%s" % os.path.join(event.path, event.name)
        else:
            f = "%s" % event.path
        print "%s: closed" % f


if __name__ == '__main__':
    #
    # - watch for IN_CLOSE_* events and process them with
    #   the same processing method.
    # - The watched path is '/tmp' (by default) or the first
    #   command line argument if given.
    #
    import sys

    path = '/tmp'  # default watched path
    if sys.argv[1:]:
        path = sys.argv[1]

    # only watch these events
    mask = EventsCodes.IN_CLOSE_WRITE | EventsCodes.IN_CLOSE_NOWRITE

    # watch manager instance
    wm = WatchManager()
    # notifier instance and init give an instance of PClose as
    # processing function.
    notifier = Notifier(wm, PClose())

    print 'start monitoring %s with mask 0x%08x' % (path, mask)

    added_flag = False
    # read and process events
    while True:
        try:
            if not added_flag:
                # on first iteration, add a watch on path:
                # watch path for events handled by mask.
                wm.add_watch(path, mask)
                added_flag = True
            notifier.process_events()
            if notifier.check_events():
                notifier.read_events()
        except KeyboardInterrupt:
            # ...until c^c signal
            print 'stop monitoring...'
            # stop monitoring
            notifier.stop()
            break
        except Exception, err:
            # otherwise keep on watching
            print err

