cdef extern from "gsm.h":
    cdef struct gsm_state
    #ctypedef gsm_state *gsm
    ctypedef short gsm_signal
    ctypedef unsigned char gsm_byte
    ctypedef gsm_byte gsm_frame[33]
    gsm_state *gsm_create()
    void gsm_encode(gsm_state *handle, gsm_signal src[160], gsm_frame dst)
    int gsm_decode(gsm_state *handle, gsm_frame src, gsm_signal dst[160])
    void gsm_destroy(gsm_state *handle)

cdef extern from "stdlib.h":
    void *malloc(int size)
    void *realloc(void *ptr, int size)
    void free(void *ptr)

cdef extern from "string.h":
    cdef void *memset(void *s, int c, int n)
    cdef void *memcpy(void *dest, void *src, int n)

cdef extern from "Python.h":
    object PyString_FromStringAndSize(char *, int)


BIG = 0
LITTLE = 1

cdef class gsm:
    cdef gsm_state *_handle
    cdef int _endian

    def __init__(self, endian=LITTLE):
        self._handle = gsm_create()
        if type(endian) != int:
            raise TypeError, "invalid endianness"
        if endian not in (BIG, LITTLE):
            raise ValueError, "invalid endianness"
        self._endian = endian

    def decode(self, frame):
        cdef gsm_signal dst[160]
        cdef gsm_frame src
        cdef char result[320]
        cdef int first
        cdef int second

        if len(frame) != 33:
            raise ValueError("decode needs a string of 33 bytes")

        memcpy(src, <char *>frame, 33)

        if gsm_decode(self._handle, src, dst) < 0:
            raise ValueError, "frame decode failed" 
        for i in range(160):
            if self._endian == BIG:
                result[i * 2] = (dst[i] >> 8) & 0xff
                result[(i * 2)+1] = dst[i] & 0xff
            else:
                result[(i * 2)+1] = (dst[i] >> 8) & 0xff
                result[i * 2] = dst[i] & 0xff
        return PyString_FromStringAndSize(<char *>result, 320)

    def encode(self, pcm):
        cdef gsm_signal src[160]
        cdef gsm_frame dst
        cdef int first
        cdef int second
        cdef char ret[34]

        if len(pcm) != 320:
            raise ValueError("encode needs a string of 320 bytes")
        for i in range(160):
            if self._endian == BIG:
                first = ord(pcm[i*2])
                second = ord(pcm[(i*2)+1])
                src[i] = ((first & 0xff) << 8)|(second & 0xff)
            else:
                src[i] = ((second & 0xff) << 8)|(first & 0xff)
        gsm_encode(self._handle, src, dst)
        return PyString_FromStringAndSize(<char *>dst, 33)

    def close(self):
        gsm_destroy(self._handle)

    
