cdef extern from "g729a/typedef.h":
   ctypedef short Word16 

cdef extern from "g729a/ld8a.h":
    void Init_Pre_Process()
    void Init_Post_Process()
    void Init_Coder_ld8a()
    void Init_Decod_ld8a()
    void Pre_Process(Word16 signal[], Word16 lg)
    void Post_Process(Word16 signal[], Word16 lg)
    void Set_zero(Word16 x[], Word16 L)
    void Coder_ld8a(Word16 ana[])
    void Decod_ld8a(Word16 parm[], Word16 synth[], Word16 A_t[], Word16 *T2)
    void prm2bits_ld8k(Word16 prm[], Word16 bits[])
    void bits2prm_ld8k(Word16 bits[], Word16 prm[])

cdef extern from "stdlib.h":
    void *malloc(int size)
    void *realloc(void *ptr, int size)
    void free(void *ptr)

cdef extern from "string.h":
    cdef void *memset(void *s, int c, int n)
    cdef void *memcpy(void *dest, void *src, int n)




cdef enum:
    SERIAL_SIZE = 82
    PRM_SIZE = 11
    L_FRAME = 80
    WordSize = 2

cdef class encoder:
    cdef Word16 *prm
    cdef Word16 *serial
    cdef Word16 *_input
    cdef char *_output

    def __init__(self):
        self.prm = <Word16 *>malloc(PRM_SIZE * sizeof(Word16))
        self.serial = <Word16 *>malloc(SERIAL_SIZE * sizeof(Word16))
        self._input = <Word16 *>malloc(L_FRAME * sizeof(Word16))
        self._output = <char *>malloc(L_FRAME * sizeof(Word16))
        Init_Pre_Process()
        Init_Coder_ld8a()
        Set_zero(self.prm, <Word16>PRM_SIZE)

    def __dealloc__(self):
        free(self.prm)
        free(self.serial)

    def encode_frame(self, input):
        if len(input) != WordSize * L_FRAME:
            raise ValueError, "Must be a complete frame of %d bytes"%(
                                                        WordSize * L_FRAME)
        memcpy(self._input, <char *>input, WordSize * L_FRAME)
        Pre_Process(self._input, L_FRAME)
        Coder_ld8a(self.prm)
        prm2bits_ld8k(self.prm, self.serial)
        memcpy(<char *>self._output, self.prm, WordSize * L_FRAME)
        return self._output
