#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
These are very basic tests, beacue fribidi has its own tests. It may be
better to reuse fribidi own tests, but its not clear what is the value
of base_dir for those tests.
"""

# uncomment import syspath on Mac OS X to test uninstalled version
#import syspath
import unittest
import pyfribidi


class BasicTests(unittest.TestCase):

    def testDefaultDirection(self):
        """ use RTL default """
        self.assertEqual(pyfribidi.log2vis("hello - שלום"),
                         pyfribidi.log2vis("hello - שלום", 'RTL'))

    def testAsRTL(self):
        """ reorder line as RTL """
        self.assertEqual(pyfribidi.log2vis("hello - שלום", 'RTL'),
                         "םולש - hello")

    def testAsLTR(self):
        """ reorder line as LTR """
        self.assertEqual(pyfribidi.log2vis("hello - שלום", 'LTR'),
                         "hello - םולש")

    def testNaturalLTR(self):
        """ reorder LTR line by natural order """
        self.assertEqual(pyfribidi.log2vis("hello - שלום", 'ON'),
                         "hello - םולש")

    def testNaturalRTL(self):
        """ reorder RTL line by natural order """
        self.assertEqual(pyfribidi.log2vis("שלום - hello", 'ON'),
                         "hello - םולש")

    def testInvalidDirection(self):
        """ raise ValueError for invalid direction """
        self.assertRaises(ValueError, pyfribidi.log2vis, "שלום", 'foo')


if __name__ == '__main__':
    suite = unittest.defaultTestLoader.loadTestsFromName(__name__)
    unittest.TextTestRunner(verbosity=2).run(suite)
