# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.39
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
pyFltk, the Python bindings to the FLTK GUI toolkit.
This is an easy to use and light-weight GUI toolkit
offering basic capabilities for the creation of
graphical user interfaces.
"""

from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_fltk', [dirname(__file__)])
        except ImportError:
            import _fltk
            return _fltk
        if fp is not None:
            try:
                _mod = imp.load_module('_fltk', fp, pathname, description)
            finally:
                fp.close()
                return _mod
    _fltk = swig_import_helper()
    del swig_import_helper
else:
    import _fltk
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


def _swig_setattr_nondynamic_method(set):
    def set_attr(self,name,value):
        if (name == "thisown"): return self.this.own(value)
        if hasattr(self,name) or (name == "this"):
            set(self,name,value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


try:
    import weakref
    weakref_proxy = weakref.proxy
except:
    weakref_proxy = lambda x: x


class Fl_Label(object):
    """Proxy of C++ Fl_Label class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self, int arg0, int arg1, int arg2, int arg3, Fl_Align arg4)"""
        return _fltk.Fl_Label_draw(self, *args)

    def measure(self, *args):
        """measure(self, int arg0, int arg1)"""
        return _fltk.Fl_Label_measure(self, *args)

    def __init__(self, *args): 
        """__init__(self) -> Fl_Label"""
        this = _fltk.new_Fl_Label(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Label
    __del__ = lambda self : None;
Fl_Label_swigregister = _fltk.Fl_Label_swigregister
Fl_Label_swigregister(Fl_Label)

class Fl_Widget(object):
    """
    Fl_Widget is the base class for all widgets in FLTK. You can't create one of 
    these because the constructor is not public. However you can subclass it.

    All 'property' accessing methods, such as color(), parent(), or argument() 
    are implemented as trivial inline functions and thus are as fast and small 
    as accessing fields in a structure. Unless otherwise noted, the property 
    setting methods such as color(n) or label(s) are also trivial inline 
    functions, even if they change the widget's appearance. It is up to the user 
    code to call redraw() after these. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Widget"""
        if self.__class__ == Fl_Widget:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Widget(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Widget
    __del__ = lambda self : None;
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Widget_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Widget_handle(self, *args)

    def parent(self, *args):
        """
        parent(self) -> Fl_Group
        parent(self, Fl_Group p)
        """
        return _fltk.Fl_Widget_parent(self, *args)

    def type(self, *args):
        """
        type(self) -> uchar
        type(self, uchar t)
        """
        return _fltk.Fl_Widget_type(self, *args)

    def x(self, *args):
        """x(self) -> int"""
        return _fltk.Fl_Widget_x(self, *args)

    def y(self, *args):
        """y(self) -> int"""
        return _fltk.Fl_Widget_y(self, *args)

    def w(self, *args):
        """w(self) -> int"""
        return _fltk.Fl_Widget_w(self, *args)

    def h(self, *args):
        """h(self) -> int"""
        return _fltk.Fl_Widget_h(self, *args)

    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Widget_resize(self, *args)

    def damage_resize(self, *args):
        """damage_resize(self, int arg0, int arg1, int arg2, int arg3) -> int"""
        return _fltk.Fl_Widget_damage_resize(self, *args)

    def position(self, *args):
        """position(self, int X, int Y)"""
        return _fltk.Fl_Widget_position(self, *args)

    def size(self, *args):
        """size(self, int W, int H)"""
        return _fltk.Fl_Widget_size(self, *args)

    def align(self, *args):
        """
        align(self) -> Fl_Align
        align(self, uchar a)
        """
        return _fltk.Fl_Widget_align(self, *args)

    def box(self, *args):
        """
        box(self) -> Fl_Boxtype
        box(self, Fl_Boxtype a)
        """
        return _fltk.Fl_Widget_box(self, *args)

    def selection_color(self, *args):
        """
        selection_color(self) -> Fl_Color
        selection_color(self, unsigned int a)
        """
        return _fltk.Fl_Widget_selection_color(self, *args)

    def color(self, *args):
        """
        color(self) -> Fl_Color
        color(self, unsigned int a)
        color(self, unsigned int a, unsigned int b)
        """
        return _fltk.Fl_Widget_color(self, *args)

    def copy_label(self, *args):
        """copy_label(self, char a)"""
        return _fltk.Fl_Widget_copy_label(self, *args)

    def label(self, *args):
        """
        label(self) -> char
        label(self, char a)
        label(self, Fl_Labeltype a, char b)
        """
        val = _fltk.Fl_Widget_label(self, *args)
        if len(args) > 0:
            self.my_label = args[len(args)-1]


        return val

    def labeltype(self, *args):
        """
        labeltype(self) -> Fl_Labeltype
        labeltype(self, Fl_Labeltype a)
        """
        return _fltk.Fl_Widget_labeltype(self, *args)

    def labelcolor(self, *args):
        """
        labelcolor(self) -> Fl_Color
        labelcolor(self, unsigned int a)
        """
        return _fltk.Fl_Widget_labelcolor(self, *args)

    def labelfont(self, *args):
        """
        labelfont(self) -> Fl_Font
        labelfont(self, uchar a)
        """
        return _fltk.Fl_Widget_labelfont(self, *args)

    def labelsize(self, *args):
        """
        labelsize(self) -> uchar
        labelsize(self, uchar a)
        """
        return _fltk.Fl_Widget_labelsize(self, *args)

    def image(self, *args):
        """
        image(self) -> Fl_Image
        image(self, Fl_Image a)
        """
        val = _fltk.Fl_Widget_image(self, *args)
        if len(args) > 0:
            #delegate ownership to C++
            self.my_image = args[0]


        return val

    def deimage(self, *args):
        """
        deimage(self) -> Fl_Image
        deimage(self, Fl_Image a)
        """
        val = _fltk.Fl_Widget_deimage(self, *args)
        if len(args) > 0:
            #delegate ownership to C++
            self.my_deimage = args[0]


        return val

    def tooltip(self, *args):
        """
        tooltip(self) -> char
        tooltip(self, char t)
        """
        return _fltk.Fl_Widget_tooltip(self, *args)

    def argument(self, *args):
        """
        argument(self) -> long
        argument(self, long v)
        """
        return _fltk.Fl_Widget_argument(self, *args)

    def when(self, *args):
        """
        when(self) -> Fl_When
        when(self, uchar i)
        """
        return _fltk.Fl_Widget_when(self, *args)

    def visible(self, *args):
        """visible(self) -> int"""
        return _fltk.Fl_Widget_visible(self, *args)

    def visible_r(self, *args):
        """visible_r(self) -> int"""
        return _fltk.Fl_Widget_visible_r(self, *args)

    def show(self, *args):
        """show(self)"""
        return _fltk.Fl_Widget_show(self, *args)

    def hide(self, *args):
        """hide(self)"""
        return _fltk.Fl_Widget_hide(self, *args)

    def set_visible(self, *args):
        """set_visible(self)"""
        return _fltk.Fl_Widget_set_visible(self, *args)

    def clear_visible(self, *args):
        """clear_visible(self)"""
        return _fltk.Fl_Widget_clear_visible(self, *args)

    def active(self, *args):
        """active(self) -> int"""
        return _fltk.Fl_Widget_active(self, *args)

    def active_r(self, *args):
        """active_r(self) -> int"""
        return _fltk.Fl_Widget_active_r(self, *args)

    def activate(self, *args):
        """activate(self)"""
        return _fltk.Fl_Widget_activate(self, *args)

    def deactivate(self, *args):
        """deactivate(self)"""
        return _fltk.Fl_Widget_deactivate(self, *args)

    def output(self, *args):
        """output(self) -> int"""
        return _fltk.Fl_Widget_output(self, *args)

    def set_output(self, *args):
        """set_output(self)"""
        return _fltk.Fl_Widget_set_output(self, *args)

    def clear_output(self, *args):
        """clear_output(self)"""
        return _fltk.Fl_Widget_clear_output(self, *args)

    def takesevents(self, *args):
        """takesevents(self) -> int"""
        return _fltk.Fl_Widget_takesevents(self, *args)

    def changed(self, *args):
        """changed(self) -> int"""
        return _fltk.Fl_Widget_changed(self, *args)

    def set_changed(self, *args):
        """set_changed(self)"""
        return _fltk.Fl_Widget_set_changed(self, *args)

    def clear_changed(self, *args):
        """clear_changed(self)"""
        return _fltk.Fl_Widget_clear_changed(self, *args)

    def take_focus(self, *args):
        """take_focus(self) -> int"""
        return _fltk.Fl_Widget_take_focus(self, *args)

    def set_visible_focus(self, *args):
        """set_visible_focus(self)"""
        return _fltk.Fl_Widget_set_visible_focus(self, *args)

    def clear_visible_focus(self, *args):
        """clear_visible_focus(self)"""
        return _fltk.Fl_Widget_clear_visible_focus(self, *args)

    def visible_focus(self, *args):
        """
        visible_focus(self, int v)
        visible_focus(self) -> int
        """
        return _fltk.Fl_Widget_visible_focus(self, *args)

    def default_callback(*args):
        """default_callback(Fl_Widget arg0, void arg1)"""
        return _fltk.Fl_Widget_default_callback(*args)

    default_callback = staticmethod(default_callback)
    def do_callback(self, *args):
        """
        do_callback(self)
        do_callback(self, Fl_Widget o, void arg = None)
        do_callback(self, Fl_Widget o, long arg)
        """
        return _fltk.Fl_Widget_do_callback(self, *args)

    def label_shortcut(*args):
        """label_shortcut(char t) -> char"""
        return _fltk.Fl_Widget_label_shortcut(*args)

    label_shortcut = staticmethod(label_shortcut)
    def test_shortcut(*args):
        """
        test_shortcut() -> int
        test_shortcut(char arg0) -> int
        """
        return _fltk.Fl_Widget_test_shortcut(*args)

    test_shortcut = staticmethod(test_shortcut)
    def contains(self, *args):
        """contains(self, Fl_Widget arg0) -> int"""
        return _fltk.Fl_Widget_contains(self, *args)

    def inside(self, *args):
        """inside(self, Fl_Widget o) -> int"""
        return _fltk.Fl_Widget_inside(self, *args)

    def redraw(self, *args):
        """redraw(self)"""
        return _fltk.Fl_Widget_redraw(self, *args)

    def redraw_label(self, *args):
        """redraw_label(self)"""
        return _fltk.Fl_Widget_redraw_label(self, *args)

    def clear_damage(self, *args):
        """clear_damage(self, uchar c = 0)"""
        return _fltk.Fl_Widget_clear_damage(self, *args)

    def damage(self, *args):
        """
        damage(self) -> uchar
        damage(self, uchar c)
        damage(self, uchar c, int arg1, int arg2, int arg3, int arg4)
        """
        return _fltk.Fl_Widget_damage(self, *args)

    def draw_label(self, *args):
        """draw_label(self, int arg0, int arg1, int arg2, int arg3, Fl_Align arg4)"""
        return _fltk.Fl_Widget_draw_label(self, *args)

    def measure_label(self, *args):
        """measure_label(self, int xx, int yy)"""
        return _fltk.Fl_Widget_measure_label(self, *args)

    def window(self, *args):
        """window(self) -> Fl_Window"""
        return _fltk.Fl_Widget_window(self, *args)

    def color2(self, *args):
        """
        color2(self) -> Fl_Color
        color2(self, unsigned int a)
        """
        return _fltk.Fl_Widget_color2(self, *args)

    def callback(self, *args):
        """
        callback(self) -> Fl_Callback_p
        callback(self, Fl_Callback c, void p)
        callback(self, Fl_Callback c)
        callback(self, Fl_Callback0 c)
        callback(self, Fl_Callback1 c, long p = 0)
        callback(self, PyObject PyFunc, PyObject PyWidget, PyObject PyData = None)
        """
        return _fltk.Fl_Widget_callback(self, *args)

    def user_data(self, *args):
        """
        user_data(self)
        user_data(self, void v)
        user_data(self, PyObject PyData)
        user_data(self) -> PyObject
        """
        return _fltk.Fl_Widget_user_data(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Widget(self)
        return weakref_proxy(self)
Fl_Widget_swigregister = _fltk.Fl_Widget_swigregister
Fl_Widget_swigregister(Fl_Widget)

def Fl_Widget_default_callback(*args):
  """Fl_Widget_default_callback(Fl_Widget arg0, void arg1)"""
  return _fltk.Fl_Widget_default_callback(*args)

def Fl_Widget_label_shortcut(*args):
  """Fl_Widget_label_shortcut(char t) -> char"""
  return _fltk.Fl_Widget_label_shortcut(*args)

def Fl_Widget_test_shortcut(*args):
  """
    test_shortcut() -> int
    Fl_Widget_test_shortcut(char arg0) -> int
    """
  return _fltk.Fl_Widget_test_shortcut(*args)

FL_RESERVED_TYPE = _fltk.FL_RESERVED_TYPE
class Fl_Group(Fl_Widget):
    """
    The Fl_Group class is the FLTK container widget. It maintains an array of 
    child widgets. These children can themselves be any widget including Fl_Group. 
    The most important subclass of Fl_Group  is Fl_Window, however groups can 
    also be used to control radio buttons or to enforce resize behavior.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Group_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Group_handle(self, *args)

    def begin(self, *args):
        """begin(self)"""
        return _fltk.Fl_Group_begin(self, *args)

    def end(self, *args):
        """end(self)"""
        return _fltk.Fl_Group_end(self, *args)

    def current(*args):
        """
        current() -> Fl_Group
        current(Fl_Group g)
        """
        return _fltk.Fl_Group_current(*args)

    current = staticmethod(current)
    def children(self, *args):
        """children(self) -> int"""
        return _fltk.Fl_Group_children(self, *args)

    def child(self, *args):
        """child(self, int n) -> Fl_Widget"""
        return _fltk.Fl_Group_child(self, *args)

    def find(self, *args):
        """find(self, Fl_Widget o) -> int"""
        return _fltk.Fl_Group_find(self, *args)

    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Group_resize(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Group"""
        if self.__class__ == Fl_Group:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Group(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Group
    __del__ = lambda self : None;
    def add(self, *args):
        """add(self, Fl_Widget o)"""
        val = _fltk.Fl_Group_add(self, *args)
        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val

    def insert(self, *args):
        """insert(self, Fl_Widget arg0, int i)"""
        return _fltk.Fl_Group_insert(self, *args)

    def insert_before(self, *args):
        """insert_before(self, Fl_Widget o, Fl_Widget before)"""
        return _fltk.Fl_Group_insert_before(self, *args)

    def remove(self, *args):
        """remove(self, Fl_Widget o)"""
        val = _fltk.Fl_Group_remove(self, *args)
        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val

    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_Group_clear(self, *args)

    def resizable(self, *args):
        """
        resizable(self, Fl_Widget o)
        resizable(self) -> Fl_Widget
        """
        return _fltk.Fl_Group_resizable(self, *args)

    def add_resizable(self, *args):
        """add_resizable(self, Fl_Widget o)"""
        return _fltk.Fl_Group_add_resizable(self, *args)

    def init_sizes(self, *args):
        """init_sizes(self)"""
        return _fltk.Fl_Group_init_sizes(self, *args)

    def focus(self, *args):
        """focus(self, Fl_Widget o)"""
        return _fltk.Fl_Group_focus(self, *args)

    def _ddfdesign_kludge(self, *args):
        """_ddfdesign_kludge(self) -> Fl_Widget"""
        return _fltk.Fl_Group__ddfdesign_kludge(self, *args)

    def forms_end(self, *args):
        """forms_end(self)"""
        return _fltk.Fl_Group_forms_end(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Group(self)
        return weakref_proxy(self)
Fl_Group_swigregister = _fltk.Fl_Group_swigregister
Fl_Group_swigregister(Fl_Group)

def Fl_Group_current(*args):
  """
    current() -> Fl_Group
    Fl_Group_current(Fl_Group g)
    """
  return _fltk.Fl_Group_current(*args)

class Fl_End(object):
    """Proxy of C++ Fl_End class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> Fl_End"""
        this = _fltk.new_Fl_End(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_End
    __del__ = lambda self : None;
Fl_End_swigregister = _fltk.Fl_End_swigregister
Fl_End_swigregister(Fl_End)

FL_NORMAL_BROWSER = _fltk.FL_NORMAL_BROWSER
FL_SELECT_BROWSER = _fltk.FL_SELECT_BROWSER
FL_HOLD_BROWSER = _fltk.FL_HOLD_BROWSER
FL_MULTI_BROWSER = _fltk.FL_MULTI_BROWSER
class Fl_Browser_(Fl_Group):
    """
    This is the base class for browsers. To be useful it must be subclassed 
    and several virtual functions defined. The Forms-compatible browser and 
    the file chooser's browser are subclassed off of this.

    This has been designed so that the subclass has complete control over 
    the storage of the data, although because next() and prev() functions 
    are used to index, it works best as a linked list or as a large block 
    of characters in which the line breaks must be searched for.

    A great deal of work has been done so that the 'height' of a data object 
    does not need to be determined until it is drawn. This is useful if 
    actually figuring out the size of an object requires accessing image 
    data or doing stat() on a file or doing some other slow operation. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def item_first(self, *args):
        """item_first(self) -> void"""
        return _fltk.Fl_Browser__item_first(self, *args)

    def item_next(self, *args):
        """item_next(self, void arg0) -> void"""
        return _fltk.Fl_Browser__item_next(self, *args)

    def item_prev(self, *args):
        """item_prev(self, void arg0) -> void"""
        return _fltk.Fl_Browser__item_prev(self, *args)

    def item_height(self, *args):
        """item_height(self, void arg0) -> int"""
        return _fltk.Fl_Browser__item_height(self, *args)

    def item_width(self, *args):
        """item_width(self, void arg0) -> int"""
        return _fltk.Fl_Browser__item_width(self, *args)

    def item_quick_height(self, *args):
        """item_quick_height(self, void arg0) -> int"""
        return _fltk.Fl_Browser__item_quick_height(self, *args)

    def item_draw(self, *args):
        """item_draw(self, void arg0, int arg1, int arg2, int arg3, int arg4)"""
        return _fltk.Fl_Browser__item_draw(self, *args)

    def full_width(self, *args):
        """full_width(self) -> int"""
        return _fltk.Fl_Browser__full_width(self, *args)

    def full_height(self, *args):
        """full_height(self) -> int"""
        return _fltk.Fl_Browser__full_height(self, *args)

    def incr_height(self, *args):
        """incr_height(self) -> int"""
        return _fltk.Fl_Browser__incr_height(self, *args)

    def item_select(self, *args):
        """item_select(self, void arg0, int arg1 = 1)"""
        return _fltk.Fl_Browser__item_select(self, *args)

    def item_selected(self, *args):
        """item_selected(self, void arg0) -> int"""
        return _fltk.Fl_Browser__item_selected(self, *args)

    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Browser__draw(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Browser_"""
        if self.__class__ == Fl_Browser_:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Browser_(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Browser__handle(self, *args)

    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Browser__resize(self, *args)

    def select(self, *args):
        """select(self, void arg0, int arg1 = 1, int docallbacks = 0) -> int"""
        return _fltk.Fl_Browser__select(self, *args)

    def select_only(self, *args):
        """select_only(self, void arg0, int docallbacks = 0) -> int"""
        return _fltk.Fl_Browser__select_only(self, *args)

    def deselect(self, *args):
        """deselect(self, int docallbacks = 0) -> int"""
        return _fltk.Fl_Browser__deselect(self, *args)

    def position(self, *args):
        """
        position(self) -> int
        position(self, int arg0)
        """
        return _fltk.Fl_Browser__position(self, *args)

    def hposition(self, *args):
        """
        hposition(self) -> int
        hposition(self, int arg0)
        """
        return _fltk.Fl_Browser__hposition(self, *args)

    def display(self, *args):
        """display(self, void arg0)"""
        return _fltk.Fl_Browser__display(self, *args)

    def has_scrollbar(self, *args):
        """
        has_scrollbar(self) -> uchar
        has_scrollbar(self, uchar i)
        """
        return _fltk.Fl_Browser__has_scrollbar(self, *args)

    HORIZONTAL = _fltk.Fl_Browser__HORIZONTAL
    VERTICAL = _fltk.Fl_Browser__VERTICAL
    BOTH = _fltk.Fl_Browser__BOTH
    ALWAYS_ON = _fltk.Fl_Browser__ALWAYS_ON
    HORIZONTAL_ALWAYS = _fltk.Fl_Browser__HORIZONTAL_ALWAYS
    VERTICAL_ALWAYS = _fltk.Fl_Browser__VERTICAL_ALWAYS
    BOTH_ALWAYS = _fltk.Fl_Browser__BOTH_ALWAYS
    def textfont(self, *args):
        """
        textfont(self) -> Fl_Font
        textfont(self, uchar s)
        """
        return _fltk.Fl_Browser__textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_Browser__textsize(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, unsigned int n)
        """
        return _fltk.Fl_Browser__textcolor(self, *args)

    def scrollbar_width(*args):
        """
        scrollbar_width(int b)
        scrollbar_width() -> int
        """
        return _fltk.Fl_Browser__scrollbar_width(*args)

    scrollbar_width = staticmethod(scrollbar_width)
    def scrollbar_right(self, *args):
        """scrollbar_right(self)"""
        return _fltk.Fl_Browser__scrollbar_right(self, *args)

    def scrollbar_left(self, *args):
        """scrollbar_left(self)"""
        return _fltk.Fl_Browser__scrollbar_left(self, *args)

    def getScrollbar(self, *args):
        """getScrollbar(self) -> Fl_Scrollbar"""
        return _fltk.Fl_Browser__getScrollbar(self, *args)

    def getHScrollbar(self, *args):
        """getHScrollbar(self) -> Fl_Scrollbar"""
        return _fltk.Fl_Browser__getHScrollbar(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Browser_
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Browser_(self)
        return weakref_proxy(self)
Fl_Browser__swigregister = _fltk.Fl_Browser__swigregister
Fl_Browser__swigregister(Fl_Browser_)

def Fl_Browser__scrollbar_width(*args):
  """
    scrollbar_width(int b)
    Fl_Browser__scrollbar_width() -> int
    """
  return _fltk.Fl_Browser__scrollbar_width(*args)

class Fl_Browser(Fl_Browser_):
    """
    The Fl_Browser widget displays a scrolling list of text lines, and manages 
    all the storage for the text. This is not a text editor or spreadsheet! But 
    it is useful for showing a vertical list of named objects to the user.

    Each line in the browser is identified by number. The numbers start at one 
    (this is so that zero can be reserved for 'no line' in the selective browsers).
    Unless otherwise noted, the methods do not check to see if the passed line 
    number is in range and legal. It must always be greater than zero 
    and <= size().

    Each line contains a null-terminated string of text and a data pointer. 
    The text string is displayed, the  pointer can be used by the callbacks 
    to reference the object the text describes.

    The base class does nothing when the user clicks on it. The subclasses 
    Fl_Select_Browser, Fl_Hold_Browser, and Fl_Multi_Browser react to user 
    clicks to select lines in the browser and do callbacks.

    The base class called Fl_Browser_ provides the scrolling and selection 
    mechanisms of this and all the subclasses, but the dimensions and appearance 
    of each item are determined by the subclass. You can use Fl_Browser_ to 
    display information other than text, or text that is dynamically produced 
    from your own data structures. If you find that loading the browser is a 
    lot of work or is inefficient, you may want to make a subclass of Fl_Browser_. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def item_first(self, *args):
        """item_first(self) -> void"""
        return _fltk.Fl_Browser_item_first(self, *args)

    def item_next(self, *args):
        """item_next(self, void arg0) -> void"""
        return _fltk.Fl_Browser_item_next(self, *args)

    def item_prev(self, *args):
        """item_prev(self, void arg0) -> void"""
        return _fltk.Fl_Browser_item_prev(self, *args)

    def item_selected(self, *args):
        """item_selected(self, void arg0) -> int"""
        return _fltk.Fl_Browser_item_selected(self, *args)

    def item_select(self, *args):
        """item_select(self, void arg0, int arg1)"""
        return _fltk.Fl_Browser_item_select(self, *args)

    def item_height(self, *args):
        """item_height(self, void arg0) -> int"""
        return _fltk.Fl_Browser_item_height(self, *args)

    def item_width(self, *args):
        """item_width(self, void arg0) -> int"""
        return _fltk.Fl_Browser_item_width(self, *args)

    def item_draw(self, *args):
        """item_draw(self, void arg0, int arg1, int arg2, int arg3, int arg4)"""
        return _fltk.Fl_Browser_item_draw(self, *args)

    def full_height(self, *args):
        """full_height(self) -> int"""
        return _fltk.Fl_Browser_full_height(self, *args)

    def incr_height(self, *args):
        """incr_height(self) -> int"""
        return _fltk.Fl_Browser_incr_height(self, *args)

    def remove(self, *args):
        """remove(self, int arg0)"""
        val = _fltk.Fl_Browser_remove(self, *args)
        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val

    def move(self, *args):
        """move(self, int to, int _from)"""
        return _fltk.Fl_Browser_move(self, *args)

    def load(self, *args):
        """load(self, char filename) -> int"""
        return _fltk.Fl_Browser_load(self, *args)

    def swap(self, *args):
        """swap(self, int a, int b)"""
        return _fltk.Fl_Browser_swap(self, *args)

    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_Browser_clear(self, *args)

    def size(self, *args):
        """
        size(self) -> int
        size(self, int W, int H)
        """
        return _fltk.Fl_Browser_size(self, *args)

    TOP = _fltk.Fl_Browser_TOP
    BOTTOM = _fltk.Fl_Browser_BOTTOM
    MIDDLE = _fltk.Fl_Browser_MIDDLE
    def lineposition(self, *args):
        """lineposition(self, int arg0, Fl_Line_Position arg1)"""
        return _fltk.Fl_Browser_lineposition(self, *args)

    def topline(self, *args):
        """
        topline(self) -> int
        topline(self, int l)
        """
        return _fltk.Fl_Browser_topline(self, *args)

    def bottomline(self, *args):
        """bottomline(self, int l)"""
        return _fltk.Fl_Browser_bottomline(self, *args)

    def middleline(self, *args):
        """middleline(self, int l)"""
        return _fltk.Fl_Browser_middleline(self, *args)

    def select(self, *args):
        """select(self, int arg0, int arg1 = 1) -> int"""
        return _fltk.Fl_Browser_select(self, *args)

    def selected(self, *args):
        """selected(self, int arg0) -> int"""
        return _fltk.Fl_Browser_selected(self, *args)

    def show(self, *args):
        """
        show(self, int n)
        show(self)
        """
        return _fltk.Fl_Browser_show(self, *args)

    def hide(self, *args):
        """
        hide(self, int n)
        hide(self)
        """
        return _fltk.Fl_Browser_hide(self, *args)

    def visible(self, *args):
        """visible(self, int n) -> int"""
        return _fltk.Fl_Browser_visible(self, *args)

    def value(self, *args):
        """
        value(self) -> int
        value(self, int v)
        """
        return _fltk.Fl_Browser_value(self, *args)

    def text(self, *args):
        """
        text(self, int arg0) -> char
        text(self, int arg0, char arg1)
        """
        return _fltk.Fl_Browser_text(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Browser"""
        if self.__class__ == Fl_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Browser(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Browser
    __del__ = lambda self : None;
    def format_char(self, *args):
        """
        format_char(self) -> char
        format_char(self, char c)
        """
        return _fltk.Fl_Browser_format_char(self, *args)

    def column_char(self, *args):
        """
        column_char(self) -> char
        column_char(self, char c)
        """
        return _fltk.Fl_Browser_column_char(self, *args)

    def displayed(self, *args):
        """displayed(self, int n) -> int"""
        return _fltk.Fl_Browser_displayed(self, *args)

    def make_visible(self, *args):
        """make_visible(self, int n)"""
        return _fltk.Fl_Browser_make_visible(self, *args)

    def replace(self, *args):
        """replace(self, int a, char b)"""
        return _fltk.Fl_Browser_replace(self, *args)

    def display(self, *args):
        """display(self, int arg0, int arg1 = 1)"""
        return _fltk.Fl_Browser_display(self, *args)

    def add(self, *args):
        """add(self, char text, PyObject data = None)"""
        val = _fltk.Fl_Browser_add(self, *args)
        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val

    def insert(self, *args):
        """insert(self, int index, char text, PyObject data = None)"""
        return _fltk.Fl_Browser_insert(self, *args)

    def get_data(self, *args):
        """get_data(self, int index) -> PyObject"""
        return _fltk.Fl_Browser_get_data(self, *args)

    def data(self, *args):
        """data(self, int index, PyObject data = None) -> PyObject"""
        return _fltk.Fl_Browser_data(self, *args)

    def column_widths(self, *args):
        """
        column_widths(self) -> int
        column_widths(self, PyObject widths)
        """
        return _fltk.Fl_Browser_column_widths(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Browser(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Browser_draw(self, *args)

    def item_quick_height(self, *args):
        """item_quick_height(self, void arg0) -> int"""
        return _fltk.Fl_Browser_item_quick_height(self, *args)

    def full_width(self, *args):
        """full_width(self) -> int"""
        return _fltk.Fl_Browser_full_width(self, *args)

Fl_Browser_swigregister = _fltk.Fl_Browser_swigregister
Fl_Browser_swigregister(Fl_Browser)

class Fl_File_Browser(Fl_Browser):
    """
    The Fl_File_Browser widget displays a list of filenames, optionally with 
    file-specific icons.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    FILES = _fltk.Fl_File_Browser_FILES
    DIRECTORIES = _fltk.Fl_File_Browser_DIRECTORIES
    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_File_Browser"""
        if self.__class__ == Fl_File_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_File_Browser(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def iconsize(self, *args):
        """
        iconsize(self) -> uchar
        iconsize(self, uchar s)
        """
        return _fltk.Fl_File_Browser_iconsize(self, *args)

    def filter(self, *args):
        """
        filter(self, char pattern)
        filter(self) -> char
        """
        return _fltk.Fl_File_Browser_filter(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_File_Browser_textsize(self, *args)

    def filetype(self, *args):
        """
        filetype(self) -> int
        filetype(self, int t)
        """
        return _fltk.Fl_File_Browser_filetype(self, *args)

    def load(self, *args):
        """load(self, PyObject dObj, PyObject sObj) -> int"""
        return _fltk.Fl_File_Browser_load(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_File_Browser
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_File_Browser(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_File_Browser_draw(self, *args)

    def item_first(self, *args):
        """item_first(self) -> void"""
        return _fltk.Fl_File_Browser_item_first(self, *args)

    def item_next(self, *args):
        """item_next(self, void arg0) -> void"""
        return _fltk.Fl_File_Browser_item_next(self, *args)

    def item_prev(self, *args):
        """item_prev(self, void arg0) -> void"""
        return _fltk.Fl_File_Browser_item_prev(self, *args)

    def item_height(self, *args):
        """item_height(self, void arg0) -> int"""
        return _fltk.Fl_File_Browser_item_height(self, *args)

    def item_width(self, *args):
        """item_width(self, void arg0) -> int"""
        return _fltk.Fl_File_Browser_item_width(self, *args)

    def item_quick_height(self, *args):
        """item_quick_height(self, void arg0) -> int"""
        return _fltk.Fl_File_Browser_item_quick_height(self, *args)

    def item_draw(self, *args):
        """item_draw(self, void arg0, int arg1, int arg2, int arg3, int arg4)"""
        return _fltk.Fl_File_Browser_item_draw(self, *args)

    def full_width(self, *args):
        """full_width(self) -> int"""
        return _fltk.Fl_File_Browser_full_width(self, *args)

    def full_height(self, *args):
        """full_height(self) -> int"""
        return _fltk.Fl_File_Browser_full_height(self, *args)

    def incr_height(self, *args):
        """incr_height(self) -> int"""
        return _fltk.Fl_File_Browser_incr_height(self, *args)

    def item_select(self, *args):
        """item_select(self, void arg0, int arg1)"""
        return _fltk.Fl_File_Browser_item_select(self, *args)

    def item_selected(self, *args):
        """item_selected(self, void arg0) -> int"""
        return _fltk.Fl_File_Browser_item_selected(self, *args)

Fl_File_Browser_swigregister = _fltk.Fl_File_Browser_swigregister
Fl_File_Browser_swigregister(Fl_File_Browser)

FL_ALPHASORT = _fltk.FL_ALPHASORT
FL_CASEALPHASORT = _fltk.FL_CASEALPHASORT
FL_CASENUMERICSORT = _fltk.FL_CASENUMERICSORT
FL_NUMERICSORT = _fltk.FL_NUMERICSORT
class Fl_File_Icon(object):
    """
    The Fl_File_Icon class manages icon images that can be used as labels in 
    other widgets and as icons in the FileBrowser widget.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    ANY = _fltk.Fl_File_Icon_ANY
    PLAIN = _fltk.Fl_File_Icon_PLAIN
    FIFO = _fltk.Fl_File_Icon_FIFO
    DEVICE = _fltk.Fl_File_Icon_DEVICE
    LINK = _fltk.Fl_File_Icon_LINK
    DIRECTORY = _fltk.Fl_File_Icon_DIRECTORY
    END = _fltk.Fl_File_Icon_END
    COLOR = _fltk.Fl_File_Icon_COLOR
    LINE = _fltk.Fl_File_Icon_LINE
    CLOSEDLINE = _fltk.Fl_File_Icon_CLOSEDLINE
    POLYGON = _fltk.Fl_File_Icon_POLYGON
    OUTLINEPOLYGON = _fltk.Fl_File_Icon_OUTLINEPOLYGON
    VERTEX = _fltk.Fl_File_Icon_VERTEX
    def __init__(self, *args): 
        """__init__(self, char p, int t, int nd = 0, short d = None) -> Fl_File_Icon"""
        this = _fltk.new_Fl_File_Icon(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_File_Icon
    __del__ = lambda self : None;
    def add(self, *args):
        """add(self, short d) -> short"""
        return _fltk.Fl_File_Icon_add(self, *args)

    def add_color(self, *args):
        """add_color(self, Fl_Color c) -> short"""
        return _fltk.Fl_File_Icon_add_color(self, *args)

    def add_vertex(self, *args):
        """
        add_vertex(self, int x, int y) -> short
        add_vertex(self, float x, float y) -> short
        """
        return _fltk.Fl_File_Icon_add_vertex(self, *args)

    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_File_Icon_clear(self, *args)

    def draw(self, *args):
        """draw(self, int x, int y, int w, int h, Fl_Color ic, int active = 1)"""
        return _fltk.Fl_File_Icon_draw(self, *args)

    def label(self, *args):
        """label(self, Fl_Widget w)"""
        return _fltk.Fl_File_Icon_label(self, *args)

    def labeltype(*args):
        """labeltype(Fl_Label o, int x, int y, int w, int h, Fl_Align a)"""
        return _fltk.Fl_File_Icon_labeltype(*args)

    labeltype = staticmethod(labeltype)
    def load(self, *args):
        """load(self, char f)"""
        return _fltk.Fl_File_Icon_load(self, *args)

    def load_fti(self, *args):
        """load_fti(self, char fti) -> int"""
        return _fltk.Fl_File_Icon_load_fti(self, *args)

    def load_image(self, *args):
        """load_image(self, char i) -> int"""
        return _fltk.Fl_File_Icon_load_image(self, *args)

    def next(self, *args):
        """next(self) -> Fl_File_Icon"""
        return _fltk.Fl_File_Icon_next(self, *args)

    def pattern(self, *args):
        """pattern(self) -> char"""
        return _fltk.Fl_File_Icon_pattern(self, *args)

    def size(self, *args):
        """size(self) -> int"""
        return _fltk.Fl_File_Icon_size(self, *args)

    def type(self, *args):
        """type(self) -> int"""
        return _fltk.Fl_File_Icon_type(self, *args)

    def value(self, *args):
        """value(self) -> short"""
        return _fltk.Fl_File_Icon_value(self, *args)

    def find(*args):
        """find(char filename, int filetype = ANY) -> Fl_File_Icon"""
        return _fltk.Fl_File_Icon_find(*args)

    find = staticmethod(find)
    def first(*args):
        """first() -> Fl_File_Icon"""
        return _fltk.Fl_File_Icon_first(*args)

    first = staticmethod(first)
    def load_system_icons(*args):
        """load_system_icons()"""
        return _fltk.Fl_File_Icon_load_system_icons(*args)

    load_system_icons = staticmethod(load_system_icons)
Fl_File_Icon_swigregister = _fltk.Fl_File_Icon_swigregister
Fl_File_Icon_swigregister(Fl_File_Icon)

def Fl_File_Icon_labeltype(*args):
  """Fl_File_Icon_labeltype(Fl_Label o, int x, int y, int w, int h, Fl_Align a)"""
  return _fltk.Fl_File_Icon_labeltype(*args)

def Fl_File_Icon_find(*args):
  """Fl_File_Icon_find(char filename, int filetype = ANY) -> Fl_File_Icon"""
  return _fltk.Fl_File_Icon_find(*args)

def Fl_File_Icon_first(*args):
  """Fl_File_Icon_first() -> Fl_File_Icon"""
  return _fltk.Fl_File_Icon_first(*args)

def Fl_File_Icon_load_system_icons(*args):
  """Fl_File_Icon_load_system_icons()"""
  return _fltk.Fl_File_Icon_load_system_icons(*args)

class Fl_File_Chooser(object):
    """
    The Fl_File_Chooser widget displays a standard file selection dialog that 
    supports various selection modes.

    The Fl_File_Chooser class also exports several static values that may be used 
    to localize or customize the appearance of all file chooser dialogs:
    Member 	Default value
    add_favorites_label 	'Add to Favorites'
    all_files_label 	'All Files (*)'
    custom_filter_label 	'Custom Filter'
    existing_file_label 	'Please choose an existing file!'
    favorites_label 	'Favorites'
    filename_label 		'Filename:'
    filesystems_label 	'My Computer' (WIN32)
    			'File Systems' (all others)
    manage_favorites_label 	'Manage Favorites'
    new_directory_label 	'New Directory?'
    new_directory_tooltip 	'Create a new directory.'
    preview_label 		'Preview'
    save_label 		'Save'
    show_label 		'Show:'
    sort 			fl_numericsort

    The sort member specifies the sort function that is used when loading the 
    contents of a directory. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    SINGLE = _fltk.Fl_File_Chooser_SINGLE
    MULTI = _fltk.Fl_File_Chooser_MULTI
    CREATE = _fltk.Fl_File_Chooser_CREATE
    DIRECTORY = _fltk.Fl_File_Chooser_DIRECTORY
    def __init__(self, *args): 
        """__init__(self, char d, char p, int t, char title) -> Fl_File_Chooser"""
        this = _fltk.new_Fl_File_Chooser(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_File_Chooser
    __del__ = lambda self : None;
    def color(self, *args):
        """
        color(self, Fl_Color c)
        color(self) -> Fl_Color
        """
        return _fltk.Fl_File_Chooser_color(self, *args)

    def count(self, *args):
        """count(self) -> int"""
        return _fltk.Fl_File_Chooser_count(self, *args)

    def directory(self, *args):
        """
        directory(self, char d)
        directory(self) -> char
        """
        return _fltk.Fl_File_Chooser_directory(self, *args)

    def filter(self, *args):
        """
        filter(self, char p)
        filter(self) -> char
        """
        return _fltk.Fl_File_Chooser_filter(self, *args)

    def filter_value(self, *args):
        """
        filter_value(self) -> int
        filter_value(self, int f)
        """
        return _fltk.Fl_File_Chooser_filter_value(self, *args)

    def hide(self, *args):
        """hide(self)"""
        return _fltk.Fl_File_Chooser_hide(self, *args)

    def iconsize(self, *args):
        """
        iconsize(self, uchar s)
        iconsize(self) -> uchar
        """
        return _fltk.Fl_File_Chooser_iconsize(self, *args)

    def label(self, *args):
        """
        label(self, char l)
        label(self) -> char
        """
        return _fltk.Fl_File_Chooser_label(self, *args)

    def ok_label(self, *args):
        """
        ok_label(self, char l)
        ok_label(self) -> char
        """
        return _fltk.Fl_File_Chooser_ok_label(self, *args)

    def preview(self, *args):
        """
        preview(self, int e)
        preview(self) -> int
        """
        return _fltk.Fl_File_Chooser_preview(self, *args)

    def rescan(self, *args):
        """rescan(self)"""
        return _fltk.Fl_File_Chooser_rescan(self, *args)

    def show(self, *args):
        """show(self)"""
        return _fltk.Fl_File_Chooser_show(self, *args)

    def shown(self, *args):
        """shown(self) -> int"""
        return _fltk.Fl_File_Chooser_shown(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self, Fl_Color c)
        textcolor(self) -> Fl_Color
        """
        return _fltk.Fl_File_Chooser_textcolor(self, *args)

    def textfont(self, *args):
        """
        textfont(self, uchar f)
        textfont(self) -> uchar
        """
        return _fltk.Fl_File_Chooser_textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self, uchar s)
        textsize(self) -> uchar
        """
        return _fltk.Fl_File_Chooser_textsize(self, *args)

    def type(self, *args):
        """
        type(self, int t)
        type(self) -> int
        """
        return _fltk.Fl_File_Chooser_type(self, *args)

    def user_data(self, *args):
        """
        user_data(self)
        user_data(self, void d)
        """
        return _fltk.Fl_File_Chooser_user_data(self, *args)

    def value(self, *args):
        """
        value(self, int f = 1) -> char
        value(self, char filename)
        """
        return _fltk.Fl_File_Chooser_value(self, *args)

    def visible(self, *args):
        """visible(self) -> int"""
        return _fltk.Fl_File_Chooser_visible(self, *args)

    def callback(self, *args):
        """
        callback(self, void cb, void d = None)
        callback(self, PyObject PyFunc, PyObject PyWidget, PyObject PyData = None)
        """
        return _fltk.Fl_File_Chooser_callback(self, *args)

Fl_File_Chooser_swigregister = _fltk.Fl_File_Chooser_swigregister
Fl_File_Chooser_swigregister(Fl_File_Chooser)


def fl_dir_chooser(*args):
  """fl_dir_chooser(char message, char fname, int relative = 0) -> char"""
  return _fltk.fl_dir_chooser(*args)

def fl_file_chooser(*args):
  """fl_file_chooser(char message, char pat, char fname, int relative = 0) -> char"""
  return _fltk.fl_file_chooser(*args)

def fl_file_chooser_callback(*args):
  """fl_file_chooser_callback(void cb)"""
  return _fltk.fl_file_chooser_callback(*args)

def fl_file_chooser_ok_label(*args):
  """fl_file_chooser_ok_label(char l)"""
  return _fltk.fl_file_chooser_ok_label(*args)
class Fl(object):
    """
    The Fl class is the FLTK global (static) class containing state 
    information and global methods for the current application.
    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def add_awake_handler_(*args):
        """add_awake_handler_(Fl_Awake_Handler arg0, void arg1) -> int"""
        return _fltk.Fl_add_awake_handler_(*args)

    add_awake_handler_ = staticmethod(add_awake_handler_)
    def get_awake_handler_(*args):
        """get_awake_handler_(Fl_Awake_Handler arg0, void arg1) -> int"""
        return _fltk.Fl_get_awake_handler_(*args)

    get_awake_handler_ = staticmethod(get_awake_handler_)
    def version(*args):
        """version() -> double"""
        return _fltk.Fl_version(*args)

    version = staticmethod(version)
    def arg(*args):
        """arg(int arg0, char arg1, int arg2) -> int"""
        return _fltk.Fl_arg(*args)

    arg = staticmethod(arg)
    def args(*args):
        """
        args(int arg0, char arg1, int arg2, int arg3 = None) -> int
        args(int arg0, char arg1)
        """
        return _fltk.Fl_args(*args)

    args = staticmethod(args)
    def display(*args):
        """display(char arg0)"""
        return _fltk.Fl_display(*args)

    display = staticmethod(display)
    def visual(*args):
        """visual(int arg0) -> int"""
        return _fltk.Fl_visual(*args)

    visual = staticmethod(visual)
    def own_colormap(*args):
        """own_colormap()"""
        return _fltk.Fl_own_colormap(*args)

    own_colormap = staticmethod(own_colormap)
    def get_system_colors(*args):
        """get_system_colors()"""
        return _fltk.Fl_get_system_colors(*args)

    get_system_colors = staticmethod(get_system_colors)
    def foreground(*args):
        """foreground(uchar arg0, uchar arg1, uchar arg2)"""
        return _fltk.Fl_foreground(*args)

    foreground = staticmethod(foreground)
    def background(*args):
        """background(uchar arg0, uchar arg1, uchar arg2)"""
        return _fltk.Fl_background(*args)

    background = staticmethod(background)
    def background2(*args):
        """background2(uchar arg0, uchar arg1, uchar arg2)"""
        return _fltk.Fl_background2(*args)

    background2 = staticmethod(background2)
    def scheme(*args):
        """
        scheme(char arg0) -> int
        scheme() -> char
        """
        return _fltk.Fl_scheme(*args)

    scheme = staticmethod(scheme)
    def reload_scheme(*args):
        """reload_scheme() -> int"""
        return _fltk.Fl_reload_scheme(*args)

    reload_scheme = staticmethod(reload_scheme)
    def scrollbar_size(*args):
        """
        scrollbar_size() -> int
        scrollbar_size(int W)
        """
        return _fltk.Fl_scrollbar_size(*args)

    scrollbar_size = staticmethod(scrollbar_size)
    def wait(*args):
        """
        wait() -> int
        wait(double time) -> double
        """
        return _fltk.Fl_wait(*args)

    wait = staticmethod(wait)
    def check(*args):
        """check() -> int"""
        return _fltk.Fl_check(*args)

    check = staticmethod(check)
    def ready(*args):
        """ready() -> int"""
        return _fltk.Fl_ready(*args)

    ready = staticmethod(ready)
    def run(*args):
        """run() -> int"""
        return _fltk.Fl_run(*args)

    run = staticmethod(run)
    def readqueue(*args):
        """readqueue() -> Fl_Widget"""
        return _fltk.Fl_readqueue(*args)

    readqueue = staticmethod(readqueue)
    def has_timeout(*args):
        """has_timeout(Fl_Timeout_Handler arg0, void arg1 = None) -> int"""
        return _fltk.Fl_has_timeout(*args)

    has_timeout = staticmethod(has_timeout)
    def has_idle(*args):
        """has_idle(void cb, void arg1 = None) -> int"""
        return _fltk.Fl_has_idle(*args)

    has_idle = staticmethod(has_idle)
    def damage(*args):
        """
        damage(int d)
        damage() -> int
        """
        return _fltk.Fl_damage(*args)

    damage = staticmethod(damage)
    def redraw(*args):
        """redraw()"""
        return _fltk.Fl_redraw(*args)

    redraw = staticmethod(redraw)
    def flush(*args):
        """flush()"""
        return _fltk.Fl_flush(*args)

    flush = staticmethod(flush)
    def first_window(*args):
        """
        first_window() -> Fl_Window
        first_window(Fl_Window arg0)
        """
        return _fltk.Fl_first_window(*args)

    first_window = staticmethod(first_window)
    def next_window(*args):
        """next_window(Fl_Window arg0) -> Fl_Window"""
        return _fltk.Fl_next_window(*args)

    next_window = staticmethod(next_window)
    def modal(*args):
        """modal() -> Fl_Window"""
        return _fltk.Fl_modal(*args)

    modal = staticmethod(modal)
    def grab(*args):
        """
        grab() -> Fl_Window
        grab(Fl_Window arg0)
        """
        return _fltk.Fl_grab(*args)

    grab = staticmethod(grab)
    def event(*args):
        """event() -> int"""
        return _fltk.Fl_event(*args)

    event = staticmethod(event)
    def event_x(*args):
        """event_x() -> int"""
        return _fltk.Fl_event_x(*args)

    event_x = staticmethod(event_x)
    def event_y(*args):
        """event_y() -> int"""
        return _fltk.Fl_event_y(*args)

    event_y = staticmethod(event_y)
    def event_x_root(*args):
        """event_x_root() -> int"""
        return _fltk.Fl_event_x_root(*args)

    event_x_root = staticmethod(event_x_root)
    def event_y_root(*args):
        """event_y_root() -> int"""
        return _fltk.Fl_event_y_root(*args)

    event_y_root = staticmethod(event_y_root)
    def event_dx(*args):
        """event_dx() -> int"""
        return _fltk.Fl_event_dx(*args)

    event_dx = staticmethod(event_dx)
    def event_dy(*args):
        """event_dy() -> int"""
        return _fltk.Fl_event_dy(*args)

    event_dy = staticmethod(event_dy)
    def get_mouse(*args):
        """get_mouse(int arg0, int arg1)"""
        return _fltk.Fl_get_mouse(*args)

    get_mouse = staticmethod(get_mouse)
    def event_clicks(*args):
        """
        event_clicks() -> int
        event_clicks(int i)
        """
        return _fltk.Fl_event_clicks(*args)

    event_clicks = staticmethod(event_clicks)
    def event_is_click(*args):
        """
        event_is_click() -> int
        event_is_click(int i)
        """
        return _fltk.Fl_event_is_click(*args)

    event_is_click = staticmethod(event_is_click)
    def event_button(*args):
        """event_button() -> int"""
        return _fltk.Fl_event_button(*args)

    event_button = staticmethod(event_button)
    def event_state(*args):
        """
        event_state() -> int
        event_state(int i) -> int
        """
        return _fltk.Fl_event_state(*args)

    event_state = staticmethod(event_state)
    def event_original_key(*args):
        """event_original_key() -> int"""
        return _fltk.Fl_event_original_key(*args)

    event_original_key = staticmethod(event_original_key)
    def event_key(*args):
        """
        event_key() -> int
        event_key(int arg0) -> int
        """
        return _fltk.Fl_event_key(*args)

    event_key = staticmethod(event_key)
    def get_key(*args):
        """get_key(int arg0) -> int"""
        return _fltk.Fl_get_key(*args)

    get_key = staticmethod(get_key)
    def event_text(*args):
        """event_text() -> char"""
        return _fltk.Fl_event_text(*args)

    event_text = staticmethod(event_text)
    def event_length(*args):
        """event_length() -> int"""
        return _fltk.Fl_event_length(*args)

    event_length = staticmethod(event_length)
    def compose(*args):
        """compose(int _del) -> int"""
        return _fltk.Fl_compose(*args)

    compose = staticmethod(compose)
    def compose_reset(*args):
        """compose_reset()"""
        return _fltk.Fl_compose_reset(*args)

    compose_reset = staticmethod(compose_reset)
    def event_inside(*args):
        """
        event_inside(int arg0, int arg1, int arg2, int arg3) -> int
        event_inside(Fl_Widget arg0) -> int
        """
        return _fltk.Fl_event_inside(*args)

    event_inside = staticmethod(event_inside)
    def test_shortcut(*args):
        """test_shortcut(int arg0) -> int"""
        return _fltk.Fl_test_shortcut(*args)

    test_shortcut = staticmethod(test_shortcut)
    def handle(*args):
        """handle(int arg0, Fl_Window arg1) -> int"""
        return _fltk.Fl_handle(*args)

    handle = staticmethod(handle)
    def belowmouse(*args):
        """
        belowmouse() -> Fl_Widget
        belowmouse(Fl_Widget arg0)
        """
        return _fltk.Fl_belowmouse(*args)

    belowmouse = staticmethod(belowmouse)
    def pushed(*args):
        """
        pushed() -> Fl_Widget
        pushed(Fl_Widget arg0)
        """
        return _fltk.Fl_pushed(*args)

    pushed = staticmethod(pushed)
    def focus(*args):
        """
        focus() -> Fl_Widget
        focus(Fl_Widget arg0)
        """
        return _fltk.Fl_focus(*args)

    focus = staticmethod(focus)
    def copy(*args):
        """copy(char stuff, int len, int clipboard = 0)"""
        return _fltk.Fl_copy(*args)

    copy = staticmethod(copy)
    def dnd(*args):
        """dnd() -> int"""
        return _fltk.Fl_dnd(*args)

    dnd = staticmethod(dnd)
    def selection_owner(*args):
        """
        selection_owner() -> Fl_Widget
        selection_owner(Fl_Widget arg0)
        """
        return _fltk.Fl_selection_owner(*args)

    selection_owner = staticmethod(selection_owner)
    def selection(*args):
        """selection(Fl_Widget owner, char arg1, int len)"""
        return _fltk.Fl_selection(*args)

    selection = staticmethod(selection)
    def paste(*args):
        """
        paste(Fl_Widget receiver, int clipboard)
        paste(Fl_Widget receiver)
        """
        return _fltk.Fl_paste(*args)

    paste = staticmethod(paste)
    def x(*args):
        """x() -> int"""
        return _fltk.Fl_x(*args)

    x = staticmethod(x)
    def y(*args):
        """y() -> int"""
        return _fltk.Fl_y(*args)

    y = staticmethod(y)
    def w(*args):
        """w() -> int"""
        return _fltk.Fl_w(*args)

    w = staticmethod(w)
    def h(*args):
        """h() -> int"""
        return _fltk.Fl_h(*args)

    h = staticmethod(h)
    def screen_count(*args):
        """screen_count() -> int"""
        return _fltk.Fl_screen_count(*args)

    screen_count = staticmethod(screen_count)
    def screen_xywh(*args):
        """
        screen_xywh(int X, int Y, int W, int H)
        screen_xywh(int X, int Y, int W, int H, int mx, int my)
        screen_xywh(int X, int Y, int W, int H, int n)
        """
        return _fltk.Fl_screen_xywh(*args)

    screen_xywh = staticmethod(screen_xywh)
    def set_color(*args):
        """
        set_color(Fl_Color arg0, uchar arg1, uchar arg2, uchar arg3)
        set_color(Fl_Color arg0, unsigned int arg1)
        """
        return _fltk.Fl_set_color(*args)

    set_color = staticmethod(set_color)
    def get_color(*args):
        """get_color(Fl_Color arg0)"""
        return _fltk.Fl_get_color(*args)

    get_color = staticmethod(get_color)
    def free_color(*args):
        """free_color(Fl_Color arg0, int overlay = 0)"""
        return _fltk.Fl_free_color(*args)

    free_color = staticmethod(free_color)
    def get_font(*args):
        """get_font(Fl_Font arg0) -> char"""
        return _fltk.Fl_get_font(*args)

    get_font = staticmethod(get_font)
    def get_font_name(*args):
        """get_font_name(Fl_Font arg0, int attributes = None) -> char"""
        return _fltk.Fl_get_font_name(*args)

    get_font_name = staticmethod(get_font_name)
    def get_font_sizes(*args):
        """get_font_sizes(Fl_Font arg0, int sizep) -> int"""
        return _fltk.Fl_get_font_sizes(*args)

    get_font_sizes = staticmethod(get_font_sizes)
    def set_font(*args):
        """
        set_font(Fl_Font arg0, char arg1)
        set_font(Fl_Font arg0, Fl_Font arg1)
        """
        return _fltk.Fl_set_font(*args)

    set_font = staticmethod(set_font)
    def set_fonts(*args):
        """set_fonts(char arg0 = None) -> Fl_Font"""
        return _fltk.Fl_set_fonts(*args)

    set_fonts = staticmethod(set_fonts)
    def set_labeltype(*args):
        """set_labeltype(Fl_Labeltype arg0, Fl_Label_Draw_F arg1, Fl_Label_Measure_F arg2)"""
        return _fltk.Fl_set_labeltype(*args)

    set_labeltype = staticmethod(set_labeltype)
    def get_boxtype(*args):
        """get_boxtype(Fl_Boxtype arg0) -> Fl_Box_Draw_F"""
        return _fltk.Fl_get_boxtype(*args)

    get_boxtype = staticmethod(get_boxtype)
    def set_boxtype(*args):
        """
        set_boxtype(Fl_Boxtype arg0, Fl_Box_Draw_F arg1, uchar arg2, uchar arg3, 
            uchar arg4, uchar arg5)
        set_boxtype(Fl_Boxtype arg0, Fl_Boxtype _from)
        """
        return _fltk.Fl_set_boxtype(*args)

    set_boxtype = staticmethod(set_boxtype)
    def box_dx(*args):
        """box_dx(Fl_Boxtype arg0) -> int"""
        return _fltk.Fl_box_dx(*args)

    box_dx = staticmethod(box_dx)
    def box_dy(*args):
        """box_dy(Fl_Boxtype arg0) -> int"""
        return _fltk.Fl_box_dy(*args)

    box_dy = staticmethod(box_dy)
    def box_dw(*args):
        """box_dw(Fl_Boxtype arg0) -> int"""
        return _fltk.Fl_box_dw(*args)

    box_dw = staticmethod(box_dw)
    def box_dh(*args):
        """box_dh(Fl_Boxtype arg0) -> int"""
        return _fltk.Fl_box_dh(*args)

    box_dh = staticmethod(box_dh)
    def draw_box_active(*args):
        """draw_box_active() -> int"""
        return _fltk.Fl_draw_box_active(*args)

    draw_box_active = staticmethod(draw_box_active)
    def set_abort(*args):
        """set_abort(void f)"""
        return _fltk.Fl_set_abort(*args)

    set_abort = staticmethod(set_abort)
    def default_atclose(*args):
        """default_atclose(Fl_Window arg0, void arg1)"""
        return _fltk.Fl_default_atclose(*args)

    default_atclose = staticmethod(default_atclose)
    def set_atclose(*args):
        """set_atclose(void f)"""
        return _fltk.Fl_set_atclose(*args)

    set_atclose = staticmethod(set_atclose)
    def event_shift(*args):
        """event_shift() -> int"""
        return _fltk.Fl_event_shift(*args)

    event_shift = staticmethod(event_shift)
    def event_ctrl(*args):
        """event_ctrl() -> int"""
        return _fltk.Fl_event_ctrl(*args)

    event_ctrl = staticmethod(event_ctrl)
    def event_alt(*args):
        """event_alt() -> int"""
        return _fltk.Fl_event_alt(*args)

    event_alt = staticmethod(event_alt)
    def event_buttons(*args):
        """event_buttons() -> int"""
        return _fltk.Fl_event_buttons(*args)

    event_buttons = staticmethod(event_buttons)
    def event_button1(*args):
        """event_button1() -> int"""
        return _fltk.Fl_event_button1(*args)

    event_button1 = staticmethod(event_button1)
    def event_button2(*args):
        """event_button2() -> int"""
        return _fltk.Fl_event_button2(*args)

    event_button2 = staticmethod(event_button2)
    def event_button3(*args):
        """event_button3() -> int"""
        return _fltk.Fl_event_button3(*args)

    event_button3 = staticmethod(event_button3)
    def release(*args):
        """release()"""
        return _fltk.Fl_release(*args)

    release = staticmethod(release)
    def visible_focus(*args):
        """
        visible_focus(int v)
        visible_focus() -> int
        """
        return _fltk.Fl_visible_focus(*args)

    visible_focus = staticmethod(visible_focus)
    def dnd_text_ops(*args):
        """
        dnd_text_ops(int v)
        dnd_text_ops() -> int
        """
        return _fltk.Fl_dnd_text_ops(*args)

    dnd_text_ops = staticmethod(dnd_text_ops)
    def delete_widget(*args):
        """delete_widget(Fl_Widget w)"""
        return _fltk.Fl_delete_widget(*args)

    delete_widget = staticmethod(delete_widget)
    def do_widget_deletion(*args):
        """do_widget_deletion()"""
        return _fltk.Fl_do_widget_deletion(*args)

    do_widget_deletion = staticmethod(do_widget_deletion)
    def watch_widget_pointer(*args):
        """watch_widget_pointer(Fl_Widget w)"""
        return _fltk.Fl_watch_widget_pointer(*args)

    watch_widget_pointer = staticmethod(watch_widget_pointer)
    def release_widget_pointer(*args):
        """release_widget_pointer(Fl_Widget w)"""
        return _fltk.Fl_release_widget_pointer(*args)

    release_widget_pointer = staticmethod(release_widget_pointer)
    def clear_widget_pointer(*args):
        """clear_widget_pointer(Fl_Widget w)"""
        return _fltk.Fl_clear_widget_pointer(*args)

    clear_widget_pointer = staticmethod(clear_widget_pointer)
    def lock(*args):
        """lock()"""
        return _fltk.Fl_lock(*args)

    lock = staticmethod(lock)
    def unlock(*args):
        """unlock()"""
        return _fltk.Fl_unlock(*args)

    unlock = staticmethod(unlock)
    def awake(*args):
        """
        awake(Fl_Awake_Handler cb, void message = None) -> int
        awake(void message = None)
        """
        return _fltk.Fl_awake(*args)

    awake = staticmethod(awake)
    def thread_message(*args):
        """thread_message()"""
        return _fltk.Fl_thread_message(*args)

    thread_message = staticmethod(thread_message)
    __swig_destroy__ = _fltk.delete_Fl
    __del__ = lambda self : None;
Fl_swigregister = _fltk.Fl_swigregister
Fl_swigregister(Fl)

def Fl_add_awake_handler_(*args):
  """Fl_add_awake_handler_(Fl_Awake_Handler arg0, void arg1) -> int"""
  return _fltk.Fl_add_awake_handler_(*args)

def Fl_get_awake_handler_(*args):
  """Fl_get_awake_handler_(Fl_Awake_Handler arg0, void arg1) -> int"""
  return _fltk.Fl_get_awake_handler_(*args)

def Fl_version(*args):
  """Fl_version() -> double"""
  return _fltk.Fl_version(*args)

def Fl_arg(*args):
  """Fl_arg(int arg0, char arg1, int arg2) -> int"""
  return _fltk.Fl_arg(*args)

def Fl_args(*args):
  """
    args(int arg0, char arg1, int arg2, int arg3 = None) -> int
    Fl_args(int arg0, char arg1)
    """
  return _fltk.Fl_args(*args)

def Fl_display(*args):
  """Fl_display(char arg0)"""
  return _fltk.Fl_display(*args)

def Fl_visual(*args):
  """Fl_visual(int arg0) -> int"""
  return _fltk.Fl_visual(*args)

def Fl_own_colormap(*args):
  """Fl_own_colormap()"""
  return _fltk.Fl_own_colormap(*args)

def Fl_get_system_colors(*args):
  """Fl_get_system_colors()"""
  return _fltk.Fl_get_system_colors(*args)

def Fl_foreground(*args):
  """Fl_foreground(uchar arg0, uchar arg1, uchar arg2)"""
  return _fltk.Fl_foreground(*args)

def Fl_background(*args):
  """Fl_background(uchar arg0, uchar arg1, uchar arg2)"""
  return _fltk.Fl_background(*args)

def Fl_background2(*args):
  """Fl_background2(uchar arg0, uchar arg1, uchar arg2)"""
  return _fltk.Fl_background2(*args)

def Fl_scheme(*args):
  """
    scheme(char arg0) -> int
    Fl_scheme() -> char
    """
  return _fltk.Fl_scheme(*args)

def Fl_reload_scheme(*args):
  """Fl_reload_scheme() -> int"""
  return _fltk.Fl_reload_scheme(*args)

def Fl_scrollbar_size(*args):
  """
    scrollbar_size() -> int
    Fl_scrollbar_size(int W)
    """
  return _fltk.Fl_scrollbar_size(*args)

def Fl_wait(*args):
  """
    wait() -> int
    Fl_wait(double time) -> double
    """
  return _fltk.Fl_wait(*args)

def Fl_check(*args):
  """Fl_check() -> int"""
  return _fltk.Fl_check(*args)

def Fl_ready(*args):
  """Fl_ready() -> int"""
  return _fltk.Fl_ready(*args)

def Fl_run(*args):
  """Fl_run() -> int"""
  return _fltk.Fl_run(*args)

def Fl_readqueue(*args):
  """Fl_readqueue() -> Fl_Widget"""
  return _fltk.Fl_readqueue(*args)

def Fl_has_timeout(*args):
  """Fl_has_timeout(Fl_Timeout_Handler arg0, void arg1 = None) -> int"""
  return _fltk.Fl_has_timeout(*args)

def Fl_has_idle(*args):
  """Fl_has_idle(void cb, void arg1 = None) -> int"""
  return _fltk.Fl_has_idle(*args)

def Fl_damage(*args):
  """
    damage(int d)
    Fl_damage() -> int
    """
  return _fltk.Fl_damage(*args)

def Fl_redraw(*args):
  """Fl_redraw()"""
  return _fltk.Fl_redraw(*args)

def Fl_flush(*args):
  """Fl_flush()"""
  return _fltk.Fl_flush(*args)

def Fl_first_window(*args):
  """
    first_window() -> Fl_Window
    Fl_first_window(Fl_Window arg0)
    """
  return _fltk.Fl_first_window(*args)

def Fl_next_window(*args):
  """Fl_next_window(Fl_Window arg0) -> Fl_Window"""
  return _fltk.Fl_next_window(*args)

def Fl_modal(*args):
  """Fl_modal() -> Fl_Window"""
  return _fltk.Fl_modal(*args)

def Fl_grab(*args):
  """
    grab() -> Fl_Window
    Fl_grab(Fl_Window arg0)
    """
  return _fltk.Fl_grab(*args)

def Fl_event(*args):
  """Fl_event() -> int"""
  return _fltk.Fl_event(*args)

def Fl_event_x(*args):
  """Fl_event_x() -> int"""
  return _fltk.Fl_event_x(*args)

def Fl_event_y(*args):
  """Fl_event_y() -> int"""
  return _fltk.Fl_event_y(*args)

def Fl_event_x_root(*args):
  """Fl_event_x_root() -> int"""
  return _fltk.Fl_event_x_root(*args)

def Fl_event_y_root(*args):
  """Fl_event_y_root() -> int"""
  return _fltk.Fl_event_y_root(*args)

def Fl_event_dx(*args):
  """Fl_event_dx() -> int"""
  return _fltk.Fl_event_dx(*args)

def Fl_event_dy(*args):
  """Fl_event_dy() -> int"""
  return _fltk.Fl_event_dy(*args)

def Fl_get_mouse(*args):
  """Fl_get_mouse(int arg0, int arg1)"""
  return _fltk.Fl_get_mouse(*args)

def Fl_event_clicks(*args):
  """
    event_clicks() -> int
    Fl_event_clicks(int i)
    """
  return _fltk.Fl_event_clicks(*args)

def Fl_event_is_click(*args):
  """
    event_is_click() -> int
    Fl_event_is_click(int i)
    """
  return _fltk.Fl_event_is_click(*args)

def Fl_event_button(*args):
  """Fl_event_button() -> int"""
  return _fltk.Fl_event_button(*args)

def Fl_event_state(*args):
  """
    event_state() -> int
    Fl_event_state(int i) -> int
    """
  return _fltk.Fl_event_state(*args)

def Fl_event_original_key(*args):
  """Fl_event_original_key() -> int"""
  return _fltk.Fl_event_original_key(*args)

def Fl_event_key(*args):
  """
    event_key() -> int
    Fl_event_key(int arg0) -> int
    """
  return _fltk.Fl_event_key(*args)

def Fl_get_key(*args):
  """Fl_get_key(int arg0) -> int"""
  return _fltk.Fl_get_key(*args)

def Fl_event_text(*args):
  """Fl_event_text() -> char"""
  return _fltk.Fl_event_text(*args)

def Fl_event_length(*args):
  """Fl_event_length() -> int"""
  return _fltk.Fl_event_length(*args)

def Fl_compose(*args):
  """Fl_compose(int _del) -> int"""
  return _fltk.Fl_compose(*args)

def Fl_compose_reset(*args):
  """Fl_compose_reset()"""
  return _fltk.Fl_compose_reset(*args)

def Fl_event_inside(*args):
  """
    event_inside(int arg0, int arg1, int arg2, int arg3) -> int
    Fl_event_inside(Fl_Widget arg0) -> int
    """
  return _fltk.Fl_event_inside(*args)

def Fl_test_shortcut(*args):
  """Fl_test_shortcut(int arg0) -> int"""
  return _fltk.Fl_test_shortcut(*args)

def Fl_handle(*args):
  """Fl_handle(int arg0, Fl_Window arg1) -> int"""
  return _fltk.Fl_handle(*args)

def Fl_belowmouse(*args):
  """
    belowmouse() -> Fl_Widget
    Fl_belowmouse(Fl_Widget arg0)
    """
  return _fltk.Fl_belowmouse(*args)

def Fl_pushed(*args):
  """
    pushed() -> Fl_Widget
    Fl_pushed(Fl_Widget arg0)
    """
  return _fltk.Fl_pushed(*args)

def Fl_focus(*args):
  """
    focus() -> Fl_Widget
    Fl_focus(Fl_Widget arg0)
    """
  return _fltk.Fl_focus(*args)

def Fl_copy(*args):
  """Fl_copy(char stuff, int len, int clipboard = 0)"""
  return _fltk.Fl_copy(*args)

def Fl_dnd(*args):
  """Fl_dnd() -> int"""
  return _fltk.Fl_dnd(*args)

def Fl_selection_owner(*args):
  """
    selection_owner() -> Fl_Widget
    Fl_selection_owner(Fl_Widget arg0)
    """
  return _fltk.Fl_selection_owner(*args)

def Fl_selection(*args):
  """Fl_selection(Fl_Widget owner, char arg1, int len)"""
  return _fltk.Fl_selection(*args)

def Fl_paste(*args):
  """
    paste(Fl_Widget receiver, int clipboard)
    Fl_paste(Fl_Widget receiver)
    """
  return _fltk.Fl_paste(*args)

def Fl_x(*args):
  """Fl_x() -> int"""
  return _fltk.Fl_x(*args)

def Fl_y(*args):
  """Fl_y() -> int"""
  return _fltk.Fl_y(*args)

def Fl_w(*args):
  """Fl_w() -> int"""
  return _fltk.Fl_w(*args)

def Fl_h(*args):
  """Fl_h() -> int"""
  return _fltk.Fl_h(*args)

def Fl_screen_count(*args):
  """Fl_screen_count() -> int"""
  return _fltk.Fl_screen_count(*args)

def Fl_screen_xywh(*args):
  """
    screen_xywh(int X, int Y, int W, int H)
    screen_xywh(int X, int Y, int W, int H, int mx, int my)
    Fl_screen_xywh(int X, int Y, int W, int H, int n)
    """
  return _fltk.Fl_screen_xywh(*args)

def Fl_set_color(*args):
  """
    set_color(Fl_Color arg0, uchar arg1, uchar arg2, uchar arg3)
    Fl_set_color(Fl_Color arg0, unsigned int arg1)
    """
  return _fltk.Fl_set_color(*args)

def Fl_get_color(*args):
  """Fl_get_color(Fl_Color arg0)"""
  return _fltk.Fl_get_color(*args)

def Fl_free_color(*args):
  """Fl_free_color(Fl_Color arg0, int overlay = 0)"""
  return _fltk.Fl_free_color(*args)

def Fl_get_font(*args):
  """Fl_get_font(Fl_Font arg0) -> char"""
  return _fltk.Fl_get_font(*args)

def Fl_get_font_name(*args):
  """Fl_get_font_name(Fl_Font arg0, int attributes = None) -> char"""
  return _fltk.Fl_get_font_name(*args)

def Fl_get_font_sizes(*args):
  """Fl_get_font_sizes(Fl_Font arg0, int sizep) -> int"""
  return _fltk.Fl_get_font_sizes(*args)

def Fl_set_font(*args):
  """
    set_font(Fl_Font arg0, char arg1)
    Fl_set_font(Fl_Font arg0, Fl_Font arg1)
    """
  return _fltk.Fl_set_font(*args)

def Fl_set_fonts(*args):
  """Fl_set_fonts(char arg0 = None) -> Fl_Font"""
  return _fltk.Fl_set_fonts(*args)

def Fl_set_labeltype(*args):
  """Fl_set_labeltype(Fl_Labeltype arg0, Fl_Label_Draw_F arg1, Fl_Label_Measure_F arg2)"""
  return _fltk.Fl_set_labeltype(*args)

def Fl_get_boxtype(*args):
  """Fl_get_boxtype(Fl_Boxtype arg0) -> Fl_Box_Draw_F"""
  return _fltk.Fl_get_boxtype(*args)

def Fl_set_boxtype(*args):
  """
    set_boxtype(Fl_Boxtype arg0, Fl_Box_Draw_F arg1, uchar arg2, uchar arg3, 
        uchar arg4, uchar arg5)
    Fl_set_boxtype(Fl_Boxtype arg0, Fl_Boxtype _from)
    """
  return _fltk.Fl_set_boxtype(*args)

def Fl_box_dx(*args):
  """Fl_box_dx(Fl_Boxtype arg0) -> int"""
  return _fltk.Fl_box_dx(*args)

def Fl_box_dy(*args):
  """Fl_box_dy(Fl_Boxtype arg0) -> int"""
  return _fltk.Fl_box_dy(*args)

def Fl_box_dw(*args):
  """Fl_box_dw(Fl_Boxtype arg0) -> int"""
  return _fltk.Fl_box_dw(*args)

def Fl_box_dh(*args):
  """Fl_box_dh(Fl_Boxtype arg0) -> int"""
  return _fltk.Fl_box_dh(*args)

def Fl_draw_box_active(*args):
  """Fl_draw_box_active() -> int"""
  return _fltk.Fl_draw_box_active(*args)

def Fl_set_abort(*args):
  """Fl_set_abort(void f)"""
  return _fltk.Fl_set_abort(*args)

def Fl_default_atclose(*args):
  """Fl_default_atclose(Fl_Window arg0, void arg1)"""
  return _fltk.Fl_default_atclose(*args)

def Fl_set_atclose(*args):
  """Fl_set_atclose(void f)"""
  return _fltk.Fl_set_atclose(*args)

def Fl_event_shift(*args):
  """Fl_event_shift() -> int"""
  return _fltk.Fl_event_shift(*args)

def Fl_event_ctrl(*args):
  """Fl_event_ctrl() -> int"""
  return _fltk.Fl_event_ctrl(*args)

def Fl_event_alt(*args):
  """Fl_event_alt() -> int"""
  return _fltk.Fl_event_alt(*args)

def Fl_event_buttons(*args):
  """Fl_event_buttons() -> int"""
  return _fltk.Fl_event_buttons(*args)

def Fl_event_button1(*args):
  """Fl_event_button1() -> int"""
  return _fltk.Fl_event_button1(*args)

def Fl_event_button2(*args):
  """Fl_event_button2() -> int"""
  return _fltk.Fl_event_button2(*args)

def Fl_event_button3(*args):
  """Fl_event_button3() -> int"""
  return _fltk.Fl_event_button3(*args)

def Fl_release(*args):
  """Fl_release()"""
  return _fltk.Fl_release(*args)

def Fl_visible_focus(*args):
  """
    visible_focus(int v)
    Fl_visible_focus() -> int
    """
  return _fltk.Fl_visible_focus(*args)

def Fl_dnd_text_ops(*args):
  """
    dnd_text_ops(int v)
    Fl_dnd_text_ops() -> int
    """
  return _fltk.Fl_dnd_text_ops(*args)

def Fl_delete_widget(*args):
  """Fl_delete_widget(Fl_Widget w)"""
  return _fltk.Fl_delete_widget(*args)

def Fl_do_widget_deletion(*args):
  """Fl_do_widget_deletion()"""
  return _fltk.Fl_do_widget_deletion(*args)

def Fl_watch_widget_pointer(*args):
  """Fl_watch_widget_pointer(Fl_Widget w)"""
  return _fltk.Fl_watch_widget_pointer(*args)

def Fl_release_widget_pointer(*args):
  """Fl_release_widget_pointer(Fl_Widget w)"""
  return _fltk.Fl_release_widget_pointer(*args)

def Fl_clear_widget_pointer(*args):
  """Fl_clear_widget_pointer(Fl_Widget w)"""
  return _fltk.Fl_clear_widget_pointer(*args)

def Fl_lock(*args):
  """Fl_lock()"""
  return _fltk.Fl_lock(*args)

def Fl_unlock(*args):
  """Fl_unlock()"""
  return _fltk.Fl_unlock(*args)

def Fl_awake(*args):
  """
    awake(Fl_Awake_Handler cb, void message = None) -> int
    Fl_awake(void message = None)
    """
  return _fltk.Fl_awake(*args)

def Fl_thread_message(*args):
  """Fl_thread_message()"""
  return _fltk.Fl_thread_message(*args)


def pyFLTK_controlIdleCallbacks(*args):
  """pyFLTK_controlIdleCallbacks(int enable)"""
  return _fltk.pyFLTK_controlIdleCallbacks(*args)
def Fl_mt_run(window):
    import time
    while window.visible():
        time.sleep(0.1)
        Fl.check()

Fl.mt_run = staticmethod(Fl_mt_run)

FL_MAJOR_VERSION = _fltk.FL_MAJOR_VERSION
FL_MINOR_VERSION = _fltk.FL_MINOR_VERSION
FL_PATCH_VERSION = _fltk.FL_PATCH_VERSION
FL_NO_EVENT = _fltk.FL_NO_EVENT
FL_PUSH = _fltk.FL_PUSH
FL_RELEASE = _fltk.FL_RELEASE
FL_ENTER = _fltk.FL_ENTER
FL_LEAVE = _fltk.FL_LEAVE
FL_DRAG = _fltk.FL_DRAG
FL_FOCUS = _fltk.FL_FOCUS
FL_UNFOCUS = _fltk.FL_UNFOCUS
FL_KEYDOWN = _fltk.FL_KEYDOWN
FL_KEYUP = _fltk.FL_KEYUP
FL_CLOSE = _fltk.FL_CLOSE
FL_MOVE = _fltk.FL_MOVE
FL_SHORTCUT = _fltk.FL_SHORTCUT
FL_DEACTIVATE = _fltk.FL_DEACTIVATE
FL_ACTIVATE = _fltk.FL_ACTIVATE
FL_HIDE = _fltk.FL_HIDE
FL_SHOW = _fltk.FL_SHOW
FL_PASTE = _fltk.FL_PASTE
FL_SELECTIONCLEAR = _fltk.FL_SELECTIONCLEAR
FL_MOUSEWHEEL = _fltk.FL_MOUSEWHEEL
FL_DND_ENTER = _fltk.FL_DND_ENTER
FL_DND_DRAG = _fltk.FL_DND_DRAG
FL_DND_LEAVE = _fltk.FL_DND_LEAVE
FL_DND_RELEASE = _fltk.FL_DND_RELEASE
FL_WHEN_NEVER = _fltk.FL_WHEN_NEVER
FL_WHEN_CHANGED = _fltk.FL_WHEN_CHANGED
FL_WHEN_RELEASE = _fltk.FL_WHEN_RELEASE
FL_WHEN_RELEASE_ALWAYS = _fltk.FL_WHEN_RELEASE_ALWAYS
FL_WHEN_ENTER_KEY = _fltk.FL_WHEN_ENTER_KEY
FL_WHEN_ENTER_KEY_ALWAYS = _fltk.FL_WHEN_ENTER_KEY_ALWAYS
FL_WHEN_ENTER_KEY_CHANGED = _fltk.FL_WHEN_ENTER_KEY_CHANGED
FL_WHEN_NOT_CHANGED = _fltk.FL_WHEN_NOT_CHANGED
FL_Button = _fltk.FL_Button
FL_BackSpace = _fltk.FL_BackSpace
FL_Tab = _fltk.FL_Tab
FL_Enter = _fltk.FL_Enter
FL_Pause = _fltk.FL_Pause
FL_Scroll_Lock = _fltk.FL_Scroll_Lock
FL_Escape = _fltk.FL_Escape
FL_Home = _fltk.FL_Home
FL_Left = _fltk.FL_Left
FL_Up = _fltk.FL_Up
FL_Right = _fltk.FL_Right
FL_Down = _fltk.FL_Down
FL_Page_Up = _fltk.FL_Page_Up
FL_Page_Down = _fltk.FL_Page_Down
FL_End = _fltk.FL_End
FL_Print = _fltk.FL_Print
FL_Insert = _fltk.FL_Insert
FL_Menu = _fltk.FL_Menu
FL_Help = _fltk.FL_Help
FL_Num_Lock = _fltk.FL_Num_Lock
FL_KP = _fltk.FL_KP
FL_KP_Enter = _fltk.FL_KP_Enter
FL_KP_Last = _fltk.FL_KP_Last
FL_F = _fltk.FL_F
FL_F_Last = _fltk.FL_F_Last
FL_Shift_L = _fltk.FL_Shift_L
FL_Shift_R = _fltk.FL_Shift_R
FL_Control_L = _fltk.FL_Control_L
FL_Control_R = _fltk.FL_Control_R
FL_Caps_Lock = _fltk.FL_Caps_Lock
FL_Meta_L = _fltk.FL_Meta_L
FL_Meta_R = _fltk.FL_Meta_R
FL_Alt_L = _fltk.FL_Alt_L
FL_Alt_R = _fltk.FL_Alt_R
FL_Delete = _fltk.FL_Delete
FL_LEFT_MOUSE = _fltk.FL_LEFT_MOUSE
FL_MIDDLE_MOUSE = _fltk.FL_MIDDLE_MOUSE
FL_RIGHT_MOUSE = _fltk.FL_RIGHT_MOUSE
FL_SHIFT = _fltk.FL_SHIFT
FL_CAPS_LOCK = _fltk.FL_CAPS_LOCK
FL_CTRL = _fltk.FL_CTRL
FL_ALT = _fltk.FL_ALT
FL_NUM_LOCK = _fltk.FL_NUM_LOCK
FL_META = _fltk.FL_META
FL_SCROLL_LOCK = _fltk.FL_SCROLL_LOCK
FL_BUTTON1 = _fltk.FL_BUTTON1
FL_BUTTON2 = _fltk.FL_BUTTON2
FL_BUTTON3 = _fltk.FL_BUTTON3
FL_BUTTONS = _fltk.FL_BUTTONS
FL_COMMAND = _fltk.FL_COMMAND
FL_NO_BOX = _fltk.FL_NO_BOX
FL_FLAT_BOX = _fltk.FL_FLAT_BOX
FL_UP_BOX = _fltk.FL_UP_BOX
FL_DOWN_BOX = _fltk.FL_DOWN_BOX
FL_UP_FRAME = _fltk.FL_UP_FRAME
FL_DOWN_FRAME = _fltk.FL_DOWN_FRAME
FL_THIN_UP_BOX = _fltk.FL_THIN_UP_BOX
FL_THIN_DOWN_BOX = _fltk.FL_THIN_DOWN_BOX
FL_THIN_UP_FRAME = _fltk.FL_THIN_UP_FRAME
FL_THIN_DOWN_FRAME = _fltk.FL_THIN_DOWN_FRAME
FL_ENGRAVED_BOX = _fltk.FL_ENGRAVED_BOX
FL_EMBOSSED_BOX = _fltk.FL_EMBOSSED_BOX
FL_ENGRAVED_FRAME = _fltk.FL_ENGRAVED_FRAME
FL_EMBOSSED_FRAME = _fltk.FL_EMBOSSED_FRAME
FL_BORDER_BOX = _fltk.FL_BORDER_BOX
_FL_SHADOW_BOX = _fltk._FL_SHADOW_BOX
FL_BORDER_FRAME = _fltk.FL_BORDER_FRAME
_FL_SHADOW_FRAME = _fltk._FL_SHADOW_FRAME
_FL_ROUNDED_BOX = _fltk._FL_ROUNDED_BOX
_FL_RSHADOW_BOX = _fltk._FL_RSHADOW_BOX
_FL_ROUNDED_FRAME = _fltk._FL_ROUNDED_FRAME
_FL_RFLAT_BOX = _fltk._FL_RFLAT_BOX
_FL_ROUND_UP_BOX = _fltk._FL_ROUND_UP_BOX
_FL_ROUND_DOWN_BOX = _fltk._FL_ROUND_DOWN_BOX
_FL_DIAMOND_UP_BOX = _fltk._FL_DIAMOND_UP_BOX
_FL_DIAMOND_DOWN_BOX = _fltk._FL_DIAMOND_DOWN_BOX
_FL_OVAL_BOX = _fltk._FL_OVAL_BOX
_FL_OSHADOW_BOX = _fltk._FL_OSHADOW_BOX
_FL_OVAL_FRAME = _fltk._FL_OVAL_FRAME
_FL_OFLAT_BOX = _fltk._FL_OFLAT_BOX
_FL_PLASTIC_UP_BOX = _fltk._FL_PLASTIC_UP_BOX
_FL_PLASTIC_DOWN_BOX = _fltk._FL_PLASTIC_DOWN_BOX
_FL_PLASTIC_UP_FRAME = _fltk._FL_PLASTIC_UP_FRAME
_FL_PLASTIC_DOWN_FRAME = _fltk._FL_PLASTIC_DOWN_FRAME
_FL_PLASTIC_THIN_UP_BOX = _fltk._FL_PLASTIC_THIN_UP_BOX
_FL_PLASTIC_THIN_DOWN_BOX = _fltk._FL_PLASTIC_THIN_DOWN_BOX
_FL_PLASTIC_ROUND_UP_BOX = _fltk._FL_PLASTIC_ROUND_UP_BOX
_FL_PLASTIC_ROUND_DOWN_BOX = _fltk._FL_PLASTIC_ROUND_DOWN_BOX
_FL_GTK_UP_BOX = _fltk._FL_GTK_UP_BOX
_FL_GTK_DOWN_BOX = _fltk._FL_GTK_DOWN_BOX
_FL_GTK_UP_FRAME = _fltk._FL_GTK_UP_FRAME
_FL_GTK_DOWN_FRAME = _fltk._FL_GTK_DOWN_FRAME
_FL_GTK_THIN_UP_BOX = _fltk._FL_GTK_THIN_UP_BOX
_FL_GTK_THIN_DOWN_BOX = _fltk._FL_GTK_THIN_DOWN_BOX
_FL_GTK_THIN_UP_FRAME = _fltk._FL_GTK_THIN_UP_FRAME
_FL_GTK_THIN_DOWN_FRAME = _fltk._FL_GTK_THIN_DOWN_FRAME
_FL_GTK_ROUND_UP_BOX = _fltk._FL_GTK_ROUND_UP_BOX
_FL_GTK_ROUND_DOWN_BOX = _fltk._FL_GTK_ROUND_DOWN_BOX
FL_FREE_BOXTYPE = _fltk.FL_FREE_BOXTYPE

def fl_define_FL_ROUND_UP_BOX(*args):
  """fl_define_FL_ROUND_UP_BOX() -> Fl_Boxtype"""
  return _fltk.fl_define_FL_ROUND_UP_BOX(*args)

def fl_define_FL_SHADOW_BOX(*args):
  """fl_define_FL_SHADOW_BOX() -> Fl_Boxtype"""
  return _fltk.fl_define_FL_SHADOW_BOX(*args)

def fl_define_FL_ROUNDED_BOX(*args):
  """fl_define_FL_ROUNDED_BOX() -> Fl_Boxtype"""
  return _fltk.fl_define_FL_ROUNDED_BOX(*args)

def fl_define_FL_RFLAT_BOX(*args):
  """fl_define_FL_RFLAT_BOX() -> Fl_Boxtype"""
  return _fltk.fl_define_FL_RFLAT_BOX(*args)

def fl_define_FL_RSHADOW_BOX(*args):
  """fl_define_FL_RSHADOW_BOX() -> Fl_Boxtype"""
  return _fltk.fl_define_FL_RSHADOW_BOX(*args)

def fl_define_FL_DIAMOND_BOX(*args):
  """fl_define_FL_DIAMOND_BOX() -> Fl_Boxtype"""
  return _fltk.fl_define_FL_DIAMOND_BOX(*args)

def fl_define_FL_OVAL_BOX(*args):
  """fl_define_FL_OVAL_BOX() -> Fl_Boxtype"""
  return _fltk.fl_define_FL_OVAL_BOX(*args)

def fl_define_FL_PLASTIC_UP_BOX(*args):
  """fl_define_FL_PLASTIC_UP_BOX() -> Fl_Boxtype"""
  return _fltk.fl_define_FL_PLASTIC_UP_BOX(*args)

def fl_define_FL_GTK_UP_BOX(*args):
  """fl_define_FL_GTK_UP_BOX() -> Fl_Boxtype"""
  return _fltk.fl_define_FL_GTK_UP_BOX(*args)

def fl_box(*args):
  """fl_box(Fl_Boxtype b) -> Fl_Boxtype"""
  return _fltk.fl_box(*args)

def fl_down(*args):
  """fl_down(Fl_Boxtype b) -> Fl_Boxtype"""
  return _fltk.fl_down(*args)
FL_NORMAL_LABEL = _fltk.FL_NORMAL_LABEL
FL_NO_LABEL = _fltk.FL_NO_LABEL
_FL_SHADOW_LABEL = _fltk._FL_SHADOW_LABEL
_FL_ENGRAVED_LABEL = _fltk._FL_ENGRAVED_LABEL
_FL_EMBOSSED_LABEL = _fltk._FL_EMBOSSED_LABEL
_FL_MULTI_LABEL = _fltk._FL_MULTI_LABEL
_FL_ICON_LABEL = _fltk._FL_ICON_LABEL
_FL_IMAGE_LABEL = _fltk._FL_IMAGE_LABEL
FL_FREE_LABELTYPE = _fltk.FL_FREE_LABELTYPE

def fl_define_FL_SHADOW_LABEL(*args):
  """fl_define_FL_SHADOW_LABEL() -> Fl_Labeltype"""
  return _fltk.fl_define_FL_SHADOW_LABEL(*args)

def fl_define_FL_ENGRAVED_LABEL(*args):
  """fl_define_FL_ENGRAVED_LABEL() -> Fl_Labeltype"""
  return _fltk.fl_define_FL_ENGRAVED_LABEL(*args)

def fl_define_FL_EMBOSSED_LABEL(*args):
  """fl_define_FL_EMBOSSED_LABEL() -> Fl_Labeltype"""
  return _fltk.fl_define_FL_EMBOSSED_LABEL(*args)
FL_ALIGN_CENTER = _fltk.FL_ALIGN_CENTER
FL_ALIGN_TOP = _fltk.FL_ALIGN_TOP
FL_ALIGN_BOTTOM = _fltk.FL_ALIGN_BOTTOM
FL_ALIGN_LEFT = _fltk.FL_ALIGN_LEFT
FL_ALIGN_RIGHT = _fltk.FL_ALIGN_RIGHT
FL_ALIGN_INSIDE = _fltk.FL_ALIGN_INSIDE
FL_ALIGN_TEXT_OVER_IMAGE = _fltk.FL_ALIGN_TEXT_OVER_IMAGE
FL_ALIGN_IMAGE_OVER_TEXT = _fltk.FL_ALIGN_IMAGE_OVER_TEXT
FL_ALIGN_CLIP = _fltk.FL_ALIGN_CLIP
FL_ALIGN_WRAP = _fltk.FL_ALIGN_WRAP
FL_ALIGN_TOP_LEFT = _fltk.FL_ALIGN_TOP_LEFT
FL_ALIGN_TOP_RIGHT = _fltk.FL_ALIGN_TOP_RIGHT
FL_ALIGN_BOTTOM_LEFT = _fltk.FL_ALIGN_BOTTOM_LEFT
FL_ALIGN_BOTTOM_RIGHT = _fltk.FL_ALIGN_BOTTOM_RIGHT
FL_ALIGN_LEFT_TOP = _fltk.FL_ALIGN_LEFT_TOP
FL_ALIGN_RIGHT_TOP = _fltk.FL_ALIGN_RIGHT_TOP
FL_ALIGN_LEFT_BOTTOM = _fltk.FL_ALIGN_LEFT_BOTTOM
FL_ALIGN_RIGHT_BOTTOM = _fltk.FL_ALIGN_RIGHT_BOTTOM
FL_ALIGN_NOWRAP = _fltk.FL_ALIGN_NOWRAP
FL_HELVETICA = _fltk.FL_HELVETICA
FL_HELVETICA_BOLD = _fltk.FL_HELVETICA_BOLD
FL_HELVETICA_ITALIC = _fltk.FL_HELVETICA_ITALIC
FL_HELVETICA_BOLD_ITALIC = _fltk.FL_HELVETICA_BOLD_ITALIC
FL_COURIER = _fltk.FL_COURIER
FL_COURIER_BOLD = _fltk.FL_COURIER_BOLD
FL_COURIER_ITALIC = _fltk.FL_COURIER_ITALIC
FL_COURIER_BOLD_ITALIC = _fltk.FL_COURIER_BOLD_ITALIC
FL_TIMES = _fltk.FL_TIMES
FL_TIMES_BOLD = _fltk.FL_TIMES_BOLD
FL_TIMES_ITALIC = _fltk.FL_TIMES_ITALIC
FL_TIMES_BOLD_ITALIC = _fltk.FL_TIMES_BOLD_ITALIC
FL_SYMBOL = _fltk.FL_SYMBOL
FL_SCREEN = _fltk.FL_SCREEN
FL_SCREEN_BOLD = _fltk.FL_SCREEN_BOLD
FL_ZAPF_DINGBATS = _fltk.FL_ZAPF_DINGBATS
FL_FREE_FONT = _fltk.FL_FREE_FONT
FL_BOLD = _fltk.FL_BOLD
FL_ITALIC = _fltk.FL_ITALIC
FL_FOREGROUND_COLOR = _fltk.FL_FOREGROUND_COLOR
FL_BACKGROUND2_COLOR = _fltk.FL_BACKGROUND2_COLOR
FL_INACTIVE_COLOR = _fltk.FL_INACTIVE_COLOR
FL_SELECTION_COLOR = _fltk.FL_SELECTION_COLOR
FL_GRAY0 = _fltk.FL_GRAY0
FL_DARK3 = _fltk.FL_DARK3
FL_DARK2 = _fltk.FL_DARK2
FL_DARK1 = _fltk.FL_DARK1
FL_BACKGROUND_COLOR = _fltk.FL_BACKGROUND_COLOR
FL_LIGHT1 = _fltk.FL_LIGHT1
FL_LIGHT2 = _fltk.FL_LIGHT2
FL_LIGHT3 = _fltk.FL_LIGHT3
FL_BLACK = _fltk.FL_BLACK
FL_RED = _fltk.FL_RED
FL_GREEN = _fltk.FL_GREEN
FL_YELLOW = _fltk.FL_YELLOW
FL_BLUE = _fltk.FL_BLUE
FL_MAGENTA = _fltk.FL_MAGENTA
FL_CYAN = _fltk.FL_CYAN
FL_DARK_RED = _fltk.FL_DARK_RED
FL_DARK_GREEN = _fltk.FL_DARK_GREEN
FL_DARK_YELLOW = _fltk.FL_DARK_YELLOW
FL_DARK_BLUE = _fltk.FL_DARK_BLUE
FL_DARK_MAGENTA = _fltk.FL_DARK_MAGENTA
FL_DARK_CYAN = _fltk.FL_DARK_CYAN
FL_WHITE = _fltk.FL_WHITE
FL_NUM_FREE_COLOR = _fltk.FL_NUM_FREE_COLOR
FL_NUM_GRAY = _fltk.FL_NUM_GRAY
FL_NUM_RED = _fltk.FL_NUM_RED
FL_NUM_GREEN = _fltk.FL_NUM_GREEN
FL_NUM_BLUE = _fltk.FL_NUM_BLUE

def fl_inactive(*args):
  """fl_inactive(Fl_Color c) -> Fl_Color"""
  return _fltk.fl_inactive(*args)

def fl_contrast(*args):
  """fl_contrast(Fl_Color fg, Fl_Color bg) -> Fl_Color"""
  return _fltk.fl_contrast(*args)

def fl_color_average(*args):
  """fl_color_average(Fl_Color c1, Fl_Color c2, float weight) -> Fl_Color"""
  return _fltk.fl_color_average(*args)

def fl_lighter(*args):
  """fl_lighter(Fl_Color c) -> Fl_Color"""
  return _fltk.fl_lighter(*args)

def fl_darker(*args):
  """fl_darker(Fl_Color c) -> Fl_Color"""
  return _fltk.fl_darker(*args)

def fl_gray_ramp(*args):
  """fl_gray_ramp(int i) -> Fl_Color"""
  return _fltk.fl_gray_ramp(*args)

def fl_color_cube(*args):
  """fl_color_cube(int r, int g, int b) -> Fl_Color"""
  return _fltk.fl_color_cube(*args)
FL_CURSOR_DEFAULT = _fltk.FL_CURSOR_DEFAULT
FL_CURSOR_ARROW = _fltk.FL_CURSOR_ARROW
FL_CURSOR_CROSS = _fltk.FL_CURSOR_CROSS
FL_CURSOR_WAIT = _fltk.FL_CURSOR_WAIT
FL_CURSOR_INSERT = _fltk.FL_CURSOR_INSERT
FL_CURSOR_HAND = _fltk.FL_CURSOR_HAND
FL_CURSOR_HELP = _fltk.FL_CURSOR_HELP
FL_CURSOR_MOVE = _fltk.FL_CURSOR_MOVE
FL_CURSOR_NS = _fltk.FL_CURSOR_NS
FL_CURSOR_WE = _fltk.FL_CURSOR_WE
FL_CURSOR_NWSE = _fltk.FL_CURSOR_NWSE
FL_CURSOR_NESW = _fltk.FL_CURSOR_NESW
FL_CURSOR_NONE = _fltk.FL_CURSOR_NONE
FL_CURSOR_N = _fltk.FL_CURSOR_N
FL_CURSOR_NE = _fltk.FL_CURSOR_NE
FL_CURSOR_E = _fltk.FL_CURSOR_E
FL_CURSOR_SE = _fltk.FL_CURSOR_SE
FL_CURSOR_S = _fltk.FL_CURSOR_S
FL_CURSOR_SW = _fltk.FL_CURSOR_SW
FL_CURSOR_W = _fltk.FL_CURSOR_W
FL_CURSOR_NW = _fltk.FL_CURSOR_NW
FL_READ = _fltk.FL_READ
FL_WRITE = _fltk.FL_WRITE
FL_EXCEPT = _fltk.FL_EXCEPT
FL_RGB = _fltk.FL_RGB
FL_INDEX = _fltk.FL_INDEX
FL_SINGLE = _fltk.FL_SINGLE
FL_DOUBLE = _fltk.FL_DOUBLE
FL_ACCUM = _fltk.FL_ACCUM
FL_ALPHA = _fltk.FL_ALPHA
FL_DEPTH = _fltk.FL_DEPTH
FL_STENCIL = _fltk.FL_STENCIL
FL_RGB8 = _fltk.FL_RGB8
FL_MULTISAMPLE = _fltk.FL_MULTISAMPLE
FL_STEREO = _fltk.FL_STEREO
FL_FAKE_SINGLE = _fltk.FL_FAKE_SINGLE
FL_IMAGE_WITH_ALPHA = _fltk.FL_IMAGE_WITH_ALPHA
FL_DAMAGE_CHILD = _fltk.FL_DAMAGE_CHILD
FL_DAMAGE_EXPOSE = _fltk.FL_DAMAGE_EXPOSE
FL_DAMAGE_SCROLL = _fltk.FL_DAMAGE_SCROLL
FL_DAMAGE_OVERLAY = _fltk.FL_DAMAGE_OVERLAY
FL_DAMAGE_USER1 = _fltk.FL_DAMAGE_USER1
FL_DAMAGE_USER2 = _fltk.FL_DAMAGE_USER2
FL_DAMAGE_ALL = _fltk.FL_DAMAGE_ALL
# events
FL_KEYBOARD=FL_KEYDOWN

# additional boxtypes instead of defines
FL_ROUND_UP_BOX=fl_define_FL_ROUND_UP_BOX()
FL_ROUND_DOWN_BOX=fl_define_FL_ROUND_UP_BOX()+1
FL_SHADOW_BOX=fl_define_FL_SHADOW_BOX()
FL_SHADOW_FRAME=fl_define_FL_SHADOW_BOX()+2
FL_ROUNDED_BOX=fl_define_FL_ROUNDED_BOX()
FL_ROUNDED_FRAME=fl_define_FL_ROUNDED_BOX()+2
FL_RFLAT_BOX=fl_define_FL_RFLAT_BOX()
FL_RSHADOW_BOX=fl_define_FL_RSHADOW_BOX()
FL_DIAMOND_UP_BOX=fl_define_FL_DIAMOND_BOX()
FL_DIAMOND_DOWN_BOX=fl_define_FL_DIAMOND_BOX()+1
FL_OVAL_BOX=fl_define_FL_OVAL_BOX()
FL_OSHADOW_BOX=fl_define_FL_OVAL_BOX()+1
FL_OVAL_FRAME=fl_define_FL_OVAL_BOX()+2
FL_OFLAT_BOX=fl_define_FL_OVAL_BOX()+3
FL_PLASTIC_UP_BOX=fl_define_FL_PLASTIC_UP_BOX()
FL_PLASTIC_DOWN_BOX=fl_define_FL_PLASTIC_UP_BOX()+1
FL_PLASTIC_UP_FRAME=fl_define_FL_PLASTIC_UP_BOX()+2
FL_PLASTIC_DOWN_FRAME=fl_define_FL_PLASTIC_UP_BOX()+3
FL_PLASTIC_THIN_UP_BOX=fl_define_FL_PLASTIC_UP_BOX()+4
FL_PLASTIC_THIN_DOWN_BOX=fl_define_FL_PLASTIC_UP_BOX()+5
FL_PLASTIC_ROUND_UP_BOX=fl_define_FL_PLASTIC_UP_BOX()+6
FL_PLASTIC_ROUND_DOWN_BOX=fl_define_FL_PLASTIC_UP_BOX()+7

FL_GTK_UP_BOX=fl_define_FL_GTK_UP_BOX()
FL_GTK_DOWN_BOX=fl_define_FL_GTK_UP_BOX()+1
FL_GTK_UP_FRAME=fl_define_FL_GTK_UP_BOX()+2
FL_GTK_DOWN_FRAME=fl_define_FL_GTK_UP_BOX()+3
FL_GTK_THIN_UP_BOX=fl_define_FL_GTK_UP_BOX()+4
FL_GTK_THIN_DOWN_BOX=fl_define_FL_GTK_UP_BOX()+5
FL_GTK_THIN_UP_FRAME=fl_define_FL_GTK_UP_BOX()+6
FL_GTK_THIN_DOWN_FRAME=fl_define_FL_GTK_UP_BOX()+7
FL_GTK_ROUND_UP_BOX=fl_define_FL_GTK_UP_BOX()+8
FL_GTK_ROUND_DOWN_BOX=fl_define_FL_GTK_UP_BOX()+9


# color defines
FL_FREE_COLOR=16           
FL_NUM_FREE_COLOR=16       
FL_GRAY_RAMP=32           
FL_NUM_GRAY=24                     
FL_GRAY=FL_BACKGROUND_COLOR    
FL_COLOR_CUBE=56           
FL_NUM_RED=5                      
FL_NUM_GREEN=8                      
FL_NUM_BLUE=5

# label defines
FL_SYMBOL_LABEL=FL_NORMAL_LABEL
FL_SHADOW_LABEL=fl_define_FL_SHADOW_LABEL()
FL_ENGRAVED_LABEL=fl_define_FL_ENGRAVED_LABEL()
FL_EMBOSSED_LABEL=fl_define_FL_EMBOSSED_LABEL()


FL_PATH_MAX = _fltk.FL_PATH_MAX

def fl_filename_name(*args):
  """fl_filename_name(char arg0) -> char"""
  return _fltk.fl_filename_name(*args)

def fl_filename_ext(*args):
  """fl_filename_ext(char arg0) -> char"""
  return _fltk.fl_filename_ext(*args)

def fl_filename_match(*args):
  """fl_filename_match(char name, char pattern) -> int"""
  return _fltk.fl_filename_match(*args)

def fl_filename_isdir(*args):
  """fl_filename_isdir(char name) -> int"""
  return _fltk.fl_filename_isdir(*args)

def fl_open_uri(*args):
  """fl_open_uri(char uri, char msg = (char *) 0, int msglen = 0) -> int"""
  return _fltk.fl_open_uri(*args)

def _fl_filename_isdir_quick(*args):
  """_fl_filename_isdir_quick(char name) -> int"""
  return _fltk._fl_filename_isdir_quick(*args)
class Fl_Valuator(Fl_Widget):
    """
    The Fl_Valuator class controls a single floating-point value and provides 
    a consistent interface to set the value, range, and step, and insures that 
    callbacks are done the same for every object.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def bounds(self, *args):
        """bounds(self, double a, double b)"""
        return _fltk.Fl_Valuator_bounds(self, *args)

    def minimum(self, *args):
        """
        minimum(self) -> double
        minimum(self, double a)
        """
        return _fltk.Fl_Valuator_minimum(self, *args)

    def maximum(self, *args):
        """
        maximum(self) -> double
        maximum(self, double a)
        """
        return _fltk.Fl_Valuator_maximum(self, *args)

    def range(self, *args):
        """range(self, double a, double b)"""
        return _fltk.Fl_Valuator_range(self, *args)

    def step(self, *args):
        """
        step(self, int a)
        step(self, double a, int b)
        step(self, double s)
        step(self) -> double
        """
        return _fltk.Fl_Valuator_step(self, *args)

    def precision(self, *args):
        """precision(self, int arg0)"""
        return _fltk.Fl_Valuator_precision(self, *args)

    def value(self, *args):
        """
        value(self) -> double
        value(self, double arg0) -> int
        """
        return _fltk.Fl_Valuator_value(self, *args)

    def format(self, *args):
        """format(self, char format_string) -> int"""
        return _fltk.Fl_Valuator_format(self, *args)

    def round(self, *args):
        """round(self, double arg0) -> double"""
        return _fltk.Fl_Valuator_round(self, *args)

    def clamp(self, *args):
        """clamp(self, double arg0) -> double"""
        return _fltk.Fl_Valuator_clamp(self, *args)

    def increment(self, *args):
        """increment(self, double arg0, int arg1) -> double"""
        return _fltk.Fl_Valuator_increment(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Valuator
    __del__ = lambda self : None;
Fl_Valuator_swigregister = _fltk.Fl_Valuator_swigregister
Fl_Valuator_swigregister(Fl_Valuator)
pyFLTK_registerDoIdle = _fltk.pyFLTK_registerDoIdle
Fl_add_timeout = _fltk.Fl_add_timeout
Fl_repeat_timeout = _fltk.Fl_repeat_timeout
Fl_remove_timeout = _fltk.Fl_remove_timeout
Fl_add_fd = _fltk.Fl_add_fd
Fl_remove_fd = _fltk.Fl_remove_fd
Fl_add_handler = _fltk.Fl_add_handler
Fl_remove_handler = _fltk.Fl_remove_handler
Fl_add_check = _fltk.Fl_add_check
Fl_remove_check = _fltk.Fl_remove_check

def fl_rgb_color(*args):
  """
    fl_rgb_color(uchar r, uchar g, uchar b) -> Fl_Color
    fl_rgb_color(uchar g) -> Fl_Color
    """
  return _fltk.fl_rgb_color(*args)

def fl_filename_setext(*args):
  """
    fl_filename_setext(char to, int tolen, char ext) -> char
    fl_filename_setext(char to, char ext) -> char
    """
  return _fltk.fl_filename_setext(*args)

def fl_filename_expand(*args):
  """
    fl_filename_expand(char to, int tolen, char _from) -> int
    fl_filename_expand(char to, char _from) -> int
    """
  return _fltk.fl_filename_expand(*args)

def fl_filename_absolute(*args):
  """
    fl_filename_absolute(char to, int tolen, char _from) -> int
    fl_filename_absolute(char to, char _from) -> int
    """
  return _fltk.fl_filename_absolute(*args)

def fl_filename_relative(*args):
  """
    fl_filename_relative(char to, int tolen, char _from) -> int
    fl_filename_relative(char to, char _from) -> int
    """
  return _fltk.fl_filename_relative(*args)

FL_VERTICAL=0
FL_HORIZONTAL=1

class Fl_Adjuster(Fl_Valuator):
    """
    The Fl_Adjuster widget has proven to be very useful for values that need a 
    was stolen from Prisms, and large dynamic range.
    When you press a button and drag to the right the value increases. When you 
    drag to the left it decreases. The largest button adjusts by 100 * step(), 
    the next by 10 * step() and that smallest button by step(). Clicking on the 
    buttons increments by 10 times the amount dragging by a pixel does. 
    Shift + click decrements by 10 times the amount. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Adjuster_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Adjuster_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Adjuster"""
        if self.__class__ == Fl_Adjuster:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Adjuster(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def soft(self, *args):
        """
        soft(self, int s)
        soft(self) -> int
        """
        return _fltk.Fl_Adjuster_soft(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Adjuster
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Adjuster(self)
        return weakref_proxy(self)
Fl_Adjuster_swigregister = _fltk.Fl_Adjuster_swigregister
Fl_Adjuster_swigregister(Fl_Adjuster)

FL_BEEP_DEFAULT = _fltk.FL_BEEP_DEFAULT
FL_BEEP_MESSAGE = _fltk.FL_BEEP_MESSAGE
FL_BEEP_ERROR = _fltk.FL_BEEP_ERROR
FL_BEEP_QUESTION = _fltk.FL_BEEP_QUESTION
FL_BEEP_PASSWORD = _fltk.FL_BEEP_PASSWORD
FL_BEEP_NOTIFICATION = _fltk.FL_BEEP_NOTIFICATION

def fl_beep(*args):
  """fl_beep(int type = FL_BEEP_DEFAULT)"""
  return _fltk.fl_beep(*args)

def fl_message(*args):
  """fl_message(char arg0, v(...) *args)"""
  return _fltk.fl_message(*args)

def fl_alert(*args):
  """fl_alert(char arg0, v(...) *args)"""
  return _fltk.fl_alert(*args)

def fl_ask(*args):
  """fl_ask(char arg0, v(...) *args) -> int"""
  return _fltk.fl_ask(*args)

def fl_choice(*args):
  """fl_choice(char q, char b0, char b1, char b2, v(...) *args) -> int"""
  return _fltk.fl_choice(*args)

def fl_message_icon(*args):
  """fl_message_icon() -> Fl_Widget"""
  return _fltk.fl_message_icon(*args)

def fl_message_font(*args):
  """fl_message_font(unsigned char f, unsigned char s)"""
  return _fltk.fl_message_font(*args)

def fl_input(*args):
  """fl_input(char label, char deflt = None) -> char"""
  return _fltk.fl_input(*args)

def fl_password(*args):
  """fl_password(char label, char deflt = None) -> char"""
  return _fltk.fl_password(*args)

def fl_no_get(*args):
  """fl_no_get() -> char"""
  return _fltk.fl_no_get(*args)

def fl_yes_get(*args):
  """fl_yes_get() -> char"""
  return _fltk.fl_yes_get(*args)

def fl_ok_get(*args):
  """fl_ok_get() -> char"""
  return _fltk.fl_ok_get(*args)

def fl_cancel_get(*args):
  """fl_cancel_get() -> char"""
  return _fltk.fl_cancel_get(*args)

def fl_close_get(*args):
  """fl_close_get() -> char"""
  return _fltk.fl_close_get(*args)

def fl_no_set(*args):
  """fl_no_set(char value)"""
  return _fltk.fl_no_set(*args)

def fl_yes_set(*args):
  """fl_yes_set(char value)"""
  return _fltk.fl_yes_set(*args)

def fl_ok_set(*args):
  """fl_ok_set(char value)"""
  return _fltk.fl_ok_set(*args)

def fl_cancel_set(*args):
  """fl_cancel_set(char value)"""
  return _fltk.fl_cancel_set(*args)

def fl_close_set(*args):
  """fl_close_set(char value)"""
  return _fltk.fl_close_set(*args)

def fl_mt_message(*args):
  """fl_mt_message(char text)"""
  return _fltk.fl_mt_message(*args)

def fl_mt_alert(*args):
  """fl_mt_alert(char text)"""
  return _fltk.fl_mt_alert(*args)

def fl_mt_ask(*args):
  """fl_mt_ask(char text) -> int"""
  return _fltk.fl_mt_ask(*args)

def fl_mt_choice(*args):
  """fl_mt_choice(char q, char b0, char b1, char b2) -> int"""
  return _fltk.fl_mt_choice(*args)

def fl_mt_input(*args):
  """fl_mt_input(char label, char deflt = None) -> char"""
  return _fltk.fl_mt_input(*args)

def fl_mt_password(*args):
  """fl_mt_password(char label, char deflt = None) -> char"""
  return _fltk.fl_mt_password(*args)
class Fl_Image(object):
    """
    Fl_Image is the base class used for caching and drawing all kinds of images 
    in FLTK. This class keeps track of common image data such as the pixels, 
    colormap, width, height, and depth. Virtual methods are used to provide 
    type-specific image handling.

    Since the Fl_Image class does not support image drawing by itself, calling 
    the draw() method results in a box with an X in it being drawn instead.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def w(self, *args):
        """w(self) -> int"""
        return _fltk.Fl_Image_w(self, *args)

    def h(self, *args):
        """h(self) -> int"""
        return _fltk.Fl_Image_h(self, *args)

    def d(self, *args):
        """d(self) -> int"""
        return _fltk.Fl_Image_d(self, *args)

    def ld(self, *args):
        """ld(self) -> int"""
        return _fltk.Fl_Image_ld(self, *args)

    def count(self, *args):
        """count(self) -> int"""
        return _fltk.Fl_Image_count(self, *args)

    def data(self, *args):
        """data(self) -> char"""
        return _fltk.Fl_Image_data(self, *args)

    def __init__(self, *args): 
        """__init__(self, int W, int H, int D) -> Fl_Image"""
        if self.__class__ == Fl_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Image
    __del__ = lambda self : None;
    def copy(self, *args):
        """
        copy(self, int W, int H) -> Fl_Image
        copy(self) -> Fl_Image
        """
        return _fltk.Fl_Image_copy(self, *args)

    def color_average(self, *args):
        """color_average(self, Fl_Color c, float i)"""
        return _fltk.Fl_Image_color_average(self, *args)

    def inactive(self, *args):
        """inactive(self)"""
        return _fltk.Fl_Image_inactive(self, *args)

    def desaturate(self, *args):
        """desaturate(self)"""
        return _fltk.Fl_Image_desaturate(self, *args)

    def label(self, *args):
        """
        label(self, Fl_Widget w)
        label(self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Image_label(self, *args)

    def draw(self, *args):
        """
        draw(self, int X, int Y, int W, int H, int cx = 0, int cy = 0)
        draw(self, int X, int Y)
        """
        return _fltk.Fl_Image_draw(self, *args)

    def uncache(self, *args):
        """uncache(self)"""
        return _fltk.Fl_Image_uncache(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Image(self)
        return weakref_proxy(self)
Fl_Image_swigregister = _fltk.Fl_Image_swigregister
Fl_Image_swigregister(Fl_Image)

class Fl_RGB_Image(Fl_Image):
    """Proxy of C++ Fl_RGB_Image class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, uchar bits, int W, int H, int D = 3, int LD = 0) -> Fl_RGB_Image"""
        if self.__class__ == Fl_RGB_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_RGB_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_RGB_Image
    __del__ = lambda self : None;
    def copy(self, *args):
        """
        copy(self, int W, int H) -> Fl_Image
        copy(self) -> Fl_Image
        """
        return _fltk.Fl_RGB_Image_copy(self, *args)

    def color_average(self, *args):
        """color_average(self, Fl_Color c, float i)"""
        return _fltk.Fl_RGB_Image_color_average(self, *args)

    def desaturate(self, *args):
        """desaturate(self)"""
        return _fltk.Fl_RGB_Image_desaturate(self, *args)

    def draw(self, *args):
        """
        draw(self, int X, int Y, int W, int H, int cx = 0, int cy = 0)
        draw(self, int X, int Y)
        """
        return _fltk.Fl_RGB_Image_draw(self, *args)

    def label(self, *args):
        """
        label(self, Fl_Widget w)
        label(self, Fl_Menu_Item m)
        """
        return _fltk.Fl_RGB_Image_label(self, *args)

    def uncache(self, *args):
        """uncache(self)"""
        return _fltk.Fl_RGB_Image_uncache(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_RGB_Image(self)
        return weakref_proxy(self)
Fl_RGB_Image_swigregister = _fltk.Fl_RGB_Image_swigregister
Fl_RGB_Image_swigregister(Fl_RGB_Image)

class Fl_Bitmap(Fl_Image):
    """
    The Fl_Bitmap class supports caching and drawing of mono-color 
    (bitmap) images. Images are drawn using the current color.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, uchar bits, int W, int H) -> Fl_Bitmap"""
        if self.__class__ == Fl_Bitmap:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Bitmap(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Bitmap
    __del__ = lambda self : None;
    def copy(self, *args):
        """
        copy(self, int W, int H) -> Fl_Image
        copy(self) -> Fl_Image
        """
        return _fltk.Fl_Bitmap_copy(self, *args)

    def draw(self, *args):
        """
        draw(self, int X, int Y, int W, int H, int cx = 0, int cy = 0)
        draw(self, int X, int Y)
        """
        return _fltk.Fl_Bitmap_draw(self, *args)

    def label(self, *args):
        """
        label(self, Fl_Widget w)
        label(self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Bitmap_label(self, *args)

    def uncache(self, *args):
        """uncache(self)"""
        return _fltk.Fl_Bitmap_uncache(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Bitmap(self)
        return weakref_proxy(self)
Fl_Bitmap_swigregister = _fltk.Fl_Bitmap_swigregister
Fl_Bitmap_swigregister(Fl_Bitmap)

class Fl_BMP_Image(Fl_RGB_Image):
    """
    The Fl_BMP_Image class supports loading, caching, and drawing of 
    Windows Bitmap (BMP) image files.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char filename) -> Fl_BMP_Image"""
        if self.__class__ == Fl_BMP_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_BMP_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_BMP_Image
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_BMP_Image(self)
        return weakref_proxy(self)
Fl_BMP_Image_swigregister = _fltk.Fl_BMP_Image_swigregister
Fl_BMP_Image_swigregister(Fl_BMP_Image)

class Fl_Box(Fl_Widget):
    """
    This widget simply draws its box, and possibly it's label. 
    Putting it before some other widgets and making it big enough 
    to surround them will let you draw a frame around them.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Box_draw(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Box
        __init__(self, Fl_Boxtype b, int X, int Y, int W, int H, char l) -> Fl_Box
        """
        if self.__class__ == Fl_Box:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Box(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Box_handle(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Box
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Box(self)
        return weakref_proxy(self)
Fl_Box_swigregister = _fltk.Fl_Box_swigregister
Fl_Box_swigregister(Fl_Box)

FL_NORMAL_BUTTON = _fltk.FL_NORMAL_BUTTON
FL_TOGGLE_BUTTON = _fltk.FL_TOGGLE_BUTTON
FL_RADIO_BUTTON = _fltk.FL_RADIO_BUTTON
FL_HIDDEN_BUTTON = _fltk.FL_HIDDEN_BUTTON

def fl_old_shortcut(*args):
  """fl_old_shortcut(char arg0) -> int"""
  return _fltk.fl_old_shortcut(*args)
class Fl_Button(Fl_Widget):
    """
    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type()  and when().

    Buttons can also generate callbacks in response to FL_SHORTCUT events. The 
    button can either have an explicit shortcut() value or a letter shortcut 
    can be indicated in the label() with an '&' character before it. For the 
    label shortcut it does not matter if Alt is held down, but if you have an 
    input field in the same window, the user will have to hold down the Alt key 
    so that the input field does not eat the event first as an FL_KEYBOARD event. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Button_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Button_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Button"""
        if self.__class__ == Fl_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def value(self, *args):
        """
        value(self, int arg0) -> int
        value(self) -> char
        """
        return _fltk.Fl_Button_value(self, *args)

    def set(self, *args):
        """set(self) -> int"""
        return _fltk.Fl_Button_set(self, *args)

    def clear(self, *args):
        """clear(self) -> int"""
        return _fltk.Fl_Button_clear(self, *args)

    def setonly(self, *args):
        """setonly(self)"""
        return _fltk.Fl_Button_setonly(self, *args)

    def down_box(self, *args):
        """
        down_box(self) -> Fl_Boxtype
        down_box(self, Fl_Boxtype b)
        """
        return _fltk.Fl_Button_down_box(self, *args)

    def shortcut(self, *args):
        """
        shortcut(self) -> int
        shortcut(self, int s)
        shortcut(self, char s)
        """
        return _fltk.Fl_Button_shortcut(self, *args)

    def down_color(self, *args):
        """
        down_color(self) -> Fl_Color
        down_color(self, unsigned int c)
        """
        return _fltk.Fl_Button_down_color(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Button(self)
        return weakref_proxy(self)
Fl_Button_swigregister = _fltk.Fl_Button_swigregister
Fl_Button_swigregister(Fl_Button)

FL_BAR_CHART = _fltk.FL_BAR_CHART
FL_HORBAR_CHART = _fltk.FL_HORBAR_CHART
FL_LINE_CHART = _fltk.FL_LINE_CHART
FL_FILL_CHART = _fltk.FL_FILL_CHART
FL_SPIKE_CHART = _fltk.FL_SPIKE_CHART
FL_PIE_CHART = _fltk.FL_PIE_CHART
FL_SPECIALPIE_CHART = _fltk.FL_SPECIALPIE_CHART
FL_FILLED_CHART = _fltk.FL_FILLED_CHART
FL_CHART_MAX = _fltk.FL_CHART_MAX
FL_CHART_LABEL_MAX = _fltk.FL_CHART_LABEL_MAX
class FL_CHART_ENTRY(object):
    """Proxy of C++ FL_CHART_ENTRY class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> FL_CHART_ENTRY"""
        this = _fltk.new_FL_CHART_ENTRY(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_FL_CHART_ENTRY
    __del__ = lambda self : None;
FL_CHART_ENTRY_swigregister = _fltk.FL_CHART_ENTRY_swigregister
FL_CHART_ENTRY_swigregister(FL_CHART_ENTRY)

class Fl_Chart(Fl_Widget):
    """
    This widget displays simple charts and is provided for Forms compatibility.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Chart_draw(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Chart"""
        if self.__class__ == Fl_Chart:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Chart(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Chart
    __del__ = lambda self : None;
    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_Chart_clear(self, *args)

    def add(self, *args):
        """add(self, double arg0, char arg1 = None, unsigned int arg2 = 0)"""
        return _fltk.Fl_Chart_add(self, *args)

    def insert(self, *args):
        """insert(self, int arg0, double arg1, char arg2 = None, unsigned int arg3 = 0)"""
        return _fltk.Fl_Chart_insert(self, *args)

    def replace(self, *args):
        """replace(self, int arg0, double arg1, char arg2 = None, unsigned int arg3 = 0)"""
        return _fltk.Fl_Chart_replace(self, *args)

    def bounds(self, *args):
        """
        bounds(self, double a, double b)
        bounds(self, double a, double b)
        """
        return _fltk.Fl_Chart_bounds(self, *args)

    def size(self, *args):
        """
        size(self) -> int
        size(self, int W, int H)
        """
        return _fltk.Fl_Chart_size(self, *args)

    def maxsize(self, *args):
        """
        maxsize(self) -> int
        maxsize(self, int arg0)
        """
        return _fltk.Fl_Chart_maxsize(self, *args)

    def textfont(self, *args):
        """
        textfont(self) -> Fl_Font
        textfont(self, uchar s)
        """
        return _fltk.Fl_Chart_textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_Chart_textsize(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, unsigned int n)
        """
        return _fltk.Fl_Chart_textcolor(self, *args)

    def autosize(self, *args):
        """
        autosize(self) -> uchar
        autosize(self, uchar n)
        """
        return _fltk.Fl_Chart_autosize(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Chart(self)
        return weakref_proxy(self)
Fl_Chart_swigregister = _fltk.Fl_Chart_swigregister
Fl_Chart_swigregister(Fl_Chart)

class Fl_Check_Browser(Fl_Browser_):
    """
    The Fl_Check_Browser widget displays a scrolling list of text lines that may be selected and/or checked by the user.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Check_Browser"""
        if self.__class__ == Fl_Check_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Check_Browser(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Check_Browser
    __del__ = lambda self : None;
    def remove(self, *args):
        """remove(self, int item) -> int"""
        val = _fltk.Fl_Check_Browser_remove(self, *args)
        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val

    def add(self, *args):
        """
        add(self, char s) -> int
        add(self, char s, int b) -> int
        """
        val = _fltk.Fl_Check_Browser_add(self, *args)
        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val

    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_Check_Browser_clear(self, *args)

    def nitems(self, *args):
        """nitems(self) -> int"""
        return _fltk.Fl_Check_Browser_nitems(self, *args)

    def nchecked(self, *args):
        """nchecked(self) -> int"""
        return _fltk.Fl_Check_Browser_nchecked(self, *args)

    def checked(self, *args):
        """
        checked(self, int item) -> int
        checked(self, int item, int b)
        """
        return _fltk.Fl_Check_Browser_checked(self, *args)

    def set_checked(self, *args):
        """set_checked(self, int item)"""
        return _fltk.Fl_Check_Browser_set_checked(self, *args)

    def check_all(self, *args):
        """check_all(self)"""
        return _fltk.Fl_Check_Browser_check_all(self, *args)

    def check_none(self, *args):
        """check_none(self)"""
        return _fltk.Fl_Check_Browser_check_none(self, *args)

    def value(self, *args):
        """value(self) -> int"""
        return _fltk.Fl_Check_Browser_value(self, *args)

    def text(self, *args):
        """text(self, int item) -> char"""
        return _fltk.Fl_Check_Browser_text(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Check_Browser_handle(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Check_Browser(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Check_Browser_draw(self, *args)

    def item_first(self, *args):
        """item_first(self) -> void"""
        return _fltk.Fl_Check_Browser_item_first(self, *args)

    def item_next(self, *args):
        """item_next(self, void arg0) -> void"""
        return _fltk.Fl_Check_Browser_item_next(self, *args)

    def item_prev(self, *args):
        """item_prev(self, void arg0) -> void"""
        return _fltk.Fl_Check_Browser_item_prev(self, *args)

    def item_height(self, *args):
        """item_height(self, void arg0) -> int"""
        return _fltk.Fl_Check_Browser_item_height(self, *args)

    def item_width(self, *args):
        """item_width(self, void arg0) -> int"""
        return _fltk.Fl_Check_Browser_item_width(self, *args)

    def item_quick_height(self, *args):
        """item_quick_height(self, void arg0) -> int"""
        return _fltk.Fl_Check_Browser_item_quick_height(self, *args)

    def item_draw(self, *args):
        """item_draw(self, void arg0, int arg1, int arg2, int arg3, int arg4)"""
        return _fltk.Fl_Check_Browser_item_draw(self, *args)

    def full_width(self, *args):
        """full_width(self) -> int"""
        return _fltk.Fl_Check_Browser_full_width(self, *args)

    def full_height(self, *args):
        """full_height(self) -> int"""
        return _fltk.Fl_Check_Browser_full_height(self, *args)

    def incr_height(self, *args):
        """incr_height(self) -> int"""
        return _fltk.Fl_Check_Browser_incr_height(self, *args)

    def item_select(self, *args):
        """item_select(self, void arg0, int arg1 = 1)"""
        return _fltk.Fl_Check_Browser_item_select(self, *args)

    def item_selected(self, *args):
        """item_selected(self, void arg0) -> int"""
        return _fltk.Fl_Check_Browser_item_selected(self, *args)

Fl_Check_Browser_swigregister = _fltk.Fl_Check_Browser_swigregister
Fl_Check_Browser_swigregister(Fl_Check_Browser)

class Fl_Light_Button(Fl_Button):
    """
    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type() and when().

    The Fl_Light_Button subclass display the 'on' state by turning on a light, 
    rather than drawing pushed in. The shape of the 'light' is initially set 
    to FL_DOWN_BOX. The color of the light when on is controlled with 
    selection_color(), which defaults to FL_YELLOW.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Light_Button_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Light_Button_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Light_Button"""
        if self.__class__ == Fl_Light_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Light_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Light_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Light_Button(self)
        return weakref_proxy(self)
Fl_Light_Button_swigregister = _fltk.Fl_Light_Button_swigregister
Fl_Light_Button_swigregister(Fl_Light_Button)

class Fl_Check_Button(Fl_Light_Button):
    """
    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type() and when().

    The Fl_Check_Button subclass display the 'on' state by turning on a light, 
    rather than drawing pushed in. The shape of the 'light' is initially set to 
    FL_DIAMOND_DOWN_BOX. The color of the light when on is controlled with 
    selection_color(), which defaults to FL_RED.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Check_Button"""
        if self.__class__ == Fl_Check_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Check_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Check_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Check_Button(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Check_Button_draw(self, *args)

Fl_Check_Button_swigregister = _fltk.Fl_Check_Button_swigregister
Fl_Check_Button_swigregister(Fl_Check_Button)

class Fl_Menu_(Fl_Widget):
    """
    All widgets that have a menu in FLTK are subclassed off of this class. 
    Currently FLTK provides you with Fl_Menu_Button, Fl_Menu_Bar, and Fl_Choice .

    The class contains a pointer to an array of structures of type Fl_Menu_Item. 
    The array may either be supplied directly by the user program, or it may be 
    'private': a dynamically allocated array managed by the Fl_Menu_. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Menu_"""
        if self.__class__ == Fl_Menu_:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Menu_(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Menu_
    __del__ = lambda self : None;
    def item_pathname(self, *args):
        """item_pathname(self, char name, int namelen, Fl_Menu_Item finditem = None) -> int"""
        return _fltk.Fl_Menu__item_pathname(self, *args)

    def picked(self, *args):
        """picked(self, Fl_Menu_Item arg0) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__picked(self, *args)

    def find_item(self, *args):
        """find_item(self, char name) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__find_item(self, *args)

    def test_shortcut(self, *args):
        """test_shortcut(self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__test_shortcut(self, *args)

    def size(self, *args):
        """
        size(self) -> int
        size(self, int W, int H)
        """
        return _fltk.Fl_Menu__size(self, *args)

    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_Menu__clear(self, *args)

    def replace(self, *args):
        """replace(self, int arg0, char arg1)"""
        return _fltk.Fl_Menu__replace(self, *args)

    def remove(self, *args):
        """remove(self, int arg0)"""
        return _fltk.Fl_Menu__remove(self, *args)

    def shortcut(self, *args):
        """shortcut(self, int i, int s)"""
        return _fltk.Fl_Menu__shortcut(self, *args)

    def mode(self, *args):
        """
        mode(self, int i, int fl)
        mode(self, int i) -> int
        """
        return _fltk.Fl_Menu__mode(self, *args)

    def mvalue(self, *args):
        """mvalue(self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu__mvalue(self, *args)

    def value(self, *args):
        """
        value(self) -> int
        value(self, int i) -> int
        """
        return _fltk.Fl_Menu__value(self, *args)

    def text(self, *args):
        """
        text(self) -> char
        text(self, int i) -> char
        """
        return _fltk.Fl_Menu__text(self, *args)

    def textfont(self, *args):
        """
        textfont(self) -> Fl_Font
        textfont(self, uchar c)
        """
        return _fltk.Fl_Menu__textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar c)
        """
        return _fltk.Fl_Menu__textsize(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, unsigned int c)
        """
        return _fltk.Fl_Menu__textcolor(self, *args)

    def down_box(self, *args):
        """
        down_box(self) -> Fl_Boxtype
        down_box(self, Fl_Boxtype b)
        """
        return _fltk.Fl_Menu__down_box(self, *args)

    def down_color(self, *args):
        """
        down_color(self) -> Fl_Color
        down_color(self, unsigned int c)
        """
        return _fltk.Fl_Menu__down_color(self, *args)

    def copy(self, *args):
        """
        copy(self, Fl_Menu_Item m, void user_data = None)
        copy(self, PyObject args, PyObject user_data = None)
        """
        return _fltk.Fl_Menu__copy(self, *args)

    def add(self, *args):
        """
        add(self, char arg0, int shortcut, Fl_Callback arg2, void arg3 = None, 
            int arg4 = 0) -> int
        add(self, char arg0) -> int
        add(self, PyObject lObj, PyObject sObj, PyObject cObj, PyObject uObj = None, 
            PyObject fObj = None) -> int
        """
        return _fltk.Fl_Menu__add(self, *args)

    def menu(self, *args):
        """
        menu(self) -> Fl_Menu_Item
        menu(self, PyObject args)
        menu(self) -> PyObject
        """
        return _fltk.Fl_Menu__menu(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_(self)
        return weakref_proxy(self)
Fl_Menu__swigregister = _fltk.Fl_Menu__swigregister
Fl_Menu__swigregister(Fl_Menu_)

class Fl_Choice(Fl_Menu_):
    """
    This is a button that when pushed pops up a menu (or hierarchy of menus) 
    defined by an array of Fl_Menu_Item objects. Motif calls this an OptionButton.

    The only difference between this and a Fl_Menu_Button is that the name of 
    the most recent chosen menu item is displayed inside the box, while the 
    label is displayed outside the box. However, since the use of this is most 
    often to control a single variable rather than do individual callbacks, some 
    of the Fl_Menu_Button methods are redescribed here in those terms.

    When the user picks an item off the menu the value() is set to that item and 
    then the item's callback is done with the menu_button as the Fl_Widget 
    argument. If the item does not have a callback the menu_button's callback is 
    done instead.

    All three mouse buttons pop up the menu. The Forms behavior of the first two 
    buttons to increment/decrement the choice is not implemented. This could be 
    added with a subclass, however.

    The menu will also pop up in response to shortcuts indicated by putting a '&' 
    character in the label(). See Fl_Button for a description of this.

    Typing the shortcut() of any of the items will do exactly the same as when 
    you pick the item with the mouse. The '&' character in item names are only 
    looked at when the menu is popped up, however. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Choice_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Choice_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Choice"""
        if self.__class__ == Fl_Choice:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Choice(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def value(self, *args):
        """
        value(self, int i) -> int
        value(self) -> int
        """
        return _fltk.Fl_Choice_value(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Choice
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Choice(self)
        return weakref_proxy(self)
Fl_Choice_swigregister = _fltk.Fl_Choice_swigregister
Fl_Choice_swigregister(Fl_Choice)

FL_SQUARE_CLOCK = _fltk.FL_SQUARE_CLOCK
FL_ROUND_CLOCK = _fltk.FL_ROUND_CLOCK
FL_ANALOG_CLOCK = _fltk.FL_ANALOG_CLOCK
FL_DIGITAL_CLOCK = _fltk.FL_DIGITAL_CLOCK
class Fl_Clock_Output(Fl_Widget):
    """Proxy of C++ Fl_Clock_Output class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Clock_Output_draw(self, *args)

    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Clock_Output"""
        if self.__class__ == Fl_Clock_Output:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Clock_Output(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def value(self, *args):
        """
        value(self, ulong v)
        value(self, int arg0, int arg1, int arg2)
        value(self) -> ulong
        """
        return _fltk.Fl_Clock_Output_value(self, *args)

    def hour(self, *args):
        """hour(self) -> int"""
        return _fltk.Fl_Clock_Output_hour(self, *args)

    def minute(self, *args):
        """minute(self) -> int"""
        return _fltk.Fl_Clock_Output_minute(self, *args)

    def second(self, *args):
        """second(self) -> int"""
        return _fltk.Fl_Clock_Output_second(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Clock_Output
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Clock_Output(self)
        return weakref_proxy(self)
Fl_Clock_Output_swigregister = _fltk.Fl_Clock_Output_swigregister
Fl_Clock_Output_swigregister(Fl_Clock_Output)

class Fl_Clock(Fl_Clock_Output):
    """
    This widget provides a round analog clock display and is provided for Forms 
    compatibility. It installs a 1-second timeout callback using Fl.add_timeout().

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Clock_handle(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, int x, int y, int w, int h, char l = None) -> Fl_Clock
        __init__(self, uchar t, int x, int y, int w, int h, char l) -> Fl_Clock
        """
        if self.__class__ == Fl_Clock:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Clock(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Clock
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Clock(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Clock_draw(self, *args)

Fl_Clock_swigregister = _fltk.Fl_Clock_swigregister
Fl_Clock_swigregister(Fl_Clock)

class Fl_Value_Input(Fl_Valuator):
    """
    The Fl_Value_Input widget displays a numeric value. The user can click in 
    the text field and edit it - there is in fact a hidden Fl_Input widget with 
    type(FL_FLOAT_INPUT) or type(FL_INT_INPUT) in there - and when they hit 
    return or tab the value updates to what they typed and the callback is done.

    If step() is non-zero, the user can also drag the mouse across the object 
    and thus slide the value. The left button moves one step() per pixel, the 
    middle by 10 * step(), and the right button by 100 * step(). It is therefore 
    impossible to select text by dragging across it, although clicking can still 
    move the insertion cursor.

    If step() is non-zero and integral, then the range of numbers are limited 
    to integers instead of floating point values. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Value_Input_handle(self, *args)

    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Value_Input_draw(self, *args)

    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Value_Input_resize(self, *args)

    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Value_Input"""
        if self.__class__ == Fl_Value_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Value_Input(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def soft(self, *args):
        """
        soft(self, char s)
        soft(self) -> char
        """
        return _fltk.Fl_Value_Input_soft(self, *args)

    def textfont(self, *args):
        """
        textfont(self) -> Fl_Font
        textfont(self, uchar s)
        """
        return _fltk.Fl_Value_Input_textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_Value_Input_textsize(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, unsigned int n)
        """
        return _fltk.Fl_Value_Input_textcolor(self, *args)

    def cursor_color(self, *args):
        """
        cursor_color(self) -> Fl_Color
        cursor_color(self, unsigned int n)
        """
        return _fltk.Fl_Value_Input_cursor_color(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Value_Input
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Value_Input(self)
        return weakref_proxy(self)
Fl_Value_Input_swigregister = _fltk.Fl_Value_Input_swigregister
Fl_Value_Input_swigregister(Fl_Value_Input)

class Flcc_HueBox(Fl_Widget):
    """Proxy of C++ Flcc_HueBox class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Flcc_HueBox_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Flcc_HueBox_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H) -> Flcc_HueBox"""
        if self.__class__ == Flcc_HueBox:
            _self = None
        else:
            _self = self
        this = _fltk.new_Flcc_HueBox(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Flcc_HueBox
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Flcc_HueBox(self)
        return weakref_proxy(self)
Flcc_HueBox_swigregister = _fltk.Flcc_HueBox_swigregister
Flcc_HueBox_swigregister(Flcc_HueBox)

class Flcc_ValueBox(Fl_Widget):
    """Proxy of C++ Flcc_ValueBox class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Flcc_ValueBox_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Flcc_ValueBox_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H) -> Flcc_ValueBox"""
        if self.__class__ == Flcc_ValueBox:
            _self = None
        else:
            _self = self
        this = _fltk.new_Flcc_ValueBox(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Flcc_ValueBox
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Flcc_ValueBox(self)
        return weakref_proxy(self)
Flcc_ValueBox_swigregister = _fltk.Flcc_ValueBox_swigregister
Flcc_ValueBox_swigregister(Flcc_ValueBox)

class Flcc_Value_Input(Fl_Value_Input):
    """Proxy of C++ Flcc_Value_Input class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def format(self, *args):
        """format(self, char arg0) -> int"""
        return _fltk.Flcc_Value_Input_format(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H) -> Flcc_Value_Input"""
        if self.__class__ == Flcc_Value_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Flcc_Value_Input(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Flcc_Value_Input
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Flcc_Value_Input(self)
        return weakref_proxy(self)
Flcc_Value_Input_swigregister = _fltk.Flcc_Value_Input_swigregister
Flcc_Value_Input_swigregister(Flcc_Value_Input)

class Fl_Color_Chooser(Fl_Group):
    """
    The Fl_Color_Chooser widget provides a standard RGB color chooser. You can 
    place any number of these into a panel of your own design. This widget 
    contains the hue box, value slider, and rgb input fields from the above 
    diagram (it does not have the color chips or the Cancel or OK buttons). The 
    callback is done every time the user changes the rgb value. It is not done 
    if they move the hue control in a way that produces the same rgb value, such 
    as when saturation or value is zero.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def mode(self, *args):
        """mode(self) -> int"""
        return _fltk.Fl_Color_Chooser_mode(self, *args)

    def hue(self, *args):
        """hue(self) -> double"""
        return _fltk.Fl_Color_Chooser_hue(self, *args)

    def saturation(self, *args):
        """saturation(self) -> double"""
        return _fltk.Fl_Color_Chooser_saturation(self, *args)

    def value(self, *args):
        """value(self) -> double"""
        return _fltk.Fl_Color_Chooser_value(self, *args)

    def r(self, *args):
        """r(self) -> double"""
        return _fltk.Fl_Color_Chooser_r(self, *args)

    def g(self, *args):
        """g(self) -> double"""
        return _fltk.Fl_Color_Chooser_g(self, *args)

    def b(self, *args):
        """b(self) -> double"""
        return _fltk.Fl_Color_Chooser_b(self, *args)

    def hsv(self, *args):
        """hsv(self, double arg0, double arg1, double arg2) -> int"""
        return _fltk.Fl_Color_Chooser_hsv(self, *args)

    def rgb(self, *args):
        """rgb(self, double arg0, double arg1, double arg2) -> int"""
        return _fltk.Fl_Color_Chooser_rgb(self, *args)

    def hsv2rgb(*args):
        """
        hsv2rgb(double arg0, double arg1, double arg2, double arg3, 
            double arg4, double arg5)
        """
        return _fltk.Fl_Color_Chooser_hsv2rgb(*args)

    hsv2rgb = staticmethod(hsv2rgb)
    def rgb2hsv(*args):
        """
        rgb2hsv(double arg0, double arg1, double arg2, double arg3, 
            double arg4, double arg5)
        """
        return _fltk.Fl_Color_Chooser_rgb2hsv(*args)

    rgb2hsv = staticmethod(rgb2hsv)
    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Color_Chooser"""
        if self.__class__ == Fl_Color_Chooser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Color_Chooser(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Color_Chooser
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Color_Chooser(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Color_Chooser_draw(self, *args)

Fl_Color_Chooser_swigregister = _fltk.Fl_Color_Chooser_swigregister
Fl_Color_Chooser_swigregister(Fl_Color_Chooser)

def Fl_Color_Chooser_hsv2rgb(*args):
  """
    Fl_Color_Chooser_hsv2rgb(double arg0, double arg1, double arg2, double arg3, 
        double arg4, double arg5)
    """
  return _fltk.Fl_Color_Chooser_hsv2rgb(*args)

def Fl_Color_Chooser_rgb2hsv(*args):
  """
    Fl_Color_Chooser_rgb2hsv(double arg0, double arg1, double arg2, double arg3, 
        double arg4, double arg5)
    """
  return _fltk.Fl_Color_Chooser_rgb2hsv(*args)


def fl_color_chooser(*args):
  """fl_color_chooser(char name, uchar r, uchar g, uchar b) -> int"""
  return _fltk.fl_color_chooser(*args)
FL_NORMAL_COUNTER = _fltk.FL_NORMAL_COUNTER
FL_SIMPLE_COUNTER = _fltk.FL_SIMPLE_COUNTER
class Fl_Counter(Fl_Valuator):
    """
    The Fl_Counter widget is provided for forms compatibility. It controls a 
    single floating point value.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Counter_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Counter_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Counter"""
        if self.__class__ == Fl_Counter:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Counter(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Counter
    __del__ = lambda self : None;
    def lstep(self, *args):
        """lstep(self, double a)"""
        return _fltk.Fl_Counter_lstep(self, *args)

    def step(self, *args):
        """
        step(self, double a, double b)
        step(self, double a)
        """
        return _fltk.Fl_Counter_step(self, *args)

    def textfont(self, *args):
        """
        textfont(self) -> Fl_Font
        textfont(self, uchar s)
        """
        return _fltk.Fl_Counter_textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_Counter_textsize(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, unsigned int s)
        """
        return _fltk.Fl_Counter_textcolor(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Counter(self)
        return weakref_proxy(self)
Fl_Counter_swigregister = _fltk.Fl_Counter_swigregister
Fl_Counter_swigregister(Fl_Counter)

FL_NORMAL_DIAL = _fltk.FL_NORMAL_DIAL
FL_LINE_DIAL = _fltk.FL_LINE_DIAL
FL_FILL_DIAL = _fltk.FL_FILL_DIAL
class Fl_Dial(Fl_Valuator):
    """
    The Fl_Dial widget provides a circular dial to control a single floating 
    point value.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Dial_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Dial_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Dial"""
        if self.__class__ == Fl_Dial:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Dial(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def angle1(self, *args):
        """
        angle1(self) -> short
        angle1(self, short a)
        """
        return _fltk.Fl_Dial_angle1(self, *args)

    def angle2(self, *args):
        """
        angle2(self) -> short
        angle2(self, short a)
        """
        return _fltk.Fl_Dial_angle2(self, *args)

    def angles(self, *args):
        """angles(self, short a, short b)"""
        return _fltk.Fl_Dial_angles(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Dial
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Dial(self)
        return weakref_proxy(self)
Fl_Dial_swigregister = _fltk.Fl_Dial_swigregister
Fl_Dial_swigregister(Fl_Dial)

FL_WINDOW = _fltk.FL_WINDOW
FL_DOUBLE_WINDOW = _fltk.FL_DOUBLE_WINDOW
class Fl_Window(Fl_Group):
    """
    This widget produces an actual window. This can either be a main window, 
    with a border and title and all the window management controls, or a 
    'subwindow' inside a window. This is controlled by whether or not the 
    window has a parent().

    Once you create a window, you usually add children Fl_Widget 's to it by 
    using window->add(child) for each new widget. See Fl_Group for more 
    information on how to add and remove children.

    There are several subclasses of Fl_Window that provide double-buffering, 
    overlay, menu, and OpenGL support.

    The window's callback is done if the user tries to close a window using 
    the window manager and Fl.modal() is zero or equal to the window. Fl_Window 
    has a default callback that calls Fl_Window.hide(). 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Window_draw(self, *args)

    def flush(self, *args):
        """flush(self)"""
        return _fltk.Fl_Window_flush(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Window
        __init__(self, int arg0, int arg1, char arg2 = None) -> Fl_Window
        """
        if self.__class__ == Fl_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Window(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Window
    __del__ = lambda self : None;
    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Window_handle(self, *args)

    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Window_resize(self, *args)

    def clear_border(self, *args):
        """clear_border(self)"""
        return _fltk.Fl_Window_clear_border(self, *args)

    def border(self, *args):
        """
        border(self, int b)
        border(self) -> int
        """
        return _fltk.Fl_Window_border(self, *args)

    def set_override(self, *args):
        """set_override(self)"""
        return _fltk.Fl_Window_set_override(self, *args)

    def override(self, *args):
        """override(self) -> int"""
        return _fltk.Fl_Window_override(self, *args)

    def set_modal(self, *args):
        """set_modal(self)"""
        return _fltk.Fl_Window_set_modal(self, *args)

    def modal(self, *args):
        """modal(self) -> int"""
        return _fltk.Fl_Window_modal(self, *args)

    def set_non_modal(self, *args):
        """set_non_modal(self)"""
        return _fltk.Fl_Window_set_non_modal(self, *args)

    def non_modal(self, *args):
        """non_modal(self) -> int"""
        return _fltk.Fl_Window_non_modal(self, *args)

    def hotspot(self, *args):
        """
        hotspot(self, int x, int y, int offscreen = 0)
        hotspot(self, Fl_Widget arg0, int offscreen = 0)
        """
        return _fltk.Fl_Window_hotspot(self, *args)

    def free_position(self, *args):
        """free_position(self)"""
        return _fltk.Fl_Window_free_position(self, *args)

    def size_range(self, *args):
        """
        size_range(self, int a, int b, int c = 0, int d = 0, int e = 0, int f = 0, 
            int g = 0)
        """
        return _fltk.Fl_Window_size_range(self, *args)

    def iconlabel(self, *args):
        """
        iconlabel(self) -> char
        iconlabel(self, char arg0)
        """
        return _fltk.Fl_Window_iconlabel(self, *args)

    def label(self, *args):
        """
        label(self) -> char
        label(self, char arg0)
        label(self, char label, char iconlabel)
        """
        val = _fltk.Fl_Window_label(self, *args)
        if len(args) > 0:
            self.my_label = args[len(args)-1]


        return val

    def copy_label(self, *args):
        """copy_label(self, char a)"""
        return _fltk.Fl_Window_copy_label(self, *args)

    def xclass(self, *args):
        """
        xclass(self) -> char
        xclass(self, char c)
        """
        return _fltk.Fl_Window_xclass(self, *args)

    def icon(self, *args):
        """
        icon(self) -> void
        icon(self, void ic)
        """
        return _fltk.Fl_Window_icon(self, *args)

    def shown(self, *args):
        """shown(self) -> int"""
        return _fltk.Fl_Window_shown(self, *args)

    def hide(self, *args):
        """hide(self)"""
        return _fltk.Fl_Window_hide(self, *args)

    def fullscreen(self, *args):
        """fullscreen(self)"""
        return _fltk.Fl_Window_fullscreen(self, *args)

    def fullscreen_off(self, *args):
        """fullscreen_off(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Window_fullscreen_off(self, *args)

    def iconize(self, *args):
        """iconize(self)"""
        return _fltk.Fl_Window_iconize(self, *args)

    def x_root(self, *args):
        """x_root(self) -> int"""
        return _fltk.Fl_Window_x_root(self, *args)

    def y_root(self, *args):
        """y_root(self) -> int"""
        return _fltk.Fl_Window_y_root(self, *args)

    def current(*args):
        """current() -> Fl_Window"""
        return _fltk.Fl_Window_current(*args)

    current = staticmethod(current)
    def make_current(self, *args):
        """make_current(self)"""
        return _fltk.Fl_Window_make_current(self, *args)

    def cursor(self, *args):
        """cursor(self, Fl_Cursor arg0, Fl_Color arg1 = FL_BLACK, Fl_Color arg2 = FL_WHITE)"""
        return _fltk.Fl_Window_cursor(self, *args)

    def default_cursor(self, *args):
        """default_cursor(self, Fl_Cursor arg0, Fl_Color arg1 = FL_BLACK, Fl_Color arg2 = FL_WHITE)"""
        return _fltk.Fl_Window_default_cursor(self, *args)

    def default_callback(*args):
        """default_callback(Fl_Window arg0, void v)"""
        return _fltk.Fl_Window_default_callback(*args)

    default_callback = staticmethod(default_callback)
    def show(self, *args):
        """show(self, PyObject count = None, PyObject data = None)"""
        return _fltk.Fl_Window_show(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Window(self)
        return weakref_proxy(self)
Fl_Window_swigregister = _fltk.Fl_Window_swigregister
Fl_Window_swigregister(Fl_Window)

def Fl_Window_current(*args):
  """Fl_Window_current() -> Fl_Window"""
  return _fltk.Fl_Window_current(*args)

def Fl_Window_default_callback(*args):
  """Fl_Window_default_callback(Fl_Window arg0, void v)"""
  return _fltk.Fl_Window_default_callback(*args)

class Fl_Double_Window(Fl_Window):
    """
    The Fl_Double_Window class provides a double-buffered window. If possible 
    this will use the X double buffering extension (Xdbe). If not, it will draw 
    the window data into an off-screen pixmap, and then copy it to the on-screen 
    window.

    It is highly recommended that you put the following code before the first 
    show() of any window in your program:

          Fl.visual(FL_DOUBLE|FL_INDEX)

    This makes sure you can use Xdbe on servers where double buffering does not 
    exist for every visual.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def flush(self, *args):
        """flush(self)"""
        return _fltk.Fl_Double_Window_flush(self, *args)

    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Double_Window_resize(self, *args)

    def hide(self, *args):
        """hide(self)"""
        return _fltk.Fl_Double_Window_hide(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Double_Window
    __del__ = lambda self : None;
    def __init__(self, *args): 
        """
        __init__(self, int W, int H, char l = None) -> Fl_Double_Window
        __init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Double_Window
        """
        if self.__class__ == Fl_Double_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Double_Window(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def show(self, *args):
        """show(self, PyObject count = None, PyObject data = None)"""
        return _fltk.Fl_Double_Window_show(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Double_Window(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Double_Window_draw(self, *args)

Fl_Double_Window_swigregister = _fltk.Fl_Double_Window_swigregister
Fl_Double_Window_swigregister(Fl_Double_Window)


def fl_push_clip(*args):
  """fl_push_clip(int x, int y, int w, int h)"""
  return _fltk.fl_push_clip(*args)

def fl_push_no_clip(*args):
  """fl_push_no_clip()"""
  return _fltk.fl_push_no_clip(*args)

def fl_pop_clip(*args):
  """fl_pop_clip()"""
  return _fltk.fl_pop_clip(*args)

def fl_not_clipped(*args):
  """fl_not_clipped(int x, int y, int w, int h) -> int"""
  return _fltk.fl_not_clipped(*args)

def fl_clip_box(*args):
  """fl_clip_box(int arg0, int arg1, int arg2, int arg3) -> int"""
  return _fltk.fl_clip_box(*args)

def fl_point(*args):
  """fl_point(int x, int y)"""
  return _fltk.fl_point(*args)

def fl_line_style(*args):
  """fl_line_style(int style, int width = 0, char dashes = None)"""
  return _fltk.fl_line_style(*args)
FL_SOLID = _fltk.FL_SOLID
FL_DASH = _fltk.FL_DASH
FL_DOT = _fltk.FL_DOT
FL_DASHDOT = _fltk.FL_DASHDOT
FL_DASHDOTDOT = _fltk.FL_DASHDOTDOT
FL_CAP_FLAT = _fltk.FL_CAP_FLAT
FL_CAP_ROUND = _fltk.FL_CAP_ROUND
FL_CAP_SQUARE = _fltk.FL_CAP_SQUARE
FL_JOIN_MITER = _fltk.FL_JOIN_MITER
FL_JOIN_ROUND = _fltk.FL_JOIN_ROUND
FL_JOIN_BEVEL = _fltk.FL_JOIN_BEVEL

def fl_pie(*args):
  """fl_pie(int x, int y, int w, int h, double a1, double a2)"""
  return _fltk.fl_pie(*args)

def fl_push_matrix(*args):
  """fl_push_matrix()"""
  return _fltk.fl_push_matrix(*args)

def fl_pop_matrix(*args):
  """fl_pop_matrix()"""
  return _fltk.fl_pop_matrix(*args)

def fl_translate(*args):
  """fl_translate(double x, double y)"""
  return _fltk.fl_translate(*args)

def fl_rotate(*args):
  """fl_rotate(double d)"""
  return _fltk.fl_rotate(*args)

def fl_mult_matrix(*args):
  """fl_mult_matrix(double a, double b, double c, double d, double x, double y)"""
  return _fltk.fl_mult_matrix(*args)

def fl_begin_points(*args):
  """fl_begin_points()"""
  return _fltk.fl_begin_points(*args)

def fl_begin_line(*args):
  """fl_begin_line()"""
  return _fltk.fl_begin_line(*args)

def fl_begin_loop(*args):
  """fl_begin_loop()"""
  return _fltk.fl_begin_loop(*args)

def fl_begin_polygon(*args):
  """fl_begin_polygon()"""
  return _fltk.fl_begin_polygon(*args)

def fl_vertex(*args):
  """fl_vertex(double x, double y)"""
  return _fltk.fl_vertex(*args)

def fl_curve(*args):
  """
    fl_curve(double arg0, double arg1, double arg2, double arg3, 
        double arg4, double arg5, double arg6, double arg7)
    """
  return _fltk.fl_curve(*args)

def fl_circle(*args):
  """fl_circle(double x, double y, double r)"""
  return _fltk.fl_circle(*args)

def fl_end_points(*args):
  """fl_end_points()"""
  return _fltk.fl_end_points(*args)

def fl_end_line(*args):
  """fl_end_line()"""
  return _fltk.fl_end_line(*args)

def fl_end_loop(*args):
  """fl_end_loop()"""
  return _fltk.fl_end_loop(*args)

def fl_end_polygon(*args):
  """fl_end_polygon()"""
  return _fltk.fl_end_polygon(*args)

def fl_begin_complex_polygon(*args):
  """fl_begin_complex_polygon()"""
  return _fltk.fl_begin_complex_polygon(*args)

def fl_gap(*args):
  """fl_gap()"""
  return _fltk.fl_gap(*args)

def fl_end_complex_polygon(*args):
  """fl_end_complex_polygon()"""
  return _fltk.fl_end_complex_polygon(*args)

def fl_transform_x(*args):
  """fl_transform_x(double x, double y) -> double"""
  return _fltk.fl_transform_x(*args)

def fl_transform_y(*args):
  """fl_transform_y(double x, double y) -> double"""
  return _fltk.fl_transform_y(*args)

def fl_transform_dx(*args):
  """fl_transform_dx(double x, double y) -> double"""
  return _fltk.fl_transform_dx(*args)

def fl_transform_dy(*args):
  """fl_transform_dy(double x, double y) -> double"""
  return _fltk.fl_transform_dy(*args)

def fl_transformed_vertex(*args):
  """fl_transformed_vertex(double x, double y)"""
  return _fltk.fl_transformed_vertex(*args)

def fl_size(*args):
  """fl_size() -> int"""
  return _fltk.fl_size(*args)

def fl_descent(*args):
  """fl_descent() -> int"""
  return _fltk.fl_descent(*args)

def fl_measure(*args):
  """fl_measure(char arg0, int draw_symbols = 1)"""
  return _fltk.fl_measure(*args)

def fl_latin1_to_local(*args):
  """fl_latin1_to_local(char arg0, int n = -1) -> char"""
  return _fltk.fl_latin1_to_local(*args)

def fl_local_to_latin1(*args):
  """fl_local_to_latin1(char arg0, int n = -1) -> char"""
  return _fltk.fl_local_to_latin1(*args)

def fl_mac_roman_to_local(*args):
  """fl_mac_roman_to_local(char arg0, int n = -1) -> char"""
  return _fltk.fl_mac_roman_to_local(*args)

def fl_local_to_mac_roman(*args):
  """fl_local_to_mac_roman(char arg0, int n = -1) -> char"""
  return _fltk.fl_local_to_mac_roman(*args)

def fl_frame2(*args):
  """fl_frame2(char s, int x, int y, int w, int h)"""
  return _fltk.fl_frame2(*args)

def fl_draw_box(*args):
  """fl_draw_box(Fl_Boxtype arg0, int x, int y, int w, int h, Fl_Color arg5)"""
  return _fltk.fl_draw_box(*args)

def fl_draw_image(*args):
  """
    fl_draw_image(uchar arg0, int arg1, int arg2, int arg3, int arg4, 
        int delta = 3, int ldelta = 0)
    """
  return _fltk.fl_draw_image(*args)

def fl_draw_image_mono(*args):
  """
    fl_draw_image_mono(uchar arg0, int arg1, int arg2, int arg3, int arg4, 
        int delta = 1, int ld = 0)
    """
  return _fltk.fl_draw_image_mono(*args)

def fl_can_do_alpha_blending(*args):
  """fl_can_do_alpha_blending() -> char"""
  return _fltk.fl_can_do_alpha_blending(*args)

def fl_draw_pixmap(*args):
  """fl_draw_pixmap(char data, int x, int y, Fl_Color arg3 = FL_BACKGROUND_COLOR) -> int"""
  return _fltk.fl_draw_pixmap(*args)

def fl_measure_pixmap(*args):
  """fl_measure_pixmap(char data) -> int"""
  return _fltk.fl_measure_pixmap(*args)

def fl_scroll(*args):
  """
    fl_scroll(int X, int Y, int W, int H, int dx, int dy, void draw_area, 
        void data)
    """
  return _fltk.fl_scroll(*args)

def fl_shortcut_label(*args):
  """fl_shortcut_label(int arg0) -> char"""
  return _fltk.fl_shortcut_label(*args)

def fl_overlay_rect(*args):
  """fl_overlay_rect(int arg0, int arg1, int arg2, int arg3)"""
  return _fltk.fl_overlay_rect(*args)

def fl_overlay_clear(*args):
  """fl_overlay_clear()"""
  return _fltk.fl_overlay_clear(*args)

def fl_cursor(*args):
  """fl_cursor(Fl_Cursor arg0, Fl_Color arg1 = FL_BLACK, Fl_Color arg2 = FL_WHITE)"""
  return _fltk.fl_cursor(*args)

def fl_draw_symbol(*args):
  """fl_draw_symbol(char label, int x, int y, int w, int h, Fl_Color arg5) -> int"""
  return _fltk.fl_draw_symbol(*args)

def fl_add_symbol(*args):
  """fl_add_symbol(char name, void drawit, int scalable) -> int"""
  return _fltk.fl_add_symbol(*args)
FL_NORMAL_INPUT = _fltk.FL_NORMAL_INPUT
FL_FLOAT_INPUT = _fltk.FL_FLOAT_INPUT
FL_INT_INPUT = _fltk.FL_INT_INPUT
FL_HIDDEN_INPUT = _fltk.FL_HIDDEN_INPUT
FL_MULTILINE_INPUT = _fltk.FL_MULTILINE_INPUT
FL_SECRET_INPUT = _fltk.FL_SECRET_INPUT
FL_INPUT_TYPE = _fltk.FL_INPUT_TYPE
FL_INPUT_READONLY = _fltk.FL_INPUT_READONLY
FL_NORMAL_OUTPUT = _fltk.FL_NORMAL_OUTPUT
FL_MULTILINE_OUTPUT = _fltk.FL_MULTILINE_OUTPUT
FL_INPUT_WRAP = _fltk.FL_INPUT_WRAP
FL_MULTILINE_INPUT_WRAP = _fltk.FL_MULTILINE_INPUT_WRAP
FL_MULTILINE_OUTPUT_WRAP = _fltk.FL_MULTILINE_OUTPUT_WRAP
class Fl_Input_(Fl_Widget):
    """
    This is a virtual base class below Fl_Input. It has all the same interfaces, 
    but lacks the handle() and draw() method. You may want to subclass it if you 
    are one of those people who likes to change how the editing keys work.

    This can act like any of the subclasses of Fl_Input, by setting type() to one 
    of the following values:

          FL_NORMAL_INPUT		0
          FL_FLOAT_INPUT		1
          FL_INT_INPUT		2
          FL_MULTILINE_INPUT	4
          FL_SECRET_INPUT		5
          FL_INPUT_TYPE		7
          FL_INPUT_READONLY		8
          FL_NORMAL_OUTPUT		(FL_NORMAL_INPUT | FL_INPUT_READONLY)
          FL_MULTILINE_OUTPUT	(FL_MULTILINE_INPUT | FL_INPUT_READONLY)
          FL_INPUT_WRAP		16
          FL_MULTILINE_INPUT_WRAP	(FL_MULTILINE_INPUT | FL_INPUT_WRAP)
          FL_MULTILINE_OUTPUT_WRAP 	(FL_MULTILINE_INPUT | FL_INPUT_READONLY | FL_INPUT_WRAP)


    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Input__resize(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Input_"""
        if self.__class__ == Fl_Input_:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Input_(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Input_
    __del__ = lambda self : None;
    def static_value(self, *args):
        """
        static_value(self, char arg0) -> int
        static_value(self, char arg0, int arg1) -> int
        """
        return _fltk.Fl_Input__static_value(self, *args)

    def value(self, *args):
        """
        value(self, char arg0) -> int
        value(self, char arg0, int arg1) -> int
        value(self) -> char
        """
        return _fltk.Fl_Input__value(self, *args)

    def index(self, *args):
        """index(self, int i) -> char"""
        return _fltk.Fl_Input__index(self, *args)

    def size(self, *args):
        """
        size(self) -> int
        size(self, int W, int H)
        """
        return _fltk.Fl_Input__size(self, *args)

    def maximum_size(self, *args):
        """
        maximum_size(self) -> int
        maximum_size(self, int m)
        """
        return _fltk.Fl_Input__maximum_size(self, *args)

    def position(self, *args):
        """
        position(self) -> int
        position(self, int p, int m) -> int
        position(self, int p) -> int
        """
        return _fltk.Fl_Input__position(self, *args)

    def mark(self, *args):
        """
        mark(self) -> int
        mark(self, int m) -> int
        """
        return _fltk.Fl_Input__mark(self, *args)

    def replace(self, *args):
        """replace(self, int arg0, int arg1, char arg2, int arg3 = 0) -> int"""
        return _fltk.Fl_Input__replace(self, *args)

    def cut(self, *args):
        """
        cut(self) -> int
        cut(self, int n) -> int
        cut(self, int a, int b) -> int
        """
        return _fltk.Fl_Input__cut(self, *args)

    def insert(self, *args):
        """insert(self, char t, int l = 0) -> int"""
        return _fltk.Fl_Input__insert(self, *args)

    def copy(self, *args):
        """copy(self, int clipboard) -> int"""
        return _fltk.Fl_Input__copy(self, *args)

    def undo(self, *args):
        """undo(self) -> int"""
        return _fltk.Fl_Input__undo(self, *args)

    def copy_cuts(self, *args):
        """copy_cuts(self) -> int"""
        return _fltk.Fl_Input__copy_cuts(self, *args)

    def textfont(self, *args):
        """
        textfont(self) -> Fl_Font
        textfont(self, uchar s)
        """
        return _fltk.Fl_Input__textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_Input__textsize(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, unsigned int n)
        """
        return _fltk.Fl_Input__textcolor(self, *args)

    def cursor_color(self, *args):
        """
        cursor_color(self) -> Fl_Color
        cursor_color(self, unsigned int n)
        """
        return _fltk.Fl_Input__cursor_color(self, *args)

    def input_type(self, *args):
        """
        input_type(self) -> int
        input_type(self, int t)
        """
        return _fltk.Fl_Input__input_type(self, *args)

    def readonly(self, *args):
        """
        readonly(self) -> int
        readonly(self, int b)
        """
        return _fltk.Fl_Input__readonly(self, *args)

    def wrap(self, *args):
        """
        wrap(self) -> int
        wrap(self, int b)
        """
        return _fltk.Fl_Input__wrap(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Input_(self)
        return weakref_proxy(self)
Fl_Input__swigregister = _fltk.Fl_Input__swigregister
Fl_Input__swigregister(Fl_Input_)

def fl_color(*args):
  """
    fl_color(Fl_Color arg0)
    fl_color(uchar arg0, uchar arg1, uchar arg2)
    fl_color() -> Fl_Color
    """
  return _fltk.fl_color(*args)

def fl_rect(*args):
  """
    fl_rect(int x, int y, int w, int h)
    fl_rect(int x, int y, int w, int h, Fl_Color c)
    """
  return _fltk.fl_rect(*args)

def fl_line(*args):
  """
    fl_line(int arg0, int arg1, int arg2, int arg3)
    fl_line(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5)
    """
  return _fltk.fl_line(*args)

def fl_loop(*args):
  """
    fl_loop(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5)
    fl_loop(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, 
        int arg6, int arg7)
    """
  return _fltk.fl_loop(*args)

def fl_polygon(*args):
  """
    fl_polygon(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5)
    fl_polygon(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, 
        int arg6, int arg7)
    """
  return _fltk.fl_polygon(*args)

def fl_xyline(*args):
  """
    fl_xyline(int x, int y, int x1)
    fl_xyline(int x, int y, int x1, int y2)
    fl_xyline(int x, int y, int x1, int y2, int x3)
    """
  return _fltk.fl_xyline(*args)

def fl_yxline(*args):
  """
    fl_yxline(int x, int y, int y1)
    fl_yxline(int x, int y, int y1, int x2)
    fl_yxline(int x, int y, int y1, int x2, int y3)
    """
  return _fltk.fl_yxline(*args)

def fl_scale(*args):
  """
    fl_scale(double x, double y)
    fl_scale(double x)
    """
  return _fltk.fl_scale(*args)

def fl_arc(*args):
  """
    fl_arc(int x, int y, int w, int h, double a1, double a2)
    fl_arc(double x, double y, double r, double start, double a)
    """
  return _fltk.fl_arc(*args)

def fl_font(*args):
  """
    fl_font(int face, int size)
    fl_font() -> int
    """
  return _fltk.fl_font(*args)

def fl_height(*args):
  """
    fl_height() -> int
    fl_height(int arg0, int size) -> int
    """
  return _fltk.fl_height(*args)

def fl_width(*args):
  """
    fl_width(char arg0) -> double
    fl_width(char arg0, int n) -> double
    fl_width(uchar arg0) -> double
    """
  return _fltk.fl_width(*args)

def fl_draw(*args):
  """
    fl_draw(char arg0, int x, int y)
    fl_draw(char arg0, int n, int x, int y)
    fl_draw(char arg0, int arg1, int arg2, int arg3, int arg4, 
        Fl_Align arg5, Fl_Image img = None, int draw_symbols = 1)
    fl_draw(char arg0, int arg1, int arg2, int arg3, int arg4, 
        Fl_Align arg5, void callthis, Fl_Image img = None, 
        int draw_symbols = 1)
    """
  return _fltk.fl_draw(*args)

def fl_frame(*args):
  """
    fl_frame(Fl_Boxtype b) -> Fl_Boxtype
    fl_frame(char s, int x, int y, int w, int h)
    """
  return _fltk.fl_frame(*args)

def fl_rectf(*args):
  """
    fl_rectf(int x, int y, int w, int h)
    fl_rectf(int x, int y, int w, int h, Fl_Color c)
    fl_rectf(int x, int y, int w, int h, uchar r, uchar g, uchar b)
    """
  return _fltk.fl_rectf(*args)

class Fl_Input(Fl_Input_):
    """
    This is the FLTK text input widget. It displays a single line of text and 
    lets the user edit it. Normally it is drawn with an inset box and a white 
    background. The text may contain any characters (even 0), and will correctly 
    display anything, using ^X notation for unprintable control characters 
    and 
    nn notation for unprintable characters with the high bit set. It 
    assumes the font can draw any characters in the ISO-8859-1 character set.
    Mouse button 1	Moves the cursor to this point. Drag selects characters. 
    Double click selects words. Triple click selects all text. Shift+click 
    extends the selection. When you select text it is automatically copied 
    to the clipboard.
    Mouse button 2	Insert the clipboard at the point clicked. You can also 
    select a region and replace it with the clipboard by selecting the region 
    with mouse button 2.
    Mouse button 3	Currently acts like button 1.
    Backspace	Deletes one character to the left, or deletes the selected 
    region.
    Enter	May cause the callback, see when().
    ^A or Home	Go to start of line.
    ^B or Left	Move left
    ^C	Copy the selection to the clipboard
    ^D or Delete	Deletes one character to the right or deletes the selected 
    region.
    ^E or End	Go to the end of line.
    ^F or Right	Move right
    ^K	Delete to the end of line (next 
     character) or deletes a single 
     
    character. These deletions are all concatenated into the clipboard.
    ^N or Down	Move down (for Fl_Multiline_Input only, otherwise it moves
    to the next input field).
    ^P or Up	Move up (for Fl_Multiline_Input only, otherwise it moves to 
    the previous input field).
    ^U	Delete everything.
    ^V or ^Y	Paste the clipboard
    ^X or ^W	Copy the region to the clipboard and delete it.
    ^Z or ^_	Undo. This is a single-level undo mechanism, but all adjacent 
    deletions and insertions are concatenated into a single 'undo'. Often this 
    will undo a lot more than you expected.
    Shift+move	Move the cursor but also extend the selection.
    RightCtrl or
    Compose	Start a compose-character sequence. The next one or two keys typed 
    define the character to insert (see table that follows.)

    The character 'nbsp' (non-breaking space) is typed by using [compose][space].

    The single-character sequences may be followed by a space if necessary to 
    remove ambiguity. 

    The same key may be used to 'quote' control characters into the text. If you 
    need a ^Q character you can get one by typing [compose][Control+Q].

    X may have a key on the keyboard defined as XK_Multi_key. If so this key 
    may be used as well as the right-hand control key. You can set this up 
    with the program xmodmap.

    If your keyboard is set to support a foreign language you should also be 
    able to type 'dead key' prefix characters. On X you will actually be able 
    to see what dead key you typed, and if you then move the cursor without 
    completing the sequence the accent will remain inserted. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Input_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Input_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Input"""
        if self.__class__ == Fl_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Input(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Input
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Input(self)
        return weakref_proxy(self)
Fl_Input_swigregister = _fltk.Fl_Input_swigregister
Fl_Input_swigregister(Fl_Input)

class Fl_File_Input(Fl_Input):
    """
    This widget displays a pathname in a text input field. A navigation bar 
    located above the input field allows the user to navigate upward in the 
    directory tree.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char t = None) -> Fl_File_Input"""
        if self.__class__ == Fl_File_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_File_Input(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_File_Input_handle(self, *args)

    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_File_Input_draw(self, *args)

    def down_box(self, *args):
        """
        down_box(self) -> Fl_Boxtype
        down_box(self, Fl_Boxtype b)
        """
        return _fltk.Fl_File_Input_down_box(self, *args)

    def errorcolor(self, *args):
        """
        errorcolor(self) -> Fl_Color
        errorcolor(self, Fl_Color c)
        """
        return _fltk.Fl_File_Input_errorcolor(self, *args)

    def value(self, *args):
        """
        value(self, char arg0) -> int
        value(self, char arg0, int arg1) -> int
        value(self) -> char
        """
        return _fltk.Fl_File_Input_value(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_File_Input
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_File_Input(self)
        return weakref_proxy(self)
Fl_File_Input_swigregister = _fltk.Fl_File_Input_swigregister
Fl_File_Input_swigregister(Fl_File_Input)

class Fl_Fill_Dial(Fl_Dial):
    """
    The Fl_Fill_Dial widget provides a filled, circular dial to control a single 
    floating point value.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Fill_Dial"""
        if self.__class__ == Fl_Fill_Dial:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Fill_Dial(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Fill_Dial
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Fill_Dial(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Fill_Dial_draw(self, *args)

Fl_Fill_Dial_swigregister = _fltk.Fl_Fill_Dial_swigregister
Fl_Fill_Dial_swigregister(Fl_Fill_Dial)

FL_VERT_SLIDER = _fltk.FL_VERT_SLIDER
FL_HOR_SLIDER = _fltk.FL_HOR_SLIDER
FL_VERT_FILL_SLIDER = _fltk.FL_VERT_FILL_SLIDER
FL_HOR_FILL_SLIDER = _fltk.FL_HOR_FILL_SLIDER
FL_VERT_NICE_SLIDER = _fltk.FL_VERT_NICE_SLIDER
FL_HOR_NICE_SLIDER = _fltk.FL_HOR_NICE_SLIDER
class Fl_Slider(Fl_Valuator):
    """
    The Fl_Slider widget contains a sliding knob inside a box. It if often 
    used as a scrollbar. Moving the box all the way to the top/left sets it 
    to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Slider_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Slider_handle(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, int x, int y, int w, int h, char l = None) -> Fl_Slider
        __init__(self, uchar t, int x, int y, int w, int h, char l) -> Fl_Slider
        """
        if self.__class__ == Fl_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Slider(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def scrollvalue(self, *args):
        """scrollvalue(self, int windowtop, int windowsize, int first, int totalsize) -> int"""
        return _fltk.Fl_Slider_scrollvalue(self, *args)

    def bounds(self, *args):
        """bounds(self, double a, double b)"""
        return _fltk.Fl_Slider_bounds(self, *args)

    def slider_size(self, *args):
        """
        slider_size(self) -> float
        slider_size(self, double v)
        """
        return _fltk.Fl_Slider_slider_size(self, *args)

    def slider(self, *args):
        """
        slider(self) -> Fl_Boxtype
        slider(self, Fl_Boxtype c)
        """
        return _fltk.Fl_Slider_slider(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Slider
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Slider(self)
        return weakref_proxy(self)
Fl_Slider_swigregister = _fltk.Fl_Slider_swigregister
Fl_Slider_swigregister(Fl_Slider)

class Fl_Fill_Slider(Fl_Slider):
    """
    The Fl_Fill_Slider widget contains a sliding knob inside a box. It if often 
    used as a scrollbar. Moving the box all the way to the top/left sets it to 
    the minimum(), and to the bottom/right to the maximum(). The minimum() may 
    be greater than the maximum() to reverse the slider direction.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Fill_Slider"""
        if self.__class__ == Fl_Fill_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Fill_Slider(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Fill_Slider
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Fill_Slider(self)
        return weakref_proxy(self)
Fl_Fill_Slider_swigregister = _fltk.Fl_Fill_Slider_swigregister
Fl_Fill_Slider_swigregister(Fl_Fill_Slider)

class Fl_Float_Input(Fl_Input):
    """
    The Fl_Float_Input class is a subclass of Fl_Input  that only allows the 
    user to type floating point numbers (sign, digits, decimal point, more 
    digits, 'E' or 'e', sign, digits).

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Float_Input"""
        if self.__class__ == Fl_Float_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Float_Input(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Float_Input
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Float_Input(self)
        return weakref_proxy(self)
Fl_Float_Input_swigregister = _fltk.Fl_Float_Input_swigregister
Fl_Float_Input_swigregister(Fl_Float_Input)

class Fl_FormsBitmap(Fl_Widget):
    """Proxy of C++ Fl_FormsBitmap class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_FormsBitmap_draw(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, Fl_Boxtype arg0, int arg1, int arg2, int arg3, int arg4, 
            char arg5 = None) -> Fl_FormsBitmap
        """
        if self.__class__ == Fl_FormsBitmap:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_FormsBitmap(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def set(self, *args):
        """set(self, int W, int H, uchar bits)"""
        return _fltk.Fl_FormsBitmap_set(self, *args)

    def bitmap(self, *args):
        """
        bitmap(self, Fl_Bitmap B)
        bitmap(self) -> Fl_Bitmap
        """
        return _fltk.Fl_FormsBitmap_bitmap(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_FormsBitmap
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_FormsBitmap(self)
        return weakref_proxy(self)
Fl_FormsBitmap_swigregister = _fltk.Fl_FormsBitmap_swigregister
Fl_FormsBitmap_swigregister(Fl_FormsBitmap)

class Fl_FormsPixmap(Fl_Widget):
    """Proxy of C++ Fl_FormsPixmap class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_FormsPixmap_draw(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, Fl_Boxtype arg0, int arg1, int arg2, int arg3, int arg4, 
            char arg5 = None) -> Fl_FormsPixmap
        """
        if self.__class__ == Fl_FormsPixmap:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_FormsPixmap(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def set(self, *args):
        """set(self, char bits)"""
        return _fltk.Fl_FormsPixmap_set(self, *args)

    def Pixmap(self, *args):
        """
        Pixmap(self, Fl_Pixmap B)
        Pixmap(self) -> Fl_Pixmap
        """
        return _fltk.Fl_FormsPixmap_Pixmap(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_FormsPixmap
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_FormsPixmap(self)
        return weakref_proxy(self)
Fl_FormsPixmap_swigregister = _fltk.Fl_FormsPixmap_swigregister
Fl_FormsPixmap_swigregister(Fl_FormsPixmap)

FL_NORMAL_FREE = _fltk.FL_NORMAL_FREE
FL_SLEEPING_FREE = _fltk.FL_SLEEPING_FREE
FL_INPUT_FREE = _fltk.FL_INPUT_FREE
FL_CONTINUOUS_FREE = _fltk.FL_CONTINUOUS_FREE
FL_ALL_FREE = _fltk.FL_ALL_FREE
class Fl_Free(Fl_Widget):
    """
    Emulation of the Forms 'free' widget. This emulation allows the free demo 
    to run, and appears to be useful for porting programs written in Forms which 
    use the free widget or make subclasses of the Forms widgets.

    There are five types of free, which determine when the handle function is 
    called:

          FL_NORMAL_FREE		1
          FL_SLEEPING_FREE		2
          FL_INPUT_FREE		3
          FL_CONTINUOUS_FREE	4
          FL_ALL_FREE		5

    An FL_INPUT_FREE accepts FL_FOCUS events. A FL_CONTINUOUS_FREE sets a 
    timeout callback 100 times a second and provides a FL_STEP event, this 
    has obvious detrimental effects on machine performance. FL_ALL_FREE does 
    both. FL_SLEEPING_FREE are deactivated. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Free_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Free_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, uchar t, int x, int y, int w, int h, char l, FL_HANDLEPTR hdl) -> Fl_Free"""
        if self.__class__ == Fl_Free:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Free(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Free
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Free(self)
        return weakref_proxy(self)
Fl_Free_swigregister = _fltk.Fl_Free_swigregister
Fl_Free_swigregister(Fl_Free)

FL_DRAW = _fltk.FL_DRAW
FL_STEP = _fltk.FL_STEP
FL_FREEMEM = _fltk.FL_FREEMEM
FL_FREEZE = _fltk.FL_FREEZE
FL_THAW = _fltk.FL_THAW
class Fl_Pixmap(Fl_Image):
    """
    The Fl_Pixmap class supports caching and drawing of colormap (pixmap) images, including transparency.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char D) -> Fl_Pixmap"""
        if self.__class__ == Fl_Pixmap:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Pixmap(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Pixmap
    __del__ = lambda self : None;
    def copy(self, *args):
        """
        copy(self, int W, int H) -> Fl_Image
        copy(self) -> Fl_Image
        """
        return _fltk.Fl_Pixmap_copy(self, *args)

    def color_average(self, *args):
        """color_average(self, Fl_Color c, float i)"""
        return _fltk.Fl_Pixmap_color_average(self, *args)

    def desaturate(self, *args):
        """desaturate(self)"""
        return _fltk.Fl_Pixmap_desaturate(self, *args)

    def draw(self, *args):
        """
        draw(self, int X, int Y, int W, int H, int cx = 0, int cy = 0)
        draw(self, int X, int Y)
        """
        return _fltk.Fl_Pixmap_draw(self, *args)

    def label(self, *args):
        """
        label(self, Fl_Widget w)
        label(self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Pixmap_label(self, *args)

    def uncache(self, *args):
        """uncache(self)"""
        return _fltk.Fl_Pixmap_uncache(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Pixmap(self)
        return weakref_proxy(self)
Fl_Pixmap_swigregister = _fltk.Fl_Pixmap_swigregister
Fl_Pixmap_swigregister(Fl_Pixmap)

class Fl_GIF_Image(Fl_Pixmap):
    """
    The Fl_GIF_Image class supports loading, caching, and drawing of Compuserve 
    GIF images. The class loads the first image and supports transparency.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char filename) -> Fl_GIF_Image"""
        if self.__class__ == Fl_GIF_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_GIF_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_GIF_Image
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_GIF_Image(self)
        return weakref_proxy(self)
Fl_GIF_Image_swigregister = _fltk.Fl_GIF_Image_swigregister
Fl_GIF_Image_swigregister(Fl_GIF_Image)

class Fl_Gl_Window(Fl_Window):
    """
    The Fl_Gl_Window widget sets things up so OpenGL works, and also keeps an 
    OpenGL 'context' for that window, so that changes to the lighting and 
    projection may be reused between redraws. Fl_Gl_Window also flushes the 
    OpenGL streams and swaps buffers after draw()  returns.

    OpenGL hardware typically provides some overlay bit planes, which are very 
    useful for drawing UI controls atop your 3D graphics. If the overlay hardware 
    is not provided, FLTK tries to simulate the overlay, This works pretty well 
    if your graphics are double buffered, but not very well for single-buffered. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def flush(self, *args):
        """flush(self)"""
        return _fltk.Fl_Gl_Window_flush(self, *args)

    def hide(self, *args):
        """hide(self)"""
        return _fltk.Fl_Gl_Window_hide(self, *args)

    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Gl_Window_resize(self, *args)

    def valid(self, *args):
        """
        valid(self) -> char
        valid(self, char v)
        """
        return _fltk.Fl_Gl_Window_valid(self, *args)

    def invalidate(self, *args):
        """invalidate(self)"""
        return _fltk.Fl_Gl_Window_invalidate(self, *args)

    def context_valid(self, *args):
        """
        context_valid(self) -> char
        context_valid(self, char v)
        """
        return _fltk.Fl_Gl_Window_context_valid(self, *args)

    def can_do(self, *args):
        """
        can_do(self, int m) -> int
        can_do(self, int m) -> int
        can_do(self) -> int
        """
        return _fltk.Fl_Gl_Window_can_do(self, *args)

    def mode(self, *args):
        """
        mode(self) -> Fl_Mode
        mode(self, int a) -> int
        mode(self, int a) -> int
        """
        return _fltk.Fl_Gl_Window_mode(self, *args)

    def context(self, *args):
        """
        context(self)
        context(self, void arg0, int destroy_flag = 0)
        """
        return _fltk.Fl_Gl_Window_context(self, *args)

    def make_current(self, *args):
        """make_current(self)"""
        return _fltk.Fl_Gl_Window_make_current(self, *args)

    def swap_buffers(self, *args):
        """swap_buffers(self)"""
        return _fltk.Fl_Gl_Window_swap_buffers(self, *args)

    def ortho(self, *args):
        """ortho(self)"""
        return _fltk.Fl_Gl_Window_ortho(self, *args)

    def can_do_overlay(self, *args):
        """can_do_overlay(self) -> int"""
        return _fltk.Fl_Gl_Window_can_do_overlay(self, *args)

    def redraw_overlay(self, *args):
        """redraw_overlay(self)"""
        return _fltk.Fl_Gl_Window_redraw_overlay(self, *args)

    def hide_overlay(self, *args):
        """hide_overlay(self)"""
        return _fltk.Fl_Gl_Window_hide_overlay(self, *args)

    def make_overlay_current(self, *args):
        """make_overlay_current(self)"""
        return _fltk.Fl_Gl_Window_make_overlay_current(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Gl_Window
    __del__ = lambda self : None;
    def __init__(self, *args): 
        """
        __init__(self, int W, int H, char l = None) -> Fl_Gl_Window
        __init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Gl_Window
        """
        if self.__class__ == Fl_Gl_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Gl_Window(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def show(self, *args):
        """show(self, PyObject count = None, PyObject data = None)"""
        return _fltk.Fl_Gl_Window_show(self, *args)

    def drawPixels(self, *args):
        """
        drawPixels(self, PyObject rgb_py)

        Writes a raw RGB string to the canvas.

        Arguments:
            - rgb - a string of width * height * 3 bytes, comprising
              the raw image in RGB format

        """
        return _fltk.Fl_Gl_Window_drawPixels(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Gl_Window(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Gl_Window_draw(self, *args)

Fl_Gl_Window_swigregister = _fltk.Fl_Gl_Window_swigregister
Fl_Gl_Window_swigregister(Fl_Gl_Window)


def gl_start(*args):
  """gl_start()"""
  return _fltk.gl_start(*args)

def gl_finish(*args):
  """gl_finish()"""
  return _fltk.gl_finish(*args)

def gl_rect(*args):
  """gl_rect(int x, int y, int w, int h)"""
  return _fltk.gl_rect(*args)

def gl_rectf(*args):
  """gl_rectf(int x, int y, int w, int h)"""
  return _fltk.gl_rectf(*args)

def gl_font(*args):
  """gl_font(int fontid, int size)"""
  return _fltk.gl_font(*args)

def gl_height(*args):
  """gl_height() -> int"""
  return _fltk.gl_height(*args)

def gl_descent(*args):
  """gl_descent() -> int"""
  return _fltk.gl_descent(*args)

def gl_measure(*args):
  """gl_measure(char arg0)"""
  return _fltk.gl_measure(*args)

def gl_draw_image(*args):
  """
    gl_draw_image(uchar arg0, int x, int y, int w, int h, int d = 3, 
        int ld = 0)
    """
  return _fltk.gl_draw_image(*args)
class Fl_Help_Dialog(object):
    """
    The Fl_Help_Dialog widget displays a standard help dialog window using the 
    Fl_Help_View widget.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> Fl_Help_Dialog"""
        this = _fltk.new_Fl_Help_Dialog(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Help_Dialog
    __del__ = lambda self : None;
    def h(self, *args):
        """h(self) -> int"""
        return _fltk.Fl_Help_Dialog_h(self, *args)

    def hide(self, *args):
        """hide(self)"""
        return _fltk.Fl_Help_Dialog_hide(self, *args)

    def load(self, *args):
        """load(self, char f)"""
        return _fltk.Fl_Help_Dialog_load(self, *args)

    def position(self, *args):
        """position(self, int xx, int yy)"""
        return _fltk.Fl_Help_Dialog_position(self, *args)

    def resize(self, *args):
        """resize(self, int xx, int yy, int ww, int hh)"""
        return _fltk.Fl_Help_Dialog_resize(self, *args)

    def show(self, *args):
        """
        show(self)
        show(self, int argc, char argv)
        """
        return _fltk.Fl_Help_Dialog_show(self, *args)

    def textsize(self, *args):
        """
        textsize(self, uchar s)
        textsize(self) -> uchar
        """
        return _fltk.Fl_Help_Dialog_textsize(self, *args)

    def topline(self, *args):
        """
        topline(self, char n)
        topline(self, int n)
        """
        return _fltk.Fl_Help_Dialog_topline(self, *args)

    def value(self, *args):
        """
        value(self, char f)
        value(self) -> char
        """
        return _fltk.Fl_Help_Dialog_value(self, *args)

    def visible(self, *args):
        """visible(self) -> int"""
        return _fltk.Fl_Help_Dialog_visible(self, *args)

    def w(self, *args):
        """w(self) -> int"""
        return _fltk.Fl_Help_Dialog_w(self, *args)

    def x(self, *args):
        """x(self) -> int"""
        return _fltk.Fl_Help_Dialog_x(self, *args)

    def y(self, *args):
        """y(self) -> int"""
        return _fltk.Fl_Help_Dialog_y(self, *args)

Fl_Help_Dialog_swigregister = _fltk.Fl_Help_Dialog_swigregister
Fl_Help_Dialog_swigregister(Fl_Help_Dialog)

def gl_color(*args):
  """
    gl_color(Fl_Color arg0)
    gl_color(int c)
    """
  return _fltk.gl_color(*args)

def gl_width(*args):
  """
    gl_width(char arg0) -> double
    gl_width(char arg0, int n) -> double
    gl_width(uchar arg0) -> double
    """
  return _fltk.gl_width(*args)

def gl_draw(*args):
  """
    gl_draw(char arg0)
    gl_draw(char arg0, int n)
    gl_draw(char arg0, int x, int y)
    gl_draw(char arg0, float x, float y)
    gl_draw(char arg0, int n, int x, int y)
    gl_draw(char arg0, int n, float x, float y)
    gl_draw(char arg0, int x, int y, int w, int h, Fl_Align arg5)
    """
  return _fltk.gl_draw(*args)

class Fl_Help_Block(object):
    """Proxy of C++ Fl_Help_Block class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> Fl_Help_Block"""
        this = _fltk.new_Fl_Help_Block(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Help_Block
    __del__ = lambda self : None;
Fl_Help_Block_swigregister = _fltk.Fl_Help_Block_swigregister
Fl_Help_Block_swigregister(Fl_Help_Block)

class Fl_Help_Link(object):
    """Proxy of C++ Fl_Help_Link class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> Fl_Help_Link"""
        this = _fltk.new_Fl_Help_Link(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Help_Link
    __del__ = lambda self : None;
Fl_Help_Link_swigregister = _fltk.Fl_Help_Link_swigregister
Fl_Help_Link_swigregister(Fl_Help_Link)

class Fl_Help_Target(object):
    """Proxy of C++ Fl_Help_Target class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> Fl_Help_Target"""
        this = _fltk.new_Fl_Help_Target(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Help_Target
    __del__ = lambda self : None;
Fl_Help_Target_swigregister = _fltk.Fl_Help_Target_swigregister
Fl_Help_Target_swigregister(Fl_Help_Target)

class Fl_Help_View(Fl_Group):
    """
    The Fl_Help_View widget displays HTML text. Most HTML 2.0 elements are 
    supported, as well as a primitive implementation of tables. GIF, JPEG, 
    and PNG images are displayed inline.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int xx, int yy, int ww, int hh, char l = None) -> Fl_Help_View"""
        if self.__class__ == Fl_Help_View:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Help_View(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Help_View
    __del__ = lambda self : None;
    def directory(self, *args):
        """directory(self) -> char"""
        return _fltk.Fl_Help_View_directory(self, *args)

    def filename(self, *args):
        """filename(self) -> char"""
        return _fltk.Fl_Help_View_filename(self, *args)

    def find(self, *args):
        """find(self, char s, int p = 0) -> int"""
        return _fltk.Fl_Help_View_find(self, *args)

    def load(self, *args):
        """load(self, char f) -> int"""
        return _fltk.Fl_Help_View_load(self, *args)

    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Help_View_resize(self, *args)

    def size(self, *args):
        """
        size(self) -> int
        size(self, int W, int H)
        """
        return _fltk.Fl_Help_View_size(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self, Fl_Color c)
        textcolor(self) -> Fl_Color
        """
        return _fltk.Fl_Help_View_textcolor(self, *args)

    def textfont(self, *args):
        """
        textfont(self, uchar f)
        textfont(self) -> uchar
        """
        return _fltk.Fl_Help_View_textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self, uchar s)
        textsize(self) -> uchar
        """
        return _fltk.Fl_Help_View_textsize(self, *args)

    def title(self, *args):
        """title(self) -> char"""
        return _fltk.Fl_Help_View_title(self, *args)

    def topline(self, *args):
        """
        topline(self, char n)
        topline(self, int arg0)
        topline(self) -> int
        """
        return _fltk.Fl_Help_View_topline(self, *args)

    def leftline(self, *args):
        """
        leftline(self, int arg0)
        leftline(self) -> int
        """
        return _fltk.Fl_Help_View_leftline(self, *args)

    def value(self, *args):
        """
        value(self, char v)
        value(self) -> char
        """
        return _fltk.Fl_Help_View_value(self, *args)

    def clear_selection(self, *args):
        """clear_selection(self)"""
        return _fltk.Fl_Help_View_clear_selection(self, *args)

    def select_all(self, *args):
        """select_all(self)"""
        return _fltk.Fl_Help_View_select_all(self, *args)

    def link(self, *args):
        """
        link(self, Fl_Help_Func fn)
        link(self, PyObject PyFunc, PyObject PyWidget)
        """
        return _fltk.Fl_Help_View_link(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Help_View(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Help_View_draw(self, *args)

Fl_Help_View_swigregister = _fltk.Fl_Help_View_swigregister
Fl_Help_View_swigregister(Fl_Help_View)

class Fl_Hold_Browser(Fl_Browser):
    """
    The Fl_Hold_Browser class is a subclass of Fl_Browser  which lets the user 
    select a single item, or no items by clicking on the empty space. As long 
    as the mouse button is held down the item pointed to by it is highlighted, 
    and this highlighting remains on when the mouse button is released. Normally 
    the callback is done when the user releases the mouse, but you can change 
    this with when().

    See Fl_Browser for methods to add and remove lines from the browser. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Hold_Browser"""
        if self.__class__ == Fl_Hold_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Hold_Browser(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Hold_Browser
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hold_Browser(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Hold_Browser_draw(self, *args)

    def item_first(self, *args):
        """item_first(self) -> void"""
        return _fltk.Fl_Hold_Browser_item_first(self, *args)

    def item_next(self, *args):
        """item_next(self, void arg0) -> void"""
        return _fltk.Fl_Hold_Browser_item_next(self, *args)

    def item_prev(self, *args):
        """item_prev(self, void arg0) -> void"""
        return _fltk.Fl_Hold_Browser_item_prev(self, *args)

    def item_height(self, *args):
        """item_height(self, void arg0) -> int"""
        return _fltk.Fl_Hold_Browser_item_height(self, *args)

    def item_width(self, *args):
        """item_width(self, void arg0) -> int"""
        return _fltk.Fl_Hold_Browser_item_width(self, *args)

    def item_quick_height(self, *args):
        """item_quick_height(self, void arg0) -> int"""
        return _fltk.Fl_Hold_Browser_item_quick_height(self, *args)

    def item_draw(self, *args):
        """item_draw(self, void arg0, int arg1, int arg2, int arg3, int arg4)"""
        return _fltk.Fl_Hold_Browser_item_draw(self, *args)

    def full_width(self, *args):
        """full_width(self) -> int"""
        return _fltk.Fl_Hold_Browser_full_width(self, *args)

    def full_height(self, *args):
        """full_height(self) -> int"""
        return _fltk.Fl_Hold_Browser_full_height(self, *args)

    def incr_height(self, *args):
        """incr_height(self) -> int"""
        return _fltk.Fl_Hold_Browser_incr_height(self, *args)

    def item_select(self, *args):
        """item_select(self, void arg0, int arg1)"""
        return _fltk.Fl_Hold_Browser_item_select(self, *args)

    def item_selected(self, *args):
        """item_selected(self, void arg0) -> int"""
        return _fltk.Fl_Hold_Browser_item_selected(self, *args)

Fl_Hold_Browser_swigregister = _fltk.Fl_Hold_Browser_swigregister
Fl_Hold_Browser_swigregister(Fl_Hold_Browser)

class Fl_Hor_Fill_Slider(Fl_Slider):
    """
    The Fl_Hor_Fill_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Hor_Fill_Slider"""
        if self.__class__ == Fl_Hor_Fill_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Hor_Fill_Slider(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Hor_Fill_Slider
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Fill_Slider(self)
        return weakref_proxy(self)
Fl_Hor_Fill_Slider_swigregister = _fltk.Fl_Hor_Fill_Slider_swigregister
Fl_Hor_Fill_Slider_swigregister(Fl_Hor_Fill_Slider)

class Fl_Hor_Nice_Slider(Fl_Slider):
    """
    The Fl_Hor_Nice_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Hor_Nice_Slider"""
        if self.__class__ == Fl_Hor_Nice_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Hor_Nice_Slider(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Hor_Nice_Slider
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Nice_Slider(self)
        return weakref_proxy(self)
Fl_Hor_Nice_Slider_swigregister = _fltk.Fl_Hor_Nice_Slider_swigregister
Fl_Hor_Nice_Slider_swigregister(Fl_Hor_Nice_Slider)

class Fl_Hor_Slider(Fl_Slider):
    """
    The Fl_Hor_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Hor_Slider"""
        if self.__class__ == Fl_Hor_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Hor_Slider(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Hor_Slider
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Slider(self)
        return weakref_proxy(self)
Fl_Hor_Slider_swigregister = _fltk.Fl_Hor_Slider_swigregister
Fl_Hor_Slider_swigregister(Fl_Hor_Slider)

class Fl_Value_Slider(Fl_Slider):
    """
    The Fl_Value_Slider widget is a Fl_Slider widget with a box displaying 
    the current value.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Value_Slider_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Value_Slider_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Value_Slider"""
        if self.__class__ == Fl_Value_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Value_Slider(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def textfont(self, *args):
        """
        textfont(self) -> Fl_Font
        textfont(self, uchar s)
        """
        return _fltk.Fl_Value_Slider_textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_Value_Slider_textsize(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, unsigned int s)
        """
        return _fltk.Fl_Value_Slider_textcolor(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Value_Slider
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Value_Slider(self)
        return weakref_proxy(self)
Fl_Value_Slider_swigregister = _fltk.Fl_Value_Slider_swigregister
Fl_Value_Slider_swigregister(Fl_Value_Slider)

class Fl_Hor_Value_Slider(Fl_Value_Slider):
    """
    The Fl_Hor_Value_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Hor_Value_Slider"""
        if self.__class__ == Fl_Hor_Value_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Hor_Value_Slider(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Hor_Value_Slider
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Hor_Value_Slider(self)
        return weakref_proxy(self)
Fl_Hor_Value_Slider_swigregister = _fltk.Fl_Hor_Value_Slider_swigregister
Fl_Hor_Value_Slider_swigregister(Fl_Hor_Value_Slider)

class Fl_Int_Input(Fl_Input):
    """
    The Fl_Int_Input class is a subclass of Fl_Input  that only allows the user 
    to type decimal digits (or hex numbers of the form 0xaef).

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Int_Input"""
        if self.__class__ == Fl_Int_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Int_Input(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Int_Input
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Int_Input(self)
        return weakref_proxy(self)
Fl_Int_Input_swigregister = _fltk.Fl_Int_Input_swigregister
Fl_Int_Input_swigregister(Fl_Int_Input)

class Fl_Input_Choice(Fl_Group):
    """
    A combination of the input widget and a menu button. The user can either 
    type into the input area, or use the menu button chooser on the right, 
    which loads the input area with predefined text. Normally it is drawn with 
    an inset box and a white background.

    The application can directly access both the input and menu widgets directly, 
    using the menubutton() and input() accessor methods. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Input_Choice"""
        if self.__class__ == Fl_Input_Choice:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Input_Choice(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def add(self, *args):
        """add(self, char s)"""
        val = _fltk.Fl_Input_Choice_add(self, *args)
        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val

    def changed(self, *args):
        """changed(self) -> int"""
        return _fltk.Fl_Input_Choice_changed(self, *args)

    def clear_changed(self, *args):
        """clear_changed(self)"""
        return _fltk.Fl_Input_Choice_clear_changed(self, *args)

    def set_changed(self, *args):
        """set_changed(self)"""
        return _fltk.Fl_Input_Choice_set_changed(self, *args)

    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_Input_Choice_clear(self, *args)

    def down_box(self, *args):
        """
        down_box(self) -> Fl_Boxtype
        down_box(self, Fl_Boxtype b)
        """
        return _fltk.Fl_Input_Choice_down_box(self, *args)

    def menu(self, *args):
        """
        menu(self) -> Fl_Menu_Item
        menu(self, Fl_Menu_Item m)
        """
        return _fltk.Fl_Input_Choice_menu(self, *args)

    def resize(self, *args):
        """resize(self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Input_Choice_resize(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, Fl_Color c)
        """
        return _fltk.Fl_Input_Choice_textcolor(self, *args)

    def textfont(self, *args):
        """
        textfont(self) -> uchar
        textfont(self, uchar f)
        """
        return _fltk.Fl_Input_Choice_textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_Input_Choice_textsize(self, *args)

    def value(self, *args):
        """
        value(self) -> char
        value(self, char val)
        value(self, int val)
        """
        return _fltk.Fl_Input_Choice_value(self, *args)

    def menubutton(self, *args):
        """menubutton(self) -> Fl_Menu_Button"""
        return _fltk.Fl_Input_Choice_menubutton(self, *args)

    def input(self, *args):
        """input(self) -> Fl_Input"""
        return _fltk.Fl_Input_Choice_input(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Input_Choice
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Input_Choice(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Input_Choice_draw(self, *args)

Fl_Input_Choice_swigregister = _fltk.Fl_Input_Choice_swigregister
Fl_Input_Choice_swigregister(Fl_Input_Choice)

class Fl_JPEG_Image(Fl_RGB_Image):
    """
    The Fl_JPEG_Image class supports loading, caching, and drawing of Joint 
    Photographic Experts Group (JPEG) File Interchange Format (JFIF) images. 
    The class supports grayscale and color (RGB) JPEG image files.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char filename) -> Fl_JPEG_Image"""
        if self.__class__ == Fl_JPEG_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_JPEG_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_JPEG_Image
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_JPEG_Image(self)
        return weakref_proxy(self)
Fl_JPEG_Image_swigregister = _fltk.Fl_JPEG_Image_swigregister
Fl_JPEG_Image_swigregister(Fl_JPEG_Image)

class Fl_Line_Dial(Fl_Dial):
    """
    The Fl_Line_Dial widget provides a circular dial to control a single 
    floating point value.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Line_Dial"""
        if self.__class__ == Fl_Line_Dial:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Line_Dial(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Line_Dial
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Line_Dial(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Line_Dial_draw(self, *args)

Fl_Line_Dial_swigregister = _fltk.Fl_Line_Dial_swigregister
Fl_Line_Dial_swigregister(Fl_Line_Dial)

class Fl_Menu_Bar(Fl_Menu_):
    """
    This widget provides a standard menubar interface. Usually you will put 
    this widget along the top edge of your window. The height of the widget 
    should be 30 for the menu titles to draw correctly with the default font.

    The items on the bar and the menus they bring up are defined by a single 
    Fl_Menu_Item array. Because a Fl_Menu_Item array defines a hierarchy, the 
    top level menu defines the items in the menubar, while the submenus define 
    the pull-down menus. Sub-sub menus and lower pop up to the right of the 
    submenus.

    If there is an item in the top menu that is not a title of a submenu, then 
    it acts like a 'button' in the menubar. Clicking on it will pick it.

    When the user picks an item off the menu, the item's callback is done with 
    the menubar as the Fl_Widget* argument. If the item does not have a callback 
    the menubar's callback is done instead.

    Submenus will also pop up in response to shortcuts indicated by putting 
    a '&' character in the name field of the menu item. If you put a '&' 
    character in a top-level 'button' then the shortcut picks it. The '&' 
    character in submenus is ignored until the menu is popped up.

    Typing the shortcut() of any of the menu items will cause callbacks 
    exactly the same as when you pick the item with the mouse. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Menu_Bar_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Menu_Bar_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Menu_Bar"""
        if self.__class__ == Fl_Menu_Bar:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Menu_Bar(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Menu_Bar
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_Bar(self)
        return weakref_proxy(self)
Fl_Menu_Bar_swigregister = _fltk.Fl_Menu_Bar_swigregister
Fl_Menu_Bar_swigregister(Fl_Menu_Bar)

class Fl_Menu_Button(Fl_Menu_):
    """
    This is a button that when pushed pops up a menu (or hierarchy of menus) 
    defined by an array of Fl_Menu_Item objects.

    Fl_Menu_Button widget.

    Normally any mouse button will pop up a menu and it is lined up below the 
    button as shown in the picture. However an Fl_Menu_Button may also control 
    a pop-up menu. This is done by setting the type() , see below.

    The menu will also pop up in response to shortcuts indicated by putting 
    a '&' character in the label().

    Typing the shortcut() of any of the menu items will cause callbacks exactly 
    the same as when you pick the item with the mouse. The '&' character in menu 
    item names are only looked at when the menu is popped up, however.

    When the user picks an item off the menu, the item's callback is done with 
    the menu_button as the Fl_Widget* argument. If the item does not have a 
    callback the menu_button's callback is done instead. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Menu_Button_draw(self, *args)

    POPUP1 = _fltk.Fl_Menu_Button_POPUP1
    POPUP2 = _fltk.Fl_Menu_Button_POPUP2
    POPUP12 = _fltk.Fl_Menu_Button_POPUP12
    POPUP3 = _fltk.Fl_Menu_Button_POPUP3
    POPUP13 = _fltk.Fl_Menu_Button_POPUP13
    POPUP23 = _fltk.Fl_Menu_Button_POPUP23
    POPUP123 = _fltk.Fl_Menu_Button_POPUP123
    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Menu_Button_handle(self, *args)

    def popup(self, *args):
        """popup(self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Button_popup(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Menu_Button"""
        if self.__class__ == Fl_Menu_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Menu_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Menu_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_Button(self)
        return weakref_proxy(self)
Fl_Menu_Button_swigregister = _fltk.Fl_Menu_Button_swigregister
Fl_Menu_Button_swigregister(Fl_Menu_Button)

FL_MENU_INACTIVE = _fltk.FL_MENU_INACTIVE
FL_MENU_TOGGLE = _fltk.FL_MENU_TOGGLE
FL_MENU_VALUE = _fltk.FL_MENU_VALUE
FL_MENU_RADIO = _fltk.FL_MENU_RADIO
FL_MENU_INVISIBLE = _fltk.FL_MENU_INVISIBLE
FL_SUBMENU_POINTER = _fltk.FL_SUBMENU_POINTER
FL_SUBMENU = _fltk.FL_SUBMENU
FL_MENU_DIVIDER = _fltk.FL_MENU_DIVIDER
FL_MENU_HORIZONTAL = _fltk.FL_MENU_HORIZONTAL
class Fl_Menu_Item(object):
    """
    The Fl_Menu_Item structure defines a single menu item that is used by the 
    Fl_Menu_ class. This structure is defined as

          Fl_Menu_Item :
            text 		-> character array # label()
            shortcut_ 	-> unsigned long
            callback_	-> Fl_Callback
            user_data_	
            flags		-> int
            labeltype_	-> unsigned character
            labelfont_	-> unsigned character
            labelsize_	-> unsigned character
            labelcolor_	-> unsigned character
          

          enum: # values for flags:
            FL_MENU_INACTIVE	= 1,
            FL_MENU_TOGGLE		= 2,
            FL_MENU_VALUE		= 4,
            FL_MENU_RADIO		= 8,
            FL_MENU_INVISIBLE	= 0x10,
            FL_SUBMENU_POINTER	= 0x20,
            FL_SUBMENU		= 0x40,
            FL_MENU_DIVIDER		= 0x80,
            FL_MENU_HORIZONTAL	= 0x100
          

    Typically menu items are statically defined; for example:

          MenuTable = (
            ('&alpha',   FL_ALT+ord('a'), the_cb, 1),
            ('&beta',    FL_ALT+ord('b'), the_cb, 2),
            ('gamma',    FL_ALT+ord('c'), the_cb, 3, FL_MENU_DIVIDER),
            ('&strange',  0,   strange_cb),
            ('&charm',    0,   charm_cb),
            ('&truth',    0,   truth_cb),
            ('b&eauty',   0,   beauty_cb),
            ('sub&menu',	0,   0, 0, FL_SUBMENU),
              ('one'),
              ('two'),
              ('three'),
            (None,),
            ('inactive', FL_ALT+'i', 0, 0, FL_MENU_INACTIVE|FL_MENU_DIVIDER),
            ('invisible',FL_ALT+'i', 0, 0, FL_MENU_INVISIBLE),
            ('check',    FL_ALT+'i', 0, 0, FL_MENU_TOGGLE|FL_MENU_VALUE),
            ('box',      FL_ALT+'i', 0, 0, FL_MENU_TOGGLE),
          (None,);

    A submenu title is identified by the bit FL_SUBMENU in the flags field, 
    and ends with a label() that is NULL. You can nest menus to any depth. A 
    pointer to the first item in the submenu can be treated as an Fl_Menu array 
    itself. It is also possible to make seperate submenu arrays with 
    FL_SUBMENU_POINTER flags.

    You should use the method functions to access structure members and not 
    access them directly to avoid compatibility problems with future releases 
    of FLTK. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def next(self, *args):
        """
        next(self, int arg0 = 1) -> Fl_Menu_Item
        next(self, int i = 1) -> Fl_Menu_Item
        """
        return _fltk.Fl_Menu_Item_next(self, *args)

    def first(self, *args):
        """
        first(self) -> Fl_Menu_Item
        first(self) -> Fl_Menu_Item
        """
        return _fltk.Fl_Menu_Item_first(self, *args)

    def label(self, *args):
        """
        label(self) -> char
        label(self, char a)
        label(self, Fl_Labeltype a, char b)
        """
        return _fltk.Fl_Menu_Item_label(self, *args)

    def labeltype(self, *args):
        """
        labeltype(self) -> Fl_Labeltype
        labeltype(self, Fl_Labeltype a)
        """
        return _fltk.Fl_Menu_Item_labeltype(self, *args)

    def labelcolor(self, *args):
        """
        labelcolor(self) -> Fl_Color
        labelcolor(self, unsigned int a)
        """
        return _fltk.Fl_Menu_Item_labelcolor(self, *args)

    def labelfont(self, *args):
        """
        labelfont(self) -> Fl_Font
        labelfont(self, uchar a)
        """
        return _fltk.Fl_Menu_Item_labelfont(self, *args)

    def labelsize(self, *args):
        """
        labelsize(self) -> uchar
        labelsize(self, uchar a)
        """
        return _fltk.Fl_Menu_Item_labelsize(self, *args)

    def argument(self, *args):
        """
        argument(self) -> long
        argument(self, long v)
        """
        return _fltk.Fl_Menu_Item_argument(self, *args)

    def shortcut(self, *args):
        """
        shortcut(self) -> int
        shortcut(self, int s)
        """
        return _fltk.Fl_Menu_Item_shortcut(self, *args)

    def submenu(self, *args):
        """submenu(self) -> int"""
        return _fltk.Fl_Menu_Item_submenu(self, *args)

    def checkbox(self, *args):
        """checkbox(self) -> int"""
        return _fltk.Fl_Menu_Item_checkbox(self, *args)

    def radio(self, *args):
        """radio(self) -> int"""
        return _fltk.Fl_Menu_Item_radio(self, *args)

    def value(self, *args):
        """value(self) -> int"""
        return _fltk.Fl_Menu_Item_value(self, *args)

    def set(self, *args):
        """set(self)"""
        return _fltk.Fl_Menu_Item_set(self, *args)

    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_Menu_Item_clear(self, *args)

    def setonly(self, *args):
        """setonly(self)"""
        return _fltk.Fl_Menu_Item_setonly(self, *args)

    def visible(self, *args):
        """visible(self) -> int"""
        return _fltk.Fl_Menu_Item_visible(self, *args)

    def show(self, *args):
        """show(self)"""
        return _fltk.Fl_Menu_Item_show(self, *args)

    def hide(self, *args):
        """hide(self)"""
        return _fltk.Fl_Menu_Item_hide(self, *args)

    def active(self, *args):
        """active(self) -> int"""
        return _fltk.Fl_Menu_Item_active(self, *args)

    def activate(self, *args):
        """activate(self)"""
        return _fltk.Fl_Menu_Item_activate(self, *args)

    def deactivate(self, *args):
        """deactivate(self)"""
        return _fltk.Fl_Menu_Item_deactivate(self, *args)

    def activevisible(self, *args):
        """activevisible(self) -> int"""
        return _fltk.Fl_Menu_Item_activevisible(self, *args)

    def image(self, *args):
        """image(self, Fl_Image a)"""
        return _fltk.Fl_Menu_Item_image(self, *args)

    def measure(self, *args):
        """measure(self, int h, Fl_Menu_ arg1) -> int"""
        return _fltk.Fl_Menu_Item_measure(self, *args)

    def draw(self, *args):
        """draw(self, int x, int y, int w, int h, Fl_Menu_ arg4, int t = 0)"""
        return _fltk.Fl_Menu_Item_draw(self, *args)

    def popup(self, *args):
        """
        popup(self, int X, int Y, char title = None, Fl_Menu_Item picked = None, 
            Fl_Menu_ arg4 = None) -> Fl_Menu_Item
        """
        return _fltk.Fl_Menu_Item_popup(self, *args)

    def pulldown(self, *args):
        """
        pulldown(self, int X, int Y, int W, int H, Fl_Menu_Item picked = None, 
            Fl_Menu_ arg5 = None, Fl_Menu_Item title = None, 
            int menubar = 0) -> Fl_Menu_Item
        """
        return _fltk.Fl_Menu_Item_pulldown(self, *args)

    def test_shortcut(self, *args):
        """test_shortcut(self) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Item_test_shortcut(self, *args)

    def find_shortcut(self, *args):
        """find_shortcut(self, int ip = None) -> Fl_Menu_Item"""
        return _fltk.Fl_Menu_Item_find_shortcut(self, *args)

    def do_callback(self, *args):
        """
        do_callback(self, Fl_Widget o)
        do_callback(self, Fl_Widget o, void arg)
        do_callback(self, Fl_Widget o, long arg)
        """
        return _fltk.Fl_Menu_Item_do_callback(self, *args)

    def checked(self, *args):
        """checked(self) -> int"""
        return _fltk.Fl_Menu_Item_checked(self, *args)

    def check(self, *args):
        """check(self)"""
        return _fltk.Fl_Menu_Item_check(self, *args)

    def uncheck(self, *args):
        """uncheck(self)"""
        return _fltk.Fl_Menu_Item_uncheck(self, *args)

    def add(self, *args):
        """
        add(self, char arg0, int shortcut, Fl_Callback arg2, void arg3 = None, 
            int arg4 = 0) -> int
        add(self, char a, char b, Fl_Callback c, void d = None, int e = 0) -> int
        """
        return _fltk.Fl_Menu_Item_add(self, *args)

    def size(self, *args):
        """size(self) -> int"""
        return _fltk.Fl_Menu_Item_size(self, *args)

    def callback(self, *args):
        """
        callback(self, Fl_Callback c, void p)
        callback(self, Fl_Callback c)
        callback(self, Fl_Callback0 c)
        callback(self, Fl_Callback1 c, long p = 0)
        callback(self) -> PyObject
        """
        return _fltk.Fl_Menu_Item_callback(self, *args)

    def user_data(self, *args):
        """
        user_data(self)
        user_data(self, void v)
        user_data(self) -> PyObject
        """
        return _fltk.Fl_Menu_Item_user_data(self, *args)

    def __init__(self, *args): 
        """__init__(self) -> Fl_Menu_Item"""
        this = _fltk.new_Fl_Menu_Item(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Menu_Item
    __del__ = lambda self : None;
Fl_Menu_Item_swigregister = _fltk.Fl_Menu_Item_swigregister
Fl_Menu_Item_swigregister(Fl_Menu_Item)

FL_PUP_NONE = _fltk.FL_PUP_NONE
FL_PUP_GREY = _fltk.FL_PUP_GREY
FL_PUP_GRAY = _fltk.FL_PUP_GRAY
FL_MENU_BOX = _fltk.FL_MENU_BOX
FL_PUP_BOX = _fltk.FL_PUP_BOX
FL_MENU_CHECK = _fltk.FL_MENU_CHECK
FL_PUP_CHECK = _fltk.FL_PUP_CHECK
FL_PUP_RADIO = _fltk.FL_PUP_RADIO
FL_PUP_INVISIBLE = _fltk.FL_PUP_INVISIBLE
FL_PUP_SUBMENU = _fltk.FL_PUP_SUBMENU
class Fl_Single_Window(Fl_Window):
    """
    This is the same as Fl_Window. However, it is possible that some 
    implementations will provide double-buffered windows by default. This 
    subclass can be used to force single-buffering. This may be useful for 
    modifying existing programs that use incremental update, or for some 
    types of image data, such as a movie flipbook.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def flush(self, *args):
        """flush(self)"""
        return _fltk.Fl_Single_Window_flush(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, int W, int H, char l = None) -> Fl_Single_Window
        __init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Single_Window
        """
        if self.__class__ == Fl_Single_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Single_Window(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def show(self, *args):
        """show(self, PyObject count = None, PyObject data = None)"""
        return _fltk.Fl_Single_Window_show(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Single_Window
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Single_Window(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Single_Window_draw(self, *args)

Fl_Single_Window_swigregister = _fltk.Fl_Single_Window_swigregister
Fl_Single_Window_swigregister(Fl_Single_Window)

class Fl_Menu_Window(Fl_Single_Window):
    """
    The Fl_Menu_Window widget is a window type used for menus. By default the 
    window is drawn in the hardware overlay planes if they are available so that 
    the menu don't force the rest of the window to redraw.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def erase(self, *args):
        """erase(self)"""
        return _fltk.Fl_Menu_Window_erase(self, *args)

    def flush(self, *args):
        """flush(self)"""
        return _fltk.Fl_Menu_Window_flush(self, *args)

    def hide(self, *args):
        """hide(self)"""
        return _fltk.Fl_Menu_Window_hide(self, *args)

    def overlay(self, *args):
        """overlay(self) -> int"""
        return _fltk.Fl_Menu_Window_overlay(self, *args)

    def set_overlay(self, *args):
        """set_overlay(self)"""
        return _fltk.Fl_Menu_Window_set_overlay(self, *args)

    def clear_overlay(self, *args):
        """clear_overlay(self)"""
        return _fltk.Fl_Menu_Window_clear_overlay(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Menu_Window
    __del__ = lambda self : None;
    def __init__(self, *args): 
        """
        __init__(self, int W, int H, char l = None) -> Fl_Menu_Window
        __init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Menu_Window
        """
        if self.__class__ == Fl_Menu_Window:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Menu_Window(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Menu_Window(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Menu_Window_draw(self, *args)

Fl_Menu_Window_swigregister = _fltk.Fl_Menu_Window_swigregister
Fl_Menu_Window_swigregister(Fl_Menu_Window)

class Fl_Multiline_Input(Fl_Input):
    """
    This input field displays '
    ' characters as new lines rather than ^J, and 
    accepts the Return, Tab, and up and down arrow keys. This is for editing 
    multiline text.

    This is far from the nirvana of text editors, and is probably only good for 
    small bits of text, 10 lines at most. I think FLTK can be used to write a 
    powerful text editor, but it is not going to be a built-in feature. Powerful 
    text editors in a toolkit are a big source of bloat. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Multiline_Input"""
        if self.__class__ == Fl_Multiline_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Multiline_Input(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Multiline_Input
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Multiline_Input(self)
        return weakref_proxy(self)
Fl_Multiline_Input_swigregister = _fltk.Fl_Multiline_Input_swigregister
Fl_Multiline_Input_swigregister(Fl_Multiline_Input)

class Fl_Output(Fl_Input):
    """
    This widget displays a piece of text. When you set the value() , Fl_Output 
    does a strcpy() to it's own storage, which is useful for program-generated 
    values. The user may select portions of the text using the mouse and paste 
    the contents into other fields or programs.

    There is a single subclass, Fl_Multiline_Output, which allows you to 
    display multiple lines of text.

    The text may contain any characters except 
    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Output"""
        if self.__class__ == Fl_Output:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Output(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Output
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Output(self)
        return weakref_proxy(self)
Fl_Output_swigregister = _fltk.Fl_Output_swigregister
Fl_Output_swigregister(Fl_Output)

class Fl_Multiline_Output(Fl_Output):
    """
    This widget is a subclass of Fl_Output that displays multiple lines of text. 
    It also displays tab characters as whitespace to the next column.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Multiline_Output"""
        if self.__class__ == Fl_Multiline_Output:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Multiline_Output(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Multiline_Output
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Multiline_Output(self)
        return weakref_proxy(self)
Fl_Multiline_Output_swigregister = _fltk.Fl_Multiline_Output_swigregister
Fl_Multiline_Output_swigregister(Fl_Multiline_Output)

class Fl_Multi_Browser(Fl_Browser):
    """
    The Fl_Multi_Browser class is a subclass of Fl_Browser  which lets the user 
    select any set of the lines. The user interface is Macintosh style: clicking 
    an item turns off all the others and selects that one, dragging selects all 
    the items the mouse moves over, and shift + click toggles the items. This 
    is different then how forms did it. Normally the callback is done when the 
    user releases the mouse, but you can change this with when().

    See Fl_Browser for methods to add and remove lines from the browser. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char L = None) -> Fl_Multi_Browser"""
        if self.__class__ == Fl_Multi_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Multi_Browser(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Multi_Browser
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Multi_Browser(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Multi_Browser_draw(self, *args)

    def item_first(self, *args):
        """item_first(self) -> void"""
        return _fltk.Fl_Multi_Browser_item_first(self, *args)

    def item_next(self, *args):
        """item_next(self, void arg0) -> void"""
        return _fltk.Fl_Multi_Browser_item_next(self, *args)

    def item_prev(self, *args):
        """item_prev(self, void arg0) -> void"""
        return _fltk.Fl_Multi_Browser_item_prev(self, *args)

    def item_height(self, *args):
        """item_height(self, void arg0) -> int"""
        return _fltk.Fl_Multi_Browser_item_height(self, *args)

    def item_width(self, *args):
        """item_width(self, void arg0) -> int"""
        return _fltk.Fl_Multi_Browser_item_width(self, *args)

    def item_quick_height(self, *args):
        """item_quick_height(self, void arg0) -> int"""
        return _fltk.Fl_Multi_Browser_item_quick_height(self, *args)

    def item_draw(self, *args):
        """item_draw(self, void arg0, int arg1, int arg2, int arg3, int arg4)"""
        return _fltk.Fl_Multi_Browser_item_draw(self, *args)

    def full_width(self, *args):
        """full_width(self) -> int"""
        return _fltk.Fl_Multi_Browser_full_width(self, *args)

    def full_height(self, *args):
        """full_height(self) -> int"""
        return _fltk.Fl_Multi_Browser_full_height(self, *args)

    def incr_height(self, *args):
        """incr_height(self) -> int"""
        return _fltk.Fl_Multi_Browser_incr_height(self, *args)

    def item_select(self, *args):
        """item_select(self, void arg0, int arg1)"""
        return _fltk.Fl_Multi_Browser_item_select(self, *args)

    def item_selected(self, *args):
        """item_selected(self, void arg0) -> int"""
        return _fltk.Fl_Multi_Browser_item_selected(self, *args)

Fl_Multi_Browser_swigregister = _fltk.Fl_Multi_Browser_swigregister
Fl_Multi_Browser_swigregister(Fl_Multi_Browser)

class Fl_Multi_Label(object):
    """Proxy of C++ Fl_Multi_Label class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def label(self, *args):
        """
        label(self, Fl_Widget arg0)
        label(self, Fl_Menu_Item arg0)
        """
        return _fltk.Fl_Multi_Label_label(self, *args)

    def __init__(self, *args): 
        """__init__(self) -> Fl_Multi_Label"""
        this = _fltk.new_Fl_Multi_Label(*args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Multi_Label
    __del__ = lambda self : None;
Fl_Multi_Label_swigregister = _fltk.Fl_Multi_Label_swigregister
Fl_Multi_Label_swigregister(Fl_Multi_Label)

class Fl_Nice_Slider(Fl_Slider):
    """
    The Fl_Nice_Slider widget contains a sliding knob inside a box. It is 
    often used as a scrollbar. Moving the box all the way to the top/left sets 
    it to the minimum(), and to the bottom/right to the maximum(). The minimum() 
    may be greater than the maximum() to reverse the slider direction.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Nice_Slider"""
        if self.__class__ == Fl_Nice_Slider:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Nice_Slider(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Nice_Slider
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Nice_Slider(self)
        return weakref_proxy(self)
Fl_Nice_Slider_swigregister = _fltk.Fl_Nice_Slider_swigregister
Fl_Nice_Slider_swigregister(Fl_Nice_Slider)

class Fl_Overlay_Window(Fl_Double_Window):
    """
    This window provides double buffering and also the ability to draw the 
    'overlay' which is another picture placed on top of the main image. The 
    overlay is designed to be a rapidly-changing but simple graphic such as 
    a mouse selection box. Fl_Overlay_Window uses the overlay planes provided 
    by your graphics hardware if they are available.

    If no hardware support is found the overlay is simulated by drawing directly 
    into the on-screen copy of the double-buffered window, and 'erased' by 
    copying the backbuffer over it again. This means the overlay will blink if 
    you change the image in the window. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def flush(self, *args):
        """flush(self)"""
        return _fltk.Fl_Overlay_Window_flush(self, *args)

    def hide(self, *args):
        """hide(self)"""
        return _fltk.Fl_Overlay_Window_hide(self, *args)

    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Overlay_Window_resize(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Overlay_Window
    __del__ = lambda self : None;
    def can_do_overlay(self, *args):
        """can_do_overlay(self) -> int"""
        return _fltk.Fl_Overlay_Window_can_do_overlay(self, *args)

    def redraw_overlay(self, *args):
        """redraw_overlay(self)"""
        return _fltk.Fl_Overlay_Window_redraw_overlay(self, *args)

    def show(self, *args):
        """show(self, PyObject count = None, PyObject data = None)"""
        return _fltk.Fl_Overlay_Window_show(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Overlay_Window(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Overlay_Window_draw(self, *args)

Fl_Overlay_Window_swigregister = _fltk.Fl_Overlay_Window_swigregister
Fl_Overlay_Window_swigregister(Fl_Overlay_Window)

class Fl_Pack(Fl_Group):
    """
    This widget was designed to add the functionality of compressing and 
    aligning widgets.

    If type() is FL_HORIZONTAL all the children are resized to the height of 
    the Fl_Pack, and are moved next to each other horizontally. If type() is 
    not FL_HORIZONTAL then the children are resized to the width and are stacked 
    below each other. Then the Fl_Pack resizes itself to surround the child 
    widgets.

    This widget is needed for the Fl_Tabs. In addition you may want to put the 
    Fl_Pack inside an Fl_Scroll. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    VERTICAL = _fltk.Fl_Pack_VERTICAL
    HORIZONTAL = _fltk.Fl_Pack_HORIZONTAL
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Pack_draw(self, *args)

    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Pack"""
        if self.__class__ == Fl_Pack:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Pack(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def spacing(self, *args):
        """
        spacing(self) -> int
        spacing(self, int i)
        """
        return _fltk.Fl_Pack_spacing(self, *args)

    def horizontal(self, *args):
        """horizontal(self) -> uchar"""
        return _fltk.Fl_Pack_horizontal(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Pack
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Pack(self)
        return weakref_proxy(self)
Fl_Pack_swigregister = _fltk.Fl_Pack_swigregister
Fl_Pack_swigregister(Fl_Pack)

class Fl_PNG_Image(Fl_RGB_Image):
    """
    The Fl_PNG_Image class supports loading, caching, and drawing of Portable 
    Network Graphics (PNG) image files. The class loads colormapped and 
    full-color images and handles color- and alpha-based transparency.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char filename) -> Fl_PNG_Image"""
        if self.__class__ == Fl_PNG_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_PNG_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_PNG_Image
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_PNG_Image(self)
        return weakref_proxy(self)
Fl_PNG_Image_swigregister = _fltk.Fl_PNG_Image_swigregister
Fl_PNG_Image_swigregister(Fl_PNG_Image)

class Fl_PNM_Image(Fl_RGB_Image):
    """
    The Fl_PNM_Image class supports loading, caching, and drawing of Portable 
    Anymap (PNM, PBM, PGM, PPM) image files. The class loads bitmap, grayscale, 
    and full-color images in both ASCII and binary formats.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char filename) -> Fl_PNM_Image"""
        if self.__class__ == Fl_PNM_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_PNM_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_PNM_Image
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_PNM_Image(self)
        return weakref_proxy(self)
Fl_PNM_Image_swigregister = _fltk.Fl_PNM_Image_swigregister
Fl_PNM_Image_swigregister(Fl_PNM_Image)

class Fl_Positioner(Fl_Widget):
    """
    This class is provided for Forms compatibility. It provides 2D input. It 
    would be useful if this could be put atop another widget so that the 
    crosshairs are on top, but this is not implemented. The color of the 
    crosshairs is selection_color().

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Positioner_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Positioner_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Positioner"""
        if self.__class__ == Fl_Positioner:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Positioner(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def xvalue(self, *args):
        """
        xvalue(self) -> double
        xvalue(self, double arg0) -> int
        """
        return _fltk.Fl_Positioner_xvalue(self, *args)

    def yvalue(self, *args):
        """
        yvalue(self) -> double
        yvalue(self, double arg0) -> int
        """
        return _fltk.Fl_Positioner_yvalue(self, *args)

    def value(self, *args):
        """value(self, double arg0, double arg1) -> int"""
        return _fltk.Fl_Positioner_value(self, *args)

    def xbounds(self, *args):
        """xbounds(self, double arg0, double arg1)"""
        return _fltk.Fl_Positioner_xbounds(self, *args)

    def xminimum(self, *args):
        """
        xminimum(self) -> double
        xminimum(self, double a)
        """
        return _fltk.Fl_Positioner_xminimum(self, *args)

    def xmaximum(self, *args):
        """
        xmaximum(self) -> double
        xmaximum(self, double a)
        """
        return _fltk.Fl_Positioner_xmaximum(self, *args)

    def ybounds(self, *args):
        """ybounds(self, double arg0, double arg1)"""
        return _fltk.Fl_Positioner_ybounds(self, *args)

    def yminimum(self, *args):
        """
        yminimum(self) -> double
        yminimum(self, double a)
        """
        return _fltk.Fl_Positioner_yminimum(self, *args)

    def ymaximum(self, *args):
        """
        ymaximum(self) -> double
        ymaximum(self, double a)
        """
        return _fltk.Fl_Positioner_ymaximum(self, *args)

    def xstep(self, *args):
        """xstep(self, double a)"""
        return _fltk.Fl_Positioner_xstep(self, *args)

    def ystep(self, *args):
        """ystep(self, double a)"""
        return _fltk.Fl_Positioner_ystep(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Positioner
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Positioner(self)
        return weakref_proxy(self)
Fl_Positioner_swigregister = _fltk.Fl_Positioner_swigregister
Fl_Positioner_swigregister(Fl_Positioner)

class Fl_Preferences(object):
    """
    Fl_Preferences provides methods to store user setting between application 
    starts. It is similar to the Registry on WIN32 and Preferences on MacOS, 
    and provides a simple configuration mechanism for UNIX.

    Fl_Preferences uses a hierarchy to store data. It bundles similar data into 
    groups and manages entries into those groups as name/value pairs.

    Preferences are stored in text files that can be edited manually. The file 
    format is easy to read and relatively forgiving. Preferences files are the 
    same on all platforms. User comments in preference files are preserved. 
    Filenames are unique for each application by using a vendor/application 
    naming scheme. The user must provide default values for all entries to 
    ensure proper operation should preferences be corrupted or not yet exist.

    Entries can be of any length. However, the size of each preferences file 
    should be kept under 100k for performance reasons. One application can 
    have multiple preferences files. Extensive binary data however should be 
    stored in seperate files; see the getUserdataPath() method. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    SYSTEM = _fltk.Fl_Preferences_SYSTEM
    USER = _fltk.Fl_Preferences_USER
    def __init__(self, *args): 
        """
        __init__(self, Root root, char vendor, char application) -> Fl_Preferences
        __init__(self, char path, char vendor, char application) -> Fl_Preferences
        __init__(self, Fl_Preferences arg0, char group) -> Fl_Preferences
        """
        this = _fltk.new_Fl_Preferences(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Preferences
    __del__ = lambda self : None;
    def groups(self, *args):
        """groups(self) -> int"""
        return _fltk.Fl_Preferences_groups(self, *args)

    def group(self, *args):
        """group(self, int arg0) -> char"""
        return _fltk.Fl_Preferences_group(self, *args)

    def groupExists(self, *args):
        """groupExists(self, char group) -> char"""
        return _fltk.Fl_Preferences_groupExists(self, *args)

    def deleteGroup(self, *args):
        """deleteGroup(self, char group) -> char"""
        return _fltk.Fl_Preferences_deleteGroup(self, *args)

    def entries(self, *args):
        """entries(self) -> int"""
        return _fltk.Fl_Preferences_entries(self, *args)

    def entry(self, *args):
        """entry(self, int arg0) -> char"""
        return _fltk.Fl_Preferences_entry(self, *args)

    def entryExists(self, *args):
        """entryExists(self, char entry) -> char"""
        return _fltk.Fl_Preferences_entryExists(self, *args)

    def deleteEntry(self, *args):
        """deleteEntry(self, char entry) -> char"""
        return _fltk.Fl_Preferences_deleteEntry(self, *args)

    def set(self, *args):
        """
        set(self, char entry, int value) -> char
        set(self, char entry, float value, int precision) -> char
        set(self, char entry, double value) -> char
        set(self, char entry, double value, int precision) -> char
        set(self, char entry, char cvalue) -> char
        set(self, char entry, void cvalue, int size) -> char
        """
        return _fltk.Fl_Preferences_set(self, *args)

    def get(self, *args):
        """
        get(self, char entry, int defaultValue) -> char
        get(self, char entry, float defaultValue) -> char
        get(self, char entry, double defaultValue) -> char
        get(self, char entry, char defaultValue, int maxSize) -> char
        get(self, char entry, void value, void defaultValue, int defaultSize, 
            int maxSize) -> char
        """
        return _fltk.Fl_Preferences_get(self, *args)

    def size(self, *args):
        """size(self, char entry) -> int"""
        return _fltk.Fl_Preferences_size(self, *args)

    def getUserdataPath(self, *args):
        """getUserdataPath(self, char path) -> char"""
        return _fltk.Fl_Preferences_getUserdataPath(self, *args)

    def flush(self, *args):
        """flush(self)"""
        return _fltk.Fl_Preferences_flush(self, *args)

Fl_Preferences_swigregister = _fltk.Fl_Preferences_swigregister
Fl_Preferences_swigregister(Fl_Preferences)

class Fl_Progress(Fl_Widget):
    """
    The Fl_Progress widget displays a progress bar for the user.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Progress_draw(self, *args)

    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Progress"""
        if self.__class__ == Fl_Progress:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Progress(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def maximum(self, *args):
        """
        maximum(self, float v)
        maximum(self) -> float
        """
        return _fltk.Fl_Progress_maximum(self, *args)

    def minimum(self, *args):
        """
        minimum(self, float v)
        minimum(self) -> float
        """
        return _fltk.Fl_Progress_minimum(self, *args)

    def value(self, *args):
        """
        value(self, float v)
        value(self) -> float
        """
        return _fltk.Fl_Progress_value(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Progress
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Progress(self)
        return weakref_proxy(self)
Fl_Progress_swigregister = _fltk.Fl_Progress_swigregister
Fl_Progress_swigregister(Fl_Progress)

class Fl_Radio_Button(Fl_Button):
    """Proxy of C++ Fl_Radio_Button class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Radio_Button"""
        if self.__class__ == Fl_Radio_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Radio_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Radio_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Radio_Button(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Radio_Button_draw(self, *args)

Fl_Radio_Button_swigregister = _fltk.Fl_Radio_Button_swigregister
Fl_Radio_Button_swigregister(Fl_Radio_Button)

class Fl_Radio_Light_Button(Fl_Light_Button):
    """Proxy of C++ Fl_Radio_Light_Button class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Radio_Light_Button"""
        if self.__class__ == Fl_Radio_Light_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Radio_Light_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Radio_Light_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Radio_Light_Button(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Radio_Light_Button_draw(self, *args)

Fl_Radio_Light_Button_swigregister = _fltk.Fl_Radio_Light_Button_swigregister
Fl_Radio_Light_Button_swigregister(Fl_Radio_Light_Button)

class Fl_Round_Button(Fl_Light_Button):
    """
    Buttons generate callbacks when they are clicked by the user. You control 
    exactly when and how by changing the values for type() and when().

    The Fl_Round_Button subclass display the 'on' state by turning on a light, 
    rather than drawing pushed in. The shape of the 'light' is initially set 
    to FL_ROUND_DOWN_BOX. The color of the light when on is controlled with 
    selection_color(), which defaults to FL_RED.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Round_Button"""
        if self.__class__ == Fl_Round_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Round_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Round_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Round_Button(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Round_Button_draw(self, *args)

Fl_Round_Button_swigregister = _fltk.Fl_Round_Button_swigregister
Fl_Round_Button_swigregister(Fl_Round_Button)

class Fl_Radio_Round_Button(Fl_Round_Button):
    """Proxy of C++ Fl_Radio_Round_Button class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Radio_Round_Button"""
        if self.__class__ == Fl_Radio_Round_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Radio_Round_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Radio_Round_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Radio_Round_Button(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Radio_Round_Button_draw(self, *args)

Fl_Radio_Round_Button_swigregister = _fltk.Fl_Radio_Round_Button_swigregister
Fl_Radio_Round_Button_swigregister(Fl_Radio_Round_Button)

class Fl_Repeat_Button(Fl_Button):
    """
    The Fl_Repeat_Button is a subclass of Fl_Button that generates a callback 
    when it is pressed and then repeatedly generates callbacks as long as it 
    is held down. The speed of the repeat is fixed and depends on the 
    implementation.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Repeat_Button_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Repeat_Button"""
        if self.__class__ == Fl_Repeat_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Repeat_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def deactivate(self, *args):
        """deactivate(self)"""
        return _fltk.Fl_Repeat_Button_deactivate(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Repeat_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Repeat_Button(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Repeat_Button_draw(self, *args)

Fl_Repeat_Button_swigregister = _fltk.Fl_Repeat_Button_swigregister
Fl_Repeat_Button_swigregister(Fl_Repeat_Button)

class Fl_Return_Button(Fl_Button):
    """
    The Fl_Return_Button is a subclass of Fl_Button that generates a callback 
    when it is pressed or when the user presses the Enter key. A carriage-return 
    symbol is drawn next to the button label.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Return_Button_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Return_Button_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Return_Button"""
        if self.__class__ == Fl_Return_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Return_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Return_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Return_Button(self)
        return weakref_proxy(self)
Fl_Return_Button_swigregister = _fltk.Fl_Return_Button_swigregister
Fl_Return_Button_swigregister(Fl_Return_Button)

class Fl_Roller(Fl_Valuator):
    """
    The Fl_Roller widget is a 'dolly' control commonly used to move 3D objects.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Roller_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Roller_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char L = None) -> Fl_Roller"""
        if self.__class__ == Fl_Roller:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Roller(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Roller
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Roller(self)
        return weakref_proxy(self)
Fl_Roller_swigregister = _fltk.Fl_Roller_swigregister
Fl_Roller_swigregister(Fl_Roller)

class Fl_Round_Clock(Fl_Clock):
    """
    This widget provides a round analog clock display and is provided for 
    Forms compatibility. It installs a 1-second timeout callback using 
    Fl::add_timeout().

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Round_Clock"""
        if self.__class__ == Fl_Round_Clock:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Round_Clock(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Round_Clock
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Round_Clock(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Round_Clock_draw(self, *args)

Fl_Round_Clock_swigregister = _fltk.Fl_Round_Clock_swigregister
Fl_Round_Clock_swigregister(Fl_Round_Clock)

class Fl_Scroll(Fl_Group):
    """
    This container widget lets you maneuver around a set of widgets much larger 
    than your window. If the child widgets are larger than the size of this 
    object then scrollbars will appear so that you can scroll over to them:

    If all of the child widgets are packed together into a solid rectangle then 
    you want to set box() to FL_NO_BOX or one of the _FRAME types. This will 
    result in the best output. However, if the child widgets are a sparse 
    arrangment you must set box() to a real _BOX type. This can result in some 
    blinking during redrawing, but that can be solved by using a Fl_Double_Window.

    This widget can also be used to pan around a single child widget 'canvas'. 
    This child widget should be of your own class, with a draw() method that 
    draws the contents. The scrolling is done by changing the x() and y() of 
    the widget, so this child must use the x() and y() to position it's drawing. 
    To speed up drawing it should test fl_push_clip() .

    Another very useful child is a single Fl_Pack, which is itself a group that 
    packs it's children together and changes size to surround them. Filling the 
    Fl_Pack with Fl_Tabs groups (and then putting normal widgets inside those) 
    gives you a very powerful scrolling list of individually-openable panels.

    Fluid lets you create these, but you can only lay out objects that fit 
    inside the Fl_Scroll without scrolling. Be sure to leave space for the 
    scrollbars, as Fluid won't show these either.

    You cannot use Fl_Window as a child of this since the clipping is not 
    conveyed to it when drawn, and it will draw over the scrollbars and 
    neighboring objects.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Scroll_draw(self, *args)

    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Scroll_resize(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Scroll_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Scroll"""
        if self.__class__ == Fl_Scroll:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Scroll(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    HORIZONTAL = _fltk.Fl_Scroll_HORIZONTAL
    VERTICAL = _fltk.Fl_Scroll_VERTICAL
    BOTH = _fltk.Fl_Scroll_BOTH
    ALWAYS_ON = _fltk.Fl_Scroll_ALWAYS_ON
    HORIZONTAL_ALWAYS = _fltk.Fl_Scroll_HORIZONTAL_ALWAYS
    VERTICAL_ALWAYS = _fltk.Fl_Scroll_VERTICAL_ALWAYS
    BOTH_ALWAYS = _fltk.Fl_Scroll_BOTH_ALWAYS
    def xposition(self, *args):
        """xposition(self) -> int"""
        return _fltk.Fl_Scroll_xposition(self, *args)

    def yposition(self, *args):
        """yposition(self) -> int"""
        return _fltk.Fl_Scroll_yposition(self, *args)

    def position(self, *args):
        """position(self, int arg0, int arg1)"""
        return _fltk.Fl_Scroll_position(self, *args)

    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_Scroll_clear(self, *args)

    def getScrollbar(self, *args):
        """getScrollbar(self) -> Fl_Scrollbar"""
        return _fltk.Fl_Scroll_getScrollbar(self, *args)

    def getHScrollbar(self, *args):
        """getHScrollbar(self) -> Fl_Scrollbar"""
        return _fltk.Fl_Scroll_getHScrollbar(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Scroll
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Scroll(self)
        return weakref_proxy(self)
Fl_Scroll_swigregister = _fltk.Fl_Scroll_swigregister
Fl_Scroll_swigregister(Fl_Scroll)

class Fl_Scrollbar(Fl_Slider):
    """
    The Fl_Scrollbar widget displays a slider with arrow buttons at the ends 
    of the scrollbar. Clicking on the arrows move up/left and down/right by 
    linesize(). Scrollbars also accept FL_SHORTCUT events: the arrows move by 
    linesize(), and vertical scrollbars take Page Up/Down (they move by the 
    page size minus linesize()) and Home/End (they jump to the top or bottom).

    Scrollbars have step(1) preset (they always return integers). If desired 
    you can set the step() to non-integer values. You will then have to use 
    casts to get at the floating-point versions of value() from Fl_Slider. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Scrollbar_draw(self, *args)

    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Scrollbar"""
        if self.__class__ == Fl_Scrollbar:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Scrollbar(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Scrollbar
    __del__ = lambda self : None;
    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Scrollbar_handle(self, *args)

    def value(self, *args):
        """
        value(self) -> int
        value(self, int p, int s, int top, int total) -> int
        """
        return _fltk.Fl_Scrollbar_value(self, *args)

    def linesize(self, *args):
        """
        linesize(self) -> int
        linesize(self, int i)
        """
        return _fltk.Fl_Scrollbar_linesize(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Scrollbar(self)
        return weakref_proxy(self)
Fl_Scrollbar_swigregister = _fltk.Fl_Scrollbar_swigregister
Fl_Scrollbar_swigregister(Fl_Scrollbar)

class Fl_Secret_Input(Fl_Input):
    """
    The Fl_Secret_Input class is a subclass of Fl_Input  that displays its input 
    as a string of asterisks. This subclass is usually used to receive passwords 
    and other 'secret' information.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Secret_Input"""
        if self.__class__ == Fl_Secret_Input:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Secret_Input(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Secret_Input
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Secret_Input(self)
        return weakref_proxy(self)
Fl_Secret_Input_swigregister = _fltk.Fl_Secret_Input_swigregister
Fl_Secret_Input_swigregister(Fl_Secret_Input)

class Fl_Select_Browser(Fl_Browser):
    """
    The Fl_Select_Browser class is a subclass of Fl_Browser  which lets the 
    user select a single item, or no items by clicking on the empty space. As 
    long as the mouse button is held down the item pointed to by it is 
    highlighted. Normally the callback is done when the user presses the mouse, 
    but you can change this with when().

    See Fl_Browser for methods to add and remove lines from the browser. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Select_Browser"""
        if self.__class__ == Fl_Select_Browser:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Select_Browser(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Select_Browser
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Select_Browser(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Select_Browser_draw(self, *args)

    def item_first(self, *args):
        """item_first(self) -> void"""
        return _fltk.Fl_Select_Browser_item_first(self, *args)

    def item_next(self, *args):
        """item_next(self, void arg0) -> void"""
        return _fltk.Fl_Select_Browser_item_next(self, *args)

    def item_prev(self, *args):
        """item_prev(self, void arg0) -> void"""
        return _fltk.Fl_Select_Browser_item_prev(self, *args)

    def item_height(self, *args):
        """item_height(self, void arg0) -> int"""
        return _fltk.Fl_Select_Browser_item_height(self, *args)

    def item_width(self, *args):
        """item_width(self, void arg0) -> int"""
        return _fltk.Fl_Select_Browser_item_width(self, *args)

    def item_quick_height(self, *args):
        """item_quick_height(self, void arg0) -> int"""
        return _fltk.Fl_Select_Browser_item_quick_height(self, *args)

    def item_draw(self, *args):
        """item_draw(self, void arg0, int arg1, int arg2, int arg3, int arg4)"""
        return _fltk.Fl_Select_Browser_item_draw(self, *args)

    def full_width(self, *args):
        """full_width(self) -> int"""
        return _fltk.Fl_Select_Browser_full_width(self, *args)

    def full_height(self, *args):
        """full_height(self) -> int"""
        return _fltk.Fl_Select_Browser_full_height(self, *args)

    def incr_height(self, *args):
        """incr_height(self) -> int"""
        return _fltk.Fl_Select_Browser_incr_height(self, *args)

    def item_select(self, *args):
        """item_select(self, void arg0, int arg1)"""
        return _fltk.Fl_Select_Browser_item_select(self, *args)

    def item_selected(self, *args):
        """item_selected(self, void arg0) -> int"""
        return _fltk.Fl_Select_Browser_item_selected(self, *args)

Fl_Select_Browser_swigregister = _fltk.Fl_Select_Browser_swigregister
Fl_Select_Browser_swigregister(Fl_Select_Browser)

class Fl_Shared_Image(Fl_Image):
    """
    The Fl_Shared_Image class supports caching, loading, and drawing of image 
    files. Most applications will also want to link against the fltk_images 
    library and call the fl_register_images() function to support standard image 
    formats such as BMP, GIF, JPEG, and PNG.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> Fl_Shared_Image
        __init__(self, char n, Fl_Image img = None) -> Fl_Shared_Image
        """
        if self.__class__ == Fl_Shared_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Shared_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    def name(self, *args):
        """name(self) -> char"""
        return _fltk.Fl_Shared_Image_name(self, *args)

    def refcount(self, *args):
        """refcount(self) -> int"""
        return _fltk.Fl_Shared_Image_refcount(self, *args)

    def release(self, *args):
        """release(self)"""
        return _fltk.Fl_Shared_Image_release(self, *args)

    def reload(self, *args):
        """reload(self)"""
        return _fltk.Fl_Shared_Image_reload(self, *args)

    def copy(self, *args):
        """
        copy(self, int W, int H) -> Fl_Image
        copy(self) -> Fl_Image
        """
        return _fltk.Fl_Shared_Image_copy(self, *args)

    def color_average(self, *args):
        """color_average(self, Fl_Color c, float i)"""
        return _fltk.Fl_Shared_Image_color_average(self, *args)

    def desaturate(self, *args):
        """desaturate(self)"""
        return _fltk.Fl_Shared_Image_desaturate(self, *args)

    def draw(self, *args):
        """
        draw(self, int X, int Y, int W, int H, int cx, int cy)
        draw(self, int X, int Y)
        """
        return _fltk.Fl_Shared_Image_draw(self, *args)

    def uncache(self, *args):
        """uncache(self)"""
        return _fltk.Fl_Shared_Image_uncache(self, *args)

    def find(*args):
        """find(char n, int W = 0, int H = 0) -> Fl_Shared_Image"""
        return _fltk.Fl_Shared_Image_find(*args)

    find = staticmethod(find)
    def get(*args):
        """get(char n, int W = 0, int H = 0) -> Fl_Shared_Image"""
        return _fltk.Fl_Shared_Image_get(*args)

    get = staticmethod(get)
    def images(*args):
        """images() -> Fl_Shared_Image"""
        return _fltk.Fl_Shared_Image_images(*args)

    images = staticmethod(images)
    def num_images(*args):
        """num_images() -> int"""
        return _fltk.Fl_Shared_Image_num_images(*args)

    num_images = staticmethod(num_images)
    def add_handler(*args):
        """add_handler(Fl_Shared_Handler f)"""
        return _fltk.Fl_Shared_Image_add_handler(*args)

    add_handler = staticmethod(add_handler)
    def remove_handler(*args):
        """remove_handler(Fl_Shared_Handler f)"""
        return _fltk.Fl_Shared_Image_remove_handler(*args)

    remove_handler = staticmethod(remove_handler)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Shared_Image(self)
        return weakref_proxy(self)
Fl_Shared_Image_swigregister = _fltk.Fl_Shared_Image_swigregister
Fl_Shared_Image_swigregister(Fl_Shared_Image)

def Fl_Shared_Image_find(*args):
  """Fl_Shared_Image_find(char n, int W = 0, int H = 0) -> Fl_Shared_Image"""
  return _fltk.Fl_Shared_Image_find(*args)

def Fl_Shared_Image_get(*args):
  """Fl_Shared_Image_get(char n, int W = 0, int H = 0) -> Fl_Shared_Image"""
  return _fltk.Fl_Shared_Image_get(*args)

def Fl_Shared_Image_images(*args):
  """Fl_Shared_Image_images() -> Fl_Shared_Image"""
  return _fltk.Fl_Shared_Image_images(*args)

def Fl_Shared_Image_num_images(*args):
  """Fl_Shared_Image_num_images() -> int"""
  return _fltk.Fl_Shared_Image_num_images(*args)

def Fl_Shared_Image_add_handler(*args):
  """Fl_Shared_Image_add_handler(Fl_Shared_Handler f)"""
  return _fltk.Fl_Shared_Image_add_handler(*args)

def Fl_Shared_Image_remove_handler(*args):
  """Fl_Shared_Image_remove_handler(Fl_Shared_Handler f)"""
  return _fltk.Fl_Shared_Image_remove_handler(*args)


def fl_register_images(*args):
  """fl_register_images()"""
  return _fltk.fl_register_images(*args)
class Fl_Spinner(Fl_Group):
    """
    The Fl_Spinner widget is a combination of the input widget and repeat 
    buttons. The user can either type into the input area or use the buttons 
    to change the value.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char L = None) -> Fl_Spinner"""
        if self.__class__ == Fl_Spinner:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Spinner(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def format(self, *args):
        """
        format(self) -> char
        format(self, char f)
        """
        return _fltk.Fl_Spinner_format(self, *args)

    def handle(self, *args):
        """handle(self, int event) -> int"""
        return _fltk.Fl_Spinner_handle(self, *args)

    def maxinum(self, *args):
        """maxinum(self) -> double"""
        return _fltk.Fl_Spinner_maxinum(self, *args)

    def mininum(self, *args):
        """mininum(self) -> double"""
        return _fltk.Fl_Spinner_mininum(self, *args)

    def range(self, *args):
        """range(self, double a, double b)"""
        return _fltk.Fl_Spinner_range(self, *args)

    def resize(self, *args):
        """resize(self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Spinner_resize(self, *args)

    def step(self, *args):
        """
        step(self) -> double
        step(self, double s)
        """
        return _fltk.Fl_Spinner_step(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, Fl_Color c)
        """
        return _fltk.Fl_Spinner_textcolor(self, *args)

    def textfont(self, *args):
        """
        textfont(self) -> uchar
        textfont(self, uchar f)
        """
        return _fltk.Fl_Spinner_textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_Spinner_textsize(self, *args)

    def type(self, *args):
        """
        type(self) -> uchar
        type(self, uchar v)
        """
        return _fltk.Fl_Spinner_type(self, *args)

    def value(self, *args):
        """
        value(self) -> double
        value(self, double v)
        """
        return _fltk.Fl_Spinner_value(self, *args)

    def minimum(self, *args):
        """
        minimum(self, double m)
        minimum(self) -> double
        """
        return _fltk.Fl_Spinner_minimum(self, *args)

    def maximum(self, *args):
        """
        maximum(self, double m)
        maximum(self) -> double
        """
        return _fltk.Fl_Spinner_maximum(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Spinner
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Spinner(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Spinner_draw(self, *args)

Fl_Spinner_swigregister = _fltk.Fl_Spinner_swigregister
Fl_Spinner_swigregister(Fl_Spinner)


def fl_show_colormap(*args):
  """fl_show_colormap(Fl_Color oldcol) -> Fl_Color"""
  return _fltk.fl_show_colormap(*args)
class Fl_Simple_Counter(Fl_Counter):
    """Proxy of C++ Fl_Simple_Counter class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Simple_Counter"""
        if self.__class__ == Fl_Simple_Counter:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Simple_Counter(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Simple_Counter
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Simple_Counter(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Simple_Counter_draw(self, *args)

Fl_Simple_Counter_swigregister = _fltk.Fl_Simple_Counter_swigregister
Fl_Simple_Counter_swigregister(Fl_Simple_Counter)

class Fl_Tabs(Fl_Group):
    """
    The Fl_Tabs widget is the 'file card tabs' interface that allows you to 
    put lots and lots of buttons and switches in a panel, as popularized by 
    many toolkits.

    Clicking the tab makes a child visible() by calling show() on it, and 
    all other children are made invisible by calling hide() on them. Usually 
    the children are Fl_Group widgets containing several widgets themselves.

    Each child makes a card, and it's label() is printed on the card tab, 
    including the label font and style. The selection color of that child 
    is used to color the tab, while the color of the child determines the 
    background color of the pane.

    The size of the tabs is controlled by the bounding box of the children 
    (there should be some space between the children and the edge of the Fl_Tabs), 
    and the tabs may be placed 'inverted' on the bottom, this is determined 
    by which gap is larger. It is easiest to lay this out in fluid, using the 
    fluid browser to select each child group and resize them until the tabs 
    look the way you want them to. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Tabs_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Tabs_handle(self, *args)

    def value(self, *args):
        """
        value(self) -> Fl_Widget
        value(self, Fl_Widget arg0) -> int
        """
        return _fltk.Fl_Tabs_value(self, *args)

    def push(self, *args):
        """
        push(self) -> Fl_Widget
        push(self, Fl_Widget arg0) -> int
        """
        return _fltk.Fl_Tabs_push(self, *args)

    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Tabs"""
        if self.__class__ == Fl_Tabs:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Tabs(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def which(self, *args):
        """which(self, int event_x, int event_y) -> Fl_Widget"""
        return _fltk.Fl_Tabs_which(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Tabs
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tabs(self)
        return weakref_proxy(self)
Fl_Tabs_swigregister = _fltk.Fl_Tabs_swigregister
Fl_Tabs_swigregister(Fl_Tabs)

FL_TEXT_MAX_EXP_CHAR_LEN = _fltk.FL_TEXT_MAX_EXP_CHAR_LEN
class Fl_Text_Selection(object):
    """Proxy of C++ Fl_Text_Selection class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def set(self, *args):
        """set(self, int start, int end)"""
        return _fltk.Fl_Text_Selection_set(self, *args)

    def set_rectangular(self, *args):
        """set_rectangular(self, int start, int end, int rectStart, int rectEnd)"""
        return _fltk.Fl_Text_Selection_set_rectangular(self, *args)

    def update(self, *args):
        """update(self, int pos, int nDeleted, int nInserted)"""
        return _fltk.Fl_Text_Selection_update(self, *args)

    def rectangular(self, *args):
        """rectangular(self) -> char"""
        return _fltk.Fl_Text_Selection_rectangular(self, *args)

    def start(self, *args):
        """start(self) -> int"""
        return _fltk.Fl_Text_Selection_start(self, *args)

    def end(self, *args):
        """end(self) -> int"""
        return _fltk.Fl_Text_Selection_end(self, *args)

    def rect_start(self, *args):
        """rect_start(self) -> int"""
        return _fltk.Fl_Text_Selection_rect_start(self, *args)

    def rect_end(self, *args):
        """rect_end(self) -> int"""
        return _fltk.Fl_Text_Selection_rect_end(self, *args)

    def selected(self, *args):
        """
        selected(self) -> char
        selected(self, char b)
        """
        return _fltk.Fl_Text_Selection_selected(self, *args)

    def includes(self, *args):
        """includes(self, int pos, int lineStartPos, int dispIndex) -> int"""
        return _fltk.Fl_Text_Selection_includes(self, *args)

    def position(self, *args):
        """
        position(self, int start, int end) -> int
        position(self, int start, int end, int isRect, int rectStart, int rectEnd) -> int
        """
        return _fltk.Fl_Text_Selection_position(self, *args)

    def __init__(self, *args): 
        """__init__(self) -> Fl_Text_Selection"""
        this = _fltk.new_Fl_Text_Selection(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Text_Selection
    __del__ = lambda self : None;
Fl_Text_Selection_swigregister = _fltk.Fl_Text_Selection_swigregister
Fl_Text_Selection_swigregister(Fl_Text_Selection)

class Fl_Text_Buffer(object):
    """
    The Fl_Text_Buffer class is used by the Fl_Text_Display and Fl_Text_Editor 
    to manage complex text data and is based upon the excellent NEdit text 
    editor engine - see http://www.nedit.org/.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int requestedSize = 0) -> Fl_Text_Buffer"""
        this = _fltk.new_Fl_Text_Buffer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Text_Buffer
    __del__ = lambda self : None;
    def length(self, *args):
        """length(self) -> int"""
        return _fltk.Fl_Text_Buffer_length(self, *args)

    def text(self, *args):
        """
        text(self) -> char
        text(self, char text)
        """
        return _fltk.Fl_Text_Buffer_text(self, *args)

    def text_range(self, *args):
        """text_range(self, int start, int end) -> char"""
        return _fltk.Fl_Text_Buffer_text_range(self, *args)

    def character(self, *args):
        """character(self, int pos) -> char"""
        return _fltk.Fl_Text_Buffer_character(self, *args)

    def text_in_rectangle(self, *args):
        """text_in_rectangle(self, int start, int end, int rectStart, int rectEnd) -> char"""
        return _fltk.Fl_Text_Buffer_text_in_rectangle(self, *args)

    def insert(self, *args):
        """insert(self, int pos, char text)"""
        return _fltk.Fl_Text_Buffer_insert(self, *args)

    def append(self, *args):
        """append(self, char t)"""
        return _fltk.Fl_Text_Buffer_append(self, *args)

    def remove(self, *args):
        """remove(self, int start, int end)"""
        return _fltk.Fl_Text_Buffer_remove(self, *args)

    def replace(self, *args):
        """replace(self, int start, int end, char text)"""
        return _fltk.Fl_Text_Buffer_replace(self, *args)

    def copy(self, *args):
        """
        copy(self, Fl_Text_Buffer fromBuf, int fromStart, int fromEnd, 
            int toPos)
        """
        return _fltk.Fl_Text_Buffer_copy(self, *args)

    def undo(self, *args):
        """undo(self, int cp = None) -> int"""
        return _fltk.Fl_Text_Buffer_undo(self, *args)

    def canUndo(self, *args):
        """canUndo(self, char flag = 1)"""
        return _fltk.Fl_Text_Buffer_canUndo(self, *args)

    def insertfile(self, *args):
        """insertfile(self, char file, int pos, int buflen = 128*1024) -> int"""
        return _fltk.Fl_Text_Buffer_insertfile(self, *args)

    def appendfile(self, *args):
        """appendfile(self, char file, int buflen = 128*1024) -> int"""
        return _fltk.Fl_Text_Buffer_appendfile(self, *args)

    def loadfile(self, *args):
        """loadfile(self, char file, int buflen = 128*1024) -> int"""
        return _fltk.Fl_Text_Buffer_loadfile(self, *args)

    def outputfile(self, *args):
        """outputfile(self, char file, int start, int end, int buflen = 128*1024) -> int"""
        return _fltk.Fl_Text_Buffer_outputfile(self, *args)

    def savefile(self, *args):
        """savefile(self, char file, int buflen = 128*1024) -> int"""
        return _fltk.Fl_Text_Buffer_savefile(self, *args)

    def insert_column(self, *args):
        """
        insert_column(self, int column, int startPos, char text, int charsInserted, 
            int charsDeleted)
        """
        return _fltk.Fl_Text_Buffer_insert_column(self, *args)

    def replace_rectangular(self, *args):
        """replace_rectangular(self, int start, int end, int rectStart, int rectEnd, char text)"""
        return _fltk.Fl_Text_Buffer_replace_rectangular(self, *args)

    def overlay_rectangular(self, *args):
        """
        overlay_rectangular(self, int startPos, int rectStart, int rectEnd, char text, 
            int charsInserted, int charsDeleted)
        """
        return _fltk.Fl_Text_Buffer_overlay_rectangular(self, *args)

    def remove_rectangular(self, *args):
        """remove_rectangular(self, int start, int end, int rectStart, int rectEnd)"""
        return _fltk.Fl_Text_Buffer_remove_rectangular(self, *args)

    def clear_rectangular(self, *args):
        """clear_rectangular(self, int start, int end, int rectStart, int rectEnd)"""
        return _fltk.Fl_Text_Buffer_clear_rectangular(self, *args)

    def tab_distance(self, *args):
        """
        tab_distance(self) -> int
        tab_distance(self, int tabDist)
        """
        return _fltk.Fl_Text_Buffer_tab_distance(self, *args)

    def select(self, *args):
        """select(self, int start, int end)"""
        return _fltk.Fl_Text_Buffer_select(self, *args)

    def selected(self, *args):
        """selected(self) -> int"""
        return _fltk.Fl_Text_Buffer_selected(self, *args)

    def unselect(self, *args):
        """unselect(self)"""
        return _fltk.Fl_Text_Buffer_unselect(self, *args)

    def select_rectangular(self, *args):
        """select_rectangular(self, int start, int end, int rectStart, int rectEnd)"""
        return _fltk.Fl_Text_Buffer_select_rectangular(self, *args)

    def selection_position(self, *args):
        """
        selection_position(self, int start, int end) -> int
        selection_position(self, int start, int end, int isRect, int rectStart, int rectEnd) -> int
        """
        return _fltk.Fl_Text_Buffer_selection_position(self, *args)

    def selection_text(self, *args):
        """selection_text(self) -> char"""
        return _fltk.Fl_Text_Buffer_selection_text(self, *args)

    def remove_selection(self, *args):
        """remove_selection(self)"""
        return _fltk.Fl_Text_Buffer_remove_selection(self, *args)

    def replace_selection(self, *args):
        """replace_selection(self, char text)"""
        return _fltk.Fl_Text_Buffer_replace_selection(self, *args)

    def secondary_select(self, *args):
        """secondary_select(self, int start, int end)"""
        return _fltk.Fl_Text_Buffer_secondary_select(self, *args)

    def secondary_selected(self, *args):
        """secondary_selected(self) -> int"""
        return _fltk.Fl_Text_Buffer_secondary_selected(self, *args)

    def secondary_unselect(self, *args):
        """secondary_unselect(self)"""
        return _fltk.Fl_Text_Buffer_secondary_unselect(self, *args)

    def secondary_select_rectangular(self, *args):
        """secondary_select_rectangular(self, int start, int end, int rectStart, int rectEnd)"""
        return _fltk.Fl_Text_Buffer_secondary_select_rectangular(self, *args)

    def secondary_selection_position(self, *args):
        """
        secondary_selection_position(self, int start, int end) -> int
        secondary_selection_position(self, int start, int end, int isRect, int rectStart, int rectEnd) -> int
        """
        return _fltk.Fl_Text_Buffer_secondary_selection_position(self, *args)

    def secondary_selection_text(self, *args):
        """secondary_selection_text(self) -> char"""
        return _fltk.Fl_Text_Buffer_secondary_selection_text(self, *args)

    def remove_secondary_selection(self, *args):
        """remove_secondary_selection(self)"""
        return _fltk.Fl_Text_Buffer_remove_secondary_selection(self, *args)

    def replace_secondary_selection(self, *args):
        """replace_secondary_selection(self, char text)"""
        return _fltk.Fl_Text_Buffer_replace_secondary_selection(self, *args)

    def highlight(self, *args):
        """
        highlight(self, int start, int end)
        highlight(self) -> int
        """
        return _fltk.Fl_Text_Buffer_highlight(self, *args)

    def unhighlight(self, *args):
        """unhighlight(self)"""
        return _fltk.Fl_Text_Buffer_unhighlight(self, *args)

    def highlight_rectangular(self, *args):
        """highlight_rectangular(self, int start, int end, int rectStart, int rectEnd)"""
        return _fltk.Fl_Text_Buffer_highlight_rectangular(self, *args)

    def highlight_position(self, *args):
        """
        highlight_position(self, int start, int end) -> int
        highlight_position(self, int start, int end, int isRect, int rectStart, int rectEnd) -> int
        """
        return _fltk.Fl_Text_Buffer_highlight_position(self, *args)

    def highlight_text(self, *args):
        """highlight_text(self) -> char"""
        return _fltk.Fl_Text_Buffer_highlight_text(self, *args)

    def call_modify_callbacks(self, *args):
        """call_modify_callbacks(self)"""
        return _fltk.Fl_Text_Buffer_call_modify_callbacks(self, *args)

    def add_predelete_callback(self, *args):
        """add_predelete_callback(self, Fl_Text_Predelete_Cb bufPredelCB, void cbArg)"""
        return _fltk.Fl_Text_Buffer_add_predelete_callback(self, *args)

    def remove_predelete_callback(self, *args):
        """remove_predelete_callback(self, Fl_Text_Predelete_Cb predelCB, void cbArg)"""
        return _fltk.Fl_Text_Buffer_remove_predelete_callback(self, *args)

    def call_predelete_callbacks(self, *args):
        """call_predelete_callbacks(self)"""
        return _fltk.Fl_Text_Buffer_call_predelete_callbacks(self, *args)

    def line_text(self, *args):
        """line_text(self, int pos) -> char"""
        return _fltk.Fl_Text_Buffer_line_text(self, *args)

    def line_start(self, *args):
        """line_start(self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_line_start(self, *args)

    def line_end(self, *args):
        """line_end(self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_line_end(self, *args)

    def word_start(self, *args):
        """word_start(self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_word_start(self, *args)

    def word_end(self, *args):
        """word_end(self, int pos) -> int"""
        return _fltk.Fl_Text_Buffer_word_end(self, *args)

    def expand_character(*args):
        """
        expand_character(int pos, int indent, char outStr) -> int
        expand_character(char c, int indent, char outStr, int tabDist, char nullSubsChar) -> int
        """
        return _fltk.Fl_Text_Buffer_expand_character(*args)

    expand_character = staticmethod(expand_character)
    def character_width(*args):
        """character_width(char c, int indent, int tabDist, char nullSubsChar) -> int"""
        return _fltk.Fl_Text_Buffer_character_width(*args)

    character_width = staticmethod(character_width)
    def count_displayed_characters(self, *args):
        """count_displayed_characters(self, int lineStartPos, int targetPos) -> int"""
        return _fltk.Fl_Text_Buffer_count_displayed_characters(self, *args)

    def skip_displayed_characters(self, *args):
        """skip_displayed_characters(self, int lineStartPos, int nChars) -> int"""
        return _fltk.Fl_Text_Buffer_skip_displayed_characters(self, *args)

    def count_lines(self, *args):
        """count_lines(self, int startPos, int endPos) -> int"""
        return _fltk.Fl_Text_Buffer_count_lines(self, *args)

    def skip_lines(self, *args):
        """skip_lines(self, int startPos, int nLines) -> int"""
        return _fltk.Fl_Text_Buffer_skip_lines(self, *args)

    def rewind_lines(self, *args):
        """rewind_lines(self, int startPos, int nLines) -> int"""
        return _fltk.Fl_Text_Buffer_rewind_lines(self, *args)

    def findchar_forward(self, *args):
        """findchar_forward(self, int startPos, char searchChar) -> int"""
        return _fltk.Fl_Text_Buffer_findchar_forward(self, *args)

    def findchar_backward(self, *args):
        """findchar_backward(self, int startPos, char searchChar) -> int"""
        return _fltk.Fl_Text_Buffer_findchar_backward(self, *args)

    def findchars_forward(self, *args):
        """findchars_forward(self, int startPos, char searchChars) -> int"""
        return _fltk.Fl_Text_Buffer_findchars_forward(self, *args)

    def findchars_backward(self, *args):
        """findchars_backward(self, int startPos, char searchChars) -> int"""
        return _fltk.Fl_Text_Buffer_findchars_backward(self, *args)

    def search_forward(self, *args):
        """search_forward(self, int startPos, char searchString, int matchCase = 0) -> int"""
        return _fltk.Fl_Text_Buffer_search_forward(self, *args)

    def search_backward(self, *args):
        """search_backward(self, int startPos, char searchString, int matchCase = 0) -> int"""
        return _fltk.Fl_Text_Buffer_search_backward(self, *args)

    def substitute_null_characters(self, *args):
        """substitute_null_characters(self, char string, int length) -> int"""
        return _fltk.Fl_Text_Buffer_substitute_null_characters(self, *args)

    def unsubstitute_null_characters(self, *args):
        """unsubstitute_null_characters(self, char string)"""
        return _fltk.Fl_Text_Buffer_unsubstitute_null_characters(self, *args)

    def null_substitution_character(self, *args):
        """null_substitution_character(self) -> char"""
        return _fltk.Fl_Text_Buffer_null_substitution_character(self, *args)

    def primary_selection(self, *args):
        """primary_selection(self) -> Fl_Text_Selection"""
        return _fltk.Fl_Text_Buffer_primary_selection(self, *args)

    def secondary_selection(self, *args):
        """secondary_selection(self) -> Fl_Text_Selection"""
        return _fltk.Fl_Text_Buffer_secondary_selection(self, *args)

    def highlight_selection(self, *args):
        """highlight_selection(self) -> Fl_Text_Selection"""
        return _fltk.Fl_Text_Buffer_highlight_selection(self, *args)

    def add_modify_callback(self, *args):
        """
        add_modify_callback(self, Fl_Text_Modify_Cb bufModifiedCB, void cbArg)
        add_modify_callback(self, PyObject PyFunc, PyObject PyTarget = None)
        """
        return _fltk.Fl_Text_Buffer_add_modify_callback(self, *args)

    def remove_modify_callback(self, *args):
        """
        remove_modify_callback(self, Fl_Text_Modify_Cb bufModifiedCB, void cbArg)
        remove_modify_callback(self, PyObject PyFunc, PyObject PyWidget, PyObject PyTarget)
        """
        return _fltk.Fl_Text_Buffer_remove_modify_callback(self, *args)

Fl_Text_Buffer_swigregister = _fltk.Fl_Text_Buffer_swigregister
Fl_Text_Buffer_swigregister(Fl_Text_Buffer)

def Fl_Text_Buffer_expand_character(*args):
  """
    expand_character(int pos, int indent, char outStr) -> int
    Fl_Text_Buffer_expand_character(char c, int indent, char outStr, int tabDist, char nullSubsChar) -> int
    """
  return _fltk.Fl_Text_Buffer_expand_character(*args)

def Fl_Text_Buffer_character_width(*args):
  """Fl_Text_Buffer_character_width(char c, int indent, int tabDist, char nullSubsChar) -> int"""
  return _fltk.Fl_Text_Buffer_character_width(*args)

class Style_Table_Entry(object):
    """Proxy of C++ Style_Table_Entry class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> Style_Table_Entry"""
        this = _fltk.new_Style_Table_Entry(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Style_Table_Entry
    __del__ = lambda self : None;
Style_Table_Entry_swigregister = _fltk.Style_Table_Entry_swigregister
Style_Table_Entry_swigregister(Style_Table_Entry)

class Fl_Text_Display(Fl_Group):
    """
    This is the FLTK text display widget. It allows the user to view multiple 
    lines of text and supports highlighting and scrolling. The buffer that is 
    displayed in the widget is managed by the Fl_Text_Buffer class.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    NORMAL_CURSOR = _fltk.Fl_Text_Display_NORMAL_CURSOR
    CARET_CURSOR = _fltk.Fl_Text_Display_CARET_CURSOR
    DIM_CURSOR = _fltk.Fl_Text_Display_DIM_CURSOR
    BLOCK_CURSOR = _fltk.Fl_Text_Display_BLOCK_CURSOR
    HEAVY_CURSOR = _fltk.Fl_Text_Display_HEAVY_CURSOR
    CURSOR_POS = _fltk.Fl_Text_Display_CURSOR_POS
    CHARACTER_POS = _fltk.Fl_Text_Display_CHARACTER_POS
    DRAG_CHAR = _fltk.Fl_Text_Display_DRAG_CHAR
    DRAG_WORD = _fltk.Fl_Text_Display_DRAG_WORD
    DRAG_LINE = _fltk.Fl_Text_Display_DRAG_LINE
    ATTR_NONE = _fltk.Fl_Text_Display_ATTR_NONE
    ATTR_UNDERLINE = _fltk.Fl_Text_Display_ATTR_UNDERLINE
    ATTR_HIDDEN = _fltk.Fl_Text_Display_ATTR_HIDDEN
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Text_Display"""
        if self.__class__ == Fl_Text_Display:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Text_Display(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Text_Display
    __del__ = lambda self : None;
    def handle(self, *args):
        """handle(self, int e) -> int"""
        return _fltk.Fl_Text_Display_handle(self, *args)

    def buffer(self, *args):
        """
        buffer(self, Fl_Text_Buffer buf)
        buffer(self) -> Fl_Text_Buffer
        """
        val = _fltk.Fl_Text_Display_buffer(self, *args)
        if len(args) > 0 and args[0] != None:
            #delegate ownership to C++
            args[0].this.disown()


        return val

    def redisplay_range(self, *args):
        """redisplay_range(self, int start, int end)"""
        return _fltk.Fl_Text_Display_redisplay_range(self, *args)

    def scroll(self, *args):
        """scroll(self, int topLineNum, int horizOffset)"""
        return _fltk.Fl_Text_Display_scroll(self, *args)

    def insert(self, *args):
        """insert(self, char text)"""
        return _fltk.Fl_Text_Display_insert(self, *args)

    def overstrike(self, *args):
        """overstrike(self, char text)"""
        return _fltk.Fl_Text_Display_overstrike(self, *args)

    def insert_position(self, *args):
        """
        insert_position(self, int newPos)
        insert_position(self) -> int
        """
        return _fltk.Fl_Text_Display_insert_position(self, *args)

    def in_selection(self, *args):
        """in_selection(self, int x, int y) -> int"""
        return _fltk.Fl_Text_Display_in_selection(self, *args)

    def show_insert_position(self, *args):
        """show_insert_position(self)"""
        return _fltk.Fl_Text_Display_show_insert_position(self, *args)

    def move_right(self, *args):
        """move_right(self) -> int"""
        return _fltk.Fl_Text_Display_move_right(self, *args)

    def move_left(self, *args):
        """move_left(self) -> int"""
        return _fltk.Fl_Text_Display_move_left(self, *args)

    def move_up(self, *args):
        """move_up(self) -> int"""
        return _fltk.Fl_Text_Display_move_up(self, *args)

    def move_down(self, *args):
        """move_down(self) -> int"""
        return _fltk.Fl_Text_Display_move_down(self, *args)

    def count_lines(self, *args):
        """count_lines(self, int start, int end, bool start_pos_is_line_start) -> int"""
        return _fltk.Fl_Text_Display_count_lines(self, *args)

    def line_start(self, *args):
        """line_start(self, int pos) -> int"""
        return _fltk.Fl_Text_Display_line_start(self, *args)

    def line_end(self, *args):
        """line_end(self, int pos, bool start_pos_is_line_start) -> int"""
        return _fltk.Fl_Text_Display_line_end(self, *args)

    def skip_lines(self, *args):
        """skip_lines(self, int startPos, int nLines, bool startPosIsLineStart) -> int"""
        return _fltk.Fl_Text_Display_skip_lines(self, *args)

    def rewind_lines(self, *args):
        """rewind_lines(self, int startPos, int nLines) -> int"""
        return _fltk.Fl_Text_Display_rewind_lines(self, *args)

    def next_word(self, *args):
        """next_word(self)"""
        return _fltk.Fl_Text_Display_next_word(self, *args)

    def previous_word(self, *args):
        """previous_word(self)"""
        return _fltk.Fl_Text_Display_previous_word(self, *args)

    def show_cursor(self, *args):
        """show_cursor(self, int b = 1)"""
        return _fltk.Fl_Text_Display_show_cursor(self, *args)

    def hide_cursor(self, *args):
        """hide_cursor(self)"""
        return _fltk.Fl_Text_Display_hide_cursor(self, *args)

    def cursor_style(self, *args):
        """cursor_style(self, int style)"""
        return _fltk.Fl_Text_Display_cursor_style(self, *args)

    def cursor_color(self, *args):
        """
        cursor_color(self) -> Fl_Color
        cursor_color(self, Fl_Color n)
        """
        return _fltk.Fl_Text_Display_cursor_color(self, *args)

    def scrollbar_width(self, *args):
        """
        scrollbar_width(self) -> int
        scrollbar_width(self, int W)
        """
        return _fltk.Fl_Text_Display_scrollbar_width(self, *args)

    def scrollbar_align(self, *args):
        """
        scrollbar_align(self) -> Fl_Align
        scrollbar_align(self, Fl_Align a)
        """
        return _fltk.Fl_Text_Display_scrollbar_align(self, *args)

    def word_start(self, *args):
        """word_start(self, int pos) -> int"""
        return _fltk.Fl_Text_Display_word_start(self, *args)

    def word_end(self, *args):
        """word_end(self, int pos) -> int"""
        return _fltk.Fl_Text_Display_word_end(self, *args)

    def position_style(self, *args):
        """position_style(self, int lineStartPos, int lineLen, int lineIndex, int dispIndex) -> int"""
        return _fltk.Fl_Text_Display_position_style(self, *args)

    def textfont(self, *args):
        """
        textfont(self) -> Fl_Font
        textfont(self, uchar s)
        """
        return _fltk.Fl_Text_Display_textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_Text_Display_textsize(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, unsigned int n)
        """
        return _fltk.Fl_Text_Display_textcolor(self, *args)

    def wrapped_column(self, *args):
        """wrapped_column(self, int row, int column) -> int"""
        return _fltk.Fl_Text_Display_wrapped_column(self, *args)

    def wrapped_row(self, *args):
        """wrapped_row(self, int row) -> int"""
        return _fltk.Fl_Text_Display_wrapped_row(self, *args)

    def wrap_mode(self, *args):
        """wrap_mode(self, int wrap, int wrap_margin)"""
        return _fltk.Fl_Text_Display_wrap_mode(self, *args)

    def resize(self, *args):
        """resize(self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Text_Display_resize(self, *args)

    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Text_Display_draw(self, *args)

    def highlight_data(self, *args):
        """
        highlight_data(self, Fl_Text_Buffer styleBuffer, Fl_Text_Display::Style_Table_Entry styleTable, 
            int nStyles, char unfinishedStyle, 
            PyObject func, PyObject cbArg)
        """
        return _fltk.Fl_Text_Display_highlight_data(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Text_Display(self)
        return weakref_proxy(self)
Fl_Text_Display_swigregister = _fltk.Fl_Text_Display_swigregister
Fl_Text_Display_swigregister(Fl_Text_Display)

FL_TEXT_EDITOR_ANY_STATE = _fltk.FL_TEXT_EDITOR_ANY_STATE
class Fl_Text_Editor(Fl_Text_Display):
    """
    This is the FLTK text editor widget. It allows the user to edit multiple 
    lines of text and supports highlighting and scrolling. The buffer that is 
    displayed in the widget is managed by the Fl_Text_Buffer class.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Text_Editor"""
        if self.__class__ == Fl_Text_Editor:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Text_Editor(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Text_Editor
    __del__ = lambda self : None;
    def handle(self, *args):
        """handle(self, int e) -> int"""
        return _fltk.Fl_Text_Editor_handle(self, *args)

    def insert_mode(self, *args):
        """
        insert_mode(self, int b)
        insert_mode(self) -> int
        """
        return _fltk.Fl_Text_Editor_insert_mode(self, *args)

    def add_key_binding(self, *args):
        """add_key_binding(self, int key, int state, Key_Func f)"""
        return _fltk.Fl_Text_Editor_add_key_binding(self, *args)

    def remove_key_binding(self, *args):
        """remove_key_binding(self, int key, int state)"""
        return _fltk.Fl_Text_Editor_remove_key_binding(self, *args)

    def remove_all_key_bindings(self, *args):
        """remove_all_key_bindings(self)"""
        return _fltk.Fl_Text_Editor_remove_all_key_bindings(self, *args)

    def bound_key_function(self, *args):
        """bound_key_function(self, int key, int state) -> Key_Func"""
        return _fltk.Fl_Text_Editor_bound_key_function(self, *args)

    def default_key_function(self, *args):
        """default_key_function(self, Key_Func f)"""
        return _fltk.Fl_Text_Editor_default_key_function(self, *args)

    def kf_default(*args):
        """kf_default(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_default(*args)

    kf_default = staticmethod(kf_default)
    def kf_ignore(*args):
        """kf_ignore(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_ignore(*args)

    kf_ignore = staticmethod(kf_ignore)
    def kf_backspace(*args):
        """kf_backspace(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_backspace(*args)

    kf_backspace = staticmethod(kf_backspace)
    def kf_enter(*args):
        """kf_enter(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_enter(*args)

    kf_enter = staticmethod(kf_enter)
    def kf_move(*args):
        """kf_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_move(*args)

    kf_move = staticmethod(kf_move)
    def kf_shift_move(*args):
        """kf_shift_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_shift_move(*args)

    kf_shift_move = staticmethod(kf_shift_move)
    def kf_ctrl_move(*args):
        """kf_ctrl_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_ctrl_move(*args)

    kf_ctrl_move = staticmethod(kf_ctrl_move)
    def kf_c_s_move(*args):
        """kf_c_s_move(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_c_s_move(*args)

    kf_c_s_move = staticmethod(kf_c_s_move)
    def kf_home(*args):
        """kf_home(int arg0, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_home(*args)

    kf_home = staticmethod(kf_home)
    def kf_end(*args):
        """kf_end(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_end(*args)

    kf_end = staticmethod(kf_end)
    def kf_left(*args):
        """kf_left(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_left(*args)

    kf_left = staticmethod(kf_left)
    def kf_up(*args):
        """kf_up(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_up(*args)

    kf_up = staticmethod(kf_up)
    def kf_right(*args):
        """kf_right(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_right(*args)

    kf_right = staticmethod(kf_right)
    def kf_down(*args):
        """kf_down(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_down(*args)

    kf_down = staticmethod(kf_down)
    def kf_page_up(*args):
        """kf_page_up(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_page_up(*args)

    kf_page_up = staticmethod(kf_page_up)
    def kf_page_down(*args):
        """kf_page_down(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_page_down(*args)

    kf_page_down = staticmethod(kf_page_down)
    def kf_insert(*args):
        """kf_insert(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_insert(*args)

    kf_insert = staticmethod(kf_insert)
    def kf_delete(*args):
        """kf_delete(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_delete(*args)

    kf_delete = staticmethod(kf_delete)
    def kf_copy(*args):
        """kf_copy(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_copy(*args)

    kf_copy = staticmethod(kf_copy)
    def kf_cut(*args):
        """kf_cut(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_cut(*args)

    kf_cut = staticmethod(kf_cut)
    def kf_paste(*args):
        """kf_paste(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_paste(*args)

    kf_paste = staticmethod(kf_paste)
    def kf_select_all(*args):
        """kf_select_all(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_select_all(*args)

    kf_select_all = staticmethod(kf_select_all)
    def kf_undo(*args):
        """kf_undo(int c, Fl_Text_Editor e) -> int"""
        return _fltk.Fl_Text_Editor_kf_undo(*args)

    kf_undo = staticmethod(kf_undo)
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Text_Editor(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Text_Editor_draw(self, *args)

Fl_Text_Editor_swigregister = _fltk.Fl_Text_Editor_swigregister
Fl_Text_Editor_swigregister(Fl_Text_Editor)

def Fl_Text_Editor_kf_default(*args):
  """Fl_Text_Editor_kf_default(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_default(*args)

def Fl_Text_Editor_kf_ignore(*args):
  """Fl_Text_Editor_kf_ignore(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_ignore(*args)

def Fl_Text_Editor_kf_backspace(*args):
  """Fl_Text_Editor_kf_backspace(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_backspace(*args)

def Fl_Text_Editor_kf_enter(*args):
  """Fl_Text_Editor_kf_enter(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_enter(*args)

def Fl_Text_Editor_kf_move(*args):
  """Fl_Text_Editor_kf_move(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_move(*args)

def Fl_Text_Editor_kf_shift_move(*args):
  """Fl_Text_Editor_kf_shift_move(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_shift_move(*args)

def Fl_Text_Editor_kf_ctrl_move(*args):
  """Fl_Text_Editor_kf_ctrl_move(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_ctrl_move(*args)

def Fl_Text_Editor_kf_c_s_move(*args):
  """Fl_Text_Editor_kf_c_s_move(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_c_s_move(*args)

def Fl_Text_Editor_kf_home(*args):
  """Fl_Text_Editor_kf_home(int arg0, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_home(*args)

def Fl_Text_Editor_kf_end(*args):
  """Fl_Text_Editor_kf_end(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_end(*args)

def Fl_Text_Editor_kf_left(*args):
  """Fl_Text_Editor_kf_left(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_left(*args)

def Fl_Text_Editor_kf_up(*args):
  """Fl_Text_Editor_kf_up(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_up(*args)

def Fl_Text_Editor_kf_right(*args):
  """Fl_Text_Editor_kf_right(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_right(*args)

def Fl_Text_Editor_kf_down(*args):
  """Fl_Text_Editor_kf_down(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_down(*args)

def Fl_Text_Editor_kf_page_up(*args):
  """Fl_Text_Editor_kf_page_up(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_page_up(*args)

def Fl_Text_Editor_kf_page_down(*args):
  """Fl_Text_Editor_kf_page_down(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_page_down(*args)

def Fl_Text_Editor_kf_insert(*args):
  """Fl_Text_Editor_kf_insert(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_insert(*args)

def Fl_Text_Editor_kf_delete(*args):
  """Fl_Text_Editor_kf_delete(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_delete(*args)

def Fl_Text_Editor_kf_copy(*args):
  """Fl_Text_Editor_kf_copy(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_copy(*args)

def Fl_Text_Editor_kf_cut(*args):
  """Fl_Text_Editor_kf_cut(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_cut(*args)

def Fl_Text_Editor_kf_paste(*args):
  """Fl_Text_Editor_kf_paste(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_paste(*args)

def Fl_Text_Editor_kf_select_all(*args):
  """Fl_Text_Editor_kf_select_all(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_select_all(*args)

def Fl_Text_Editor_kf_undo(*args):
  """Fl_Text_Editor_kf_undo(int c, Fl_Text_Editor e) -> int"""
  return _fltk.Fl_Text_Editor_kf_undo(*args)

class Fl_Tile(Fl_Group):
    """
    The Fl_Tile class lets you resize the children by dragging the border between 
    them:

    Fl_Tile allows objects to be resized to zero dimensions. To prevent this you 
    can use the resizable() to limit where corners can be dragged to.

    Even though objects can be resized to zero sizes, they must initially have 
    non-zero sizes so the Fl_Tile can figure out their layout. If desired, call 
    position() after creating the children but before displaying the window to 
    set the borders where you want.

    The 'borders' are part of the children - Fl_Tile does not draw any graphics 
    of its own. In the example above, all of the children have FL_DOWN_BOX types, 
    and the 'ridges' you see are actually two adjacent FL_DOWN_BOX's drawn next 
    to each other. All neighboring widgets share the same edge - the widget's 
    thick borders make it appear as though the widgets aren't actually touching, 
    but they are. If the edges of adjacent widgets do not touch, then it will be 
    impossible to drag the corresponding edges.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Tile_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Tile"""
        if self.__class__ == Fl_Tile:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Tile(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def resize(self, *args):
        """resize(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Tile_resize(self, *args)

    def position(self, *args):
        """position(self, int arg0, int arg1, int arg2, int arg3)"""
        return _fltk.Fl_Tile_position(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Tile
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tile(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Tile_draw(self, *args)

Fl_Tile_swigregister = _fltk.Fl_Tile_swigregister
Fl_Tile_swigregister(Fl_Tile)

class Fl_Tiled_Image(Fl_Image):
    """
    The Fl_Tiled_Image class supports tiling of images over a specified area. 
    The source (tile) image is not copied unless you call the color_average(), 
    desaturate(), or inactive() methods.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, Fl_Image i, int W = 0, int H = 0) -> Fl_Tiled_Image"""
        if self.__class__ == Fl_Tiled_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Tiled_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Tiled_Image
    __del__ = lambda self : None;
    def copy(self, *args):
        """
        copy(self, int W, int H) -> Fl_Image
        copy(self) -> Fl_Image
        """
        return _fltk.Fl_Tiled_Image_copy(self, *args)

    def color_average(self, *args):
        """color_average(self, Fl_Color c, float i)"""
        return _fltk.Fl_Tiled_Image_color_average(self, *args)

    def desaturate(self, *args):
        """desaturate(self)"""
        return _fltk.Fl_Tiled_Image_desaturate(self, *args)

    def draw(self, *args):
        """
        draw(self, int X, int Y, int W, int H, int cx, int cy)
        draw(self, int X, int Y)
        """
        return _fltk.Fl_Tiled_Image_draw(self, *args)

    def image(self, *args):
        """image(self) -> Fl_Image"""
        return _fltk.Fl_Tiled_Image_image(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Tiled_Image(self)
        return weakref_proxy(self)
Fl_Tiled_Image_swigregister = _fltk.Fl_Tiled_Image_swigregister
Fl_Tiled_Image_swigregister(Fl_Tiled_Image)

FL_NORMAL_TIMER = _fltk.FL_NORMAL_TIMER
FL_VALUE_TIMER = _fltk.FL_VALUE_TIMER
FL_HIDDEN_TIMER = _fltk.FL_HIDDEN_TIMER
class Fl_Timer(Fl_Widget):
    """
    This is provided only to emulate the Forms Timer widget. It works by making 
    a timeout callback every 1/5 second. This is wasteful and inaccurate if you 
    just want something to happen a fixed time in the future. You should directly 
    call Fl::add_timeout() instead.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Timer_draw(self, *args)

    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Timer_handle(self, *args)

    def __init__(self, *args): 
        """__init__(self, uchar t, int x, int y, int w, int h, char l) -> Fl_Timer"""
        if self.__class__ == Fl_Timer:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Timer(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Timer
    __del__ = lambda self : None;
    def value(self, *args):
        """
        value(self, double arg0)
        value(self) -> double
        """
        return _fltk.Fl_Timer_value(self, *args)

    def direction(self, *args):
        """
        direction(self) -> char
        direction(self, char d)
        """
        return _fltk.Fl_Timer_direction(self, *args)

    def suspended(self, *args):
        """
        suspended(self) -> char
        suspended(self, char d)
        """
        return _fltk.Fl_Timer_suspended(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Timer(self)
        return weakref_proxy(self)
Fl_Timer_swigregister = _fltk.Fl_Timer_swigregister
Fl_Timer_swigregister(Fl_Timer)

class Fl_Toggle_Button(Fl_Button):
    """Proxy of C++ Fl_Toggle_Button class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Toggle_Button"""
        if self.__class__ == Fl_Toggle_Button:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Toggle_Button(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Toggle_Button
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Toggle_Button(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Toggle_Button_draw(self, *args)

Fl_Toggle_Button_swigregister = _fltk.Fl_Toggle_Button_swigregister
Fl_Toggle_Button_swigregister(Fl_Toggle_Button)

class Fl_Tooltip(object):
    """
    The Fl_Tooltip class provides tooltip support for all FLTK widgets.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def delay(*args):
        """
        delay() -> float
        delay(float f)
        """
        return _fltk.Fl_Tooltip_delay(*args)

    delay = staticmethod(delay)
    def hoverdelay(*args):
        """
        hoverdelay() -> float
        hoverdelay(float f)
        """
        return _fltk.Fl_Tooltip_hoverdelay(*args)

    hoverdelay = staticmethod(hoverdelay)
    def enabled(*args):
        """enabled() -> int"""
        return _fltk.Fl_Tooltip_enabled(*args)

    enabled = staticmethod(enabled)
    def enable(*args):
        """enable(int b = 1)"""
        return _fltk.Fl_Tooltip_enable(*args)

    enable = staticmethod(enable)
    def disable(*args):
        """disable()"""
        return _fltk.Fl_Tooltip_disable(*args)

    disable = staticmethod(disable)
    def enter_area(*args):
        """enter_area(Fl_Widget w, int X, int Y, int W, int H, char tip)"""
        return _fltk.Fl_Tooltip_enter_area(*args)

    enter_area = staticmethod(enter_area)
    def current(*args):
        """
        current() -> Fl_Widget
        current(Fl_Widget arg0)
        """
        return _fltk.Fl_Tooltip_current(*args)

    current = staticmethod(current)
    def font(*args):
        """
        font() -> int
        font(int i)
        """
        return _fltk.Fl_Tooltip_font(*args)

    font = staticmethod(font)
    def size(*args):
        """
        size() -> int
        size(int s)
        """
        return _fltk.Fl_Tooltip_size(*args)

    size = staticmethod(size)
    def color(*args):
        """
        color(unsigned int c)
        color() -> Fl_Color
        """
        return _fltk.Fl_Tooltip_color(*args)

    color = staticmethod(color)
    def textcolor(*args):
        """
        textcolor(unsigned int c)
        textcolor() -> Fl_Color
        """
        return _fltk.Fl_Tooltip_textcolor(*args)

    textcolor = staticmethod(textcolor)
    def enter_(*args):
        """enter_(Fl_Widget w)"""
        return _fltk.Fl_Tooltip_enter_(*args)

    enter_ = staticmethod(enter_)
    def exit_(*args):
        """exit_(Fl_Widget w)"""
        return _fltk.Fl_Tooltip_exit_(*args)

    exit_ = staticmethod(exit_)
    def __init__(self, *args): 
        """__init__(self) -> Fl_Tooltip"""
        this = _fltk.new_Fl_Tooltip(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_Tooltip
    __del__ = lambda self : None;
Fl_Tooltip_swigregister = _fltk.Fl_Tooltip_swigregister
Fl_Tooltip_swigregister(Fl_Tooltip)

def Fl_Tooltip_delay(*args):
  """
    delay() -> float
    Fl_Tooltip_delay(float f)
    """
  return _fltk.Fl_Tooltip_delay(*args)

def Fl_Tooltip_hoverdelay(*args):
  """
    hoverdelay() -> float
    Fl_Tooltip_hoverdelay(float f)
    """
  return _fltk.Fl_Tooltip_hoverdelay(*args)

def Fl_Tooltip_enabled(*args):
  """Fl_Tooltip_enabled() -> int"""
  return _fltk.Fl_Tooltip_enabled(*args)

def Fl_Tooltip_enable(*args):
  """Fl_Tooltip_enable(int b = 1)"""
  return _fltk.Fl_Tooltip_enable(*args)

def Fl_Tooltip_disable(*args):
  """Fl_Tooltip_disable()"""
  return _fltk.Fl_Tooltip_disable(*args)

def Fl_Tooltip_enter_area(*args):
  """Fl_Tooltip_enter_area(Fl_Widget w, int X, int Y, int W, int H, char tip)"""
  return _fltk.Fl_Tooltip_enter_area(*args)

def Fl_Tooltip_current(*args):
  """
    current() -> Fl_Widget
    Fl_Tooltip_current(Fl_Widget arg0)
    """
  return _fltk.Fl_Tooltip_current(*args)

def Fl_Tooltip_font(*args):
  """
    font() -> int
    Fl_Tooltip_font(int i)
    """
  return _fltk.Fl_Tooltip_font(*args)

def Fl_Tooltip_size(*args):
  """
    size() -> int
    Fl_Tooltip_size(int s)
    """
  return _fltk.Fl_Tooltip_size(*args)

def Fl_Tooltip_color(*args):
  """
    color(unsigned int c)
    Fl_Tooltip_color() -> Fl_Color
    """
  return _fltk.Fl_Tooltip_color(*args)

def Fl_Tooltip_textcolor(*args):
  """
    textcolor(unsigned int c)
    Fl_Tooltip_textcolor() -> Fl_Color
    """
  return _fltk.Fl_Tooltip_textcolor(*args)

def Fl_Tooltip_enter_(*args):
  """Fl_Tooltip_enter_(Fl_Widget w)"""
  return _fltk.Fl_Tooltip_enter_(*args)

def Fl_Tooltip_exit_(*args):
  """Fl_Tooltip_exit_(Fl_Widget w)"""
  return _fltk.Fl_Tooltip_exit_(*args)

class Fl_Value_Output(Fl_Valuator):
    """
    The Fl_Value_Output widget displays a floating point value. If step() is 
    not zero, the user can adjust the value by dragging the mouse left and right. 
    The left button moves one step()  per pixel, the middle by 10 * step(), and 
    the right button by 100 * step().

    This is much lighter-weight than Fl_Value_Input because it contains no text 
    editing code or character buffer. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def handle(self, *args):
        """handle(self, int arg0) -> int"""
        return _fltk.Fl_Value_Output_handle(self, *args)

    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Value_Output_draw(self, *args)

    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char l = None) -> Fl_Value_Output"""
        if self.__class__ == Fl_Value_Output:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Value_Output(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def soft(self, *args):
        """
        soft(self, uchar s)
        soft(self) -> uchar
        """
        return _fltk.Fl_Value_Output_soft(self, *args)

    def textfont(self, *args):
        """
        textfont(self) -> Fl_Font
        textfont(self, uchar s)
        """
        return _fltk.Fl_Value_Output_textfont(self, *args)

    def textsize(self, *args):
        """
        textsize(self) -> uchar
        textsize(self, uchar s)
        """
        return _fltk.Fl_Value_Output_textsize(self, *args)

    def textcolor(self, *args):
        """
        textcolor(self) -> Fl_Color
        textcolor(self, unsigned int s)
        """
        return _fltk.Fl_Value_Output_textcolor(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Value_Output
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Value_Output(self)
        return weakref_proxy(self)
Fl_Value_Output_swigregister = _fltk.Fl_Value_Output_swigregister
Fl_Value_Output_swigregister(Fl_Value_Output)

class Fl_Wizard(Fl_Group):
    """
    The Fl_Wizard widget is based off the Fl_Tabs widget, but instead of 
    displaying tabs it only changes 'tabs' under program control. Its primary 
    purpose is to support 'wizards' that step a user through configuration or 
    troubleshooting tasks.

    As with Fl_Tabs, wizard panes are composed of child (usually Fl_Group) 
    widgets. Navigation buttons must be added separately. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int arg0, int arg1, int arg2, int arg3, char arg4 = None) -> Fl_Wizard"""
        if self.__class__ == Fl_Wizard:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Wizard(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def next(self, *args):
        """next(self)"""
        return _fltk.Fl_Wizard_next(self, *args)

    def prev(self, *args):
        """prev(self)"""
        return _fltk.Fl_Wizard_prev(self, *args)

    def value(self, *args):
        """
        value(self) -> Fl_Widget
        value(self, Fl_Widget arg0)
        """
        return _fltk.Fl_Wizard_value(self, *args)

    __swig_destroy__ = _fltk.delete_Fl_Wizard
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Wizard(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Wizard_draw(self, *args)

Fl_Wizard_swigregister = _fltk.Fl_Wizard_swigregister
Fl_Wizard_swigregister(Fl_Wizard)

class Fl_XBM_Image(Fl_Bitmap):
    """
    The Fl_XBM_Image class supports loading, caching, and drawing of X Bitmap 
    (XBM) bitmap files.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char filename) -> Fl_XBM_Image"""
        if self.__class__ == Fl_XBM_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_XBM_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_XBM_Image
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_XBM_Image(self)
        return weakref_proxy(self)
Fl_XBM_Image_swigregister = _fltk.Fl_XBM_Image_swigregister
Fl_XBM_Image_swigregister(Fl_XBM_Image)

class Fl_XPM_Image(Fl_Pixmap):
    """
    The Fl_XPM_Image class supports loading, caching, and drawing of X Pixmap (XPM) images, including transparency.

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, char filename) -> Fl_XPM_Image"""
        if self.__class__ == Fl_XPM_Image:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_XPM_Image(_self, *args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _fltk.delete_Fl_XPM_Image
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_XPM_Image(self)
        return weakref_proxy(self)
Fl_XPM_Image_swigregister = _fltk.Fl_XPM_Image_swigregister
Fl_XPM_Image_swigregister(Fl_XPM_Image)


def fl_xid(*args):
  """fl_xid(Fl_Window w) -> int"""
  return _fltk.fl_xid(*args)

def upCB(*args):
  """upCB(Fl_Widget v, void arg1)"""
  return _fltk.upCB(*args)

def downCB(*args):
  """downCB(Fl_Widget v, void arg1)"""
  return _fltk.downCB(*args)

def toggleCB(*args):
  """toggleCB(Fl_Widget v, void arg1)"""
  return _fltk.toggleCB(*args)
class ListSelect(Fl_Group):
    """Proxy of C++ ListSelect class"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, int x, int y, int w, int h, char topLabel = None, char bottomLabel = None) -> ListSelect"""
        if self.__class__ == ListSelect:
            _self = None
        else:
            _self = self
        this = _fltk.new_ListSelect(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    def getTopBrowser(self, *args):
        """getTopBrowser(self) -> Fl_Multi_Browser"""
        return _fltk.ListSelect_getTopBrowser(self, *args)

    def getBottomBrowser(self, *args):
        """getBottomBrowser(self) -> Fl_Multi_Browser"""
        return _fltk.ListSelect_getBottomBrowser(self, *args)

    def resize(self, *args):
        """resize(self, int x, int y, int w, int h)"""
        return _fltk.ListSelect_resize(self, *args)

    __swig_destroy__ = _fltk.delete_ListSelect
    __del__ = lambda self : None;
    def __disown__(self):
        self.this.disown()
        _fltk.disown_ListSelect(self)
        return weakref_proxy(self)
    def draw(self, *args):
        """draw(self)"""
        return _fltk.ListSelect_draw(self, *args)

ListSelect_swigregister = _fltk.ListSelect_swigregister
ListSelect_swigregister(ListSelect)

class Fl_Table(Fl_Group):
    """
    This is the base class for table widgets. (eg. Fl_Table_Row). To be useful it must be subclassed and several virtual functions defined. Normally applications use widgets derived from this widget, and do not use this widget directly; this widget is usually too low level to be used directly by applications.

    This widget does not handle the data in the table. The draw_cell() method must be overridden by a subclass to manage drawing the contents of the cells.

    This widget can be used in several ways:

        * As a custom widget; see testtablerow.cxx. Very optimal for even extremely large tables.

        * As a table made up of a single FLTK widget instanced all over the table; see singleinput.cxx. Very optimal for even extremely large tables;

        * As a regular container of FLTK widgets, one widget per cell. See widgettable.cxx. Not recommended for large tables.

    When acting as part of a custom widget, events on the cells and/or headings generate callbacks when they are clicked by the user. You control when events are generated based on the setting for Fl_Table::when().

    When acting as a container for FLTK widgets, the FLTK widgets maintain themselves. Although the draw_cell() method must be overridden, its contents can be very simple. See the draw_cell() code in widgettable.cxx. 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    CONTEXT_NONE = _fltk.Fl_Table_CONTEXT_NONE
    CONTEXT_STARTPAGE = _fltk.Fl_Table_CONTEXT_STARTPAGE
    CONTEXT_ENDPAGE = _fltk.Fl_Table_CONTEXT_ENDPAGE
    CONTEXT_ROW_HEADER = _fltk.Fl_Table_CONTEXT_ROW_HEADER
    CONTEXT_COL_HEADER = _fltk.Fl_Table_CONTEXT_COL_HEADER
    CONTEXT_CELL = _fltk.Fl_Table_CONTEXT_CELL
    CONTEXT_TABLE = _fltk.Fl_Table_CONTEXT_TABLE
    CONTEXT_RC_RESIZE = _fltk.Fl_Table_CONTEXT_RC_RESIZE
    def handle(self, *args):
        """handle(self, int e) -> int"""
        return _fltk.Fl_Table_handle(self, *args)

    def draw_cell(self, *args):
        """
        draw_cell(self, TableContext context, int R = 0, int C = 0, int X = 0, 
            int Y = 0, int W = 0, int H = 0)
        """
        return _fltk.Fl_Table_draw_cell(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Table"""
        if self.__class__ == Fl_Table:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Table(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Table
    __del__ = lambda self : None;
    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_Table_clear(self, *args)

    def table_box(self, *args):
        """
        table_box(self, Fl_Boxtype val)
        table_box(self) -> Fl_Boxtype
        """
        return _fltk.Fl_Table_table_box(self, *args)

    def rows(self, *args):
        """
        rows(self, int val)
        rows(self) -> int
        """
        return _fltk.Fl_Table_rows(self, *args)

    def cols(self, *args):
        """
        cols(self, int val)
        cols(self) -> int
        """
        return _fltk.Fl_Table_cols(self, *args)

    def visible_cells(self, *args):
        """visible_cells(self)"""
        return _fltk.Fl_Table_visible_cells(self, *args)

    def is_interactive_resize(self, *args):
        """is_interactive_resize(self) -> int"""
        return _fltk.Fl_Table_is_interactive_resize(self, *args)

    def row_resize(self, *args):
        """
        row_resize(self) -> int
        row_resize(self, int flag)
        """
        return _fltk.Fl_Table_row_resize(self, *args)

    def col_resize(self, *args):
        """
        col_resize(self) -> int
        col_resize(self, int flag)
        """
        return _fltk.Fl_Table_col_resize(self, *args)

    def col_resize_min(self, *args):
        """
        col_resize_min(self) -> int
        col_resize_min(self, int val)
        """
        return _fltk.Fl_Table_col_resize_min(self, *args)

    def row_resize_min(self, *args):
        """
        row_resize_min(self) -> int
        row_resize_min(self, int val)
        """
        return _fltk.Fl_Table_row_resize_min(self, *args)

    def row_header(self, *args):
        """
        row_header(self) -> int
        row_header(self, int flag)
        """
        return _fltk.Fl_Table_row_header(self, *args)

    def col_header(self, *args):
        """
        col_header(self) -> int
        col_header(self, int flag)
        """
        return _fltk.Fl_Table_col_header(self, *args)

    def col_header_height(self, *args):
        """
        col_header_height(self, int height)
        col_header_height(self) -> int
        """
        return _fltk.Fl_Table_col_header_height(self, *args)

    def row_header_width(self, *args):
        """
        row_header_width(self, int width)
        row_header_width(self) -> int
        """
        return _fltk.Fl_Table_row_header_width(self, *args)

    def row_header_color(self, *args):
        """
        row_header_color(self, Fl_Color val)
        row_header_color(self) -> Fl_Color
        """
        return _fltk.Fl_Table_row_header_color(self, *args)

    def col_header_color(self, *args):
        """
        col_header_color(self, Fl_Color val)
        col_header_color(self) -> Fl_Color
        """
        return _fltk.Fl_Table_col_header_color(self, *args)

    def row_height(self, *args):
        """
        row_height(self, int row, int height)
        row_height(self, int row) -> int
        """
        return _fltk.Fl_Table_row_height(self, *args)

    def col_width(self, *args):
        """
        col_width(self, int col, int width)
        col_width(self, int col) -> int
        """
        return _fltk.Fl_Table_col_width(self, *args)

    def row_height_all(self, *args):
        """row_height_all(self, int height)"""
        return _fltk.Fl_Table_row_height_all(self, *args)

    def col_width_all(self, *args):
        """col_width_all(self, int width)"""
        return _fltk.Fl_Table_col_width_all(self, *args)

    def row_position(self, *args):
        """
        row_position(self, int row)
        row_position(self) -> int
        """
        return _fltk.Fl_Table_row_position(self, *args)

    def col_position(self, *args):
        """
        col_position(self, int col)
        col_position(self) -> int
        """
        return _fltk.Fl_Table_col_position(self, *args)

    def top_row(self, *args):
        """
        top_row(self, int row)
        top_row(self) -> int
        """
        return _fltk.Fl_Table_top_row(self, *args)

    def is_selected(self, *args):
        """is_selected(self, int r, int c) -> int"""
        return _fltk.Fl_Table_is_selected(self, *args)

    def get_selection(self, *args):
        """get_selection(self)"""
        return _fltk.Fl_Table_get_selection(self, *args)

    def set_selection(self, *args):
        """set_selection(self, int s_top, int s_left, int s_bottom, int s_right)"""
        return _fltk.Fl_Table_set_selection(self, *args)

    def move_cursor(self, *args):
        """move_cursor(self, int R, int C) -> int"""
        return _fltk.Fl_Table_move_cursor(self, *args)

    def resize(self, *args):
        """resize(self, int X, int Y, int W, int H)"""
        return _fltk.Fl_Table_resize(self, *args)

    def draw(self, *args):
        """draw(self)"""
        return _fltk.Fl_Table_draw(self, *args)

    def init_sizes(self, *args):
        """init_sizes(self)"""
        return _fltk.Fl_Table_init_sizes(self, *args)

    def add(self, *args):
        """add(self, Fl_Widget w)"""
        val = _fltk.Fl_Table_add(self, *args)
        #self = args[0]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()
        else:                       
        #give ownership back to Python
            self.this.own() 


        return val

    def insert(self, *args):
        """insert(self, Fl_Widget w, int n)"""
        return _fltk.Fl_Table_insert(self, *args)

    def insert_before(self, *args):
        """insert_before(self, Fl_Widget w, Fl_Widget w2)"""
        return _fltk.Fl_Table_insert_before(self, *args)

    def begin(self, *args):
        """begin(self)"""
        return _fltk.Fl_Table_begin(self, *args)

    def end(self, *args):
        """end(self)"""
        return _fltk.Fl_Table_end(self, *args)

    def child(self, *args):
        """child(self, int n) -> Fl_Widget"""
        return _fltk.Fl_Table_child(self, *args)

    def children(self, *args):
        """children(self) -> int"""
        return _fltk.Fl_Table_children(self, *args)

    def find(self, *args):
        """find(self, Fl_Widget w) -> int"""
        return _fltk.Fl_Table_find(self, *args)

    def callback_row(self, *args):
        """callback_row(self) -> int"""
        return _fltk.Fl_Table_callback_row(self, *args)

    def callback_col(self, *args):
        """callback_col(self) -> int"""
        return _fltk.Fl_Table_callback_col(self, *args)

    def callback_context(self, *args):
        """callback_context(self) -> TableContext"""
        return _fltk.Fl_Table_callback_context(self, *args)

    def do_callback(self, *args):
        """do_callback(self, TableContext context, int row, int col)"""
        return _fltk.Fl_Table_do_callback(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Table(self)
        return weakref_proxy(self)
Fl_Table_swigregister = _fltk.Fl_Table_swigregister
Fl_Table_swigregister(Fl_Table)

class Fl_Table_Row(Fl_Table):
    """
    This class implements a simple table of rows and columns that specializes in the selection of rows. This widget is similar in behavior to a 'mail subject browser', similar to that found in mozilla, netscape and outlook mail browsers.

    Most methods of importance will be found in the Fl_Table widget, such as rows() and cols().

    To be useful it must be subclassed and at minimum the draw_cell() method must be overridden to provide the content of the cells. This widget does not manage the cell's data content; it is up to the parent class's draw_cell() method override to provide this.

    Events on the cells and/or headings generate callbacks when they are clicked by the user. You control when events are generated based on the values you supply for when(). 

    """
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    SELECT_NONE = _fltk.Fl_Table_Row_SELECT_NONE
    SELECT_SINGLE = _fltk.Fl_Table_Row_SELECT_SINGLE
    SELECT_MULTI = _fltk.Fl_Table_Row_SELECT_MULTI
    def handle(self, *args):
        """handle(self, int event) -> int"""
        return _fltk.Fl_Table_Row_handle(self, *args)

    def find_cell(self, *args):
        """
        find_cell(self, TableContext context, int R, int C, int X, int Y, int W, 
            int H) -> int
        """
        return _fltk.Fl_Table_Row_find_cell(self, *args)

    def __init__(self, *args): 
        """__init__(self, int X, int Y, int W, int H, char l = None) -> Fl_Table_Row"""
        if self.__class__ == Fl_Table_Row:
            _self = None
        else:
            _self = self
        this = _fltk.new_Fl_Table_Row(_self, *args)
        try: self.this.append(this)
        except: self.this = this
        if len(args) == 6:          
        #retain reference to label
            self.my_label = args[5]
        if self.parent() != None:   
        #delegate ownership to C++
            self.this.disown()



    __swig_destroy__ = _fltk.delete_Fl_Table_Row
    __del__ = lambda self : None;
    def rows(self, *args):
        """
        rows(self, int val)
        rows(self) -> int
        """
        return _fltk.Fl_Table_Row_rows(self, *args)

    def type(self, *args):
        """
        type(self, TableRowSelectMode val)
        type(self) -> TableRowSelectMode
        """
        return _fltk.Fl_Table_Row_type(self, *args)

    def row_selected(self, *args):
        """row_selected(self, int row) -> int"""
        return _fltk.Fl_Table_Row_row_selected(self, *args)

    def select_row(self, *args):
        """select_row(self, int row, int flag = 1) -> int"""
        return _fltk.Fl_Table_Row_select_row(self, *args)

    def select_all_rows(self, *args):
        """select_all_rows(self, int flag = 1)"""
        return _fltk.Fl_Table_Row_select_all_rows(self, *args)

    def clear(self, *args):
        """clear(self)"""
        return _fltk.Fl_Table_Row_clear(self, *args)

    def __disown__(self):
        self.this.disown()
        _fltk.disown_Fl_Table_Row(self)
        return weakref_proxy(self)
    def draw_cell(self, *args):
        """
        draw_cell(self, TableContext context, int R = 0, int C = 0, int X = 0, 
            int Y = 0, int W = 0, int H = 0)
        """
        return _fltk.Fl_Table_Row_draw_cell(self, *args)

Fl_Table_Row_swigregister = _fltk.Fl_Table_Row_swigregister
Fl_Table_Row_swigregister(Fl_Table_Row)


def glLoadIdentity(*args):
  """glLoadIdentity()"""
  return _fltk.glLoadIdentity(*args)

def glViewport(*args):
  """glViewport(int x, int y, int width, int height)"""
  return _fltk.glViewport(*args)

def glClear(*args):
  """glClear(int mask)"""
  return _fltk.glClear(*args)

def glColor3f(*args):
  """glColor3f(float red, float green, float blue)"""
  return _fltk.glColor3f(*args)

def glBegin(*args):
  """glBegin(int mode)"""
  return _fltk.glBegin(*args)

def glEnd(*args):
  """glEnd()"""
  return _fltk.glEnd(*args)

def glVertex3f(*args):
  """glVertex3f(float x, float y, float z)"""
  return _fltk.glVertex3f(*args)
M_PI = _fltk.M_PI
M_PI_2 = _fltk.M_PI_2
M_PI_4 = _fltk.M_PI_4
M_1_PI = _fltk.M_1_PI
M_2_PI = _fltk.M_2_PI
M_SQRT2 = _fltk.M_SQRT2
M_SQRT1_2 = _fltk.M_SQRT1_2
__idleCallbacks = []
def Fl_add_idle( func, data=None):
    __idleCallbacks.append( (func, data) )
    if len(__idleCallbacks) == 1:
        pyFLTK_controlIdleCallbacks(1)

def Fl_remove_idle( func, data=None):
    for cb in __idleCallbacks:
        if cb == ( func, data ):
            __idleCallbacks.remove(cb)
            break

def pyFLTK_doIdleCallbacks():
    for cb in __idleCallbacks:
        cb[0](cb[1])

pyFLTK_registerDoIdle(pyFLTK_doIdleCallbacks)


Fl.add_idle = staticmethod(Fl_add_idle)
Fl.remove_idle = staticmethod(Fl_remove_idle)



def __Fl_WidgetCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
        return apply(_fltk.Fl_Widget_callback,new_args)

Fl_Widget.callback = __Fl_WidgetCallback


def __Fl_Text_BufferAddModifyCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0])
        else:
            new_args = (self, args[0], args[1])
        return apply(_fltk.Fl_Text_Buffer_add_modify_callback,new_args)

Fl_Text_Buffer.add_modify_callback = __Fl_Text_BufferAddModifyCallback


def __Fl_Text_BufferRemoveModifyCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
        return apply(_fltk.Fl_Text_Buffer_remove_modify_callback,new_args)

Fl_Text_Buffer.remove_modify_callback = __Fl_Text_BufferRemoveModifyCallback


def __Fl_File_ChooserCallback(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
        return apply(_fltk.Fl_File_Chooser_callback,new_args)

Fl_File_Chooser.callback = __Fl_File_ChooserCallback


def __Fl_Help_ViewLink(self,*args):
        if len(args) == 1:
            new_args = (self, args[0], self)
        else:
            new_args = (self, args[0], self, args[1])
        return apply(_fltk.Fl_Help_View_link,new_args)

Fl_Help_View.link = __Fl_Help_ViewLink


Fl.add_timeout = staticmethod(Fl_add_timeout)
Fl.repeat_timeout = staticmethod(Fl_repeat_timeout)
Fl.remove_timeout = staticmethod(Fl_remove_timeout)
Fl.add_check = staticmethod(Fl_add_check)
Fl.remove_check = staticmethod(Fl_remove_check)
Fl.add_handler = staticmethod(Fl_add_handler)
Fl.remove_handler = staticmethod(Fl_remove_handler)
Fl.add_fd = staticmethod(Fl_add_fd)
Fl.remove_fd = staticmethod(Fl_remove_fd)


setMenu = _fltk.setMenu

