#!/usr/local/bin/python -t
# $Id: trace.py.in,v 1.7 2006/09/22 00:20:42 rockyb Exp $ -*- Python -*-
"Unit test of program execution tracing using the Extended Python debugger "
import difflib, os, time, sys, unittest

top_builddir = "../"
if top_builddir[-1] != os.path.sep:
    top_builddir += os.path.sep
sys.path.insert(0, os.path.join(top_builddir, 'pydb'))
top_srcdir = ".."
if top_srcdir[-1] != os.path.sep:
    top_srcdir += os.path.sep
sys.path.insert(0, os.path.join(top_srcdir, 'pydb'))

builddir     = "."
if builddir[-1] != os.path.sep:
    builddir += os.path.sep

srcdir = "."
if srcdir[-1] != os.path.sep:
    srcdir += os.path.sep

pydir        = os.path.join(top_builddir, "pydb")
pydb_short   = "pydb.py"
pydb_path    = os.path.join(pydir, pydb_short)

def run_debugger(testname, pythonfile, pydb_opts='', args='', outfile=None):
    global srcdir, builddir, pydir

    if sys.version_info[0:2] == (2, 5):
        rightfile   = os.path.join(srcdir, "%s-2.5.right" % testname)
    else:
        rightfile   = os.path.join(srcdir, "%s.right" % testname)

    outfile_opt = ''
    if outfile is None:
        outfile     = "%s.out" % testname
        outfile_opt = '--output=%s ' % outfile

    # print "builddir: %s, cmdfile: %s, outfile: %s, rightfile: %s" % \
    # (builddir, cmdfile, outfile, rightfile)

    if os.path.exists(outfile): os.unlink(outfile)

    cmd = "%s %s %s %s %s" % \
          (pydb_path, outfile_opt, pydb_opts, pythonfile, args)
    
    os.system(cmd)
    fromfile  = rightfile
    fromdate  = time.ctime(os.stat(fromfile).st_mtime)
    fromlines = open(fromfile, 'U').readlines()[0:-2]
    tofile    = outfile
    todate    = time.ctime(os.stat(tofile).st_mtime)
    tolines   = open(tofile, 'U').readlines()[0:-2]
    diff = list(difflib.unified_diff(fromlines, tolines, fromfile,
                                     tofile, fromdate, todate))
    if len(diff) == 0:
        os.unlink(outfile)
    for line in diff:
        print line,
    return len(diff) == 0
    
class PdbTests(unittest.TestCase):

    def test_trace(self):
        """Test running program tracing: --trace option"""
        result=run_debugger(testname='trace',
                            pydb_opts='--trace --basename',
                            pythonfile='%shanoi.py' % srcdir)
        self.assertEqual(True, result, "hanoi trace output comparision")

if __name__ == "__main__":
    unittest.main()
