#!/usr/bin/python
#-*- coding:utf-8 -*-

#    Pybik -- A 3 dimensional magic cube game.
#    Copyright © 2009, 2011  B. Clausius <barcc@gmx.de>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


import sys
import getopt
import cProfile
import pstats

def main():
    opt_vals = app_opts (sys.argv, file='profile.tmp')
    if opt_vals['run']:
        run(opt_vals)
    if opt_vals['out']:
        out(opt_vals)
    return 0

def app_opts (argv, **opt_vals):
    shortopts = "hn:f:"
    shortoptmap = {'h':"help", 'n':"name", 'r':'run', 'o':'out',
                    'y':'pure-python', 'f':'file'}
    longopts = []
    
    for o,opt in shortoptmap.items():
        if o not in shortopts:
            shortopts += o
        if o+':' in shortopts:
            longopts.append(opt+'=')
        else:
            longopts.append(opt)
            
    for o in longopts:
        if o.endswith('='):
            if not o[:-1] in opt_vals:
                opt_vals[o[:-1]] = ''
        else:
            if not o in opt_vals:
                opt_vals[o] = False
    
    #print opt_vals
    #print argv
    try:
        opts,unused_args = getopt.getopt(argv[1:], shortopts, longopts)
    except getopt.GetoptError, e:
        print e
        exit(1)
    #print opts,unused_args
    for opt,optarg in opts:
        if len(opt) == 2 and opt[1] in shortoptmap:
            opt = '--'+shortoptmap[opt[1]]
        if opt == "--help":
            print 'usage:', argv[0], 'options...'
            for so,lo in shortoptmap.items():
                if o == ':':
                    continue
                elif so+':' in shortopts:
                    print '    -%s arg, --%s=arg' % (so,lo)
                else:
                    print '    -%s, --%s' % (so,lo)
            exit (0)
        elif opt[2:] in longopts:
            opt_vals[opt[2:]] = True
        elif opt[2:]+'=' in longopts:
            opt_vals[opt[2:]] = optarg
        else:
            opt_vals[opt.lstrip('-')] = optarg
    
    #print opt_vals
    return opt_vals

def run(opts):
    global main_module
    import main as main_module
    if opts['pure-python']:
        statement = 'main_module.main(["", "--solved", "--pure-python"])'
        cProfile.run(statement, opts['file'])
    else:
        statement = 'main_module.main(["", "--solved"])'
        cProfile.run(statement, opts['file'])

def out(opts):
    p = pstats.Stats(opts['file'])
    p.strip_dirs().sort_stats(-1).print_stats(opts['name'])


if __name__ == '__main__':
    sys.exit(main())


