#-*- coding:utf-8 -*-

#  Copyright © 2009-2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pybikplugin as plugin

def play_chessboard_odd():
    size = plugin.cube_state().dimension
    # Moves are 3-Tuples (axis, slice, dir) axis=0,1,2 slice=0,...,size-1 dir=0,1
    moves =  [(0, i, 0) for i in xrange(1,size,2)]
    moves += [(1, i, 0) for i in xrange(1,size,2)]
    moves += [(2, i, 0) for i in xrange(1,size,2)]
    moves = [moves[i//2] for i in range(2*len(moves))]
    plugin.rotate_animated(moves)

def play_chessboard_even():
    size = plugin.cube_state().dimension
    moves =  [(0, i, 0) for i in xrange(0,size,2)]
    moves += [(1, i, 0) for i in xrange(0,size,2)]
    moves += [(2, i, 0) for i in xrange(0,size,2)]
    moves += [(1, i, 0) for i in xrange(0,size,2)]
    moves = [moves[i//2] for i in range(2*len(moves))]
    plugin.rotate_animated(moves)

def play_pattern(pattern, min_size):
    size = plugin.cube_state().dimension
    if size < min_size:
        plugin.error_dialog(
            ngettext('This pretty pattern only works on cubes\nwith at least {count} slice.',
                    'This pretty pattern only works on cubes\nwith at least {count} slices.',
                    min_size).format(count=min_size))
    else:
        plugin.rotate_flubrd(pattern, size)

N_ = lambda t: t

def item_path(name):
    return N_('Pretty patterns'), name
def item(name, pattern, min_size):
    return item_path(name), lambda: play_pattern(pattern, min_size)

for path, func in [
            item(N_('Stripes'),          "rrbbllrrbbll", 1),
            item(N_('Criss-Cross'),      "rruullrruurr", 1),
            item(N_('Fried Eggs'),       "l2-f2-l2f2", 2),
            item(N_('Fried Eggs v2'),    "rl-fb-ud-rl-", 1),
            item(N_('4 Fried Eggs'),     "l2l2u2l2l2u2-", 2),
            (item_path(N_('Chessboard odd')), play_chessboard_odd),
            (item_path(N_('Chessboard even')), play_chessboard_even),
            item(N_('Zig Zag'),          "rlfbrlfbrlfb", 1),
            item(N_('T-Time'),           "l2l2u2l2l2u2-l2l2duul2l2uul2l2d-l2l2uu", 2),
            #"rr2r2ll2l2ff2f2bb2b2 rr2r2ll2l2ff2f2bb2b2 rr2r2ll2l2ff2f2bb2b2 rr2r2ll2l2ff2f2bb2b2 rr2r2ll2l2ff2f2bb2b2 rr2r2ll2l2ff2f2bb2b2"
        ]:
    plugin.register_script(path, func)

