#-*- coding: utf-8 -*-


licence="""
    file acidebase.py: part of the package pyacidobasic version %s:

    Copyright (C) 2010 Georges Khaznadar <georgesk@ofset.org>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from PyQt4.QtCore import *

class acideBase:
    def __init__(self, formes=["AH","A<sup>-</sup>"], formeIndex=0, nom="acide générique", pK=[3.5], c=1.0, charge=0, v=0.0):
        """
        objet représentant un couple acido-basique
        @param formes la liste des formes acido-basiques conjuguées
        @param formeIndex la forme de base
        @param nom désignation de la forme de base
        @param pK liste des constantes d'acidité
        @param c concentration initiale en mol/L
        @param charge charge électrique de la forme acide en unité élémentaire
        @param v volume en mL
        """
        self.formes=formes
        self.formeIndex=formeIndex
        self.nom=nom
        self.pK=pK
        self.c=c
        self.charge=charge
        self.v=v

    def copie(self):
        return acideBase(self.formes, self.formeIndex, self.nom, self.pK,  self.c, self.charge, self.v)

    def __str__(self):
        return "%s;%s;%s;%s;%s;%s;%s" %(self.formes,
                                        self.formeIndex,
                                        self.nom,
                                        self.pK,
                                        self.c,
                                        self.charge,
                                        self.v)
    def chargeNette(self,pH):
        """
        Renvoie la charge électrique en Faraday en fonction du pH
        """
        concentrations=[1.0] # liste des concentrations des espèces
        total=1.0            # concentration totale
        for pK in self.pK:
            c=concentrations[-1]*10**(pH-pK)
            concentrations.append(c)
            total+=c
        # On normaliste pour que la concentration totale soit self.c
        concentrations=map(lambda c:c/total*self.c, concentrations)
        ch=self.charge # on considère la cahrge de l'espèce acide
        result=0.0
        # on calcule d'abord la concentration de charges
        for c in concentrations:
            result+=c*ch # on cumule la charge de l'espèce acide
            ch-=1        # et on passe à la base conjuguée
        # puis la charge en Faraday, en multipliant par le volume en mL.
        result*=self.v*1e-3   
        return result
    
def fromString(s):
    s=s.split(";")
    ab=acideBase()
    formes=s[0].split(',')
    ab.formes=[]
    for f in formes:
        f=unicode(f,"utf-8")
        ab.formes.append(QString(f))
    ab.formeIndex=   int(s[1])
    ab.nom=          QString(unicode(s[2],"utf-8"))
    pKs=s[3].split(",")
    ab.pK=[]
    for pK in pKs:
        ab.pK.append(float(pK))
    ab.c= float(s[4])
    ab.charge= int(s[5])
    return ab

def listFromString(s):
    liste=[]
    for ligne in s.split("\n"):
        try:
            acideOuBase=fromString(ligne)
            liste.append(acideOuBase)
        except:
            pass
    return liste

def listFromFile(fname):
    return listFromString(open(fname,"r").read(655360))
                

