#----------------------------------------------------------------------
#      ___       ___ ___   P X E S   Universal  Linux  Thin  Client
#     /__/\\_// /__ /__    Copyright(C) 2003 by Diego Torres Milano
#    /    // \\/__  __/    All rights reserved.  http://pxes.sf.net
#
# Author: Diego Torres Milano <diego@in3.com.ar>
# $Id: PxesconfigDruidPage.pm,v 1.2 2003/09/24 04:43:41 diego Exp $
#----------------------------------------------------------------------
package PxesconfigDruidPage;
require 5.000; use strict 'vars', 'refs', 'subs';


BEGIN {
	use constant TRUE => 1;
	use constant FALSE => 0;

	use Exporter   ();
   our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);
	my ($MODEL, $VIEW);

   # set the version for version checking
   #if using RCS/CVS, this may be preferred
   $VERSION = do { my @r = (q$Revision: 1.2 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }; # must be all one line, for MakeMaker

	@ISA         = qw(Exporter);
	@EXPORT      = qw();
	%EXPORT_TAGS = ( );     # eg: TAG => [ qw!name1 name2! ],

	# your exported package globals go here,
	# as well as any optionally exported functions
	@EXPORT_OK   = qw();
}

our @EXPORT_OK;
our $VERSION;
our $AUTOLOAD;

# non-exported package globals go here
# attributes and default values
our $DEBUG;
our $verbose;
our %attributes;

#
# initialize package globals
#

# debug enabled
$DEBUG = 0;

# attributes and default values
# attributes keys will become permitted_values
%attributes = (
	name => undef,
	prev => undef,
	next => undef,
	active => FALSE,
	selected => FALSE,
);

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self = {
		permitted_fields => \%attributes,
		fields => {},
		};

	# use default values
	foreach my $a (keys %attributes) {
		$self->{fields}->{$a} = $attributes{$a};
	}

	if ( $#_ == 2 ) {
		$self->{fields}->{name} = $_[0];
		$self->{fields}->{prev} = $_[1];
		$self->{fields}->{next} = $_[2];
	}
	else {
		die "PxesconfigDruidPage::new: Invalid number of arguments";
	}

	bless $self, $class;
	return $self;
}

sub DESTROY {
}

sub AUTOLOAD {
    my $self = shift;
    my $type = ref($self)
        or die "$self is not an object so we cannot '$AUTOLOAD'\n",
            "We were called from ".join(", ", caller)."\n\n";
    my $name = $AUTOLOAD;
    $name =~ s/.*://;       # strip fully-qualified portion
	 my ($value) = @_;

    if ( exists($self->{permitted_fields}->{$name}) ) {
        # This allows dynamic data methods - see hash fields above
        # eg $class->UI('new_value');
        # or $current_value = $class->UI;
        if (@_) {
            return $self->{fields}->{$name} = $value;
        }
		  else {
            return $self->{fields}->{$name};
        }
	 }
	 elsif ( exists $self->{$name} ) {
	 	if ( @_ ) {
			return $self->{$name} = $value;
		}
		else {
			return $self->{$name};
		}
    }
	 else {
        die "Can't access method `$name' in class $type\n".
            "We were called from ".join(", ", caller)."\n\n";

    }
} # End of sub AUTOLOAD

sub toString() {
	my $self = shift;
	my $s;

	$s .= "PxesconfigDruidPage:\n";

	$s .= $self->name();
	$s .= " " . $self->prev()->toString();
	$s .= " " . $self->next()->toString();

	return $s;
}

1;
__END__

#=======================================================================
#==== Documentation
#=======================================================================
=pod

=head1 NAME

PxesconfigDruidPage - version 0.01 Fri Feb 28 00:45:18 ART 2003

This is the main class

=head1 SYNOPSIS

 use PxesconfigDruidPage;
 my $p = new PxesconfigDruidPage('name', \$prev, \$next);

=head1 DESCRIPTION

Unfortunately, the author has not yet written any documentation :-(

=head1 AUTHOR

Diego Torres Milano <diego@in3.com.ar>

=cut
