#======================================================================
# $Id: Makefile.PL,v 1.5 2003/08/21 04:27:19 diego Exp $
#======================================================================
#
#   Makefile.PL for pxesconfig
#   This is a modified version of the file created by Glade::PerlSource
#
require 5.000;
use ExtUtils::MakeMaker;
use strict;

#--- Configuration section ---

my @programs_to_install = qw(pxesconfig);

my @need_perl_modules = (
    # Check for Gtk::Types rather than the Gtk supermodule
    #   this avoids dumping MakeMaker
    {'name'     => 'Gtk',
    'test'      => 'Gtk::Types',
    'version'   => '0.7000',
    'reason'    => "implements the perl bindings to Gtk+.\n".
                    "The module is called Gtk-Perl on CPAN or ".
                    "module gnome-perl in the Gnome CVS"},

    # Check for Gnome::Types rather than the Gnome supermodule
    #   this avoids dumping MakeMaker
    {'name'     => 'Gnome',
    'test'      => 'Gnome::Types',
    'version'   => '1.2.0',
    'reason'    => "implements the perl bindings to Gnome.\n".
                   "It is a submodule of the Gtk-Perl package and needs to be built separately.\n".
                   "Read the Gtk-Perl INSTALL file for details of how to do this.\n".
                   "Glade-Perl will still work but you will not be able to \n".
                   "use any Gnome widgets in your Glade projects"},

#    # Check for Glade::Perlrun
#    {'name'     => 'Glade-Perl',
#    'test'      => 'Glade::PerlRun',
#    'version'   => '0.60',
#    'reason'    => "runs glade generated programs.\n".
#                   "It is a module of the Glade-Perl package"},


    );
#--- End Configuration - You should not have to change anything below this line

# Allow us to suppress all program installation with the -n (library only)
# option.  This is for those that don't want to mess with the configuration
# section of this file.
use Getopt::Std;
use vars qw($opt_n);
unless (getopts("n")) {
    die "Usage: $0 [-n]\n";
}
@programs_to_install = () if $opt_n;

# Check for non-standard modules that are used by this library.
$| = 1; # autoflush on
my $missing_modules = 0;

foreach my $mod (@need_perl_modules) {
    print "Checking for $mod->{'name'}..";
    eval "require $mod->{'test'}";
    if ($@) {
        $missing_modules++;
        print " failed\n";
        print   "-------------------------------------------------------".
                "\n$@\n",
                "$mod->{'name'} is needed, it $mod->{'reason'}\n",
                "We need at least version $mod->{'version'}\n".
                "-------------------------------------------------------\n";
        sleep(2);  # Don't hurry too much
    } else {
        print " ok\n";
    }
}

#--------------------------------------
print "-------------------------------------------------------
The missing modules can be obtained from CPAN. Visit
<URL:http://www.perl.com/CPAN/> to find a CPAN site near you.
-------------------------------------------------------\n\n"
     if $missing_modules;

#--------------------------------------
# Last of all generate the Makefile
WriteMakefile(
	 'AUTHOR'			=> 'Diego Torres Milano <diego@pxes.com.ar>',
	 'ABSTRACT_FROM'	=> 'pxesconfig',
    'DISTNAME'     	=> 'pxesconfig',
    'NAME'         	=> 'Pxesconfig',
    'VERSION_FROM' 	=> 'pxesconfig',
    'EXE_FILES'    	=> [ @programs_to_install ],
    'clean'        	=> { FILES => '' },
    'dist'         	=> { COMPRESS => 'gzip -f', SUFFIX => 'gz' },
	 'INSTALLDIRS'		=> 'site',
	 #'PREFIX'		 	=> '/opt',
	 #'INSTALLSITELIB'	=> '$(LIB)',
	 #'PMLIBDIRS'		=> [ 'Pxesconfig' ],
);

package MY;

# Pass Glade-Perl version number to pod2man
sub manifypods
{
    my $self = shift;
    my $ver = $self->{'VERSION'} || "";
    local($_) = $self->SUPER::manifypods(@_);
    s/pod2man\s*$/pod2man --release pxesconfig-$ver/m;
    $_;
}

sub release_from
{
	my ($self, $filename) = @_;

	my $rel;

	open(RF, $filename);
	my @rf = <RF>;
	close(RF);

	foreach my $l (@rf) {
		if ( $l =~ /RELEASE\s*=\s*'(\d+)/ ) {
			$self->{'RELEASE'} = $1;
			last;
		}
	}
}

sub postamble
{
	my ($self) = shift;

	my $out='';

	release_from($self, $self->{'VERSION_FROM'})
		if ( $self->{'VERSION_FROM'} );

	$out .= <<"EOM";

PIXMAPDIR = \$(PREFIX)/share/pixmaps/pxesconfig
CONFIGDIR = \$(PREFIX)/share/pxesconfig
RELEASE = $self->{'RELEASE'}

install ::
	\$(PERL) -MExtUtils::Install \\
		-e "install({'etc' => '\$(CONFIGDIR)'},'\$(VERBINST)',0);"

install ::
	\$(PERL) -MExtUtils::Install \\
		-e "install({'pixmaps' => '\$(PIXMAPDIR)'},'\$(VERBINST)',0);"

install ::
	\$(PERL) -MExtUtils::Install \\
		-e "install({'Pxesconfig' => '\$(INSTALLSITELIB)/Pxesconfig'},'\$(VERBINST)',0);"

checkpxesconfig:
	\@if grep '^[ 	]*use lib "\."' pxesconfig >/dev/null ; \\
	then \\
		echo "This is a development version"; \\
		exit 1; \\
	fi

checkdebug:
	\@if grep 'DEBUG[    ]*=[    ]*[1-9]' Pxesconfig/*.pm > /dev/null; \\
	then \\
		echo "This version has debug enabled"; \\
		exit 1; \\
	fi

dist_with_rel: dist
	mv pxesconfig-\$(VERSION).tar.gz pxesconfig-\$(VERSION)-\$(RELEASE).tar.gz

prerpmclean:
	rm -f MANIFEST
	rm -rf pxesconfig-\$(VERSION)
	rm -f pxesconfig-\$(VERSION)-\$(RELEASE).tar.gz
	rm -f /usr/src/redhat/SOURCES/pxesconfig-\$(VERSION)-\$(RELEASE).tar.gz

rpm: checkpxesconfig checkdebug prerpmclean manifest dist dist_with_rel
	cp pxesconfig-\$(VERSION)-\$(RELEASE).tar.gz /usr/src/redhat/SOURCES/pxesconfig-\$(VERSION)-\$(RELEASE).tar.gz
	rpmbuild -ba pxesconfig.spec

	
EOM
	return $out;
}

exit(0);

# End of Makefile.PL
