/* 
    SIMD functionality for Apple Velocity Engine (AltiVec) with GCC compiler
    added by T.Grill
*/

#ifndef __M_SIMD_VE_GCC_H
#define __M_SIMD_VE_GCC_H

#include "m_pd.h"

/* SIMD functions for VE with GCC */
t_int *zero_perf_ve_gcc(t_int *w);
t_int *copy_perf_ve_gcc(t_int *w);
t_int *sig_tilde_perf_ve_gcc(t_int *w);
t_int *plus_perf_ve_gcc(t_int *w);
t_int *scalarplus_perf_ve_gcc(t_int *w);
t_int *minus_perf_ve_gcc(t_int *w);
t_int *scalarminus_perf_ve_gcc(t_int *w);
t_int *times_perf_ve_gcc(t_int *w);
t_int *scalartimes_perf_ve_gcc(t_int *w);
t_int *sqr_perf_ve_gcc(t_int *w);
t_int *over_perf_ve_gcc(t_int *w);
t_int *scalarover_perf_ve_gcc(t_int *w);
t_int *max_perf_ve_gcc(t_int *w);
t_int *scalarmax_perf_ve_gcc(t_int *w);
t_int *min_perf_ve_gcc(t_int *w);
t_int *scalarmin_perf_ve_gcc(t_int *w);
t_int *clip_perf_ve_gcc(t_int *w);
t_int *sigwrap_perf_ve_gcc(t_int *w);
t_int *sigsqrt_perf_ve_gcc(t_int *w);
t_int *sigrsqrt_perf_ve_gcc(t_int *w);


/* functions in d_ugen.c */
#define zero_perf_simd          zero_perf_ve_gcc

/* functions in d_dac.c */
#define copy_perf_simd          copy_perf_ve_gcc

/* functions in d_ctl.c */
#define sig_tilde_perf_simd     sig_tilde_perf_ve_gcc

/* functions in d_arithmetic.c */
#define plus_perf_simd          plus_perf_ve_gcc
#define scalarplus_perf_simd    scalarplus_perf_ve_gcc
#define minus_perf_simd         minus_perf_ve_gcc
#define scalarminus_perf_simd   scalarminus_perf_ve_gcc
#define times_perf_simd         times_perf_ve_gcc
#define scalartimes_perf_simd   scalartimes_perf_ve_gcc
#define sqr_perf_simd           sqr_perf_ve_gcc
#define over_perf_simd          over_perf_ve_gcc
#define scalarover_perf_simd    scalarover_perf_ve_gcc
#define min_perf_simd           min_perf_ve_gcc
#define scalarmin_perf_simd     scalarmin_perf_ve_gcc
#define max_perf_simd           max_perf_ve_gcc
#define scalarmax_perf_simd     scalarmax_perf_ve_gcc

/* functions in d_math.c */
#define clip_perf_simd          clip_perf_ve_gcc
#define sigwrap_perf_simd       sigwrap_perf_ve_gcc
#define sigsqrt_perf_simd       sigsqrt_perf_ve_gcc
#define sigrsqrt_perf_simd      sigrsqrt_perf_ve_gcc

#endif /* __M_SIMD_VE_GCC_H */
