/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Usermanager functions
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __USR_MANAGER_H__
#define __USR_MANAGER_H__
#include <unistd.h>
#include <sys/types.h>
#include "globals.h"

#define PW_LINE_SEP ":"
#define PW_LINE_SEP_CH ':'

#ifndef PW_LINE_COMMENT
# define PW_LINE_COMMENT '#'
#endif

#define PASSWD_FILE "/etc/pureftpd.passwd"

typedef struct PWInfo_ {
  gchar *login;
  gchar *pwd;
  uid_t uid;
  gid_t gid;
  gboolean chroot;
  gchar *home;
  gchar *gecos;
  gulong bw_dl;
  gulong bw_ul;
  gulong quota_files;
  gulong quota_size;
  guint ul_ratio;
  guint dl_ratio;
  gchar *allow_local_ip;
  gchar *deny_local_ip;    
  gchar *allow_client_ip;
  gchar *deny_client_ip;
  guint time_begin;
  guint time_end;
  guint per_user_max;
} PWInfo;

typedef struct PAvailableUser_ {
  gchar *login;
  gchar *realname;
} PAvailableUser;
    
struct usrman_info_widgets {
  GtkWidget *login, *realname, *home, *root, *pwd;
  GtkWidget *chk_chroot, *e_uid, *e_gid;
  GtkWidget *bw_ul, *bw_dl, *quota_files, *quota_size;
  GtkWidget *ul_ratio, *dl_ratio, *timelimit;
  GtkWidget *simsess;
  GtkWidget *loc_allow, *loc_deny, *cli_allow, *cli_deny;
  GtkWidget *btn_pwchange, *btn_savechanges, *btn_cancelchanges;
  GtkWidget *lbl_invalid_gid, *lbl_invalid_uid;
  GtkWidget *btn_browse_homedir, *btn_browse_fakeroot;
};

gboolean usr_user_exists (const gchar *user);
gboolean usr_select_first_user (void);
GList *usr_get_available_users (void);
PWInfo *usr_get_user_information (gchar *user);
PWInfo *usr_widgets_get_info (void);
gboolean usr_manager_check_prerequisites (void);
pur_error_t usr_widgets_set_info (gchar *user);
pur_error_t usr_save_user_info (gboolean existing);
pur_error_t usr_remove_user (const gchar *user);
pur_error_t usr_add_user (const gchar *user, const gchar *passwd);
void usr_widgets_set_active_state (gboolean active);

#endif /* __USR_MANAGER_H__ */
