/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Logfile-functions incl. callbacks to manage the logfile-viewer
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __LOGFILE_H__
#define __LOGFILE_H__
typedef enum 
{
  LOG_INFO,
  LOG_WARNING,
  LOG_ERROR,
  LOG_NOTICE,
  LOG_DEBUG,
  NUM_LOGTAGS
} log_textview_mode;

extern GtkTextTag *logview_tags[NUM_LOGTAGS];

gboolean init_logfile (void);
void close_logfile (void);
/* Display an errormessage explaining why logfile viewer has been disabled.
   reason = 0 ==> FAM isn't installed,
   reason = 1 ==> FAM isn't running. */
void log_display_error_text (gint reason);
void log_clear_logview (void);
void read_logfile (void);


#endif /* __LOGFILE_H__ */
