/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Misc helperfunctions related to the GUI
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __GUI_HELPER_H__
#define __GUI_HELPER_H__

#include "srv_comm.h"

#define GB 1073741824
#define MB 1048576
#define KB 1024

#define MSGDLG_TYPE_INFO "gtk-dialog-info"
#define MSGDLG_TYPE_WARNING "gtk-dialog-warning"
#define MSGDLG_TYPE_ERROR "gtk-dialog-error"


extern GtkWidget *main_window;
extern GtkWidget *dlg_usrman;
extern guint timeout_id_activities;
extern gboolean prog_exiting;;

typedef struct {
  GdkPixbuf *icon;
  gchar *text;
  gint32 id;
} PGuiActivityRow;

typedef struct {
  GdkPixbuf *icon;
  gchar *user, *host;
  gint num_connections;
} PGuiUserRow;

typedef struct {
  GdkPixbuf *icon;
  gchar *login;
  gchar *realname;
} PGuiUsermanRow;

enum
{
   COL_ACT_ICON,
   COL_ACT_TEXT,
   COL_ACT_ID,
   N_ACT_COLUMNS
};

enum
{
  COL_USR_ICON,
  COL_USR_USER,
  COL_USR_HOST,
  COL_USR_NUM_CONNECTIONS,
  N_USR_COLUMNS
};

enum
{
  COL_USRMAN_ICON,
  COL_USRMAN_LOGIN,
  COL_USRMAN_REALNAME,
  N_USRMAN_COLUMNS
};

typedef enum {
  POPUP_FROM_USRTREE,
  POPUP_FROM_ACTTREE
} popup_src_t;

void gui_terminate (void);
void statusbar_push (const gchar *msg);
void statusbar_pop (void);

void gui_update_server_status (void);
void gui_update_menu_sensivity (void);
void gui_display_activity_popup (popup_src_t source);
void gui_add_to_activities (PGuiActivityRow line);
void gui_add_to_online_users (PGuiUserRow line);
gchar *gui_gen_progress_string (gint total, gint current);
void gui_clear_activity_list (void);
void gui_clear_users_list (void);
void gui_clear_usersman_list (void);
gint gui_fill_userman_list (void);
void gui_userman_select_user (const gchar *user);
void gui_update_info_frame (PActivity *a);
GtkWidget *gui_create_menu_from_glist (GList *l);

gint gui_tree_act_get_selected_id (void);
gboolean gui_tree_usr_get_selected_user (gchar **user, gchar **host);

void gui_display_msgdialog_checkbox (const gchar *primary, const gchar *secondary, const gchar *icon_type, GtkWidget *parent, gboolean *show_again);
void gui_display_msgdialog (const gchar *primary, const gchar *secondary, const gchar *icon_type, GtkWidget *parent);
gint gui_display_confirmdialog (const gchar *primary, const gchar *secondary, const gchar *txt_btn_yes, const gchar *txt_btn_no);

#endif /* __GUI_HELPER_H__ */
