/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Global variables
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#define FILEPATH_MAX 1024
#define DEF_PUREFTPD_PIDFILE "/var/run/pure-ftpd.pid"

#ifndef LINE_MAX
# define LINE_MAX 4096
#endif
/* Set _CRITICAL since _ERR will terminate the program by glib */
#define pur_log_err(...) \
  g_log (NULL, G_LOG_LEVEL_CRITICAL, __VA_ARGS__);
#define pur_log_wrn(...) \
  g_log (NULL, G_LOG_LEVEL_WARNING, __VA_ARGS__);
#ifdef ENABLE_DEBUG
# define pur_log_dbg(...) \
  g_log (NULL, G_LOG_LEVEL_DEBUG, __VA_ARGS__);
#else
# define pur_log_dbg(...)
#endif /* ENABLE_DEBUG */
#define pur_log_nfo(...) \
  g_log (NULL, G_LOG_LEVEL_INFO, __VA_ARGS__);

void get_srv_vars ();

struct srv_externals_t {
  gchar cmd_pure_pw[FILEPATH_MAX];
  gchar cmd_pure_ftpwho[FILEPATH_MAX];
  gchar cmd_groupadd[FILEPATH_MAX];
  gchar cmd_useradd[FILEPATH_MAX];
  gchar fl_pidfile[FILEPATH_MAX];
  gchar fl_config[FILEPATH_MAX];
  gchar fl_pwfile[FILEPATH_MAX];
  gchar fl_pdbfile[FILEPATH_MAX];
  gchar dir_usrhome[FILEPATH_MAX];
  gchar backup[FILEPATH_MAX];
  gchar startupscript[FILEPATH_MAX];
  gint id_ftpgid;
  gint id_ftpuid;
  gint pureftpd_pid;
  gboolean pureftpd_running;
};

extern struct srv_externals_t srv_vars;

/* Error types */
typedef enum
{
  E_NO_ERROR,
  E_GENERAL_ERROR,
  E_CMD_NOT_FOUND,
  E_FILE_NOT_FOUND,
  E_PERMISSION_DENIED,
  E_USER_NOT_FOUND
} pur_error_t;

#endif /* __GLOBALS_H__ */
