use strict;
use warnings;

use Test::More tests => 4;
use File::pushd;
use Cwd qw(abs_path);

BEGIN {
    use_ok('Publican');
    use_ok('Publican::Builder');
}

diag("Testing Publican::Builder $Publican::Builder::VERSION");

my $dir = pushd("Test_Book");

my $publican = Publican->new(
    {   debug          => 1,
        configfile     => 'publican.cfg',
        common_config  => abs_path('../blib/datadir'),
        common_content => abs_path('../blib/datadir/Common_Content')
    }
);

my $builder = Publican::Builder->new();


is($builder->package( { lang => "en-US" } ), undef, "package a book"); 

## BUGBUG have to run this test last or we get weird errors
isa_ok( $builder, 'Publican::Builder', 'creating a Publican::Builder' );

## BUGBUG this test isn't picked up by the test engine
#is($builder->build( { formats => "html,pdf", langs => "en-US" } ), undef, "build a book");

$dir = undef;

