%
% jMetaPost change file for MetaPost, Version 0.641 (Web2C 7.2)
%
% written by Michio Matsuyama <fwhw5892@mb.infoweb.ne.jp>
%            Hideyuki Suzuki <hideyuki@sat.t.u-tokyo.ac.jp>
%
% $Id: jmp.ch,v 1.42 2000/03/20 02:55:50 hideyuki Exp $

@x
@d banner=='This is MetaPost, Version 0.641' {printed when \MP\ starts}
@y
@d banner=='This is jMetaPost, Version 0.641-0.04'
  {printed when \MP\ starts}
@z

@x
wterm (banner);
wterm (version_string);
@y
wterm (banner);
ifdef('OUTJIS') wterm (' (JIS)'); endif('OUTJIS')@/
ifdef('OUTSJIS') wterm (' (SJIS)'); endif('OUTSJIS')@/
ifdef('OUTEUC') wterm (' (EUC)'); endif('OUTEUC')@/
wterm (version_string);
@z

%
% tategaki support
%
% Suppose h=(0,height), d=(0,-depth) and w=(width,0) in horizontal string,
% and h=(height,0), d=(-depth,0) and w=(0,-width) in vertical string.
% Four vertices of the bounding box is h, d, h+w and d+w and those of the
% transformed boundig box is Th, Td, T(h+w) and T(d+w), so that the values
% of Th, Td and Tw are compared here.
@x
@ The height width and depth information stored in a text node determines a
rectangle that needs to be transformed according to the transformation
parameters stored in the text node.

@<Other cases for updating the bounding box...@>=
text_code: begin x1:=take_scaled(txx_val(p),width_val(p));
  y0:=take_scaled(txy_val(p),-depth_val(p));
  y1:=take_scaled(txy_val(p),height_val(p));
@y
@ The height width and depth information stored in a text node determines a
rectangle that needs to be transformed according to the transformation
parameters stored in the text node.

Boundig box depends on JFM font ID.

@d yoko_jfm_id = 11 {`yoko-kumi' fonts}
@d tate_jfm_id = 9  {`tate-kumi' fonts}
@d font_jfm_p(#) == (font_id[#]<>0)

@<Other cases for updating the bounding box...@>=
text_code: begin
  if font_id[font_n(p)]<>tate_jfm_id then begin
    x1:=take_scaled(txx_val(p),width_val(p));
    y0:=take_scaled(txy_val(p),-depth_val(p));
    y1:=take_scaled(txy_val(p),height_val(p));
    end
  else begin
    x1:=take_scaled(txy_val(p),-width_val(p));
    y0:=take_scaled(txx_val(p),-depth_val(p));
    y1:=take_scaled(txx_val(p),height_val(p));
    end;
@z
@x
  x1:=take_scaled(tyx_val(p),width_val(p));
  y0:=take_scaled(tyy_val(p),-depth_val(p));
  y1:=take_scaled(tyy_val(p),height_val(p));
@y
  if font_id[font_n(p)]<>tate_jfm_id then begin
    x1:=take_scaled(tyx_val(p),width_val(p));
    y0:=take_scaled(tyy_val(p),-depth_val(p));
    y1:=take_scaled(tyy_val(p),height_val(p));
    end
  else begin
    x1:=take_scaled(tyy_val(p),-width_val(p));
    y0:=take_scaled(tyx_val(p),-depth_val(p));
    y1:=take_scaled(tyx_val(p),height_val(p));
    end;
@z

@x
begin wlog(banner);
wlog (version_string);
@y
begin wlog(banner);
ifdef('OUTJIS') wlog(' (JIS)'); endif('OUTJIS')@/
ifdef('OUTSJIS') wlog(' (SJIS)'); endif('OUTSJIS')@/
ifdef('OUTEUC') wlog(' (EUC)'); endif('OUTEUC')@/
wlog (version_string);
@z

%
% char type array
@x
font_bc,font_ec:array[font_number] of eight_bits;
  {first and last character code}
@y
font_bc,font_ec:array[font_number] of eight_bits;
  {first and last character code}
font_nt:array[font_number] of halfword;
font_id:array[font_number] of halfword;
@z

@x
char_base:array[font_number] of 0..font_mem_size;
  {base address for |char_info|}
@y
char_base:array[font_number] of 0..font_mem_size;
  {base address for |char_info|}
ctype_base:array[font_number] of 0..font_mem_size;
  {base address for |char_type|}
@z

@x
char_base[null_font]:=0;
@y
font_id[null_font]:=0;
font_nt[null_font]:=0;@/
char_base[null_font]:=0;
ctype_base[null_font]:=0;
@z

@x
@d char_info_end(#)==#].qqqq
@d char_info(#)==font_info[char_base[#]+char_info_end
@y
@d char_info_end(#)==#].qqqq
@d char_info(#)==font_info[char_base[#]+char_info_end
@d ctype_char_end(#)==#].hh.lh
@d ctype_char(#)==font_info[ctype_base[#]+ctype_char_end
@d ctype_type_end(#)==#].hh.rh
@d ctype_type(#)==font_info[ctype_base[#]+ctype_type_end
@z

%
% local variable 'nt' and 'ct'
@x
@!lf,@!lh,@!bc,@!ec,@!nw,@!nh,@!nd:halfword; {subfile size parameters}
@y
@!lf,@!lh,@!bc,@!ec,@!nw,@!nh,@!nd,@!nt:halfword; {subfile size parameters}
@z
@x
@!h_and_d:eight_bits; {height and depth indices being unpacked}
@y
@!h_and_d:eight_bits; {height and depth indices being unpacked}
@!ct:halfword; {char and type}
@!id:halfword; {JFM font id}
@z

@x
@<Read the character data and the width, height, and depth tables and
  |goto done|@>
@y
@<Read the character type table@>;
@<Read the character data and the width, height, and depth tables and
  |goto done|@>
@z

%
% routine to process JFM file format
@x
@<Read the \.{TFM} size fields@>=
read_two(lf);
@y
@<Read the \.{TFM} size fields@>=
read_two(lf);
if (lf=yoko_jfm_id) or (lf=tate_jfm_id) then begin
  id:=lf;
  tfget; read_two(nt);
  tfget; read_two(lf);
  end
else begin
  id:=0; nt:=0;
  end;
@z
@x
whd_size:=(ec+1-bc)+nw+nh+nd;
@y
whd_size:=(ec+1-bc)+nt+nw+nh+nd;
@z

%
% reserve space for character type table
@x
char_base[n]:=next_fmem-bc-min_pool_ASCII;
width_base[n]:=next_fmem+ec-bc+1-min_quarterword;
@y
font_id[n]:=id;
font_nt[n]:=nt;
ctype_base[n]:=next_fmem;
char_base[n]:=next_fmem+nt-bc-min_pool_ASCII;
width_base[n]:=next_fmem+nt+ec-bc+1-min_quarterword;
@z

%
% read character type table
@x
tf_ignore(4*(lh-2))
@y
tf_ignore(4*(lh-2))

@ @<Read the character type table@>=
ii:=ctype_base[n]+nt;
i:=ctype_base[n];
while i<ii do begin
  tfget; read_two(ct);
  font_info[i].hh.lh:=ct;
  tfget; read_two(ct);
  font_info[i].hh.rh:=ct;
  incr(i);
  end
@z

@x
file_opened:=true
@y
file_opened:=true

@ @<Declare JFM function for text measuring@>=
function lookup_ctype(@!f:font_number;@!c:integer):integer;
var l, u, r, ch:integer;
begin
  l:=0; u:=font_nt[f]-1;
  while l<u do begin
    r:=(l+u)/2;
    ch:=ctype_char(f)(r);
    if (ch=c) then begin
      lookup_ctype:=ctype_type(f)(r); return end;
    if (ch<c) then l:=r+1
    else u:=r-1;
    end;
  lookup_ctype:=0;
exit:
end
@z

%
% lookup character type table
@x
procedure set_text_box(@!p:pointer);
@y
@<Declare JFM function for text measuring@>;
procedure set_text_box(@!p:pointer);
@z
@x
begin if (str_pool[k]<bc)or(str_pool[k]>ec) then lost_warning(f,k)
else begin cc:=char_info(f)(str_pool[k]);
@y
begin if ((str_pool[k]<bc)or(str_pool[k]>ec)) and (not font_jfm_p(f)) then
    lost_warning(f,k)
  else begin
    if (not font_jfm_p(f)) then cc:=char_info(f)(str_pool[k])
    else begin incr(k);
      cc:=char_info(f)(lookup_ctype(f,str_pool[k-1]*256+str_pool[k]))
      end;
@z

%
% Treat all Kanji fonts as used
@x
begin for p:=char_base[f]+si(c) to char_base[f]+si(font_ec[f]) do
  if font_info[p].qqqq.b3=used then
    begin check_ps_marks:=true; return;
    end;
@y
begin for p:=char_base[f]+si(c) to char_base[f]+si(font_ec[f]) do
  if font_info[p].qqqq.b3=used or font_jfm_p(f) then
    begin check_ps_marks:=true; return;
    end;
@z

%
% Kanji string output
@x
@ We are now ready for the main output procedure.  Note that the |selector|
@y
@ @<Declare the \ps\ output procedures@>=
procedure ps_kanji_string_out(s:str_number);
var @!i:pool_pointer; {current character code position}
@!k,kk:ASCII_code; {bits to be converted to octal}
@!c:integer; {code for Japanese two byte character}
begin
i:=str_start[s];
print("<");
while i<str_stop(s) do
  begin if ps_offset+5>max_print_line then print_ln;
  k:=so(str_pool[i]);@/
  incr(i);
  if (proc_kanji_code=1) then
     c:=EUCtoJIS(k*@'400+so(str_pool[i]))
  else if(proc_kanji_code=2) then
     c:=SJIStoJIS(k*@'400+so(str_pool[i]));
  k:=(c div @'400);
  hex_digit_out(k div 16);
  hex_digit_out(k mod 16);
  k:=c mod @'400;
  hex_digit_out(k div 16);
  hex_digit_out(k mod 16);
  incr(i);
  end;
print(">");
end;

@ We are now ready for the main output procedure.  Note that the |selector|
@z

@x
print_nl("%%Creator: MetaPost");
@y
print_nl("%%Creator: MetaPost (Japanese version)");
@z

%
% Call Kanji string output routine if the font is JFM.
@x
  ps_string_out(text_p(p));
  ps_name_out(font_name[font_n(p)],false);
@y
  if font_jfm_p(font_n(p)) then ps_kanji_string_out(text_p(p))
  else ps_string_out(text_p(p));
  ps_name_out(font_name[font_n(p)],false);
@z
