#include<stdio.h>
#include<math.h>
#include<stdlib.h>
#include<libipv1/ip_lib.h>
#include<libciomr/libciomr.h>
#include<libchkpt/chkpt.h>
#include<libpsio/psio.h>
#include<psifiles.h>
#include<libint/libint.h>

#include"defines.h"
#include"global.h"

#include"small_fns.h"
#include"parsing.h"
#include"prints.h"
#include"molecule.h"
#include"basisset.h"
#include"symm.h"
#include"dcr.h"
#include"gto.h"
#ifdef INCLUDE_Default_Ints
 #include"oe_ints.h"
 #include"te_ints.h"
#endif
#ifdef INCLUDE_Fock
 #include"fock.h"
#endif
#ifdef INCLUDE_Default_Deriv1
 #include"deriv1.h"
#endif
#ifdef INCLUDE_Default_Deriv2
void deriv1_fock(void);
#endif
#ifdef INCLUDE_OEProp_Ints
 #include"oeprop_ints.h"
#endif
#ifdef INCLUDE_MP2
 #include"mp2.h"
#endif
#ifdef INCLUDE_R12_Ints
 #include"r12_te_ints.h"
#endif
#ifdef INCLUDE_MP2R12
 #include"mp2r12.h"
#endif
#ifdef INCLUDE_CC
 #include"cc.h"
#endif

/*-------------------------------
  External functions declaration
 -------------------------------*/
char *gprgid();
void init_globals();
void check_max_am();

int main(int argc, char *argv[])
{
   /*--- Local variables ---*/
   int i,j,k,l,m,count;

   init_globals();
   start_io(argc, argv);
   parsing();
   /*--- Parse the command line ---*/
   parsing_cmdline(argc,argv);
   print_intro();
   setup();
   
   /*--- Prepare data ---*/
   init_molecule();
   init_symmetry();
   init_basisset();
   check_max_am();
   init_dcr();
   init_gto();

   /*--- Print out some stuff ---*/
   print_scalars();
   print_basisset();

   /*--- Compute the integrals ---*/
#ifdef INCLUDE_Default_Ints
   if (UserOptions.make_oei) {
     /* Molecule.Enuc = */ compute_enuc();
     chkpt_wt_enuc(Molecule.Enuc);
     oe_ints();
   }
   if (UserOptions.make_eri)
     te_ints();
#endif
#ifdef INCLUDE_Fock
   if (UserOptions.make_fock)
     fock();
#endif
   /*--- Compute the derivative integrals ---*/
#ifdef INCLUDE_Default_Deriv1
   if (UserOptions.make_deriv1)
     deriv1();
#endif

   /*--- Compute second derivative integrals ---*/
#ifdef INCLUDE_Default_Deriv2
   if (UserOptions.make_deriv2)
     deriv2();
#endif

#ifdef INCLUDE_OEProp_Ints
   if (UserOptions.make_oeprop)
     oeprop_ints();
#endif
#ifdef INCLUDE_MP2
   if (UserOptions.make_mp2)
     mp2();
#endif
#ifdef INCLUDE_R12_Ints
   if (UserOptions.make_r12ints)
     r12_te_ints();
#endif
#ifdef INCLUDE_MP2R12
   if (UserOptions.make_mp2r12)
     mp2r12();
#endif
#ifdef INCLUDE_CC
   if (UserOptions.make_cc_bt2)
     direct_cc();
#endif
   
   /*--- Cleanup ---*/
   cleanup_gto();
   cleanup_symmetry();
   cleanup_basisset();
   cleanup_molecule();

   stop_io();
   exit(PSI_RETURN_SUCCESS);
}
