#ifndef TOOLBARDLG_H
#define TOOLBARDLG_H

#include <qdialog.h>

class PsiCon;
class QToolBar;
struct Options;
class QAction;
class IconButton;
class QListView;
class QListViewItem;

class ToolbarDlg : public QDialog
{
	Q_OBJECT
public:
	ToolbarDlg(PsiCon *, QWidget *parent = 0, const char *name = 0);
	~ToolbarDlg();

	void setCurrentToolbar(QToolBar *);

signals:
	void applyOptions(const Options &);

private slots:
	void toolbarAdd();
	void toolbarDelete();
	void addToolbarAction(QListView *, QString name);
	void addToolbarAction(QListView *, const QAction *action, QString name);
	void toolbarSelectionChanged(int);
	void rebuildToolbarKeys();
	void toolbarNameChanged();
	void toolbarActionUp();
	void toolbarActionDown();
	void toolbarAddAction();
	void toolbarRemoveAction();
	void toolbarDataChanged();
	QString actionName(const QAction *a);
	void toolbarPosition();
	void selAct_selectionChanged(QListViewItem *);
	void avaAct_selectionChanged(QListViewItem *);

	void doApply();
	void toolbarPositionApply();

	void dataChangedSlot();

	void applyOptions(Options *opt);
	void restoreOptions(const Options *opt);

signals:
	void dataChanged();

private:
	void updateArrows();

	QWidget *w;
	Options *opt;
	PsiCon *psi;
	bool noDirty;
	IconButton *pb_apply;
};

#endif
