/*
 * iconaction.h - the QAction subclass that uses Icons and supports animation
 * Copyright (C) 2003  Michail Pishchagin
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef ICONACTION_H
#define ICONACTION_H

#include <qaction.h>
#include <qptrlist.h>

class QToolButton;
class QPixmap;
class Icon;
class IconToolButton;

class IconAction : public QAction
{
	Q_OBJECT
public:
	IconAction(const QString &text, const QString &icon, const QString &menuText, QKeySequence accel, QObject *parent, const char *name = 0, bool toggle = FALSE);
	IconAction(const QString &text, const QString &menuText, QKeySequence accel, QObject *parent, const char *name = 0, bool toggle = FALSE);
	~IconAction();

	virtual bool addTo(QWidget *);

	void setIcon(const Icon *);
	void setIcon(const QString &);
	const QString &iconName() const;

public slots:
	void setEnabled(bool);
	void setOn(bool);
	void setText(const QString &);

protected:
	virtual void addingToolButton(IconToolButton *) { }
	QPtrList<IconToolButton> buttonList();

private slots:
	void objectDestroyed();
	void iconUpdated(const QPixmap &);
	void toolButtonToggled(bool);

public:
	class Private;
private:
	Private *d;
	friend class Private;
};

#endif
