#ifndef TOOLBAR_H
#define TOOLBAR_H

#include <QToolBar>
#include <QToolButton>
#include <QIcon>
#include <QSpinBox>

#include "iconfactoryaccessinghost.h"

class Button;

class ToolBar : public QToolBar
{
	Q_OBJECT
public:
	enum ButtonType {
		ButtonSelect,
		ButtonPen,
		ButtonCut,
		ButtonText,
		ButtonColor,
		ButtonUndo,
		ButtonRotate,
		ButtonCopy,
		ButtonNoButton
	};

	ToolBar(QWidget *parent);
	~ToolBar();
	void setIconHost(IconFactoryAccessingHost* icoHost_);
	void init();
	ToolBar::ButtonType currentButton();
	void checkButton(ToolBar::ButtonType);
	void enableUndo(bool enable);

private slots:
	void buttonChecked(bool);
	void buttonClicked();

signals:
	void buttonClicked(ToolBar::ButtonType);
	void checkedButtonChanged(ToolBar::ButtonType);
	void newWidth(int);

private:
	QList<Button*> buttons_;
	IconFactoryAccessingHost* icoHost;
	QSpinBox *sb;

};

class Button : public QToolButton
{
	Q_OBJECT
public:
	Button(const QString &tip, const QIcon &ico, ToolBar::ButtonType type, bool checkable, QWidget *parent);
	ToolBar::ButtonType type();	

private:
	ToolBar::ButtonType type_;
};

#endif // TOOLBAR_H
