#ifndef CLEANERPLUGIN_H
#define CLEANERPLUGIN_H

#include <QWidget>
#include "psiplugin.h"
#include "applicationinfoaccessor.h"
#include "applicationinfoaccessinghost.h"
#include "iconfactoryaccessor.h"
#include "iconfactoryaccessinghost.h"
#include "optionaccessor.h"
#include "optionaccessinghost.h"
#include "plugininfoprovider.h"

class CleanerMainWindow;

class CleanerPlugin : public QObject, public PsiPlugin, public ApplicationInfoAccessor,
		    public IconFactoryAccessor, public OptionAccessor, public PluginInfoProvider
{
        Q_OBJECT
	Q_INTERFACES(PsiPlugin ApplicationInfoAccessor IconFactoryAccessor OptionAccessor PluginInfoProvider)
public:
        CleanerPlugin();
        virtual QString name() const;
        virtual QString shortName() const;
        virtual QString version() const;
        virtual QWidget* options();
        virtual bool enable();
        virtual bool disable();

        virtual void applyOptions() {};
        virtual void restoreOptions() {};
        virtual void setApplicationInfoAccessingHost(ApplicationInfoAccessingHost* host);
        virtual void setIconFactoryAccessingHost(IconFactoryAccessingHost* host);
        virtual void setOptionAccessingHost(OptionAccessingHost* host);
        virtual void optionChanged(const QString& ) {};
	virtual QString pluginInfo();

private:
        ApplicationInfoAccessingHost *appInfo;
        IconFactoryAccessingHost* iconHost;
        OptionAccessingHost* psiOptions;
        bool enabled;
        CleanerMainWindow *cln;
        friend class CleanerMainWindow;
        int height, width;

private slots:
        void start();
        void deleteCln();

    };

#endif // CLEANERPLUGIN_H
