#include <QtGui>
#include <QtCore>

#include "psiplugin.h"
#include "stanzafilter.h"
#include "accountinfoaccessor.h"
#include "accountinfoaccessinghost.h"
#include "applicationinfoaccessor.h"
#include "applicationinfoaccessinghost.h"
#include "stanzasender.h"
#include "stanzasendinghost.h"
#include "optionaccessor.h"
#include "optionaccessinghost.h"


#define cVer "0.0.8"
#define constLastCheck "lstchck"
#define constDays "days"
#define constInterval "intrvl"
#define consttimeout "timeout"

class Reminder : public QObject, public PsiPlugin, public StanzaFilter, public AccountInfoAccessor, public ApplicationInfoAccessor, public StanzaSender, public OptionAccessor
{
	Q_OBJECT
        Q_INTERFACES(PsiPlugin StanzaFilter AccountInfoAccessor ApplicationInfoAccessor StanzaSender OptionAccessor)

public:
        Reminder();
	virtual QString name() const;
	virtual QString shortName() const;
	virtual QString version() const;
        virtual QWidget* options();
	virtual bool enable();
        virtual bool disable();
        virtual void applyOptions();
        virtual void restoreOptions();
        virtual bool incomingStanza(int account, const QDomElement& xml);
        virtual void setAccountInfoAccessingHost(AccountInfoAccessingHost* host);
        virtual void setApplicationInfoAccessingHost(ApplicationInfoAccessingHost* host);
        virtual void setStanzaSendingHost(StanzaSendingHost *host);
        virtual void setOptionAccessingHost(OptionAccessingHost* host);
        virtual void optionChanged(const QString& option);

private:
        bool enabled;
        OptionAccessingHost *psiOptions;
        AccountInfoAccessingHost *AccInfoHost;
        ApplicationInfoAccessingHost *AppInfoHost;
        StanzaSendingHost *StanzaHost;
        QString id;
        QString Dir;
        QString CheckBirthdays();
        QString LastCheck;
        int Days;
        QSpinBox *DaysWidget;
        int Interval;
        QSpinBox *IntervalWidget;
        QPushButton *Close;
        int timeout;
        int timeout2;
        QDialog *window;
        QTimer *timer;
        QSpinBox *timeoutWidget;

private slots:
         void UpdateVCard();
         bool Check();
         void setDontCheck();
         void updateTimer();
         void close();
};

Q_EXPORT_PLUGIN(Reminder);

Reminder::Reminder() {
        enabled = false;        
        AppInfoHost = 0;
        AccInfoHost = 0;
        StanzaHost = 0;
        psiOptions = 0;
        Dir = "";
        id = "";
        LastCheck = "1901010101";
        Days = 5;
        DaysWidget = 0;
        Interval = 24;
        IntervalWidget = 0;
        Close = 0;
        timeout = 15;
        window = 0;
    }

QString Reminder::name() const {
        return "Birthday Reminder Plugin";
    }

QString Reminder::shortName() const {
        return "reminder";
}

QString Reminder::version() const {
        return cVer;
}

bool Reminder::enable() {
  if(psiOptions) {
    enabled = true;
    id = "111aaa222bbb";
    QVariant vLastCheck(LastCheck);
    vLastCheck = psiOptions->getPluginOption(constLastCheck);
    if(!vLastCheck.isNull()) {
        LastCheck = vLastCheck.toString();
    }
    QVariant vtimeout(timeout);
    vtimeout = psiOptions->getPluginOption(consttimeout);
    if(!vtimeout.isNull()) {
        timeout = vtimeout.toInt();
    }
    QVariant vDays(Days);
    vDays = psiOptions->getPluginOption(constDays);
    if(!vDays.isNull()) {
        Days = vDays.toInt();
    }
    QVariant vInterval(Interval);
    vInterval = psiOptions->getPluginOption(constInterval);
    if(!vInterval.isNull()) {
        Interval = vInterval.toInt();
    }
    Dir = AppInfoHost->appVCardDir() + QDir::separator() + "Birthdays";
    QDir BirthDay(Dir);
    if(!BirthDay.exists(Dir)) {
        BirthDay.mkdir(Dir);
        return enabled;
    }
    if((LastCheck.toLong() + Interval) <= QDateTime::currentDateTime().toString("yyyyMMddhh").toLong()) {
            Check();
            LastCheck = QDateTime::currentDateTime().toString("yyyyMMddhh");
            vLastCheck = LastCheck;
            psiOptions->setPluginOption(constLastCheck, vLastCheck);
    }    
}
    return enabled;
}

bool Reminder::disable() {
	enabled = false;        
	return true;
}

QWidget* Reminder::options() {
    if(!enabled) {
    return 0;
}
    QWidget *options = new QWidget();
    DaysWidget = new QSpinBox();
    DaysWidget->setMaximum(60);
    DaysWidget->setMinimum(1);
    DaysWidget->setValue(Days);
    IntervalWidget = new QSpinBox();
    IntervalWidget->setMinimum(1);
    IntervalWidget->setMaximum(24);
    IntervalWidget->setValue(Interval);
    timeoutWidget = new QSpinBox();    
    timeoutWidget->setMinimum(-1);
    timeoutWidget->setValue(timeout);
    QPushButton *CheckButton = new QPushButton(tr("Check Birthdays"));
    QPushButton *UpdateButton = new QPushButton(tr("Update Birthdays"));
    QVBoxLayout *vlayout = new QVBoxLayout(options);
    QHBoxLayout *layout = new QHBoxLayout();
    vlayout->addWidget(new QLabel(tr("If you use this plugin at first time, make sure that all your accounts \nis online and then press \"Check Birthdays\" button. It takes some time.")));
    layout->addWidget(UpdateButton);
    layout->addWidget(CheckButton);
    vlayout->addLayout(layout);
    QHBoxLayout *spinLayout = new QHBoxLayout();    
    spinLayout->addWidget(new QLabel(tr("Start notifying")));
    spinLayout->addWidget(DaysWidget);
    spinLayout->addWidget(new QLabel(tr("days in advance")));
    spinLayout->addStretch();
    QHBoxLayout *IntervalLayout = new QHBoxLayout();
    IntervalLayout->addWidget(new QLabel(tr("Check birthdays every")));
    IntervalLayout->addWidget(IntervalWidget);
    IntervalLayout->addWidget(new QLabel(tr("hours")));
    IntervalLayout->addStretch();
    QHBoxLayout *timeoutLayout = new QHBoxLayout();
    timeoutLayout->addWidget(new QLabel(tr("Show information window")));
    timeoutLayout->addWidget(timeoutWidget);
    timeoutLayout->addWidget(new QLabel(tr("sec(-1=infinite)")));
    timeoutLayout->addStretch();
    QFrame *frame = new QFrame();
    frame->setMinimumHeight(20);
    vlayout->addWidget(frame);
    vlayout->addLayout(spinLayout);
    vlayout->addLayout(IntervalLayout);
    vlayout->addLayout(timeoutLayout);
    vlayout->addStretch();
    connect(UpdateButton,SIGNAL(released()),SLOT(UpdateVCard()));
    connect(CheckButton,SIGNAL(released()),SLOT(Check()));
    return options;
}

bool Reminder::incomingStanza(int account, const QDomElement& stanza) {
    Q_UNUSED(account);
     if (enabled) {
         if(stanza.tagName() == "iq") {             
             if(stanza.attribute("id") == id) {
                 QDomNode VCard = stanza.firstChild();
                 QDomElement BDay = VCard.firstChildElement("BDAY");
                 if(!BDay.isNull()) {
                     QString Jid = stanza.attribute("from");
                     QString Nick = VCard.firstChildElement("NICKNAME").text();
                     QString Date = BDay.text();
                     if(Date != "") {                         
                         Jid.replace("@", "_at_");
                         QFile file(Dir + QDir::separator() + Jid);
                         if(file.open(QIODevice::ReadWrite)) {
                             QTextStream out(&file);
                             out << Date << "__" << Nick << endl;
                         }
                     }
                 }
                 return true;
             }
         }
          if((LastCheck.toLong() + Interval) <= QDateTime::currentDateTime().toString("yyyyMMddhh").toLong()) {
              Check();
            LastCheck = QDateTime::currentDateTime().toString("yyyyMMddhh");
            QVariant vLastCheck(LastCheck);
            psiOptions->setPluginOption(constLastCheck, vLastCheck);
        }
     }
     return false;
 }

void Reminder::setAccountInfoAccessingHost(AccountInfoAccessingHost* host) {
     AccInfoHost = host;
 }

void Reminder::setApplicationInfoAccessingHost(ApplicationInfoAccessingHost* host) {
     AppInfoHost = host;
 }

void Reminder::applyOptions() {
    if(DaysWidget == 0 || IntervalWidget == 0 || timeoutWidget == 0) {
        return;
    }
    QVariant vDays(DaysWidget->value());
    psiOptions->setPluginOption(constDays, vDays);
    Days = vDays.toInt();
    QVariant vInterval(IntervalWidget->value());
    psiOptions->setPluginOption(constInterval, vInterval);
    Interval = vInterval.toInt();
    QVariant vtimeout(timeoutWidget->value());
    psiOptions->setPluginOption(consttimeout, vtimeout);
    timeout = vtimeout.toInt();
}

void Reminder::restoreOptions() {
    if(DaysWidget == 0 || IntervalWidget == 0 || timeoutWidget == 0) {
        return;
    }
    QVariant vDays(Days);
    vDays = psiOptions->getPluginOption(constDays);
    if(!vDays.isNull()) {
        DaysWidget->setValue(vDays.toInt());
    }
    else {
        DaysWidget->setValue(Days);
    }
    QVariant vInterval(Interval);
    vInterval = psiOptions->getPluginOption(constInterval);
    if(!vInterval.isNull()) {
        IntervalWidget->setValue(vInterval.toInt());
    }
    else {
        IntervalWidget->setValue(Interval);
    }
    QVariant vtimeout(timeout);
    vtimeout = psiOptions->getPluginOption(consttimeout);
    if(!vtimeout.isNull()) {
        timeoutWidget->setValue(vtimeout.toInt());
    }
    else {
        timeoutWidget->setValue(timeout);
    }
}

void Reminder::setStanzaSendingHost(StanzaSendingHost *host) {
    StanzaHost = host;
}

void Reminder::UpdateVCard() {
    if(enabled) {
        QString path = AppInfoHost->appVCardDir();
        QDir dir(path);
        foreach (QString filename, dir.entryList(QDir::Files)) {
            QFile file(path + QDir::separator() + filename);
            if(file.open(QIODevice::ReadOnly)) {
                QTextStream in(&file);
                QDomDocument doc;
                doc.setContent(in.readAll());
                QDomElement vCard = doc.documentElement();
                QDomElement BDay = vCard.firstChildElement("BDAY");
                if(!BDay.isNull()) {
                     QString Nick = vCard.firstChildElement("NICKNAME").text();
                     QString Date = BDay.text();
                     if(Date != "") {
                         filename.replace("%5f", "_");
                         filename.replace("%2d", "-");
                         filename.remove(".xml");
                         QFile file(Dir + QDir::separator() + filename);
                         if(file.open(QIODevice::ReadWrite)) {
                             QTextStream out(&file);
                             out << Date << "__" << Nick << endl;
                         }
                     }
                 }
            }
        }

    int accs = -1;
    bool b = true;
    while(b) {
        QStringList Jids = AccInfoHost->getRoster(++accs);
        if(Jids.isEmpty()) {
                b = false;
            }
        else {
            if(AccInfoHost->getStatus(accs) != "offline") {
                foreach(QString Jid, Jids) {
                    QString text = "<iq type=\"get\" to=\"" + Jid + "\" id=\"" + id + "\"><vCard xmlns=\"vcard-temp\" version=\"2.0\" prodid=\"-//HandGen//NONSGML vGen v1.0//EN\" /></iq>";
                    StanzaHost->sendStanza(accs, text);
                }
            }
        }               
    }   
}
}

QString Reminder::CheckBirthdays() {
    QString CheckResult = "";
    if(enabled) {
    QDir dir(Dir);
    foreach(QString jid, dir.entryList(QDir::Files)) {
      if(jid.contains("_at_")) {
        QFile file(Dir + QDir::separator() + jid);
        if(file.open(QIODevice::ReadOnly)) {
            QTextStream in(&file);
            QString line = in.readLine();
            QStringList fields = line.split("__");
            QString Date = fields.takeFirst();
            QString Nick = "";
            if(!fields.isEmpty()) {
                Nick = fields.takeFirst();
            }
            QDate Birthday = QDate::currentDate();
            if(Date.contains("-")) {
                Birthday = QDate::fromString(Date, "yyyy-MM-dd");
            } else {
                if(Date.contains(".")) {
                    Birthday = QDate::fromString(Date, "d.MM.yyyy");
                } else {
                    if(Date.contains("/")) {
                        Birthday = QDate::fromString(Date, "d/MM/yyyy");
                    }
                }
            }
            QDate current = QDate::currentDate();
            if(current != Birthday) {
                int years = current.year() - Birthday.year();
                Birthday = Birthday.addYears(years);
                int daysTo = current.daysTo(Birthday);
                QString days;
                days.setNum(daysTo);
                jid.replace("_at_", "@");
                if(daysTo == 0) {
                    CheckResult += Nick + "(" + jid + ") " + tr("celebrates birthday today!") + "\n";
                } else {
                    if(daysTo <= Days && daysTo > 0) {
                        CheckResult += Nick + "(" + jid + ") " + tr("celebrates birthday in ") + days + tr(" day(s)") + "\n";
                    } else {
                        if(daysTo == -1) {
                            CheckResult += Nick + "(" + jid + ") " + tr("celebrates birthday yesterday.") + "\n";
                        }
                    }
                }
            }
        }
      }
    }
}
    return CheckResult;
}

void Reminder::optionChanged(const QString &option) {
    Q_UNUSED(option);
}

void Reminder::setOptionAccessingHost(OptionAccessingHost *host) {
    psiOptions = host;
}

bool Reminder::Check() {
    bool isBirthday = false;
    QString text = CheckBirthdays();
    if(text != "") {
        isBirthday = true;
        window = new QDialog();
        window->setWindowTitle("Birthday Reminder Plugin");
        QVBoxLayout *layout = new QVBoxLayout(window);
        QHBoxLayout *layoutButton = new QHBoxLayout();        
        Close = new QPushButton(tr("Close"));
        QPushButton *DontRemind = new QPushButton(tr("Don't remind today"));
        layout->addWidget(new QLabel(text));
        layoutButton->addStretch();
        layoutButton->addWidget(DontRemind);
        layoutButton->addWidget(Close);        
        layout->addLayout(layoutButton);
        timer = new QTimer(window);
        if(timeout != -1) {
            timeout2 = timeout;
            QString textClose;
            textClose.setNum(timeout2);
            textClose = tr("Close ") + textClose;
            connect(timer, SIGNAL(timeout()), SLOT(updateTimer()));
            timer->start(1000);
            Close->setText(textClose);
        }
        connect(Close, SIGNAL(released()), SLOT(close()));
        connect(DontRemind, SIGNAL(released()), SLOT(setDontCheck()));        
        window->setWindowModality(Qt::WindowModal);        
        window->show();
    }
    return isBirthday;
}

void Reminder::setDontCheck() {
    QDateTime Date = QDateTime::currentDateTime();
    Date.setTime(QTime::fromString("010000", "hhmmss"));
    Date = Date.addDays(1);
    LastCheck = Date.toString("yyyyMMddhh");
    QVariant vLastCheck(LastCheck);
    psiOptions->setPluginOption(constLastCheck, vLastCheck);
    timer->stop();
    delete window;    
}

void Reminder::updateTimer() {
     QString textClose;
     textClose.setNum(--timeout2);
     textClose = tr("Close ") + textClose;
     if(timeout2 > 0) {
         Close->setText(textClose);
     }
     else {
         timer->stop();
         delete window;
     }
}

void Reminder::close() {
    timer->stop();
    delete window;
}

#include "birthdayreminderplugin.moc"
