#ifndef CHATVIEW_TE_H
#define CHATVIEW_TE_H

#include <QWidget>
#include <QDateTime>

#include "psitextview.h"
#include "chatviewbase.h"

class ChatEdit;
class ChatViewBase;

class ChatView : public PsiTextView, public ChatViewBase
{
	Q_OBJECT
public:
	ChatView(QWidget* parent);
	~ChatView();

	void addLogIconsResources();
	void markReceived(QString id);

	// reimplemented
	QSize sizeHint() const;
	void clear();
	void contextMenuEvent(QContextMenuEvent *e);

	void appendText(const QString &text);
	bool handleCopyEvent(QObject *object, QEvent *event, ChatEdit *chatEdit);

	void appendMucMessage(bool local, const QString &text, bool emote, const QString &nick, const QDateTime &time, const QString &nickcolor, bool alert);
	void appendMessage(const QString &id, bool local, const QString &text, bool emote, const QString &nick, const QDateTime &time, const QString &color, bool remember, const QString &subject);
	void appendSysMessage(const QString &text, const QString &userText = "", const QDateTime &time = QDateTime::currentDateTime());
	void appendLastMsgTime(const QDate &date);
	void appendSubject(const QString &subject);
	void appendMucSubject(const QString &sysMsg, const QString &subject, const QDateTime &time);
	void startUrlsBlock();
	void appendUrl(const QString &url, const QString &desc);

	void scrollUp();
	void scrollDown();
	void doTrackBar();
	bool internalFind(QString str, bool startFromBeginning = false);
	ChatView *textWidget();

protected:
	// override the tab/esc behavior
	bool focusNextPrevChild(bool next);
	void keyPressEvent(QKeyEvent *);

protected slots:
	void autoCopy();

signals:
	void showNM(QString);

private:
	int  oldTrackBarPosition;
	bool useMessageIcons_;

	QPixmap logIconSend;
	QPixmap logIconReceive;
	QPixmap logIconDelivered;
	QPixmap logIconTime;
	QPixmap logIconInfo;
};

#endif
